#A UCI Archive dataset. See this link for more detailed information: https://archive.ics.uci.edu/ml/datasets/Japanese+Vowels
#Paper: M. Kudo, J. Toyama and M. Shimbo. (1999). "Multidimensional Curve Classification Using Passing-Through Regions". Pattern Recognition Letters, Vol. 20, No. 11--13, pages 1103--1111. 
#
#
#9 Japanese-male speakers were recorded saying the vowels 'a' and 'e'. A '12-degree linear prediction analysis' is applied to the raw recordings to obtain time-series with 12 dimensions, a originally a length between 7 and 29. In this dataset, instances have been padded to the longest length, 29. The classification task is to predict the speaker. Therefore, each instance is a transformed utterance, 12*29 values with a single class label attached, [1...9].
#
#The given training set is comprised of 30 utterances for each speaker, however the test set has a varied distribution based on external factors of timing and experimenal availability, between 24 and 88 instances per speaker. 
@problemName JapaneseVowels
@timeStamps false
@missing false
@univariate false
@dimensions 12
@equalLength false
@classLabel true 1 2 3 4 5 6 7 8 9
@data
1.860936,1.891651,1.939205,1.717517,1.741191,1.684695,1.637373,1.643283,1.60703,1.617907,1.51035,1.371225,1.299045,1.221498,1.181849,1.16163,1.19499,1.264847,1.250698,1.261441:-0.207383,-0.193249,-0.239664,-0.218572,-0.279891,-0.311977,-0.336227,-0.349773,-0.382745,-0.527367,-0.548025,-0.470988,-0.495095,-0.50008,-0.496439,-0.481933,-0.510964,-0.564878,-0.612291,-0.63835:0.261557,0.235363,0.258561,0.217119,0.196583,0.195453,0.152766,0.131553,0.179038,0.179878,0.13193,0.043163,0.029375,-0.002802,-0.075193,-0.052291,0.065827,0.162907,0.205701,0.217443:-0.214562,-0.249118,-0.291458,-0.228186,-0.236377,-0.23197,-0.223842,-0.154519,-0.115949,-0.083292,-0.028036,0.019166,0.026418,0.095565,0.167288,0.156674,0.175791,0.186745,0.211003,0.263384:-0.171253,-0.11289,-0.041053,-0.018608,-0.032012,-0.06867,-0.026278,-0.035292,-0.060406,0.031747,0.104782,0.165104,0.218288,0.226836,0.294219,0.361226,0.353618,0.35686,0.369712,0.391115:-0.118167,-0.112238,-0.102034,-0.137624,-0.090612,-0.003822,-0.009157,0.023719,0.0578,0.081424,0.092027,0.09589,0.07575,0.055463,0.009977,-0.029372,-0.066702,-0.103597,-0.135327,-0.176897:-0.277557,-0.311997,-0.3833,-0.403318,-0.363134,-0.34194,-0.363866,-0.381399,-0.364642,-0.418227,-0.416792,-0.416692,-0.374873,-0.374477,-0.4003,-0.439398,-0.483034,-0.477584,-0.511918,-0.510697:0.025668,-0.027122,0.019013,-0.009643,-0.012571,-0.008826,-0.003117,-0.021189,-0.06923,-0.081175,-0.120635,-0.159574,-0.191542,-0.233165,-0.233576,-0.153779,-0.06115,-0.036123,-0.008747,0.020526:0.126701,0.171457,0.16951,0.164607,0.124298,0.085097,0.055479,0.020397,-0.019788,-0.022385,-0.056442,-0.078847,-0.103774,-0.064838,-0.067197,-0.144769,-0.196565,-0.218547,-0.203637,-0.217709:-0.306756,-0.289431,-0.314894,-0.323267,-0.351171,-0.364329,-0.358107,-0.340491,-0.355996,-0.33766,-0.30885,-0.326813,-0.322266,-0.296219,-0.236504,-0.214368,-0.220477,-0.204974,-0.212982,-0.219071:-0.213076,-0.247722,-0.227908,-0.210105,-0.216545,-0.204794,-0.181643,-0.156417,-0.115129,-0.103184,-0.099587,-0.073882,-0.066122,-0.075885,-0.096844,-0.068804,-0.02792,-0.019119,-0.02357,-0.033314:0.088728,0.093011,0.074638,0.098098,0.113899,0.101838,0.082056,0.080884,0.131928,0.102266,0.103529,0.141055,0.130722,0.091973,0.010373,-0.041047,-0.085436,-0.136857,-0.170498,-0.175986:1
1.303905,1.28828,1.332021,1.43655,1.510069,1.492324,1.731416,1.655716,1.560145,1.981364,1.64063,1.591455,1.582411,1.541301,1.592347,1.674087,1.681482,1.647909,1.570202,1.61242,1.589158,1.519606,1.452399,1.370862,1.307289,1.334578:0.067256,0.018672,-0.058744,-0.206565,-0.30888,-0.413803,-0.615714,-0.489726,-0.309991,-0.630689,-0.471932,-0.471778,-0.507225,-0.530376,-0.596831,-0.659717,-0.614351,-0.658696,-0.665777,-0.60699,-0.526371,-0.524418,-0.623031,-0.621346,-0.600573,-0.542157:0.59772,0.631579,0.601928,0.641775,0.614297,0.583179,0.624905,0.366389,0.107469,0.261975,0.091516,0.125782,0.278858,0.363522,0.39001,0.38017,0.381238,0.511363,0.478356,0.416774,0.437124,0.443297,0.527393,0.600771,0.620979,0.558104:-0.271474,-0.355112,-0.347913,-0.391073,-0.283639,-0.197519,-0.241347,-0.183851,0.015034,-0.046982,0.061063,0.048809,-0.058031,-0.087405,-0.012749,0.048824,0.043964,-0.02978,0.003514,0.050611,-0.069075,0.032485,0.222107,0.283197,0.385506,0.470417:-0.236808,-0.119216,-0.053463,-0.103646,-0.178763,-0.242376,-0.158116,-0.018003,-0.04191,0.076403,0.165614,0.250247,0.28728,0.251401,0.198339,0.221404,0.279883,0.314603,0.288,0.24054,0.280104,0.323836,0.268061,0.250333,0.210833,0.229124:-0.411125,-0.434425,-0.421753,-0.227374,-0.267168,-0.23451,-0.18676,-0.252819,-0.217401,-0.257617,-0.212629,-0.188473,-0.155876,-0.116625,-0.130853,-0.180924,-0.193816,-0.15943,-0.130158,-0.08176,-0.006222,-0.0698,-0.120266,-0.180777,-0.251575,-0.263825:-0.014826,-0.078036,-0.028479,-0.070016,-0.03463,-0.026315,-0.01546,0.069039,0.067056,-0.015961,-0.046723,-0.121802,-0.104452,-0.04708,0.035449,0.021967,-0.012821,-0.057186,-0.056077,-0.047219,-0.121158,-0.170755,-0.179147,-0.191649,-0.228647,-0.251754:0.113175,0.178121,0.145073,0.138611,0.160095,0.178486,0.09242,0.01874,0.00926,0.017001,-0.034998,0.001121,-0.085458,-0.164929,-0.209978,-0.235745,-0.211565,-0.127571,-0.119485,-0.173372,-0.31031,-0.391098,-0.396988,-0.353358,-0.305328,-0.331181:-0.05823,-0.10643,-0.159488,-0.125229,-0.098749,-0.12212,-0.203755,-0.180031,-0.163025,-0.232117,-0.210997,-0.280562,-0.320138,-0.350866,-0.387018,-0.321056,-0.302557,-0.380802,-0.359916,-0.269674,-0.14869,-0.098999,-0.0636,-0.044004,-0.014519,-0.007968:-0.173138,-0.18191,-0.127751,-0.182744,-0.220531,-0.256385,-0.1862,-0.13658,-0.229586,-0.217084,-0.221234,-0.177655,-0.125466,-0.086459,-0.056789,-0.098248,-0.136598,-0.091613,-0.09191,-0.118128,-0.07524,-0.029453,-0.04565,-0.105327,-0.167528,-0.188285:0.093058,0.093031,0.019092,-0.021516,-0.061329,-0.038403,-0.100484,-0.24575,-0.177976,-0.192819,-0.175446,-0.1194,-0.101151,-0.096591,-0.094819,-0.162255,-0.173016,-0.143742,-0.135773,-0.176121,-0.245672,-0.198052,-0.18457,-0.193044,-0.175811,-0.13861:0.099247,0.099183,0.113546,0.065927,0.09364,0.06447,0.045003,0.052947,0.038727,0.089435,0.072476,0.011129,0.049713,0.082467,0.086401,0.202347,0.248909,0.154534,0.076777,0.075934,0.131027,0.127282,0.102709,0.119152,0.088565,0.054478:1
1.462484,1.309815,1.418207,1.585858,1.651997,1.486123,1.612464,1.723449,1.908451,2.12526,1.990155,2.08031,1.66936,1.882291,1.626219,1.26019,1.274111,1.4529,1.572425,1.565221,1.671099,1.633764:0.174066,0.120183,0.015721,-0.148691,-0.17902,-0.091183,-0.274628,-0.390642,-0.580881,-0.826085,-0.935262,-1.042286,-0.679862,-0.885675,-0.70789,-0.485673,-0.546423,-0.704247,-0.867819,-0.811536,-0.910977,-0.935421:0.505133,0.503046,0.589994,0.696888,0.55765,0.336031,0.390098,0.417834,0.431328,0.488411,0.470629,0.525433,0.256937,0.428198,0.336811,0.234296,0.296681,0.378652,0.452938,0.483607,0.587177,0.574273:-0.374302,-0.327562,-0.310586,-0.433672,-0.35244,-0.131567,-0.212909,-0.246235,-0.259862,-0.281048,-0.153762,-0.104984,0.069152,0.002923,0.044792,0.141639,0.152304,0.242781,0.29608,0.264737,0.225236,0.269021:-0.362125,-0.356789,-0.477019,-0.369871,-0.286346,-0.333492,-0.22267,-0.193408,-0.209985,-0.163277,-0.091035,0.011769,0.122822,0.265651,0.34695,0.30789,0.31242,0.311237,0.312264,0.340265,0.370719,0.371818:-0.400335,-0.445498,-0.367101,-0.325267,-0.303667,-0.258345,-0.244786,-0.197558,-0.07967,-0.008763,0.035063,0.078796,0.099089,0.115176,0.06619,0.124684,0.194313,0.192922,0.161462,0.173855,0.147173,0.119741:-0.137429,-0.060423,-0.120849,-0.192924,-0.210818,-0.201333,-0.217033,-0.173189,-0.147213,-0.18626,-0.258664,-0.371083,-0.408978,-0.406025,-0.332076,-0.332177,-0.420622,-0.452417,-0.416084,-0.421479,-0.431996,-0.396788:-8.3E-4,-0.007899,0.066952,0.12444,0.104599,0.043862,0.010084,0.070316,0.134547,0.124482,0.058584,-0.013916,-0.108924,-0.163888,-0.116821,-0.168295,-0.18505,-0.18149,-0.171377,-0.181123,-0.146687,-0.122981:0.053888,0.041605,-0.023859,-0.041498,0.040954,0.073675,0.049756,-0.015199,-0.051157,-0.054817,-0.014116,-0.020054,-0.046027,-0.123137,-0.226604,-0.174656,-0.141055,-0.116275,-0.106756,-0.093458,-0.106379,-0.152855:-0.23763,-0.231087,-0.224317,-0.20858,-0.219516,-0.24716,-0.24424,-0.344519,-0.451099,-0.464356,-0.473753,-0.478964,-0.432718,-0.360651,-0.362263,-0.385416,-0.32044,-0.295192,-0.303018,-0.289787,-0.296911,-0.268283:0.120636,0.121053,0.175298,0.129806,0.022768,-0.002587,-0.040954,-0.048362,-0.077406,-0.132886,-0.146977,-0.093402,-0.059613,-0.031532,0.004972,-0.004726,0.02087,0.053308,0.042348,0.043696,0.065611,0.095911:0.193254,0.202386,0.15667,0.146745,0.187322,0.190969,0.207889,0.248583,0.226654,0.172822,0.197983,0.230359,0.247765,0.200109,0.161445,0.184454,0.099264,0.06499,0.079769,0.066179,0.046339,-0.015915:1
1.160837,1.217979,1.234654,1.457268,1.534783,1.505516,1.552154,1.497978,1.543273,1.623602,1.626277,1.63463,1.65847,1.653296,1.704241,1.556289,1.421861,1.31135,1.175227,1.335523:0.078806,-0.043693,-0.107083,-0.318523,-0.414512,-0.466125,-0.535885,-0.67432,-0.853992,-0.883008,-0.844833,-0.84696,-0.880809,-0.987157,-1.078002,-1.043587,-1.056354,-1.039592,-0.937689,-1.090194:0.237706,0.378571,0.504189,0.427336,0.273407,0.317178,0.410055,0.473896,0.582981,0.573858,0.55501,0.575776,0.595335,0.733377,0.869738,0.909457,0.874371,0.838275,0.701567,0.832941:-0.010878,-0.055125,-0.151549,-0.127365,-0.008643,-0.06588,-0.182647,-0.228218,-0.157712,-0.090257,-0.044239,0.038173,0.013667,0.012034,-0.023985,-0.018181,0.061409,0.083326,0.200096,0.144356:-0.393053,-0.399601,-0.409837,-0.399821,-0.452153,-0.476936,-0.438259,-0.376289,-0.365579,-0.334159,-0.308894,-0.245206,-0.056339,0.003833,5.18E-4,0.018808,0.073847,0.138074,0.201766,0.217119:-0.744686,-0.756213,-0.666554,-0.612514,-0.532525,-0.353201,-0.233271,-0.168635,-0.095108,-0.047162,-0.003722,0.029938,-0.017231,0.031168,0.08961,0.033865,-0.01579,-0.001436,-0.031186,-0.074302:0.173073,0.189754,0.176855,0.236434,0.275157,0.165807,0.085723,-0.002026,-0.108669,-0.160032,-0.225799,-0.301001,-0.331172,-0.372246,-0.418634,-0.410164,-0.410899,-0.399484,-0.363746,-0.395826:-0.012922,0.014265,0.024257,0.039318,0.032256,0.006522,0.030157,0.034234,0.035963,0.009218,-0.06849,-0.122305,-0.102574,-0.133379,-0.165928,-0.134829,-0.098065,-0.100748,-0.090629,-0.05633:-0.071948,-0.099093,-0.085188,-0.129377,-0.135727,-0.077765,-0.077588,-0.082042,-0.057307,-0.043002,-0.008632,0.014359,-0.097225,-0.12298,-0.109833,-0.178459,-0.207248,-0.244054,-0.279473,-0.283548:0.028707,0.03897,0.005654,-0.053426,-0.158885,-0.253737,-0.336853,-0.352695,-0.386457,-0.406532,-0.340455,-0.281971,-0.266548,-0.25823,-0.251303,-0.244507,-0.267319,-0.27706,-0.281225,-0.268979:0.07482,0.049702,-0.007566,-0.064975,-0.070709,-0.153013,-0.190216,-0.204131,-0.185253,-0.161626,-0.155957,-0.146793,-0.025202,0.034436,0.034556,0.090128,0.119465,0.133377,0.130948,0.09866:0.146297,0.164537,0.168465,0.131102,0.073425,0.116918,0.165516,0.165831,0.16828,0.17891,0.139002,0.083612,0.030883,0.008776,-0.025393,-0.077927,-0.098507,-0.090556,-0.082822,-0.098007:1
1.66567,1.685376,1.541171,1.479049,1.602405,1.616784,1.560852,1.586381,1.55236,1.756285,1.678263,1.65066,1.627512,1.612174,1.560036,1.513187,1.463309,1.449662,1.361718,1.254506,1.251355:-0.251224,-0.305126,-0.238987,-0.278182,-0.359135,-0.373741,-0.32432,-0.335201,-0.425376,-0.615969,-0.668299,-0.744537,-0.753931,-0.724072,-0.706304,-0.782704,-0.796814,-0.922675,-0.960896,-0.869107,-0.875268:0.30971,0.339418,0.295073,0.351733,0.370285,0.264209,0.08428,0.094031,0.199152,0.208466,0.309991,0.377687,0.230844,0.121253,0.164484,0.289054,0.35513,0.480473,0.559628,0.554876,0.593917:-0.371666,-0.455499,-0.447638,-0.476356,-0.490972,-0.391096,-0.169021,-0.119184,-0.039058,-0.047114,-0.106823,-0.010016,0.148994,0.269891,0.308054,0.256406,0.238131,0.224269,0.226486,0.280537,0.332128:-0.311727,-0.259315,-0.200163,-0.134112,-0.114847,-0.06592,-0.058893,0.027851,0.07622,0.212092,0.256535,0.24253,0.216088,0.333275,0.304618,0.237954,0.252769,0.227253,0.235033,0.260423,0.276972:-0.520932,-0.5026,-0.495071,-0.463027,-0.473727,-0.523488,-0.557847,-0.475723,-0.416775,-0.417191,-0.295843,-0.280315,-0.27685,-0.345888,-0.246276,-0.123745,-0.08381,0.02826,0.063513,-0.0192,-0.10635:-0.21593,-0.195365,-0.189373,-0.258962,-0.209386,-0.100301,-0.032517,-0.169229,-0.228764,-0.204745,-0.245288,-0.297346,-0.23204,-0.170601,-0.181531,-0.210291,-0.27268,-0.391606,-0.455297,-0.447082,-0.387802:0.255584,0.185427,0.123212,0.179394,0.131919,0.046133,0.049321,0.060178,0.065394,-0.049585,-0.148974,-0.186301,-0.227556,-0.171993,-0.209579,-0.278591,-0.239268,-0.183462,-0.159983,-0.113791,-0.113938:0.048732,0.076114,0.130086,0.077287,0.008094,-0.076248,-0.134548,-0.188224,-0.183333,-0.189937,-0.158393,-0.153023,-0.168355,-0.272781,-0.260218,-0.193769,-0.162374,-0.123246,-0.100619,-0.110484,-0.130651:-0.115333,-0.106838,-0.125721,-0.15946,-0.178367,-0.176394,-0.193288,-0.16409,-0.120764,-0.075709,-0.059683,-0.047579,-0.094685,-0.098009,-0.130769,-0.139636,-0.159496,-0.221048,-0.25841,-0.289957,-0.258918:0.063014,-0.036998,-0.100226,-0.060428,-0.121264,-0.157841,-0.088907,-0.045568,-0.088878,-0.209564,-0.293401,-0.245426,-0.181778,-0.111772,-0.062059,-0.08706,-0.071656,-4.35E-4,0.037011,0.039887,0.002197:0.156787,0.200715,0.232676,0.203395,0.271936,0.329654,0.251756,0.149243,0.042436,0.074583,0.08855,0.047008,0.061112,0.05563,0.084525,0.118787,0.087922,0.035291,0.008935,0.026577,0.021173:1
1.316781,1.546594,1.608876,1.500528,1.310997,1.321061,1.450239,1.531836,1.634158,1.780029,1.862115,1.788249,1.558448,1.527604,1.800617,1.547859,1.611904,1.606463,1.523198,1.426542,1.313754,1.445636,1.622524:0.208962,0.153905,-0.017998,-0.028411,-0.030111,-0.043778,-0.080798,-0.156028,-0.344119,-0.532443,-0.707949,-0.768673,-0.647224,-0.61904,-0.790902,-0.708329,-0.821887,-0.850473,-0.83004,-0.877377,-0.784868,-0.71548,-0.763775:0.247252,0.208579,0.340853,0.437274,0.507571,0.324998,0.204418,0.190886,0.216047,0.21,0.18435,0.283067,0.182383,0.133084,0.326549,0.230714,0.364913,0.510641,0.368123,0.474689,0.562344,0.558721,0.644036:-0.122314,-0.126525,-0.161172,-0.334035,-0.491682,-0.320261,-0.149472,-0.163969,-0.178078,-0.150181,0.032872,0.081496,0.1677,0.185089,0.112653,0.301073,0.271679,0.262553,0.38173,0.389244,0.399884,0.452585,0.389923:-0.291894,-0.347069,-0.493625,-0.433048,-0.360644,-0.36592,-0.341621,-0.231265,-0.164999,-0.127082,-0.125617,0.043878,0.192839,0.212895,0.187628,0.139891,0.11478,0.08998,0.133352,0.197516,0.181482,0.18009,0.230516:-0.538407,-0.575495,-0.438199,-0.348928,-0.290714,-0.236857,-0.215631,-0.193294,-0.106416,-0.035412,-0.029569,-0.204872,-0.298809,-0.226078,-0.201391,-0.207068,-0.195785,-0.142387,-0.14214,-0.183735,-0.149606,-0.142327,-0.121277:0.038262,0.129119,0.073069,0.077534,0.133114,0.057422,-0.077424,-0.237795,-0.302677,-0.234951,-0.199874,-0.189915,-0.222101,-0.244898,-0.241863,-0.239155,-0.267947,-0.292794,-0.283807,-0.293493,-0.28253,-0.238381,-0.304381:0.028536,0.029862,0.037607,0.009284,-0.011299,-0.029263,-0.005952,0.027416,-0.002384,-0.050771,-0.075182,-0.122166,-0.179669,-0.235385,-0.26156,-0.257594,-0.24272,-0.284728,-0.275013,-0.217475,-0.247117,-0.284529,-0.241366:-0.165629,-0.12089,-0.038292,-0.036945,-0.103233,-0.095248,-0.121362,-0.113438,-0.102691,-0.136983,-0.182564,-0.273674,-0.246067,-0.233182,-0.288767,-0.238636,-0.249445,-0.225541,-0.223317,-0.227767,-0.174886,-0.172752,-0.180656:-0.145149,-0.077795,-0.169238,-0.234477,-0.171606,-0.267429,-0.375987,-0.399447,-0.386465,-0.391376,-0.368635,-0.23823,-0.17018,-0.159263,-0.137291,-0.17912,-0.195197,-0.19478,-0.157839,-0.154633,-0.164402,-0.158843,-0.159602:0.112608,0.037846,0.028236,0.021624,-0.033292,0.003456,0.066614,0.067804,0.036043,-0.023714,-0.016512,0.048968,0.031181,0.028516,-0.012089,-0.011356,0.005866,0.013731,0.017047,0.019405,-0.005472,-0.009701,0.010511:0.108192,0.080831,0.109325,0.162682,0.112799,0.12095,0.210394,0.235495,0.235927,0.265352,0.284451,0.223579,0.196374,0.152444,0.134224,0.081306,0.086699,0.108453,0.04699,0.028457,0.056626,0.075992,0.052609:1
1.298242,1.284513,1.366785,1.372831,1.417637,1.417835,1.350428,1.306239,1.418816,1.561812,1.285543,1.160802,1.34109,1.382492,1.339451,1.121185,1.082868,0.967712,0.939699,0.895805,0.971273,0.893762:-0.145848,-0.115359,-0.177232,-0.191557,-0.157945,-0.099372,-0.133935,-0.197304,-0.221052,-0.341313,-0.250419,-0.313657,-0.434988,-0.40479,-0.481133,-0.487641,-0.564467,-0.520098,-0.500703,-0.531574,-0.624686,-0.589257:0.602439,0.509488,0.502441,0.459848,0.520153,0.471114,0.443349,0.409404,0.33791,0.532809,0.485271,0.479699,0.530374,0.471562,0.570811,0.615707,0.685535,0.726917,0.762015,0.818346,0.909781,0.889266:-0.558909,-0.524351,-0.571654,-0.499487,-0.572629,-0.595027,-0.452326,-0.363984,-0.282619,-0.338048,-0.279746,-0.164835,-0.126942,-0.063385,-0.047414,-0.069434,-0.056664,-0.028067,0.005092,0.025463,0.027477,0.122634:-0.063299,-0.097627,-0.079904,-0.03967,-0.039446,0.110219,0.159401,0.229075,0.28575,0.276729,0.293163,0.269481,0.318548,0.369611,0.414503,0.425557,0.419323,0.37489,0.360897,0.356354,0.338503,0.302502:-0.371642,-0.352564,-0.33902,-0.333126,-0.253199,-0.337169,-0.351955,-0.342244,-0.349318,-0.254892,-0.222749,-0.174039,-0.13489,-0.161873,-0.202914,-0.201003,-0.136114,-0.020208,-0.048284,-0.083756,-0.051478,-0.012828:0.001086,0.080347,0.067623,-0.005106,-0.059307,-0.115554,-0.156536,-0.19479,-0.246278,-0.321675,-0.293701,-0.302722,-0.38327,-0.412308,-0.44236,-0.348885,-0.348527,-0.362509,-0.378706,-0.385054,-0.443278,-0.420706:0.285956,0.182553,0.103885,0.087083,0.048715,0.069107,-0.013074,-0.06831,-0.053703,-0.026014,-0.015083,-0.052517,-0.119058,-0.16332,-0.142528,-0.145906,-0.181743,-0.260621,-0.22562,-0.157173,-0.115329,-0.11013:-0.238774,-0.266852,-0.276118,-0.247359,-0.282594,-0.374232,-0.340212,-0.251026,-0.278733,-0.328668,-0.246913,-0.205106,-0.211241,-0.181777,-0.182088,-0.254205,-0.270824,-0.221138,-0.226413,-0.234492,-0.232085,-0.215093:-0.188824,-0.167901,-0.120408,-0.152682,-0.206558,-0.216007,-0.219998,-0.218385,-0.289131,-0.306133,-0.336171,-0.375349,-0.333793,-0.298663,-0.266776,-0.241451,-0.205987,-0.186627,-0.218629,-0.253865,-0.262236,-0.271401:-0.040123,-0.049674,-0.105818,-0.067913,-0.00389,0.012745,0.022386,-0.05055,-0.002221,0.023878,0.025722,0.062873,0.09909,0.079851,0.048488,0.066971,0.076224,0.07712,0.096138,0.078315,0.08791,0.095645:0.122868,0.124165,0.15972,0.176425,0.169362,0.177393,0.208493,0.251723,0.271178,0.258802,0.220069,0.240106,0.231482,0.185592,0.152438,0.141763,0.113327,0.017963,-0.041842,-0.058649,-0.109648,-0.134627:1
1.685639,1.698825,1.750511,1.67545,1.677717,1.686637,1.588764,1.538907,1.535322,1.593539,1.665299,1.586304,1.545194,1.507911,1.490069,1.413099,1.346525,1.493634:-0.170479,-0.245514,-0.308582,-0.310491,-0.331005,-0.387487,-0.408304,-0.420475,-0.443226,-0.517504,-0.607764,-0.614515,-0.67266,-0.69765,-0.698884,-0.583097,-0.538645,-0.749443:0.57703,0.501133,0.53531,0.588458,0.557505,0.531985,0.438431,0.408907,0.381586,0.347412,0.311501,0.267663,0.408341,0.408211,0.398661,0.45115,0.510571,0.704848:-0.756917,-0.663925,-0.715814,-0.709855,-0.691774,-0.589601,-0.431921,-0.424434,-0.37968,-0.343879,-0.274218,-0.239787,-0.284756,-0.163966,-0.06401,-0.02251,0.116505,0.03515:-0.033735,-0.039698,0.040141,0.094683,0.167053,0.204824,0.208249,0.237207,0.249742,0.279953,0.283223,0.337778,0.361038,0.351258,0.366971,0.347019,0.323031,0.373614:-0.338705,-0.355668,-0.356215,-0.328834,-0.277809,-0.281143,-0.252435,-0.198122,-0.112427,-0.033607,-0.008129,-0.007428,0.012793,-0.025547,-0.067635,-0.11885,-0.259461,-0.218369:-0.430485,-0.405613,-0.477349,-0.479756,-0.484052,-0.547638,-0.501121,-0.463432,-0.404311,-0.410133,-0.403271,-0.383705,-0.410656,-0.410941,-0.436847,-0.459499,-0.51408,-0.616608:0.307383,0.299955,0.336016,0.345373,0.29072,0.219321,0.146282,0.121427,0.047588,-0.00174,-0.009471,-0.021307,0.001494,0.021945,-0.006558,-0.010529,0.023528,-0.001447:9.45E-4,0.019627,-3.13E-4,-0.04262,-0.081371,-0.089845,-0.083805,-0.106065,-0.152123,-0.181685,-0.226521,-0.291419,-0.316842,-0.295964,-0.234806,-0.193043,-0.147556,-0.122072:-0.126192,-0.144827,-0.211349,-0.277127,-0.311812,-0.316456,-0.342953,-0.365806,-0.366294,-0.365399,-0.353389,-0.297178,-0.306321,-0.309313,-0.268016,-0.295222,-0.29126,-0.283037:8.79E-4,-0.054213,-0.082473,-0.086374,-0.0978,-0.062805,-0.051415,-0.056661,-0.043276,-0.014849,0.026372,0.059879,0.097692,0.087452,0.035742,0.045972,0.043178,0.043216:-0.047986,-0.052114,-0.037075,-0.001209,0.034412,0.048987,0.086083,0.109736,0.142535,0.141845,0.113182,0.067328,0.056051,0.024961,-0.010386,0.017651,-0.016265,-0.010643:1
1.516243,1.522134,1.538597,1.4958,1.664994,1.69838,1.729965,1.474845,1.472562,1.47459,1.575489,1.634094,1.611993,1.529423,1.358692,1.37559,1.481814,1.515759,1.558354,1.54094,1.466947,1.578368,1.591924,1.454448:-0.421519,-0.242862,-0.145072,-0.15284,-0.442855,-0.544536,-0.591056,-0.463698,-0.505034,-0.540542,-0.681505,-0.740702,-0.71044,-0.699914,-0.672804,-0.734745,-0.904536,-0.934969,-0.906916,-0.8889,-0.849363,-0.869018,-0.798423,-0.690366:0.310573,0.281658,0.238779,0.158021,0.293956,0.266387,0.34575,0.231882,0.295663,0.433514,0.433878,0.449017,0.446422,0.384836,0.436376,0.520157,0.652986,0.647722,0.586695,0.627862,0.648174,0.674816,0.728374,0.678094:-0.202095,-0.276902,-0.268656,-0.257449,-0.263568,-0.134894,-0.121536,0.008104,0.063633,0.159165,0.203983,0.216088,0.177278,0.273916,0.330847,0.30461,0.258349,0.277886,0.299804,0.260245,0.291665,0.300585,0.238048,0.253824:-0.320116,-0.295546,-0.358038,-0.287451,-0.169211,-0.073217,0.036976,0.033747,0.096361,0.186466,0.250439,0.259054,0.286573,0.284864,0.298519,0.337037,0.372686,0.377461,0.377374,0.409123,0.400575,0.396288,0.425595,0.444602:-0.217247,-0.091977,0.023831,0.015743,0.051132,0.12754,0.156905,0.151155,0.056352,-9.12E-4,0.051999,0.085238,0.102108,0.111229,0.066996,0.042646,0.004058,-8.98E-4,0.004288,-0.009881,-0.011553,-0.024568,-0.060428,-0.045315:-0.027017,-0.070047,-0.070798,-0.100512,-0.189122,-0.288386,-0.287593,-0.288897,-0.292923,-0.407321,-0.386008,-0.336907,-0.367764,-0.422259,-0.4317,-0.387385,-0.375534,-0.367178,-0.345487,-0.374699,-0.354638,-0.368117,-0.430649,-0.446628:0.267714,0.176537,0.102855,0.091736,0.112994,-0.00397,-0.141473,-0.138789,-0.116145,-0.109365,-0.150184,-0.20773,-0.156919,-0.079049,-0.039963,-0.034087,-0.011888,-0.014993,-0.037738,-0.030971,-0.065039,-0.068135,-0.0419,-0.062333:0.051747,0.009498,-0.009672,4.77E-4,0.003736,0.035204,-0.041858,-0.099927,-0.137168,-0.129811,-0.185599,-0.206868,-0.2248,-0.198201,-0.178507,-0.230783,-0.265604,-0.285441,-0.304957,-0.301894,-0.296866,-0.273898,-0.244881,-0.208914:-0.261525,-0.388598,-0.438297,-0.498749,-0.482284,-0.40045,-0.323904,-0.347759,-0.361634,-0.292933,-0.242247,-0.200138,-0.242608,-0.29037,-0.287354,-0.285107,-0.278797,-0.27202,-0.26226,-0.264241,-0.22897,-0.225763,-0.247688,-0.260407:-0.086583,-0.030845,-0.022689,-0.047789,-0.088953,-0.130278,-0.09804,-0.080469,-0.049339,0.023334,0.087925,0.099617,0.1645,0.179198,0.152888,0.180336,0.185892,0.183333,0.173711,0.159657,0.132368,0.104358,0.077049,0.071448:0.102423,0.19656,0.235453,0.25729,0.250057,0.213545,0.182918,0.194919,0.181009,0.077343,0.057007,0.062301,0.047032,0.035879,-0.016471,-0.052253,-0.087372,-0.107935,-0.111097,-0.120765,-0.141296,-0.1503,-0.144344,-0.13373:1
1.720754,1.754186,1.434685,1.236936,1.505293,1.537248,1.565709,1.62503,1.687084,1.405275,1.379467,1.388737,1.423059,1.376422,1.351184:0.010479,-0.146909,-0.08974,-0.134536,-0.419218,-0.475625,-0.440394,-0.380361,-0.710602,-0.418337,-0.429297,-0.59066,-0.643738,-0.681156,-0.677556:0.354998,0.360816,0.268809,0.200361,0.280057,0.368875,0.227486,0.106447,0.344205,0.226137,0.222273,0.300933,0.296279,0.406414,0.404298:-0.515847,-0.397811,-0.283737,-0.205342,-0.222245,-0.140776,0.119799,0.278826,0.270812,0.301184,0.327113,0.342675,0.351851,0.290211,0.35881:0.032954,0.075221,0.044152,0.115107,0.207489,0.18437,0.182469,0.212608,0.303004,0.340012,0.440683,0.412939,0.452219,0.466918,0.455207:-0.492904,-0.4497,-0.267194,-0.144189,-0.061682,-0.00548,-0.028131,-0.107166,-0.181684,-0.14146,-0.224081,-0.212705,-0.207946,-0.142681,-0.181377:-0.176563,-0.190746,-0.21518,-0.198622,-0.215156,-0.206548,-0.22007,-0.183639,-0.220784,-0.343844,-0.291186,-0.195809,-0.171174,-0.19212,-0.170452:0.225939,0.252474,0.177159,0.060671,0.015237,-0.078896,-0.119116,-0.127615,-0.047721,-0.053411,-0.097149,-0.155854,-0.173904,-0.216962,-0.201633:-0.120848,-0.149821,-0.114408,-0.167579,-0.154116,-0.176412,-0.233638,-0.271942,-0.301402,-0.257823,-0.270429,-0.300094,-0.319767,-0.275877,-0.259083:-0.146941,-0.132267,-0.200048,-0.23664,-0.324812,-0.349618,-0.336039,-0.265499,-0.229903,-0.223365,-0.153661,-0.11476,-0.0865,-0.068733,-0.098875:-0.11194,-0.126921,-0.110405,-0.135416,-0.185479,-0.135382,-0.020578,-0.001553,0.022823,0.057141,0.038937,0.041859,0.029628,-0.025688,-0.036473:0.069714,0.021162,-0.009389,0.047944,0.112412,0.179044,0.18408,0.142535,0.0793,0.043125,0.026258,0.033958,0.026568,0.022251,0.034121:1
1.143824,1.330639,1.24666,1.392635,1.531482,1.321063,1.34676,1.573314,1.553535,1.47677,1.51234,1.612976,1.51588,1.487594,1.238548,1.259592,1.266675,1.277499,1.281115,1.154672,1.130783,1.08009,1.057251:-0.363423,-0.126492,0.151568,-0.421071,-0.897376,-0.629456,-0.458321,-0.397875,-0.391296,-0.418898,-0.440015,-0.420729,-0.393612,-0.383806,-0.340393,-0.367733,-0.381534,-0.39,-0.438363,-0.437738,-0.445543,-0.489756,-0.514995:0.816897,0.763679,0.433001,0.289392,0.260646,0.507952,0.588088,0.251634,0.30002,0.299984,0.370184,0.436955,0.439643,0.457377,0.336696,0.329388,0.426722,0.373679,0.377119,0.370437,0.364569,0.471141,0.494061:-0.426212,-0.375558,-0.168661,-0.124899,-0.224507,-0.378778,-0.302881,-0.024583,-0.109167,-0.097451,-0.061555,-0.093796,-0.064997,-1.68E-4,0.192329,0.237303,0.19933,0.284657,0.329054,0.384381,0.425989,0.484207,0.551688:-0.309629,-0.155013,-0.044385,-0.078864,-0.1286,-0.105466,0.01245,0.089206,0.204107,0.287593,0.325185,0.307753,0.336189,0.377435,0.413599,0.486785,0.45691,0.496169,0.56031,0.535907,0.531755,0.390487,0.321113:-0.315248,-0.358373,-0.388238,-0.331562,-0.291986,-0.235558,-0.208158,-0.220509,-0.227375,-0.25244,-0.268885,-0.190457,-0.151479,-0.168164,-0.250835,-0.306352,-0.210103,-0.248827,-0.333618,-0.282073,-0.24613,-0.165356,-0.09109:-0.11781,-0.095703,-0.081486,-0.007683,0.039358,-0.080671,-0.133915,-0.038019,-0.028637,-0.068394,-0.142325,-0.189156,-0.196304,-0.21138,-0.189703,-0.139308,-0.130094,-0.102787,-0.053044,0.018836,0.033795,0.035563,-0.013465:0.266063,0.286107,0.150919,0.217956,0.314414,0.27653,0.22069,0.157918,0.139205,0.096903,0.035137,-0.101801,-0.1352,-0.121725,-0.091153,-0.127937,-0.191522,-0.17057,-0.153551,-0.211338,-0.269103,-0.385489,-0.444286:-0.104472,-0.129475,-0.101748,-0.216796,-0.204533,-0.226676,-0.247244,-0.37698,-0.445621,-0.428354,-0.382929,-0.315215,-0.343617,-0.416442,-0.378037,-0.344188,-0.329011,-0.323349,-0.329441,-0.343411,-0.310263,-0.207016,-0.10689:-0.159541,-0.186735,-0.242081,-0.241327,-0.290636,-0.351187,-0.330439,-0.300661,-0.290495,-0.236317,-0.206053,-0.234513,-0.226975,-0.111344,-0.116514,-0.113356,-0.111354,-0.10986,-0.074047,-0.073718,-0.086934,-0.129711,-0.165313:0.034705,0.031634,0.02314,-0.067215,-0.080772,-0.073166,-0.026863,0.029323,0.021562,-0.035986,-0.037091,-0.047591,0.003575,0.054453,0.019712,-0.01897,0.017625,-0.015355,-0.097614,-0.073466,-0.07091,-0.049912,-0.06621:0.064737,0.099495,0.146887,0.101259,0.039547,0.098491,0.141789,0.148048,0.162006,0.150682,0.141026,0.200807,0.163767,0.005791,0.015644,0.086209,0.073537,0.059884,0.065212,0.052374,0.057424,0.04397,0.038621:1
0.800522,0.796307,0.805716,0.800297,0.732117,0.781415,0.9481,0.994979,0.958847,0.910412,0.7937,0.795708,0.730497,0.793042,0.658688:0.395285,0.310857,0.265494,0.302975,0.311745,0.219573,0.09246,0.006343,-0.030636,-0.060027,-0.173967,-0.25085,-0.247311,-0.247226,-0.234403:0.493002,0.562126,0.52739,0.335931,0.273789,0.3412,0.350522,0.330657,0.288624,0.349972,0.284486,0.302034,0.357998,0.440944,0.556802:-0.253173,-0.258161,-0.32274,-0.33177,-0.363404,-0.366434,-0.268076,-0.193302,-0.009465,0.14695,0.327683,0.359372,0.364837,0.34453,0.349818:-0.516464,-0.516958,-0.384788,-0.270319,-0.15062,-0.093734,-0.026212,0.094676,0.118768,0.143977,0.282067,0.349473,0.338389,0.335469,0.267389:-0.331558,-0.353113,-0.341542,-0.265806,-0.21675,-0.167931,-0.176385,-0.148816,-0.061053,-0.029119,-0.076451,-0.133246,-0.118102,-0.160599,-0.150809:0.115512,0.188654,0.177676,0.199208,0.154201,0.077928,0.028671,0.020258,-0.064116,-0.129842,-0.154679,-0.112612,-0.100266,-0.151398,-0.203088:0.010137,-0.052386,-0.058983,-0.049145,-0.031906,-0.042151,-0.154875,-0.25223,-0.403978,-0.456497,-0.366768,-0.371102,-0.383961,-0.343337,-0.271299:0.083276,0.112706,0.075669,0.018432,-0.039511,-0.016295,-0.003311,-0.092747,-0.005774,0.014726,-0.040127,-0.057638,-0.031715,0.009328,-0.002447:-0.029377,-0.067745,-0.093875,-0.213068,-0.246001,-0.289385,-0.339176,-0.332451,-0.369379,-0.303288,-0.290624,-0.292711,-0.337306,-0.400983,-0.432495:-0.004827,-0.016408,-0.073445,-0.051511,-0.087859,-0.111269,-0.044317,-0.016312,0.026298,0.036358,0.044375,0.045088,0.032935,0.01996,0.054131:0.108569,0.141233,0.168804,0.131266,0.144529,0.19053,0.241843,0.260521,0.232154,0.143797,0.095339,0.078585,0.075689,0.087633,0.023707:1
1.537183,1.507315,1.574646,1.504845,1.508556,1.610055,1.379594,1.450007,1.714003,1.5727,1.521947,1.453766,1.248918,1.148231,1.26504,1.269335,1.314084:-0.019954,-0.095101,-0.100629,-0.171158,-0.291514,-0.405364,-0.206247,-0.178937,-0.392106,-0.461395,-0.416731,-0.464098,-0.493949,-0.50918,-0.553742,-0.541318,-0.576264:0.289778,0.345358,0.452088,0.451372,0.43243,0.327806,0.072986,0.071381,0.211441,0.353863,0.369677,0.394296,0.550772,0.713661,0.705915,0.657373,0.64117:-0.31196,-0.356143,-0.388427,-0.411951,-0.402846,-0.30613,-0.175824,-0.136031,-0.079745,0.040394,0.111857,0.178633,0.162857,0.138454,0.253473,0.310146,0.316284:-0.119883,-0.013246,-0.053732,0.013635,0.08483,0.115126,0.102402,0.147804,0.267123,0.323945,0.353614,0.434347,0.505091,0.532861,0.453579,0.44646,0.423832:-0.408652,-0.384331,-0.345429,-0.27002,-0.196651,-0.138801,-0.065519,0.010888,0.05949,0.028644,-0.034514,-0.088104,-0.152953,-0.158411,-0.130459,-0.129198,-0.082105:-0.109311,-0.153393,-0.156549,-0.134805,-0.154087,-0.160862,-0.103123,-0.135866,-0.188361,-0.12152,-0.160957,-0.260313,-0.283755,-0.3316,-0.350978,-0.361661,-0.382053:0.423848,0.432324,0.385444,0.289466,0.222237,0.175678,0.097908,0.077924,0.050761,-0.139401,-0.148336,-0.052081,-0.042731,-0.06189,-0.093914,-0.05467,-0.019413:0.043656,0.008269,-0.019361,-0.03917,-0.029452,-0.014439,-6.95E-4,-0.091754,-0.19096,-0.261805,-0.235644,-0.268762,-0.256534,-0.20263,-0.161738,-0.200724,-0.238557:-0.126077,-0.184544,-0.184289,-0.176536,-0.220182,-0.252518,-0.37922,-0.435766,-0.368236,-0.202364,-0.218637,-0.176284,-0.150737,-0.191553,-0.233712,-0.244854,-0.251735:0.068359,0.052687,0.098103,0.077733,-0.019951,-0.123595,-0.103201,-0.100893,-0.104726,-0.056542,-0.007582,0.076081,0.093485,0.0665,0.055871,0.081507,0.11619:0.047961,0.027237,0.048031,0.110177,0.176791,0.167189,0.205124,0.186682,0.104525,0.119986,0.149372,0.025526,-0.006013,0.012181,-6.8E-5,-0.065942,-0.125248:1
0.909315,0.93,1.037476,1.201256,1.282603,1.204281,1.277014,1.274289,1.167247,1.101487,1.043519,1.011749,1.013762,0.871575:-0.112361,-0.214157,-0.11028,-0.176348,-0.322722,-0.259559,-0.320963,-0.434685,-0.493665,-0.507149,-0.465808,-0.425444,-0.419543,-0.392858:0.749605,0.72618,0.455088,0.365536,0.398362,0.351681,0.371111,0.468077,0.550824,0.595837,0.659134,0.760107,0.805857,0.761589:-0.536469,-0.439735,-0.293697,-0.335663,-0.309866,-0.235486,-0.195737,-0.20373,-0.189601,-0.089892,-0.004112,-0.045285,0.027499,0.066469:-0.185042,-0.133005,-0.079974,-0.002864,0.034961,0.011143,0.086672,0.260138,0.281682,0.315784,0.343252,0.44411,0.488178,0.461942:-0.330685,-0.286941,-0.295667,-0.283062,-0.239511,-0.23247,-0.268478,-0.20492,-0.123073,-0.124667,-0.120977,-0.150515,-0.163705,-0.016615:-0.097017,-0.084586,-0.06634,-0.025602,-0.01917,0.012537,-0.019691,-0.145586,-0.210232,-0.213016,-0.214221,-0.24194,-0.266734,-0.249898:0.368622,0.376297,0.316656,0.329369,0.328989,0.283033,0.214039,0.149549,0.136691,0.090453,0.005822,0.013706,-0.001422,-0.040181:-0.110583,-0.160981,-0.152178,-0.193296,-0.246587,-0.204994,-0.235899,-0.254864,-0.236043,-0.255947,-0.2409,-0.253425,-0.257699,-0.28855:-0.107461,-0.206677,-0.255779,-0.30519,-0.321986,-0.336961,-0.278457,-0.228173,-0.239818,-0.217798,-0.194197,-0.228807,-0.212858,-0.200807:0.127103,0.12716,0.125279,0.080274,0.054446,-0.004666,0.008626,0.025656,0.06439,0.093615,0.07218,0.057901,0.059976,0.107939:0.017513,0.016802,0.072215,0.118111,0.141912,0.196732,0.229524,0.247534,0.224012,0.168525,0.142007,0.161323,0.109053,0.028734:1
1.150639,1.24706,1.269098,1.289961,1.389294,1.456287,1.420686,1.252209,1.062246,0.988805,0.997912,0.953197,0.856577,0.744143:-0.190578,-0.180708,-0.086498,-0.184865,-0.326087,-0.398315,-0.390584,-0.307534,-0.248442,-0.289113,-0.322094,-0.280671,-0.183545,-0.268284:0.562465,0.501268,0.29563,0.326296,0.490548,0.505372,0.501999,0.436751,0.394744,0.431559,0.459435,0.419334,0.432902,0.667431:-0.146862,-0.159556,-0.095281,-0.132531,-0.278633,-0.232021,-0.176515,0.008217,0.142428,0.1298,0.148502,0.278504,0.300241,0.181007:-0.402289,-0.332923,-0.275123,-0.173697,-0.012178,0.158393,0.234225,0.269128,0.325677,0.421833,0.453039,0.420468,0.43772,0.399796:-0.385894,-0.332207,-0.293166,-0.248582,-0.207796,-0.196216,-0.124958,-0.081013,-0.087827,-0.028105,0.018902,-0.035079,-0.138838,-0.091024:0.324414,0.276059,0.233744,0.160253,0.055306,-0.080687,-0.1373,-0.133184,-0.043432,-0.105608,-0.14414,-0.077954,-0.057541,-0.207869:-0.04772,-0.071612,-0.015973,0.023721,-0.004327,-0.118531,-0.211044,-0.351726,-0.420459,-0.423628,-0.452155,-0.420954,-0.383162,-0.285421:-0.122438,-0.081193,-0.041817,-0.030337,-0.033625,-0.049382,-0.047506,0.003008,-0.007272,-0.011217,-0.018447,-0.053173,-0.078646,-0.075059:-0.029703,-0.098538,-0.216096,-0.275098,-0.277367,-0.231234,-0.192806,-0.265167,-0.267961,-0.240974,-0.174568,-0.182767,-0.222391,-0.25867:-0.094095,-0.126867,-0.142268,-0.23664,-0.345757,-0.35541,-0.348979,-0.226879,-0.161362,-0.146034,-0.166112,-0.164439,-0.095005,-0.073679:0.158405,0.194833,0.170861,0.21162,0.30113,0.335051,0.286742,0.319441,0.279468,0.227469,0.151809,0.092432,0.052156,0.021505:1
1.13164,1.311113,1.290049,1.318292,1.491549,1.57544,1.578925,1.460078,1.569074,1.52871,1.448286,1.381956,1.25838,1.164661,1.119945:0.270279,-0.101263,-0.151758,0.072772,0.063008,-0.033412,-0.195205,-0.219225,-0.312195,-0.338273,-0.457778,-0.4341,-0.382374,-0.399961,-0.429497:0.739673,0.502163,0.4302,0.527553,0.428127,0.297828,0.179115,0.174257,0.288262,0.400085,0.505819,0.456064,0.421054,0.504965,0.530462:-0.310325,-0.377089,-0.424655,-0.438854,-0.54266,-0.429078,-0.236086,-0.257044,-0.291316,-0.273319,-0.221032,-0.12495,-0.043783,0.002861,0.123055:-0.020386,0.016965,-0.020797,-0.027352,0.018214,-0.006524,-0.042108,0.059286,0.221919,0.298208,0.410149,0.483448,0.486485,0.485255,0.461943:-0.524192,-0.446904,-0.442189,-0.43952,-0.263247,-0.206306,-0.122591,-0.093446,-0.12185,-0.029769,0.035309,-0.027037,-0.066118,-0.067494,-0.040234:-0.214623,-0.211112,-0.184192,-0.205391,-0.128327,-0.110903,-0.165205,-0.199549,-0.200125,-0.365356,-0.459872,-0.403813,-0.342631,-0.385267,-0.425122:0.168158,0.242711,0.272168,0.275488,0.205839,0.272779,0.277252,0.13368,0.009694,0.030743,-0.00287,-0.061952,-0.103734,-0.086977,-0.099275:-0.178383,-0.159733,-0.106583,-0.080575,-0.131185,-0.120511,-0.129835,-0.099538,-0.129985,-0.067083,-0.121979,-0.232845,-0.25765,-0.221528,-0.168386:-0.121794,-0.200028,-0.249256,-0.288183,-0.273277,-0.423546,-0.432228,-0.393757,-0.316388,-0.347567,-0.316971,-0.274758,-0.292643,-0.334659,-0.355327:0.098868,0.01518,-0.01316,0.047822,-0.021589,-0.077252,-0.139707,-0.177242,-0.217049,-0.160303,-0.047551,0.031929,0.043742,0.056923,0.055851:0.112257,0.097888,0.109049,0.116389,0.064058,0.053937,0.018108,0.030802,0.101865,0.04703,-0.001591,0.01146,0.0407,0.017084,-0.005008:1
1.399128,1.267651,1.515121,1.667603,1.601337,1.731402,1.672725,1.473706,1.520729,1.118043,0.25604,0.072195,0.590603,1.205052,1.375627:-0.343207,-0.531646,-0.538119,-0.455854,-0.52825,-0.689267,-0.54403,-0.48322,-0.567497,-0.337721,-0.015887,-0.013866,-0.317955,-0.642617,-0.792459:0.716811,0.698621,0.63786,0.444622,0.371762,0.407254,0.40283,0.474933,0.499117,0.288328,0.360707,0.48677,0.558842,0.775015,0.978507:-0.585551,-0.607688,-0.592914,-0.422037,-0.320158,-0.267094,-0.252764,-0.208832,-0.126332,0.033412,-2.76E-4,0.033438,0.182607,0.047188,-0.015287:-0.131684,-0.138077,-0.044264,-0.001333,0.05635,0.125183,0.247749,0.40894,0.515504,0.53827,0.59197,0.547263,0.547286,0.471528,0.422981:-0.253698,-0.115771,-0.08909,-0.08312,-0.049962,-0.082639,-0.066841,-0.056029,-0.052305,-0.095636,-0.100101,-0.09718,-0.157872,-0.027278,0.025122:-0.259544,-0.253289,-0.320668,-0.220889,-0.215847,-0.191287,-0.265544,-0.338618,-0.40885,-0.332692,-0.189571,-0.146265,-0.143011,-0.390254,-0.515855:0.391923,0.398088,0.380823,0.281283,0.2332,0.172756,0.050346,-0.028148,-0.052608,-0.122268,-0.189323,-0.16858,-0.164173,-0.035267,0.014642:-0.031476,-0.028213,0.00385,-0.028172,-0.070157,-0.12852,-0.128226,-0.198683,-0.243691,-0.214874,-0.260202,-0.315835,-0.299377,-0.297116,-0.269192:-0.274924,-0.369421,-0.401387,-0.388253,-0.399246,-0.34301,-0.356956,-0.29438,-0.221438,-0.247947,-0.207469,-0.195759,-0.200045,-0.322778,-0.363116:0.113393,0.08051,0.012239,-0.049455,-0.103421,-0.187941,-0.156405,-0.061778,0.007783,0.03768,0.019726,0.004896,-0.007571,0.108221,0.133912:0.099427,0.07993,0.078431,0.117501,0.070863,0.064776,0.172157,0.152167,0.076085,0.066338,0.059951,0.070725,0.081564,0.009165,-0.054855:1
1.534764,1.534597,1.663754,1.575393,1.291198,1.362346,1.365495,1.317975,1.284325,1.297862,1.322102,1.151756,1.083681,1.154806,1.256743,1.167572,1.028805,0.93788,0.948668,0.901747,0.870623:-0.293634,-0.275996,-0.325568,-0.572963,-0.52998,-0.383617,-0.280327,-0.214486,-0.27171,-0.377045,-0.448322,-0.533564,-0.535234,-0.567144,-0.567866,-0.550867,-0.460866,-0.446114,-0.50171,-0.52456,-0.492641:0.697925,0.598688,0.510932,0.584884,0.587566,0.504349,0.416021,0.331147,0.534851,0.709652,0.642123,0.621293,0.695113,0.642623,0.497713,0.538803,0.536727,0.562021,0.629602,0.708061,0.715869:-0.231267,-0.255996,-0.234888,-0.17643,-0.084848,-0.242083,-0.280696,-0.179611,-0.255311,-0.243636,-0.161898,-0.037542,-0.004617,0.023376,0.122911,0.085081,0.096939,0.15628,0.104472,0.122145,0.174196:-0.387495,-0.34072,-0.323128,-0.405552,-0.325938,-0.144744,-0.06286,-0.11229,-0.040557,-0.040671,0.068909,0.17088,0.260558,0.385305,0.481967,0.533662,0.558503,0.479215,0.524328,0.466772,0.458146:-0.423325,-0.461127,-0.467327,-0.235987,-0.234877,-0.278956,-0.257479,-0.170785,-0.062876,-0.009519,0.043746,0.043313,0.02185,-0.014452,-0.033109,-0.004658,-0.054245,-0.013178,-0.018305,-0.025465,-0.081129:-0.169507,-0.11927,-0.056795,-0.225425,-0.301744,-0.149766,-0.049423,-0.036539,-0.057025,-0.102215,-0.154014,-0.163462,-0.124814,-0.120071,-0.188238,-0.245956,-0.22201,-0.204695,-0.249413,-0.196691,-0.161138:0.07916,0.102404,0.077065,0.060941,-5.38E-4,0.07075,0.065243,0.018351,-0.054398,-0.15165,-0.288204,-0.304092,-0.314721,-0.226206,-0.232968,-0.201143,-0.190706,-0.262375,-0.240205,-0.276497,-0.271707:0.139475,0.128827,0.103187,0.139739,0.133549,0.11506,0.118959,0.078879,-0.072339,-0.143997,-0.15533,-0.150802,-0.257629,-0.353491,-0.234989,-0.252776,-0.289209,-0.219324,-0.245911,-0.274327,-0.259461:-0.09591,-0.072071,-0.042543,-0.176076,-0.190451,-0.1995,-0.281476,-0.361484,-0.341362,-0.245385,-0.151219,-0.1744,-0.113459,-0.11955,-0.179231,-0.159056,-0.118297,-0.152349,-0.118478,-0.067234,-0.078972:-0.153268,-0.187969,-0.222141,-0.154424,-0.146277,-0.268329,-0.311725,-0.202611,-0.09613,-0.070859,-0.095504,-0.106673,-0.031813,-0.006784,-0.08904,-0.072906,-0.069364,-0.075958,-0.079405,-0.09246,-0.119568:0.235328,0.199355,0.160647,0.163818,0.215198,0.226013,0.281428,0.271559,0.285666,0.220023,0.170023,0.20205,0.159526,0.120687,0.150453,0.068453,0.009944,0.032376,-0.005528,-0.035072,-0.01613:1
1.088468,1.110773,1.078846,1.121062,1.220499,1.310379,1.320922,1.21525,1.184272,1.156129,1.098663,1.166,1.21733,1.140581,1.105063,1.1198:0.081806,-0.003066,-0.157215,-0.258559,-0.312835,-0.373949,-0.269567,-0.207899,-0.255175,-0.40727,-0.471676,-0.392987,-0.343095,-0.349137,-0.361028,-0.359844:0.650128,0.631543,0.6309,0.575491,0.569161,0.563711,0.446169,0.396295,0.350293,0.481644,0.590945,0.505194,0.402116,0.395489,0.399507,0.456107:-0.539392,-0.564313,-0.485817,-0.394771,-0.462897,-0.437805,-0.358876,-0.256758,-0.16251,-0.17461,-0.159013,-0.081563,0.074703,0.105611,0.142749,0.126501:-0.223628,-0.122728,-0.061556,-0.02301,0.103559,0.139653,0.163303,0.240008,0.334065,0.397306,0.387425,0.398887,0.360159,0.432321,0.442067,0.415173:-0.421568,-0.299133,-0.211835,-0.156514,-0.148069,-0.089183,-0.037222,0.005079,-0.011663,-0.010448,0.037219,0.033333,0.039451,0.032479,0.020123,0.023207:-0.07936,-0.107636,-0.211373,-0.224537,-0.176889,-0.207204,-0.193452,-0.231156,-0.25678,-0.281453,-0.330942,-0.28532,-0.28537,-0.308796,-0.328473,-0.348506:0.275351,0.272824,0.325436,0.307288,0.353185,0.315265,0.149636,0.026193,-0.037471,-0.018871,-0.041723,-0.152142,-0.248302,-0.243207,-0.232185,-0.224027:0.001684,-0.022504,-0.001438,0.026883,-0.06788,-0.101206,-0.00795,-0.052768,-0.087406,-0.162091,-0.181212,-0.203256,-0.100481,-0.104054,-0.110911,-0.137894:-0.144648,-0.188468,-0.270212,-0.346999,-0.406562,-0.464401,-0.45807,-0.459757,-0.475552,-0.427711,-0.363392,-0.314196,-0.349669,-0.366124,-0.371956,-0.351959:0.148221,0.071057,0.037612,0.014087,-0.029996,-0.088258,-0.203661,-0.109811,-0.05861,-0.03314,0.024452,0.071793,0.039837,0.066262,0.083743,0.098603:0.124753,0.118375,0.132213,0.194243,0.160991,0.136884,0.182205,0.200211,0.239672,0.245073,0.14965,0.13122,0.163704,0.151543,0.12826,0.081224:1
0.91504,0.924537,1.031669,1.216242,1.333981,1.518447,1.540229,1.369999,1.268603,1.544377,1.437891,1.190354,1.074075,1.195419,1.346689:0.113486,-0.007616,-0.046127,-0.453245,-0.505,-0.238606,-0.356073,-0.464169,-0.447585,-0.562113,-0.376128,-0.262023,-0.324455,-0.468314,-0.646863:0.491946,0.538392,0.517596,0.591269,0.604433,0.308892,0.333341,0.592619,0.663674,0.719667,0.793687,0.719437,0.681411,0.702418,0.903277:-0.38262,-0.449885,-0.568272,-0.537921,-0.471978,-0.393895,-0.26174,-0.294615,-0.200142,-0.079853,-0.142931,-0.035795,0.192233,0.247441,0.132326:-0.080644,-0.084152,-0.014802,-0.057184,-0.043074,0.16396,0.189414,0.177478,0.122722,0.195899,0.305722,0.372289,0.379001,0.438957,0.520244:-0.401453,-0.321994,-0.240863,-0.092234,-0.010171,-0.125613,-0.111391,0.113016,0.23682,0.13926,0.06801,0.042817,0.061323,0.134997,0.044648:-0.080646,-0.057905,-0.062075,-0.244966,-0.287954,-0.226945,-0.151212,-0.30201,-0.323332,-0.319965,-0.216893,-0.103527,-0.198993,-0.312265,-0.379189:0.232774,0.239916,0.252849,0.219629,0.238005,0.173784,0.065817,0.050336,-0.002441,-0.057332,-0.09879,-0.121428,-0.134687,-0.073044,0.037663:-0.183325,-0.171668,-0.182443,-0.055705,-0.014779,-0.018315,-0.05416,-0.095241,-0.100522,-0.157751,-0.339762,-0.291596,-0.188781,-0.182975,-0.209131:-0.287493,-0.314774,-0.345273,-0.399568,-0.475696,-0.455062,-0.336337,-0.417746,-0.437068,-0.379497,-0.355722,-0.370266,-0.325608,-0.330688,-0.349021:0.076799,0.012397,-0.012897,-0.107596,-0.098344,-0.155159,-0.249153,-0.102435,-0.068108,0.006639,0.128608,0.083276,0.072058,0.080329,0.02236:0.082329,0.112309,0.113723,0.171011,0.184223,0.219508,0.200252,0.128885,0.107189,0.110016,0.15971,0.177644,0.058634,0.009665,0.011441:1
1.230617,1.46916,1.562526,1.588722,1.423469,1.179826,1.120673,1.133405,1.200804,1.327589,1.228057,1.034251,0.956642,0.937792,0.915334:-0.140656,-0.201954,-0.264775,-0.427712,-0.360519,-0.165594,-0.241489,-0.515344,-0.559037,-0.57676,-0.539057,-0.528409,-0.580854,-0.566178,-0.63776:0.238559,0.236249,0.292792,0.393339,0.434608,0.381865,0.416012,0.566787,0.588483,0.466603,0.35947,0.371854,0.462303,0.525134,0.579964:-0.280207,-0.205359,-0.138323,-0.069397,-0.082119,-0.061234,-0.012443,-0.013771,0.083772,0.165451,0.266059,0.3276,0.393265,0.341135,0.309014:0.077718,0.061638,0.101545,0.133441,0.159725,0.285824,0.283661,0.324537,0.283263,0.33637,0.402594,0.435587,0.419488,0.3627,0.277109:-0.233186,-0.173552,-0.172869,-0.146921,-0.099565,-0.093728,-0.023545,-0.03774,-0.073251,-0.066606,-0.059426,-0.064982,-0.067009,0.003613,0.062199:0.013333,-0.018498,-0.016827,-0.001989,-0.004533,-0.030273,-0.088167,-0.135525,-0.096142,-0.115675,-0.16101,-0.162761,-0.156778,-0.220809,-0.237463:0.24314,0.23112,0.245201,0.181681,0.052599,-0.032882,-0.09487,-0.091112,-0.093459,-0.147757,-0.14176,-0.167914,-0.167305,-0.122701,-0.099908:-0.146384,-0.230229,-0.282977,-0.356906,-0.378598,-0.3906,-0.419675,-0.417587,-0.366433,-0.363528,-0.383335,-0.358492,-0.342095,-0.345379,-0.370466:-0.356229,-0.387972,-0.405827,-0.362688,-0.345641,-0.381579,-0.229739,-0.133617,-0.157471,-0.138454,-0.124231,-0.115245,-0.131351,-0.175615,-0.201949:-0.093334,-0.088216,-0.08189,-0.068742,-0.052398,0.041946,0.08786,0.124115,0.069475,0.078771,0.107468,0.065643,0.050857,0.085078,0.114454:0.144191,0.116289,0.115108,0.073382,0.106167,0.175163,0.051885,-0.027507,2.29E-4,-0.017097,-0.069945,-0.069674,-0.063588,-0.113304,-0.150938:1
1.446814,1.734038,1.522698,1.585777,1.587498,1.645961,1.721178,1.699042,1.641534,1.578874,1.499765,1.582196,1.383592,1.461436,1.481151,1.205342,1.273914,1.271859,1.35755:-0.318667,-0.565097,-0.322337,-0.418757,-0.414379,-0.426125,-0.49102,-0.467732,-0.47601,-0.559405,-0.613781,-0.649904,-0.580536,-0.56287,-0.683364,-0.649643,-0.651803,-0.618895,-0.768087:0.513474,0.63397,0.320559,0.336066,0.335013,0.389522,0.353279,0.352263,0.375885,0.514297,0.588025,0.58265,0.480819,0.555253,0.744781,0.64021,0.598146,0.52888,0.707721:0.022197,-0.002178,0.037669,0.068958,0.059101,0.029,0.11663,0.027277,-0.046332,-0.145325,-0.149296,-0.124606,0.022535,-0.04839,-0.043529,0.120904,0.130473,0.265934,0.209641:-0.250185,-0.173276,-0.268206,-0.248636,-0.168013,-0.12224,-0.032529,-0.017661,0.070076,0.110138,0.099846,0.169295,0.131241,0.189035,0.184797,0.219509,0.305919,0.228445,0.231404:-0.330868,-0.349902,-0.341012,-0.290405,-0.229579,-0.202346,-0.244898,-0.130321,-0.023588,0.064871,0.152436,0.177887,0.138844,0.05741,0.014379,6.62E-4,-0.140706,-0.163184,-0.177469:-0.373807,-0.375604,-0.323087,-0.404455,-0.438571,-0.41219,-0.392073,-0.376645,-0.328485,-0.297971,-0.277307,-0.329396,-0.324225,-0.310338,-0.395377,-0.435089,-0.450778,-0.386976,-0.364945:0.19965,0.08308,0.105128,0.052597,0.003845,-0.011997,-0.082356,-0.091503,-0.098312,-0.090508,-0.116351,-0.109132,-0.085282,-0.069051,-0.047374,-0.083611,-0.079384,-0.069892,-0.065887:0.002386,0.016099,0.03477,0.066125,0.101638,0.112053,0.062469,0.077631,-0.013832,-0.159668,-0.19712,-0.176068,-0.161328,-0.186268,-0.167693,-0.108994,-0.106193,-0.140584,-0.190302:-0.224626,-0.233974,-0.196352,-0.206246,-0.208641,-0.219153,-0.22184,-0.318319,-0.397491,-0.39647,-0.399016,-0.418336,-0.438868,-0.455682,-0.405062,-0.377547,-0.331743,-0.323222,-0.305244:-0.083509,-0.090376,-0.142561,-0.149652,-0.19177,-0.228055,-0.233767,-0.253165,-0.180215,-0.03436,0.018541,0.033788,0.015132,0.029274,0.045713,0.025272,-0.032208,-0.035943,-0.028387:0.044057,0.090279,0.058604,0.058394,0.054417,0.045524,0.068984,0.148,0.228186,0.217674,0.222384,0.216312,0.209703,0.228166,0.133254,0.088531,0.05962,0.024741,0.029089:1
1.553173,1.647792,1.688864,1.5382,1.722443,1.504405,1.599441,1.643418,1.666701,1.65246,1.563245,1.438363,1.413373,1.409852,1.437613,1.324031,1.278713,1.139082,1.020596,0.870741,0.704187,0.652378:-0.127693,-0.320824,-0.353799,-0.280949,-0.435315,-0.392336,-0.5023,-0.582957,-0.574009,-0.566995,-0.551948,-0.568388,-0.538387,-0.586699,-0.68942,-0.65479,-0.681539,-0.704588,-0.686937,-0.637351,-0.569231,-0.564846:0.391798,0.595265,0.568243,0.386523,0.387453,0.242224,0.248472,0.302541,0.305233,0.272566,0.293437,0.336562,0.281989,0.25726,0.320577,0.390295,0.457142,0.462714,0.471678,0.424515,0.342379,0.310426:-0.438605,-0.555282,-0.510661,-0.440751,-0.500181,-0.390812,-0.395904,-0.362048,-0.371992,-0.282094,-0.293655,-0.327324,-0.264613,-0.220493,-0.227823,-0.22144,-0.170065,-0.113362,-0.055738,0.025324,0.169821,0.285249:0.092442,0.070723,0.01037,0.012413,0.097811,0.095371,0.12815,0.138931,0.136361,0.118564,0.188841,0.223979,0.20559,0.209703,0.245345,0.333581,0.378403,0.357184,0.359599,0.398479,0.379983,0.35648:-0.37617,-0.310653,-0.252368,-0.207275,-0.166427,-0.099243,-0.066641,-0.028856,0.011064,0.064965,0.113857,0.100954,0.074992,0.093715,0.058723,-0.03566,-0.065305,-0.064359,-0.091167,-0.153523,-0.190654,-0.22353:-0.241978,-0.297112,-0.273682,-0.228632,-0.283635,-0.306751,-0.344851,-0.388867,-0.322129,-0.283701,-0.324984,-0.343054,-0.340169,-0.402253,-0.44867,-0.464159,-0.465995,-0.387387,-0.353093,-0.289792,-0.192083,-0.104731:0.252099,0.311664,0.26639,0.189813,0.121679,0.062887,0.056126,0.067011,0.092682,0.005436,-0.066962,-0.08939,-0.114297,-0.111243,-0.07369,-0.076206,-0.12624,-0.159148,-0.178858,-0.211751,-0.27119,-0.331514:-0.068874,-0.118128,-0.061191,-0.023845,-0.068607,0.02354,0.03483,0.010154,-0.052213,-0.054202,-0.052435,-0.090629,-0.111277,-0.08985,-0.105041,-0.134893,-0.141783,-0.183447,-0.183552,-0.200519,-0.229464,-0.236417:-0.251354,-0.249979,-0.255721,-0.249312,-0.215075,-0.240399,-0.336468,-0.412716,-0.503843,-0.480537,-0.431775,-0.391145,-0.402992,-0.426665,-0.425161,-0.360836,-0.286624,-0.257295,-0.24618,-0.211769,-0.152226,-0.131977:0.048273,0.063763,0.041852,-0.003228,-0.059079,-0.092348,-0.122431,-0.091852,-0.129599,-0.190813,-0.200763,-0.174276,-0.122177,-0.088544,-0.038743,-0.001696,0.004233,0.019106,0.024194,-0.001042,-0.026383,-0.04027:0.175041,0.162092,0.169609,0.137781,0.144366,0.110563,0.167314,0.195018,0.216571,0.208979,0.178873,0.160877,0.180601,0.180087,0.171652,0.164659,0.162993,0.160221,0.154328,0.14924,0.10156,0.091554:1
1.814525,1.913461,1.643941,1.848799,1.839051,1.92841,1.695766,2.003249,1.787962,1.999333,2.081855,2.203141,1.905346,1.867525,1.661347,1.671889,1.803776,1.872214,1.893222,1.772602:-0.081445,-0.136827,-0.090529,-0.266479,-0.161169,-0.192537,-0.239186,-0.463823,-0.184362,-0.347605,-0.600221,-0.865502,-0.718912,-0.703326,-0.663582,-0.761271,-0.924345,-0.995666,-1.030526,-1.017697:0.406462,0.378663,0.335565,0.34824,0.16193,0.143783,0.142268,0.301816,0.131328,0.175564,0.365229,0.630121,0.538112,0.565267,0.476801,0.603038,0.795638,0.85273,0.882958,0.885766:0.045165,0.028427,0.053616,0.075756,0.102184,0.072931,0.105714,0.065488,0.079361,0.143843,0.166957,8.7E-4,0.018139,0.05121,0.231483,0.218876,0.15709,0.141706,0.158179,0.150642:-0.691587,-0.638446,-0.574465,-0.497886,-0.371271,-0.37755,-0.294308,-0.276633,-0.208698,-0.137619,-0.094964,0.007602,0.095584,0.086255,0.027188,0.065373,0.133068,0.194975,0.194945,0.227201:-0.336256,-0.338539,-0.278628,-0.250879,-0.245521,-0.168413,-0.096023,-0.016368,0.01489,-0.019116,2.11E-4,0.012993,0.068631,0.147812,0.17961,0.145413,0.074282,0.062342,0.083371,0.101175:-0.11607,-0.069063,-0.009622,-0.062838,-0.045897,0.006237,-0.054203,-0.103689,-0.142945,-0.21379,-0.223099,-0.272979,-0.281822,-0.289902,-0.298297,-0.291956,-0.333668,-0.395435,-0.418662,-0.421517:-0.142007,-0.11171,-0.143472,-0.13264,-0.163659,-0.154306,-0.110442,-0.158421,-0.255093,-0.255627,-0.251368,-0.203719,-0.212216,-0.268684,-0.28303,-0.28924,-0.265803,-0.220422,-0.199824,-0.168739:0.094531,0.081588,0.043421,0.059141,0.076132,0.027178,-0.017574,-0.02043,0.022933,-0.032533,-0.089013,-0.17098,-0.144963,-0.141655,-0.125028,-0.126376,-0.153147,-0.186839,-0.185917,-0.171756:-0.125119,-0.10744,-0.109197,-0.137999,-0.246382,-0.305294,-0.30539,-0.292361,-0.274259,-0.245159,-0.253617,-0.287737,-0.341511,-0.330048,-0.289832,-0.255087,-0.206243,-0.207742,-0.247347,-0.264767:-0.098098,-0.127575,-0.118097,-0.2004,-0.216415,-0.254281,-0.216012,-0.252227,-0.245443,-0.229979,-0.17696,-0.152599,-0.10774,-0.051453,-0.019564,0.005098,-0.011869,0.032937,0.080544,0.075011:0.192558,0.139456,0.090854,0.129727,0.151553,0.171682,0.175607,0.220654,0.163375,0.148459,0.167603,0.173302,0.238413,0.250288,0.211774,0.175033,0.128706,0.071721,0.059579,0.032363:1
1.114909,1.08578,1.192486,1.026753,1.194319,1.195848,1.13148,1.291878,1.520352,1.294939,1.29037,1.369264,1.374749,1.292487,1.127852,1.25305,1.406211:-0.121124,-0.07632,-0.159693,-0.121445,-0.336587,-0.410752,-0.429922,-0.457769,-0.623942,-0.607856,-0.648581,-0.662774,-0.748448,-0.684068,-0.408375,-0.451441,-0.708067:1.015215,0.962219,0.976259,0.86374,0.879784,0.828522,0.777036,0.829503,1.014618,0.969647,0.930489,1.019784,1.170514,1.112072,0.885656,0.855144,1.030679:-0.435922,-0.432658,-0.366494,-0.179242,-0.276508,-0.317516,-0.261941,-0.269479,-0.337592,-0.245665,-0.14707,-0.127393,-0.073911,-0.023419,0.065933,0.060432,-0.063167:-0.323343,-0.265439,-0.266392,-0.247755,-0.174887,-0.053492,0.035569,0.024801,0.081336,0.087413,0.17843,0.201081,0.184912,0.187619,0.171668,0.270107,0.306286:-0.315735,-0.342712,-0.305959,-0.271258,-0.100703,-0.005424,0.039537,0.136982,0.213987,0.232494,0.207555,0.160525,0.087235,0.095196,0.140684,0.062905,0.190647:-0.312388,-0.309686,-0.328253,-0.384739,-0.343256,-0.360025,-0.395585,-0.374851,-0.410641,-0.364976,-0.376823,-0.411419,-0.521944,-0.493182,-0.436227,-0.403772,-0.446484:0.203715,0.244361,0.201852,0.149977,0.174233,0.178071,0.13301,0.075446,0.018488,-0.010124,-0.048229,-0.071578,-0.036571,-0.053582,-0.13375,-0.135968,-0.119747:-0.018818,-0.036079,-0.044513,-0.051365,-0.042906,-0.050732,-0.056545,-0.056241,-0.132985,-0.138738,-0.183871,-0.193073,-0.107916,-0.077201,-0.068096,-0.169621,-0.231711:-0.201491,-0.229,-0.242928,-0.252144,-0.32113,-0.391653,-0.41671,-0.424745,-0.432263,-0.408032,-0.36287,-0.300732,-0.334844,-0.347681,-0.312012,-0.303593,-0.327354:0.13477,0.119863,0.107773,0.075688,0.023484,-0.031934,-0.056627,-0.032307,0.07408,0.051019,0.102153,0.101616,0.039406,-0.006659,-0.023187,0.054676,0.123634:0.174407,0.155059,0.139908,0.124648,0.071208,0.077595,0.104608,0.099417,0.115136,0.102502,0.070595,-0.011879,-0.036019,-0.039019,-0.061607,-0.062068,-0.048014:1
1.304824,1.391294,1.393211,1.355873,1.437055,1.406065,1.248447,1.373855,1.456962,1.335742,1.345344,1.282481,1.113669,1.141824,1.341699,1.240605,1.132632:0.106494,0.068295,0.045274,-0.098561,-0.170245,-0.171287,-0.199289,-0.314343,-0.353006,-0.283552,-0.252823,-0.294971,-0.293596,-0.29659,-0.398292,-0.365347,-0.344673:0.673842,0.661429,0.673677,0.609594,0.535669,0.581883,0.534791,0.44722,0.495846,0.4823,0.461156,0.518415,0.469422,0.412605,0.406601,0.394387,0.533299:-0.430655,-0.459121,-0.431509,-0.392927,-0.3707,-0.418838,-0.279484,-0.118827,-0.152731,-0.208787,-0.187739,-0.105232,-0.050882,-0.029596,-6.52E-4,0.009971,-0.062261:-0.012318,-0.023317,0.053768,0.219053,0.280611,0.294708,0.314338,0.30633,0.29729,0.323964,0.316227,0.291188,0.38992,0.483516,0.485882,0.52464,0.532436:-0.463848,-0.413008,-0.361994,-0.272311,-0.224883,-0.141871,-0.172977,-0.147664,-0.05861,-0.039357,-0.02421,-0.060372,-0.168576,-0.185956,-0.113026,-0.120891,-0.03776:-0.203192,-0.138002,-0.146737,-0.239973,-0.216739,-0.16148,-0.172354,-0.143144,-0.081148,-0.031319,-0.026289,-0.010993,0.042671,0.026482,-0.086596,-0.050679,-0.115923:0.31831,0.312054,0.2238,0.204978,0.208402,0.151355,0.087761,-0.045634,-0.160745,-0.117345,-0.103555,-0.187024,-0.238661,-0.227243,-0.217334,-0.276462,-0.314674:0.041553,-0.043612,-0.077534,-0.017939,-0.046987,-0.085562,-0.080004,-0.132242,-0.222021,-0.339573,-0.387785,-0.351373,-0.378178,-0.388302,-0.288581,-0.270786,-0.236332:-0.191541,-0.198387,-0.173089,-0.158494,-0.179136,-0.211082,-0.218367,-0.164455,-0.143808,-0.218489,-0.19782,-0.141429,-0.119225,-0.167532,-0.242718,-0.194246,-0.193899:0.003957,0.02456,0.013988,-0.046026,-0.103786,-0.25219,-0.312595,-0.294349,-0.253586,-0.167142,-0.109914,-0.103251,-0.072552,-0.031777,-0.065342,-0.109215,-0.100695:0.167687,0.117289,0.144424,0.128406,0.08432,0.076349,0.095468,0.082931,0.139031,0.183731,0.123856,0.132811,0.195684,0.233667,0.250143,0.234129,0.230127:1
1.216277,1.161777,1.081685,1.023211,1.096366,1.171417,1.199706,1.240064,1.305465,1.211266,1.01901,0.955648,1.10938:0.012681,0.095236,0.044812,-0.107998,-0.232957,-0.292703,-0.229663,-0.293909,-0.533004,-0.654038,-0.553564,-0.513076,-0.56422:0.40898,0.327397,0.452536,0.541522,0.58901,0.609122,0.542832,0.537479,0.590922,0.647944,0.483741,0.511201,0.681267:-0.426374,-0.389226,-0.409362,-0.415826,-0.355695,-0.266573,-0.273071,-0.160381,-0.025334,0.05303,0.244024,0.262955,0.121117:0.215753,0.280657,0.27304,0.248192,0.279578,0.340838,0.308415,0.304272,0.313182,0.334879,0.268315,0.237176,0.299765:-0.353217,-0.352852,-0.286028,-0.181357,-0.123471,-0.034374,0.072044,0.055016,0.036521,0.077153,0.10682,0.115398,0.060388:-0.101977,-0.011599,-0.043347,-0.168057,-0.252119,-0.272608,-0.254033,-0.243531,-0.276372,-0.304606,-0.21029,-0.192111,-0.13445:0.383549,0.358355,0.364225,0.33026,0.273005,0.170013,0.08332,0.050717,0.080929,-0.038022,-0.234565,-0.252293,-0.282893:-0.007235,-0.00366,-0.030882,-0.090133,-0.153015,-0.197705,-0.214953,-0.228839,-0.256191,-0.216868,-0.136763,-0.165617,-0.241263:-0.183563,-0.23093,-0.272829,-0.299025,-0.334539,-0.361787,-0.362285,-0.395071,-0.385045,-0.290119,-0.237318,-0.247033,-0.207851:-0.208273,-0.206452,-0.233829,-0.210262,-0.169006,-0.140776,-0.108924,-0.05659,-0.017659,0.004913,-0.017819,0.034718,0.018694:0.020444,0.045311,0.05112,0.025225,0.028544,0.085734,0.062222,0.10406,0.068826,0.041651,0.09882,0.064693,0.092466:1
1.11782,1.077202,1.236526,1.485754,1.619087,1.489338,1.279068,1.469151,1.559236,1.511188,1.514433,1.587129,1.48482,1.297777,1.133621,1.027953:-0.066704,-0.210086,-0.204128,-0.104244,-0.225279,-0.254832,-0.258951,-0.327381,-0.301215,-0.258918,-0.327542,-0.462659,-0.54189,-0.592594,-0.724162,-0.690171:0.574879,0.447571,0.456844,0.460147,0.5069,0.538261,0.462756,0.457376,0.339386,0.33748,0.406126,0.468461,0.526677,0.615406,0.579515,0.640242:-0.64307,-0.48432,-0.526025,-0.615787,-0.604829,-0.493594,-0.307194,-0.313057,-0.219891,-0.18227,-0.182398,-0.122726,0.021302,0.021885,0.130178,0.160346:0.273526,0.188394,0.209161,0.289725,0.3367,0.334906,0.380887,0.433723,0.453345,0.437617,0.493565,0.414587,0.348361,0.458164,0.471346,0.483883:-0.375781,-0.370709,-0.367808,-0.364911,-0.280164,-0.234932,-0.268778,-0.209163,-0.092298,-0.080864,-0.057979,0.014576,0.041496,0.005946,-0.075162,-0.026475:-0.237391,-0.231468,-0.224912,-0.287568,-0.401309,-0.359588,-0.354656,-0.414314,-0.375013,-0.258379,-0.28486,-0.334895,-0.352711,-0.347708,-0.389695,-0.407832:0.478281,0.414364,0.412866,0.323176,0.280072,0.254268,0.210209,0.191337,0.086769,0.023537,0.010952,-0.039605,-0.047108,0.013526,0.007727,-0.016861:-0.264385,-0.202973,-0.182233,-0.169553,-0.232909,-0.288615,-0.25582,-0.280119,-0.317104,-0.395031,-0.396984,-0.316836,-0.28199,-0.339159,-0.308836,-0.264037:-0.254979,-0.26564,-0.288822,-0.268474,-0.246208,-0.252764,-0.252852,-0.274974,-0.294333,-0.306518,-0.279616,-0.268347,-0.29451,-0.32365,-0.221711,-0.260204:-0.022492,-0.012836,-0.022821,-0.086694,-0.012698,0.077202,0.060922,0.073125,0.086733,0.084813,0.070613,0.076712,0.133156,0.165085,0.156582,0.143513:-0.052392,0.001502,0.052026,0.08361,0.040706,0.04177,0.072044,0.033151,0.049539,0.123908,0.109006,0.0704,0.056042,0.077357,-0.038589,-0.03278:1
1.050561,1.08985,1.179325,1.185841,1.178166,1.16001,1.154196,1.167316,1.139989,1.026168,0.948798,0.919329,0.947896:-0.050263,-0.092389,-0.232238,-0.362142,-0.28073,-0.284349,-0.298947,-0.288402,-0.197834,-0.311004,-0.463278,-0.410579,-0.360023:0.575311,0.430597,0.32874,0.393791,0.436398,0.640467,0.627666,0.562604,0.575838,0.648437,0.768951,0.802946,0.798481:-0.381542,-0.278089,-0.126913,-0.122981,-0.123665,-0.141316,-0.011026,0.117765,0.11927,0.175635,0.256821,0.249172,0.186581:0.149465,0.223769,0.219619,0.308822,0.317193,0.161923,0.206863,0.275481,0.342504,0.342404,0.276359,0.253849,0.27265:-0.251251,-0.207304,-0.110061,-0.024153,-0.046648,-0.019769,-0.10516,-0.097742,-0.012693,0.072091,0.117379,0.109066,0.114082:-0.038134,0.019118,0.022432,-0.071471,-0.068075,-0.00122,0.07953,0.061768,-0.060078,-0.112668,-0.145911,-0.182043,-0.223058:0.304118,0.162994,0.04085,0.02213,-0.025804,-0.164249,-0.195379,-0.229624,-0.229496,-0.201273,-0.154972,-0.132196,-0.185169:-0.142796,-0.204544,-0.198957,-0.200472,-0.212589,-0.256909,-0.295873,-0.303981,-0.234844,-0.192235,-0.177908,-0.171851,-0.150451:-0.323718,-0.331463,-0.262613,-0.149551,-0.151322,-0.226813,-0.240658,-0.211557,-0.283657,-0.309278,-0.314891,-0.296547,-0.242268:-0.046208,-0.044924,-0.144789,-0.284025,-0.253679,-0.078728,-0.062826,-0.021845,0.054875,0.032399,-6.86E-4,-0.001335,-0.025199:0.174628,0.234461,0.209993,0.096783,0.093293,0.196842,0.254619,0.207301,0.17442,0.167261,0.140237,0.039366,-0.034749:1
1.242771,1.072831,1.165356,1.207858,1.198668,1.121578,1.019561,0.931958,0.903557,0.963404,1.05385,1.052878,0.964784,0.947621:-0.324706,-0.353014,-0.389025,-0.46913,-0.403706,-0.310064,-0.379438,-0.430595,-0.452195,-0.535927,-0.68087,-0.675214,-0.61137,-0.660556:0.543967,0.60351,0.563948,0.567119,0.456508,0.379863,0.5805,0.652689,0.691431,0.786348,0.961209,1.04158,1.09933,1.143231:-0.373026,-0.223142,-0.216534,-0.266621,-0.216454,0.029142,4.25E-4,0.070191,0.166877,0.152062,0.161535,0.120184,-0.038945,0.022668:-0.18143,-0.103556,-0.158108,-0.072392,0.057844,0.074446,0.189253,0.208314,0.174932,0.241697,0.239084,0.315307,0.470141,0.436071:-0.28973,-0.302159,-0.160067,-0.037072,0.023264,0.032859,0.012434,0.104163,0.102996,0.21076,0.223015,0.120912,0.109947,0.081502:0.002265,-0.056409,-0.073883,-0.138187,-0.07638,-0.033693,-0.107702,-0.244137,-0.26331,-0.269965,-0.215426,-0.206793,-0.391649,-0.393783:0.167612,0.054185,0.034617,0.002427,4.4E-5,-0.041443,-0.004791,0.007508,-0.046844,-0.123498,-0.14588,-0.053528,0.018849,-0.003644:-0.095276,-0.142722,-0.11314,-0.082248,-0.05911,-0.065423,-0.096377,-0.087946,-0.102154,-0.171102,-0.237901,-0.312807,-0.265149,-0.276161:-0.276782,-0.22593,-0.289377,-0.31433,-0.322614,-0.329208,-0.369858,-0.378547,-0.310935,-0.264793,-0.216222,-0.187248,-0.224517,-0.203999:-0.229465,-0.149259,-0.105009,-0.049414,-0.057363,-0.05685,-0.030121,0.003126,0.022495,0.10134,0.142017,0.113578,0.093726,0.118564:0.14079,0.223955,0.200262,0.225021,0.230141,0.190683,0.205189,0.141469,0.054024,0.011266,-0.051177,-0.132342,-0.172448,-0.225751:1
1.077155,1.141607,1.281371,1.246666,1.147179,1.254566,1.225848,1.297097,1.181589,0.94208,0.830025,0.876531,0.86193,0.841519,0.827529,0.706666,0.567691,0.563653:-0.563933,-0.496151,-0.454458,-0.457816,-0.529007,-0.500847,-0.808048,-1.117234,-1.17987,-1.150878,-1.169169,-1.207502,-1.304825,-1.338378,-1.316856,-1.342274,-1.281638,-1.317687:0.196,0.212466,0.095795,0.027182,0.023932,-0.109702,-0.081299,0.128209,0.254624,0.266292,0.31524,0.342724,0.450422,0.512868,0.572567,0.674336,0.703973,0.778231:-0.492321,-0.614147,-0.581874,-0.494232,-0.526729,-0.477955,-0.344381,-0.350802,-0.355502,-0.279515,-0.217471,-0.141279,-0.065858,-0.027432,0.012003,-0.028475,0.015263,0.011526:-0.321541,-0.232306,-0.142009,-0.120013,-0.04538,0.069779,0.114694,0.157251,0.201794,0.253215,0.308675,0.336178,0.359489,0.388048,0.402914,0.404047,0.442999,0.455169:-0.406866,-0.365256,-0.345286,-0.288202,-0.252375,-0.228134,-0.150909,-0.025581,0.017793,-0.013039,-0.035687,-0.03854,-0.020503,-0.034021,-0.063774,-0.043849,-0.053879,-0.024745:0.073844,0.036082,0.017539,0.001498,0.015265,-0.013107,-0.133867,-0.295393,-0.366168,-0.396417,-0.440381,-0.435943,-0.44092,-0.459767,-0.447123,-0.451267,-0.417366,-0.396339:0.005135,-0.001499,-0.051493,-0.06116,-0.10539,-0.200017,-0.177265,-0.111658,-0.126331,-0.158174,-0.165308,-0.147199,-0.122864,-0.111919,-0.098543,-0.074679,-0.057316,-0.035966:0.046161,0.044405,0.077911,0.048699,0.063487,0.079537,-0.028303,-0.118254,-0.185752,-0.188249,-0.187565,-0.182251,-0.205475,-0.226189,-0.251973,-0.272685,-0.263797,-0.255105:-0.186685,-0.180397,-0.206256,-0.283163,-0.293464,-0.324837,-0.310552,-0.330487,-0.326894,-0.317832,-0.294935,-0.260007,-0.232404,-0.226762,-0.198962,-0.17123,-0.130382,-0.097224:-0.26155,-0.310957,-0.348079,-0.278757,-0.315768,-0.311149,-0.278199,-0.213523,-0.126947,-0.07501,-0.03516,-0.012422,0.009045,0.016281,0.016835,0.039671,0.030312,0.014119:0.210844,0.230254,0.247984,0.232536,0.276787,0.321516,0.265401,0.222019,0.209223,0.227227,0.210961,0.146168,0.050305,-0.010862,-0.073798,-0.129574,-0.178274,-0.230632:2
0.560677,0.510661,0.585942,0.780779,0.924772,1.166576,1.071604,0.981935,0.975333,1.030692,1.068504,1.227172,1.074429,0.990419,1.10898,1.179654,1.007006:-0.906957,-0.872723,-0.905311,-0.946545,-0.949779,-1.068611,-0.867448,-0.781601,-0.758115,-0.752297,-0.89843,-1.051519,-0.93568,-1.02449,-1.2268,-1.337314,-1.16959:0.26972,0.219086,0.171353,0.175232,0.13631,0.15432,0.134189,0.084001,0.025039,-0.004883,0.054684,0.07672,0.056823,0.21526,0.403932,0.539762,0.550939:-0.603207,-0.580779,-0.554331,-0.531226,-0.486531,-0.441137,-0.525847,-0.536046,-0.469675,-0.409344,-0.245065,-0.071666,-0.031607,0.007896,-0.019314,0.008156,0.047281:-0.230533,-0.193181,-0.088617,-0.012234,0.006926,0.019536,0.226513,0.351595,0.476983,0.497349,0.4084,0.303183,0.472233,0.44328,0.403509,0.324702,0.372519:-0.271454,-0.26793,-0.211729,-0.160615,-0.141533,-0.071799,-0.115121,-0.157744,-0.223889,-0.244879,-0.231733,-0.197478,-0.281977,-0.217691,-0.132266,-0.035721,-0.104368:-0.20027,-0.1785,-0.185051,-0.218521,-0.22705,-0.279052,-0.312455,-0.295222,-0.342726,-0.353142,-0.329415,-0.340254,-0.357486,-0.331523,-0.375476,-0.454482,-0.476174:0.189493,0.159496,0.0989,0.052898,0.001375,-0.03587,0.00201,-0.016541,-0.029883,-0.081008,-0.138554,-0.196085,-0.133742,-0.126294,-0.116498,-0.141551,-0.137408:0.061913,0.041541,-0.022152,-0.093017,-0.100572,-0.136736,-0.228968,-0.311478,-0.343701,-0.366302,-0.37314,-0.295786,-0.384035,-0.370356,-0.338067,-0.279173,-0.2819:-0.221101,-0.23553,-0.29368,-0.332918,-0.358223,-0.387997,-0.370044,-0.32726,-0.290432,-0.227306,-0.195201,-0.204725,-0.088328,-0.100622,-0.125658,-0.182564,-0.152933:-0.210243,-0.220906,-0.168039,-0.122979,-0.13114,-0.09971,-0.071543,-0.047546,-0.044878,-0.020252,0.006392,0.010567,0.047311,0.057712,0.037847,0.075574,0.066291:0.112866,0.139455,0.235752,0.305523,0.33659,0.329111,0.273873,0.224847,0.196415,0.169985,0.164663,0.159175,0.029146,-0.00114,-0.04423,-0.084971,-0.114324:2
0.252195,0.272221,0.335416,0.371955,0.353233,0.338087,0.341346,0.395583,0.445685,0.462184,0.391668,0.407183,0.350453,0.284027,0.172952,0.121476:-0.919811,-0.904389,-0.949742,-1.057776,-1.061093,-1.07297,-1.097422,-1.144582,-1.135348,-1.159866,-1.149655,-1.215007,-1.26483,-1.243597,-1.187659,-1.238949:0.53429,0.474113,0.408736,0.390776,0.363179,0.352766,0.34701,0.346426,0.317543,0.316596,0.33511,0.365269,0.416465,0.453777,0.499754,0.568191:-0.71207,-0.666865,-0.643926,-0.644235,-0.638961,-0.628149,-0.61265,-0.561105,-0.516429,-0.468564,-0.408498,-0.371845,-0.330103,-0.281122,-0.206958,-0.157602:-0.28407,-0.228458,-0.130654,-0.036837,0.032524,0.109329,0.201162,0.297462,0.372476,0.416842,0.429541,0.480241,0.515634,0.556892,0.571346,0.614081:-0.363505,-0.343869,-0.328822,-0.307545,-0.310679,-0.306933,-0.262873,-0.223984,-0.204127,-0.177386,-0.186378,-0.193189,-0.179353,-0.196727,-0.230893,-0.238651:-0.161647,-0.154448,-0.163543,-0.201138,-0.210879,-0.251646,-0.310759,-0.368935,-0.389695,-0.404825,-0.406438,-0.443365,-0.491433,-0.484977,-0.468124,-0.481015:0.312162,0.280278,0.260299,0.249053,0.238107,0.213563,0.15738,0.115628,0.087599,0.049852,0.002179,-0.006059,-0.006159,0.012361,0.019218,0.041376:-0.140145,-0.167217,-0.215786,-0.217334,-0.25054,-0.261797,-0.280807,-0.308174,-0.325936,-0.342417,-0.366572,-0.401164,-0.403006,-0.402395,-0.395499,-0.403444:-0.246842,-0.279402,-0.294517,-0.325337,-0.342448,-0.339234,-0.324437,-0.327683,-0.328193,-0.32926,-0.303013,-0.264598,-0.243719,-0.218111,-0.185647,-0.179788:0.02207,-0.009907,-0.038837,-0.102096,-0.090602,-0.083045,-0.065459,-0.036747,-0.017886,-0.006238,0.031938,0.063148,0.10206,0.101913,0.086663,0.065458:0.10401,0.131279,0.1433,0.183222,0.207309,0.212607,0.221507,0.243282,0.222409,0.190024,0.169345,0.136145,0.086905,0.019029,-0.053005,-0.118426:2
0.234252,0.293354,0.422497,0.500001,0.542148,0.448473,0.380496,0.357779,0.399077,0.398805,0.312645,0.263886,0.251438,0.22357,0.169155,0.105357,0.027341:-0.637166,-0.712223,-0.840864,-0.906655,-0.970686,-0.942845,-0.910532,-0.937038,-0.996821,-1.020785,-1.006147,-0.99924,-0.973652,-0.954402,-0.964992,-0.942579,-0.937604:0.330225,0.330256,0.341705,0.29254,0.239107,0.20308,0.186522,0.183809,0.173008,0.161763,0.188503,0.205844,0.215511,0.245872,0.326375,0.404889,0.446991:-0.714785,-0.720223,-0.746788,-0.742652,-0.684045,-0.632011,-0.574705,-0.487891,-0.433203,-0.392988,-0.373804,-0.332966,-0.28368,-0.254042,-0.189069,-0.157515,-0.098942:-0.21702,-0.160537,-0.054536,0.070078,0.152291,0.235349,0.317631,0.416678,0.478615,0.519761,0.575191,0.593118,0.596349,0.610154,0.624334,0.626762,0.654034:-0.361322,-0.34758,-0.337436,-0.300447,-0.264747,-0.259145,-0.252524,-0.239584,-0.231347,-0.248131,-0.283668,-0.31412,-0.341209,-0.364151,-0.377248,-0.404121,-0.403974:-0.17821,-0.172444,-0.198021,-0.250122,-0.281563,-0.291314,-0.295825,-0.320469,-0.356941,-0.38004,-0.401322,-0.40885,-0.412598,-0.41158,-0.400135,-0.399457,-0.38528:0.290203,0.283221,0.264235,0.217733,0.132563,0.077457,0.029175,-0.030502,-0.060632,-0.076774,-0.086601,-0.102415,-0.113226,-0.106099,-0.084496,-0.064388,-0.058259:-0.094966,-0.108956,-0.143138,-0.167477,-0.173213,-0.183753,-0.209502,-0.250593,-0.28924,-0.318108,-0.359273,-0.369615,-0.351671,-0.332629,-0.335388,-0.342219,-0.346062:-0.243508,-0.266923,-0.268539,-0.286445,-0.286142,-0.294451,-0.307365,-0.309365,-0.309752,-0.288539,-0.238853,-0.204711,-0.174565,-0.12594,-0.095695,-0.074794,-0.070639:0.029613,-0.012941,-0.075776,-0.132095,-0.149266,-0.165807,-0.172508,-0.148188,-0.10069,-0.065247,-0.017093,0.009438,0.015528,0.010017,0.001435,-0.00305,-0.021544:0.188953,0.194722,0.200029,0.215412,0.259854,0.279045,0.285457,0.282159,0.280832,0.252232,0.212785,0.186586,0.148282,0.092574,0.021294,-0.021142,-0.0746:2
-0.026534,-0.057545,0.042287,-0.059456,-0.076064,-0.029591,0.010979,0.049731,0.194957,0.296376,0.25011,0.255327,0.210817,0.184151,0.093626:-0.612432,-0.591919,-0.635741,-0.568449,-0.556176,-0.576458,-0.617264,-0.666414,-0.837184,-0.957345,-0.947985,-1.005676,-1.043871,-1.060534,-1.057497:0.344476,0.297017,0.30325,0.223011,0.199945,0.198982,0.212941,0.231707,0.272505,0.267666,0.283689,0.34138,0.379063,0.422993,0.500495:-0.816777,-0.764848,-0.762551,-0.732669,-0.723659,-0.665765,-0.601795,-0.578696,-0.590623,-0.570311,-0.507753,-0.444195,-0.362331,-0.301494,-0.229134:-0.137667,-0.090814,-0.038376,0.001813,0.06223,0.145972,0.234878,0.306568,0.395537,0.486548,0.537685,0.59852,0.662878,0.690339,0.677528:-0.375823,-0.366955,-0.352712,-0.335894,-0.328583,-0.316913,-0.312662,-0.307487,-0.290517,-0.287523,-0.287708,-0.263572,-0.261475,-0.297842,-0.32672:-0.181929,-0.145474,-0.161119,-0.162561,-0.196408,-0.221523,-0.231823,-0.24049,-0.287497,-0.358183,-0.407468,-0.457057,-0.449218,-0.455641,-0.466712:0.370468,0.324935,0.309424,0.255502,0.248544,0.223802,0.16299,0.120401,0.099784,0.081859,0.037467,0.026332,0.032151,0.0438,0.025128:-0.114808,-0.155241,-0.184234,-0.192722,-0.207273,-0.267766,-0.331561,-0.388136,-0.437805,-0.461923,-0.442162,-0.436427,-0.45749,-0.468001,-0.451057:-0.221603,-0.275319,-0.278881,-0.28004,-0.297975,-0.326634,-0.324305,-0.307729,-0.282493,-0.234592,-0.18837,-0.172728,-0.170274,-0.140624,-0.096695:0.018403,-0.024929,-0.038801,-0.070402,-0.096912,-0.059856,-0.003555,0.024247,0.028645,0.063575,0.090269,0.105099,0.082169,0.054674,0.031025:0.125845,0.14835,0.154551,0.153978,0.177947,0.235889,0.274256,0.287331,0.258423,0.1961,0.176708,0.125669,0.059243,-0.036256,-0.118206:2
0.33358,0.269163,0.215279,0.254496,0.240951,0.327127,0.388374,0.352489,0.354721,0.356416,0.330343,0.268717,0.198289,0.119403,0.057553:-0.704027,-0.678218,-0.634241,-0.652893,-0.691718,-0.76947,-0.816326,-0.804188,-0.878373,-0.919978,-0.951175,-0.96687,-0.942097,-0.921531,-0.91577:0.335314,0.310567,0.288073,0.259555,0.239862,0.217732,0.191213,0.161745,0.187258,0.200788,0.211527,0.260714,0.293485,0.314574,0.339478:-0.784197,-0.747552,-0.714681,-0.682852,-0.631083,-0.599387,-0.573771,-0.544673,-0.518472,-0.458711,-0.391023,-0.321063,-0.259481,-0.215814,-0.189696:-0.107329,-0.043703,-0.005139,0.043546,0.105637,0.184774,0.271073,0.350485,0.423975,0.505744,0.574931,0.619507,0.662046,0.689921,0.703702:-0.43087,-0.42098,-0.417181,-0.401845,-0.372831,-0.341512,-0.317885,-0.315513,-0.339918,-0.353296,-0.346784,-0.363833,-0.398947,-0.436353,-0.466944:-1.33E-4,-0.028184,-0.046559,-0.061371,-0.084296,-0.112507,-0.161748,-0.180594,-0.239915,-0.284407,-0.293851,-0.310256,-0.338284,-0.349097,-0.343935:0.29343,0.257543,0.222025,0.187887,0.129388,0.066974,0.001784,-0.024576,0.007464,0.005867,-0.013529,-0.033184,-0.052237,-0.062267,-0.062161:-0.220943,-0.23137,-0.239437,-0.244982,-0.238893,-0.270599,-0.296716,-0.347735,-0.390816,-0.426935,-0.456527,-0.456422,-0.449206,-0.454383,-0.462122:-0.193781,-0.236446,-0.265845,-0.297203,-0.324539,-0.32742,-0.30274,-0.306385,-0.29815,-0.258615,-0.221602,-0.181294,-0.129999,-0.089418,-0.055471:0.007491,-0.03562,-0.068183,-0.101444,-0.109363,-0.085561,-0.06117,-0.042592,-0.007826,0.037289,0.066129,0.046501,0.027618,0.015223,1.7E-5:0.152369,0.201828,0.24328,0.28127,0.315277,0.356611,0.363114,0.370642,0.337013,0.274596,0.205016,0.13627,0.069338,0.023047,-0.018445:2
0.066826,0.072082,-0.049079,-0.072713,-0.058741,-0.038203,0.012025,0.040504,0.038152,0.032279,0.011279,-0.030925,-0.106163,-0.198377,-0.284007:-0.648387,-0.69124,-0.613866,-0.619267,-0.602324,-0.640338,-0.705152,-0.775389,-0.794986,-0.853053,-0.910277,-0.944214,-0.901405,-0.880259,-0.871348:0.324022,0.309351,0.215648,0.133279,0.058701,0.046573,0.031142,0.034515,0.027734,0.056637,0.126793,0.17524,0.220128,0.2684,0.342772:-0.914499,-0.884934,-0.803949,-0.730421,-0.662135,-0.610972,-0.575832,-0.510004,-0.443793,-0.377539,-0.296641,-0.231356,-0.154455,-0.094866,-0.070161:-0.167877,-0.107907,-0.048283,0.032982,0.144689,0.225731,0.312841,0.426776,0.498167,0.551415,0.597925,0.606478,0.648227,0.685042,0.680051:-0.524749,-0.498282,-0.483122,-0.473614,-0.438732,-0.422821,-0.415405,-0.40999,-0.410602,-0.426266,-0.463237,-0.492863,-0.524821,-0.548845,-0.547633:0.032137,-0.002831,-0.004633,-0.013287,-0.055258,-0.070867,-0.109869,-0.200283,-0.232149,-0.264844,-0.328741,-0.319674,-0.299411,-0.266125,-0.244725:0.407233,0.364634,0.298641,0.250375,0.179979,0.111946,0.047821,-0.022242,-0.073847,-0.09472,-0.102486,-0.114906,-0.112545,-0.117711,-0.136389:-0.193759,-0.186009,-0.173338,-0.172837,-0.176689,-0.2428,-0.283036,-0.288272,-0.313732,-0.333892,-0.333334,-0.34919,-0.376142,-0.422691,-0.458832:-0.081135,-0.122114,-0.158227,-0.196546,-0.230913,-0.267128,-0.277098,-0.239931,-0.218429,-0.198198,-0.154173,-0.099656,-0.049235,0.003573,0.036823:0.054949,0.038885,0.026356,0.002665,-0.024126,-0.016516,-0.019193,-0.014192,0.002324,0.013502,0.023105,0.019175,-0.006174,-0.021872,-0.027151:0.109907,0.185905,0.254996,0.295681,0.317715,0.349455,0.353255,0.331244,0.315911,0.286936,0.225543,0.161978,0.06805,-0.028587,-0.092023:2
0.10973,0.160028,0.165805,0.239707,0.202234,0.191018,0.180565,0.194874,0.245673,0.269489,0.246436,0.212018,0.154896,0.097246,0.051761,0.018538,0.009725,-0.014999:-0.496687,-0.541979,-0.567053,-0.584035,-0.574805,-0.599466,-0.634099,-0.741374,-0.810978,-0.843502,-0.871477,-0.914617,-0.935203,-0.943567,-0.933122,-0.938247,-0.919757,-0.891275:0.348881,0.332712,0.307431,0.247733,0.192779,0.182515,0.168038,0.167392,0.155326,0.161792,0.171137,0.198748,0.243232,0.267829,0.281212,0.294255,0.30991,0.331724:-0.797435,-0.777316,-0.7397,-0.726651,-0.667789,-0.629238,-0.600089,-0.55239,-0.527205,-0.495942,-0.450622,-0.365174,-0.279614,-0.222058,-0.202307,-0.167233,-0.150521,-0.138051:-0.050057,0.028601,0.070907,0.120532,0.18147,0.261167,0.336767,0.398406,0.477688,0.528055,0.577161,0.624399,0.654651,0.679156,0.701062,0.699189,0.695841,0.695645:-0.527729,-0.510415,-0.495284,-0.468582,-0.432355,-0.413337,-0.407161,-0.404177,-0.389746,-0.378751,-0.377147,-0.380481,-0.393527,-0.404789,-0.428493,-0.458703,-0.486677,-0.498259:0.010665,-0.021262,-0.029313,-0.041954,-0.073549,-0.115196,-0.1348,-0.16707,-0.215145,-0.243214,-0.256217,-0.261757,-0.271536,-0.268934,-0.280788,-0.284506,-0.282344,-0.274353:0.307565,0.306355,0.288323,0.251424,0.188568,0.145773,0.113218,0.080257,0.047868,0.023903,0.007222,-0.016914,-0.055372,-0.085897,-0.080798,-0.074363,-0.067704,-0.075626:-0.263568,-0.295284,-0.329374,-0.348534,-0.348174,-0.385567,-0.432755,-0.458694,-0.490919,-0.518202,-0.52697,-0.525502,-0.517975,-0.52573,-0.529878,-0.523719,-0.511233,-0.493448:-0.180435,-0.241872,-0.288688,-0.298456,-0.318243,-0.312349,-0.290041,-0.269413,-0.242293,-0.21155,-0.185904,-0.163366,-0.119462,-0.084178,-0.063713,-0.050009,-0.03041,0.00405:-0.028331,-0.052686,-0.044727,-0.033413,-0.029089,-0.007174,0.004264,0.014534,0.04237,0.06352,0.074509,0.065539,0.057885,0.042463,0.027757,0.016983,0.004874,-0.0081:0.099814,0.130363,0.166449,0.183057,0.220922,0.255987,0.268767,0.256814,0.256978,0.238032,0.211264,0.154687,0.106983,0.073921,0.033785,0.002511,-0.037758,-0.0795:2
0.147799,0.511847,1.090013,1.205141,1.015456,0.996233,0.937716,0.803566,0.703411,0.733034,0.724346,0.594058,0.597614,0.628001,0.594842,0.569725,0.535625,0.444723:-0.913449,-0.886561,-0.859291,-0.939804,-0.930327,-1.079002,-1.157855,-1.17017,-1.139254,-1.129874,-1.138705,-1.111108,-1.09251,-1.098387,-1.098391,-1.111911,-1.124544,-1.129472:0.333292,0.309178,0.134056,0.151148,0.149773,0.214382,0.22634,0.204735,0.235311,0.278378,0.33916,0.372713,0.395917,0.416929,0.475798,0.543266,0.570821,0.591383:-0.703243,-0.705633,-0.608074,-0.544723,-0.537056,-0.580662,-0.568171,-0.488635,-0.448071,-0.380829,-0.304529,-0.299045,-0.280924,-0.209748,-0.163844,-0.144076,-0.083748,-0.062688:-0.126626,-0.082619,-0.071305,-0.033561,0.113966,0.156326,0.196033,0.269242,0.328064,0.349071,0.3652,0.421368,0.424882,0.386124,0.354961,0.362743,0.394101,0.411076:-0.290967,-0.263739,-0.255399,-0.210222,-0.256623,-0.183954,-0.142509,-0.183211,-0.200988,-0.197046,-0.204025,-0.233176,-0.256827,-0.275229,-0.271179,-0.260079,-0.252259,-0.247046:-0.112014,-0.154873,-0.146109,-0.22365,-0.248851,-0.301332,-0.331904,-0.344227,-0.365664,-0.369277,-0.382007,-0.408128,-0.420852,-0.41293,-0.413096,-0.408561,-0.379991,-0.365046:0.199019,0.181401,0.077852,0.073862,0.063833,0.036123,0.003971,-0.029517,-0.052741,-0.081155,-0.100864,-0.096152,-0.100002,-0.121215,-0.129193,-0.110896,-0.096854,-0.106427:-0.143132,-0.162839,-0.124871,-0.150799,-0.215605,-0.255503,-0.284465,-0.302625,-0.322858,-0.343248,-0.372329,-0.394285,-0.399441,-0.389057,-0.382383,-0.37317,-0.362289,-0.363832:-0.281702,-0.293475,-0.31837,-0.322355,-0.260726,-0.256352,-0.265783,-0.248532,-0.231428,-0.20555,-0.159236,-0.139134,-0.118144,-0.089359,-0.063126,-0.040908,-0.028215,-0.02581:-0.082416,-0.070516,-0.07045,-0.024413,-0.028426,0.004221,0.033619,0.035075,0.064422,0.080355,0.098011,0.11374,0.117234,0.108164,0.114787,0.108507,0.078431,0.05074:0.286809,0.328121,0.393441,0.352953,0.321925,0.317601,0.311786,0.306966,0.290442,0.231138,0.140816,0.094335,0.054055,0.014926,-0.030926,-0.076382,-0.120658,-0.157848:2
0.296117,0.364254,0.470947,0.557192,0.595603,0.580052,0.691164,0.793445,0.824486,0.85465,0.890211,0.900503,0.821689,0.7473,0.694812,0.643802,0.560301,0.482451,0.407913,0.325554,0.246504:-0.43303,-0.415161,-0.497841,-0.593348,-0.622289,-0.62139,-0.689144,-0.712872,-0.68669,-0.742294,-0.790295,-0.82232,-0.827036,-0.843785,-0.830926,-0.897829,-0.936217,-0.935339,-0.917316,-0.939022,-0.924561:0.370172,0.336558,0.309884,0.258571,0.20018,0.143614,0.142078,0.123932,0.12422,0.133969,0.089124,0.064377,0.090635,0.136538,0.196923,0.302045,0.386168,0.43448,0.469721,0.508643,0.538164:-0.82965,-0.787572,-0.786536,-0.735531,-0.698268,-0.642143,-0.622001,-0.552464,-0.491615,-0.452391,-0.406683,-0.366122,-0.343392,-0.293585,-0.181445,-0.111239,-0.100702,-0.08204,-0.044836,-0.025622,-0.011509:-0.124913,-0.127669,-0.065256,-0.029307,0.017131,0.06505,0.128764,0.186687,0.265677,0.322474,0.362847,0.401636,0.458502,0.492122,0.511288,0.51406,0.498715,0.484657,0.48463,0.51105,0.512151:-0.525838,-0.50317,-0.466286,-0.436548,-0.416916,-0.41322,-0.396412,-0.369094,-0.342437,-0.302793,-0.303693,-0.322812,-0.332881,-0.32067,-0.311491,-0.267096,-0.264998,-0.288814,-0.313039,-0.321723,-0.332483:0.009756,0.018118,0.009563,-0.006124,-0.015122,-0.02876,-0.064979,-0.089649,-0.132006,-0.172695,-0.197192,-0.229657,-0.270653,-0.301057,-0.295716,-0.288013,-0.290392,-0.264296,-0.237133,-0.235808,-0.2171:0.294041,0.269241,0.249305,0.236608,0.19658,0.153679,0.133823,0.077233,0.040049,0.005839,-0.034324,-0.074919,-0.095966,-0.123933,-0.149242,-0.149606,-0.144612,-0.144944,-0.149851,-0.136998,-0.130372:-0.273089,-0.265427,-0.29521,-0.306256,-0.318975,-0.311598,-0.338683,-0.363152,-0.38998,-0.405409,-0.403716,-0.398503,-0.403792,-0.386285,-0.364512,-0.361096,-0.37473,-0.393165,-0.404156,-0.406886,-0.414586:-0.172601,-0.190694,-0.22028,-0.26885,-0.296946,-0.320355,-0.325323,-0.321903,-0.312363,-0.308347,-0.288386,-0.240615,-0.200654,-0.174796,-0.13078,-0.095614,-0.06508,-0.034957,-0.014934,-0.014706,-0.007119:0.050166,0.041004,0.016155,-0.010365,-0.012132,-0.028124,-0.033961,-0.029366,-0.024496,-0.026072,-0.021603,-0.010581,0.017685,0.034466,0.019852,-0.013474,-0.031661,-0.043831,-0.049767,-0.053547,-0.062916:0.117624,0.141158,0.162938,0.175126,0.196044,0.234785,0.279233,0.309262,0.29471,0.27994,0.269175,0.251386,0.218787,0.198171,0.164351,0.092755,0.019127,-0.04243,-0.091289,-0.123223,-0.146271:2
0.127786,0.148891,0.175716,0.243648,0.235813,0.273058,0.326747,0.396897,0.456469,0.443677,0.431706,0.432608,0.436902,0.385933,0.306229,0.209253,0.107831:-0.611901,-0.618655,-0.681987,-0.771933,-0.805061,-0.856309,-0.891418,-0.92075,-0.905946,-0.919384,-0.951301,-0.948179,-0.943969,-0.933623,-0.877857,-0.893922,-0.925414:0.428238,0.418104,0.408495,0.375679,0.35269,0.319244,0.308536,0.310661,0.31681,0.333795,0.315057,0.358192,0.431113,0.44814,0.494215,0.523507,0.550222:-0.86601,-0.845138,-0.819149,-0.791855,-0.75937,-0.716109,-0.658442,-0.590668,-0.535892,-0.492768,-0.444336,-0.366214,-0.284017,-0.23392,-0.213317,-0.175897,-0.119922:-0.022043,0.02513,0.055781,0.109301,0.179718,0.250026,0.318776,0.400416,0.464216,0.511139,0.544283,0.53799,0.533709,0.586347,0.584785,0.593016,0.603896:-0.423295,-0.404304,-0.395674,-0.380369,-0.365892,-0.345281,-0.317195,-0.289491,-0.297587,-0.303278,-0.313996,-0.317159,-0.309565,-0.30954,-0.333753,-0.324471,-0.321402:-0.026131,-0.046113,-0.047536,-0.069729,-0.107497,-0.12741,-0.162912,-0.213164,-0.259986,-0.295668,-0.325561,-0.359133,-0.360507,-0.329273,-0.305335,-0.266015,-0.243411:0.279794,0.280106,0.270163,0.251452,0.228858,0.188237,0.147772,0.109933,0.074588,0.0406,0.012645,-0.034784,-0.056733,-0.035691,-0.052453,-0.064392,-0.073346:-0.370369,-0.402473,-0.439844,-0.480966,-0.511506,-0.561686,-0.582752,-0.592874,-0.613807,-0.623201,-0.58792,-0.530969,-0.489084,-0.475551,-0.4862,-0.500212,-0.499203:-0.169793,-0.193658,-0.204296,-0.222865,-0.256253,-0.255735,-0.262874,-0.257455,-0.21347,-0.178353,-0.138587,-0.075511,-0.025409,-0.004716,0.032896,0.047162,0.05448:0.052477,0.079321,0.08413,0.086969,0.082491,0.103989,0.114481,0.131261,0.159326,0.172149,0.138641,0.114201,0.096607,0.068494,0.053988,0.02159,-0.014282:0.08544,0.118006,0.110573,0.108804,0.143984,0.154772,0.165943,0.150896,0.119287,0.086882,0.038626,-0.015464,-0.062117,-0.117403,-0.156815,-0.203113,-0.239793:2
0.325912,0.401378,0.44106,0.478595,0.443634,0.419789,0.402574,0.351498,0.216234,0.04143,0.002928,0.010825,0.019482:-0.760083,-0.805347,-0.857714,-0.897924,-0.893172,-0.909207,-0.921693,-0.906824,-0.929913,-0.950655,-0.957141,-0.908735,-0.88288:0.351499,0.355659,0.339991,0.341529,0.343322,0.322972,0.297458,0.323618,0.39232,0.455045,0.518822,0.575194,0.597797:-0.749629,-0.722106,-0.663489,-0.601556,-0.547389,-0.532169,-0.487639,-0.395904,-0.291251,-0.196777,-0.16534,-0.136945,-0.113449:0.090655,0.1186,0.190076,0.277733,0.359171,0.425345,0.462732,0.494569,0.579793,0.668947,0.676191,0.642038,0.626925:-0.315962,-0.295054,-0.279685,-0.262553,-0.25704,-0.271505,-0.293907,-0.324711,-0.333742,-0.342351,-0.360442,-0.40043,-0.416225:-0.105887,-0.122147,-0.160279,-0.213894,-0.253738,-0.263423,-0.268424,-0.289852,-0.297843,-0.29534,-0.308025,-0.301873,-0.289437:0.232435,0.219976,0.189188,0.144214,0.085086,0.050883,0.020911,-0.026256,-0.033426,-0.023014,-0.015623,-0.020331,-0.03454:-0.376908,-0.399317,-0.419084,-0.458455,-0.525038,-0.584935,-0.585889,-0.55696,-0.538793,-0.538397,-0.529872,-0.508976,-0.492062:-0.355378,-0.367085,-0.363918,-0.346721,-0.313686,-0.274959,-0.236434,-0.155228,-0.080037,-0.049332,-0.019779,0.020372,0.057482:-0.015717,-0.006699,0.006125,0.048375,0.117281,0.161503,0.159958,0.162127,0.126084,0.07288,0.036168,-0.00716,-0.036881:0.199875,0.199505,0.193731,0.189912,0.196192,0.182081,0.149795,0.09081,-0.012369,-0.107658,-0.178997,-0.236081,-0.276311:2
0.228068,0.290244,0.329053,0.305375,0.337655,0.348117,0.453759,0.447674,0.431556,0.466589,0.441926,0.411111,0.320597:-0.526481,-0.646279,-0.710842,-0.715448,-0.759537,-0.763253,-0.861149,-0.888898,-0.88224,-0.869668,-0.895523,-0.972932,-1.017773:0.207628,0.24488,0.243701,0.221905,0.198473,0.179992,0.15177,0.131534,0.121551,0.157833,0.214799,0.296366,0.369808:-0.707238,-0.717639,-0.737167,-0.699555,-0.647945,-0.591296,-0.56763,-0.540044,-0.512789,-0.466236,-0.368443,-0.285538,-0.215202:-0.045547,0.03939,0.15285,0.231059,0.300635,0.364463,0.463669,0.551519,0.614579,0.650523,0.664869,0.701601,0.722743:-0.42805,-0.399591,-0.367971,-0.348998,-0.339737,-0.332699,-0.338857,-0.341605,-0.34696,-0.34299,-0.333398,-0.342131,-0.36583:-0.031519,-0.086343,-0.147639,-0.178927,-0.214801,-0.25155,-0.300445,-0.349966,-0.389228,-0.439359,-0.455529,-0.456775,-0.452823:0.255771,0.226974,0.210669,0.184948,0.162732,0.12043,0.081281,0.033568,0.004089,0.010782,0.014868,0.035439,0.033209:-0.216895,-0.246391,-0.271987,-0.294746,-0.324228,-0.343366,-0.393118,-0.429548,-0.446207,-0.44365,-0.42254,-0.425671,-0.426584:-0.234816,-0.249115,-0.282226,-0.310852,-0.338187,-0.335517,-0.293277,-0.240986,-0.199202,-0.17081,-0.137488,-0.115393,-0.089084:-0.001109,-0.0324,-0.057859,-0.053246,-0.047675,-0.033527,-5.65E-4,0.034228,0.061326,0.087215,0.08461,0.035009,-0.009386:0.155335,0.190008,0.222661,0.244648,0.249111,0.252326,0.237746,0.219931,0.197673,0.142208,0.049182,-0.057258,-0.121205:2
0.277123,0.235274,0.280658,0.37206,0.38659,0.412115,0.52653,0.580789,0.58079,0.499218,0.403842,0.405021,0.400065,0.342091,0.32755,0.303024,0.170013:-0.74862,-0.792939,-0.850836,-0.894892,-0.825947,-0.754581,-0.809776,-0.869978,-0.885318,-0.899815,-0.910736,-0.947925,-0.9443,-0.886483,-0.868602,-0.92356,-0.918726:0.467108,0.477631,0.463593,0.444749,0.387592,0.32935,0.314082,0.283242,0.262161,0.286962,0.329303,0.363719,0.399808,0.452784,0.539851,0.623637,0.653312:-0.945728,-0.915213,-0.89907,-0.861209,-0.854458,-0.827186,-0.79801,-0.761119,-0.698168,-0.618321,-0.504594,-0.439398,-0.36215,-0.271685,-0.187295,-0.155046,-0.094463:-0.197759,-0.176337,-0.136871,-0.099712,-0.025152,0.060879,0.141983,0.239099,0.349504,0.445409,0.512301,0.54133,0.529179,0.544368,0.604361,0.613784,0.609759:-0.41521,-0.398481,-0.382639,-0.357639,-0.34849,-0.327077,-0.289357,-0.270847,-0.267117,-0.257304,-0.263169,-0.274483,-0.3032,-0.331674,-0.297121,-0.279126,-0.306592:-0.075875,-0.089953,-0.117249,-0.152796,-0.144475,-0.153545,-0.198199,-0.224089,-0.268162,-0.31101,-0.356223,-0.390163,-0.400925,-0.407392,-0.400102,-0.403386,-0.379828:0.415925,0.388751,0.384084,0.353336,0.3088,0.263775,0.247045,0.223235,0.181372,0.128011,0.057951,0.031048,0.023307,-0.001825,0.012173,0.022505,0.00182:-0.241435,-0.265635,-0.286386,-0.29211,-0.334167,-0.353338,-0.371583,-0.416112,-0.463977,-0.503145,-0.521823,-0.536314,-0.519758,-0.486914,-0.459572,-0.452343,-0.445424:-0.102206,-0.132407,-0.176387,-0.217335,-0.215255,-0.239908,-0.275484,-0.294643,-0.306639,-0.280985,-0.234711,-0.208472,-0.171802,-0.087701,-0.053742,-0.04672,-0.022644:0.125201,0.104119,0.099203,0.093374,0.08714,0.079769,0.067685,0.056153,0.069932,0.083308,0.107443,0.12306,0.11885,0.113991,0.10109,0.075024,0.030279:0.019985,0.026182,0.067698,0.130032,0.164435,0.230681,0.24494,0.226887,0.227555,0.176696,0.131776,0.094197,0.02811,-0.045724,-0.135772,-0.210864,-0.237195:2
0.066991,0.19013,0.268046,0.308499,0.341783,0.334105,0.276538,0.214126,0.146665,0.183545,0.16705,0.110258,0.087654,0.064379,-0.019842:-0.481215,-0.535098,-0.622845,-0.69653,-0.814692,-0.913548,-0.923737,-0.910189,-0.83539,-0.857643,-0.879357,-0.878901,-0.909829,-0.940026,-0.909486:0.130932,0.175628,0.230986,0.282852,0.348201,0.38611,0.415162,0.442424,0.431008,0.442877,0.45772,0.470905,0.509065,0.543658,0.542521:-0.479707,-0.43399,-0.438533,-0.431781,-0.381442,-0.301415,-0.202879,-0.136055,-0.088031,-0.088667,-0.05804,-0.010167,-0.007572,-0.034191,-0.048617:0.239743,0.301936,0.382487,0.453792,0.54288,0.626814,0.669399,0.699658,0.712071,0.741178,0.758477,0.74686,0.726986,0.720619,0.714822:-0.273811,-0.267654,-0.246969,-0.219865,-0.163168,-0.157822,-0.226515,-0.269442,-0.312212,-0.338882,-0.355184,-0.364214,-0.365311,-0.372241,-0.398388:-0.114604,-0.132378,-0.170341,-0.200946,-0.247668,-0.300351,-0.340375,-0.369581,-0.370196,-0.378147,-0.362863,-0.332176,-0.338036,-0.354572,-0.345885:0.031454,-0.004486,-0.026566,-0.029877,-0.01056,-0.008849,-0.023367,-0.03621,-0.054963,-0.013294,0.029379,0.039797,0.050892,0.066797,0.059842:-0.194094,-0.281745,-0.380935,-0.44357,-0.44708,-0.426327,-0.398776,-0.383775,-0.362307,-0.356886,-0.334533,-0.319695,-0.324746,-0.346243,-0.35774:-0.430506,-0.428303,-0.374201,-0.329053,-0.296404,-0.266795,-0.209714,-0.165801,-0.125609,-0.0922,-0.06433,-0.044489,-0.045556,-0.041401,-0.031756:-0.190114,-0.119867,-0.053775,-0.007773,0.004683,-0.013698,-0.026101,-0.029633,-0.052036,-0.063625,-0.075787,-0.088302,-0.085092,-0.072485,-0.068239:0.261589,0.281952,0.268388,0.240105,0.174953,0.098226,0.035428,-0.007589,-0.029798,-0.071214,-0.102875,-0.119016,-0.139069,-0.164949,-0.166993:2
0.34036,0.433212,0.410797,0.444598,0.498971,0.56212,0.601561,0.61409,0.570338,0.534208,0.486823,0.359165,0.249168,0.200714,0.116077,0.012097:-0.688635,-0.716516,-0.75172,-0.843677,-0.900704,-0.967024,-1.035541,-1.038372,-1.044035,-1.097563,-1.09175,-1.02973,-1.031815,-1.03972,-1.049013,-1.027564:0.440722,0.396463,0.33981,0.316429,0.283658,0.255913,0.244269,0.226159,0.217667,0.23193,0.283519,0.350342,0.404845,0.45207,0.478434,0.495203:-0.870392,-0.820612,-0.765183,-0.740587,-0.707496,-0.648293,-0.585741,-0.532609,-0.496927,-0.414866,-0.306417,-0.257855,-0.221211,-0.176663,-0.135896,-0.098337:-0.156703,-0.095405,-0.005059,0.085382,0.179164,0.283017,0.384551,0.452296,0.497288,0.51611,0.539575,0.600831,0.624702,0.59655,0.600395,0.598656:-0.37515,-0.344025,-0.318248,-0.27126,-0.244339,-0.225249,-0.196279,-0.180815,-0.199653,-0.243872,-0.297514,-0.334054,-0.34389,-0.355426,-0.375866,-0.406312:-0.079531,-0.077966,-0.100349,-0.139659,-0.197637,-0.255136,-0.32892,-0.391608,-0.415248,-0.424259,-0.436066,-0.437655,-0.403397,-0.358029,-0.332894,-0.313822:0.308937,0.274966,0.26263,0.223039,0.187011,0.144815,0.084297,0.009371,-0.01753,-0.038889,-0.044037,-0.020018,-0.027676,-0.044271,-0.060662,-0.072476:-0.249207,-0.248927,-0.257613,-0.287639,-0.294692,-0.317026,-0.362589,-0.369344,-0.382444,-0.378268,-0.35425,-0.368601,-0.410396,-0.430349,-0.437032,-0.441039:-0.154469,-0.205094,-0.273067,-0.298148,-0.313886,-0.322171,-0.29934,-0.267047,-0.241186,-0.197827,-0.14001,-0.092426,-0.063623,-0.042494,-0.022102,0.001051:0.081037,0.0371,-4.5E-4,-0.039909,-0.071318,-0.066358,-0.01422,0.011266,0.024196,0.022577,0.006541,0.014656,0.019027,0.005294,-0.020343,-0.035464:0.130056,0.197726,0.22119,0.222182,0.232469,0.241662,0.218458,0.223675,0.204499,0.176103,0.118609,0.02868,-0.042223,-0.084947,-0.109527,-0.130865:2
0.165126,-0.01349,-0.051627,0.077907,0.103485,0.079344,0.061957,0.094918,0.031776,-0.005221,0.006377,-0.008775,-0.008606,-0.056387,-0.093302:-0.928304,-0.835472,-0.825304,-0.884439,-0.898863,-0.922416,-0.93925,-1.029179,-1.040649,-1.023529,-1.015443,-1.009479,-0.960244,-0.936823,-0.916441:0.448133,0.386997,0.357024,0.356773,0.330556,0.31905,0.316517,0.356118,0.408585,0.444471,0.461082,0.474452,0.529254,0.601423,0.663565:-0.852439,-0.776314,-0.72996,-0.700938,-0.655359,-0.607537,-0.561659,-0.501919,-0.409342,-0.339614,-0.300241,-0.242593,-0.212494,-0.166157,-0.135177:-0.051267,-0.033523,-0.007316,0.038354,0.136667,0.226499,0.279951,0.345176,0.429889,0.487881,0.505398,0.514137,0.502179,0.546768,0.564026:-0.291093,-0.306264,-0.294978,-0.259697,-0.259429,-0.248396,-0.262533,-0.270716,-0.272763,-0.280186,-0.310946,-0.358364,-0.354105,-0.33935,-0.357967:-0.104574,-0.078264,-0.098712,-0.144578,-0.176831,-0.188079,-0.189473,-0.213427,-0.252018,-0.296275,-0.318263,-0.316245,-0.301415,-0.282365,-0.281273:0.284052,0.221769,0.174621,0.124628,0.100931,0.061376,0.015066,-0.014119,-0.055345,-0.098229,-0.108457,-0.104139,-0.105149,-0.071946,-0.051064:-0.346075,-0.35081,-0.347962,-0.333427,-0.349652,-0.401623,-0.458301,-0.504959,-0.520054,-0.506014,-0.501232,-0.492085,-0.455907,-0.434535,-0.442521:-0.225309,-0.24603,-0.256527,-0.238928,-0.253095,-0.261896,-0.243193,-0.202286,-0.158435,-0.109425,-0.0792,-0.040118,0.013244,0.031665,0.037277:0.070829,0.055975,0.053192,0.04023,0.05278,0.074566,0.096229,0.108262,0.102661,0.100451,0.096982,0.075021,0.045675,-0.001784,-0.039923:0.151185,0.217062,0.260492,0.285429,0.317943,0.326342,0.308925,0.248709,0.146194,0.072695,0.036902,-0.015257,-0.074179,-0.147345,-0.215198:2
0.324166,0.40338,0.391482,0.462063,0.389268,0.404538,0.328747,0.285861,0.236587,0.193872,0.157262,0.160797,0.054544,-0.039339,-0.056126,-0.077574,-0.116567,-0.121488:-0.816401,-0.828751,-0.888679,-0.973567,-0.920378,-0.994656,-0.951488,-0.929441,-0.90551,-0.902543,-0.86693,-0.872102,-0.892171,-0.901388,-0.873174,-0.881692,-0.863229,-0.819577:0.157037,0.103327,0.123573,0.146062,0.210297,0.254748,0.298051,0.335421,0.421673,0.482487,0.5469,0.610297,0.611976,0.586149,0.571633,0.616081,0.646402,0.645799:-0.639129,-0.599134,-0.574207,-0.474933,-0.338329,-0.30998,-0.252626,-0.229672,-0.187969,-0.138708,-0.106469,-0.095176,-0.072632,-0.037109,-0.020026,-0.021303,-0.017249,0.004411:0.385779,0.458653,0.522587,0.567485,0.610895,0.647552,0.630975,0.613977,0.589916,0.575968,0.552361,0.50693,0.526047,0.55421,0.55644,0.533099,0.518991,0.502663:-0.385047,-0.355809,-0.31412,-0.3273,-0.332067,-0.337771,-0.417513,-0.449227,-0.454325,-0.444778,-0.432459,-0.405329,-0.406552,-0.403203,-0.404409,-0.385841,-0.390348,-0.411074:-0.257185,-0.283188,-0.352073,-0.391638,-0.427146,-0.442309,-0.423467,-0.407749,-0.437969,-0.418618,-0.369199,-0.338457,-0.299791,-0.26849,-0.269101,-0.272341,-0.262721,-0.250669:0.153828,0.095534,0.042825,-0.005106,-0.066625,-0.049642,-0.047948,-0.053975,-0.056252,-0.044851,-0.048714,-0.084261,-0.088351,-0.11569,-0.140254,-0.162946,-0.17939,-0.190032:-0.379301,-0.394409,-0.391001,-0.381923,-0.358819,-0.390717,-0.408993,-0.435191,-0.38881,-0.350703,-0.353035,-0.364216,-0.377742,-0.394961,-0.387407,-0.378874,-0.372713,-0.359587:-0.23081,-0.222693,-0.206772,-0.149732,-0.108532,-0.119725,-0.075659,-0.030324,-0.001545,0.017316,0.040601,0.050774,0.044341,0.058931,0.072492,0.085758,0.101288,0.115342:0.037058,0.02002,0.018602,0.01135,-0.006473,-0.003369,-0.012246,0.00972,8.95E-4,-0.028939,-0.048052,-0.053503,-0.079753,-0.103293,-0.1184,-0.127532,-0.145445,-0.167042:0.297127,0.288424,0.254731,0.189968,0.130016,0.085727,0.040961,-0.017734,-0.072562,-0.116565,-0.157869,-0.180779,-0.191864,-0.213451,-0.213854,-0.222835,-0.233021,-0.233062:2
0.025721,-0.049962,0.017741,0.016765,0.041875,0.07386,-0.004702,-0.107435,-0.1618,-0.218391,-0.247897,-0.242732,-0.27231,-0.278438,-0.322854:-0.640213,-0.63983,-0.764649,-0.788281,-0.824735,-0.901498,-0.891628,-0.906241,-0.89774,-0.852047,-0.848624,-0.857363,-0.831856,-0.785575,-0.759227:0.092337,0.066423,0.14723,0.167016,0.194974,0.24508,0.269948,0.337784,0.394572,0.44449,0.500643,0.57735,0.611069,0.632731,0.642803:-0.585619,-0.522565,-0.502361,-0.416867,-0.350523,-0.319118,-0.246046,-0.145258,-0.073359,-0.029864,-0.009055,0.031398,0.084071,0.099364,0.115243:0.273969,0.351799,0.458943,0.520415,0.56212,0.606997,0.643385,0.676071,0.669207,0.669715,0.663373,0.643487,0.655292,0.640285,0.655755:-0.357017,-0.35582,-0.372813,-0.401913,-0.429211,-0.435782,-0.452104,-0.442053,-0.482498,-0.534657,-0.53583,-0.500894,-0.480368,-0.487492,-0.496078:-0.106415,-0.120185,-0.168147,-0.203976,-0.253084,-0.294143,-0.274879,-0.248105,-0.237732,-0.21282,-0.187547,-0.159024,-0.128819,-0.098489,-0.052248:0.07262,0.027757,0.04273,0.002096,-0.040869,-0.046808,-0.064646,-0.076019,-0.075332,-0.049969,-0.028308,-0.003366,-0.007711,-0.015887,-0.009835:-0.289465,-0.360408,-0.445321,-0.489879,-0.517143,-0.538005,-0.524356,-0.498123,-0.47533,-0.456369,-0.44384,-0.398673,-0.361603,-0.35873,-0.377678:-0.304843,-0.299028,-0.291943,-0.252674,-0.171587,-0.0981,-0.025744,-0.005785,-0.00403,0.008245,0.030936,0.057867,0.073412,0.080789,0.091937:-0.022642,0.012016,0.023973,0.074365,0.127472,0.138966,0.113952,0.057598,-0.007287,-0.067533,-0.104303,-0.130496,-0.16365,-0.189676,-0.201651:0.306743,0.287919,0.265974,0.227441,0.167167,0.093746,0.019587,-0.054036,-0.086321,-0.121861,-0.169977,-0.211774,-0.226369,-0.235416,-0.25295:2
0.230993,0.356133,0.410335,0.615296,0.740121,0.837892,0.871332,0.916521,0.840789,0.706039,0.576607:-0.658519,-0.741919,-0.720957,-0.648633,-0.589595,-0.640704,-0.688644,-0.769227,-0.80876,-0.719265,-0.620058:0.231186,0.184632,0.15523,0.069781,0.012676,0.014155,0.102355,0.147227,0.28597,0.412856,0.585019:-0.726161,-0.715625,-0.675312,-0.577551,-0.477145,-0.391794,-0.271499,-0.070304,-0.085882,-0.066037,-0.057478:0.001163,0.116296,0.207435,0.264973,0.336929,0.424145,0.477072,0.486972,0.483763,0.524895,0.557989:-0.404327,-0.390184,-0.367761,-0.330233,-0.312856,-0.314354,-0.307945,-0.348465,-0.340341,-0.362201,-0.349947:0.004588,-0.067657,-0.123513,-0.128196,-0.135426,-0.16648,-0.222123,-0.217359,-0.295175,-0.302599,-0.251991:0.210434,0.188106,0.140498,0.037896,-0.029472,-0.095626,-0.131664,-0.172866,-0.132188,-0.108357,-0.092948:-0.270641,-0.29152,-0.310041,-0.321597,-0.338566,-0.380952,-0.402608,-0.425796,-0.400107,-0.375069,-0.363575:-0.279828,-0.299277,-0.31982,-0.333545,-0.342469,-0.254512,-0.158729,-0.064989,-0.053088,-0.007631,0.06497:-0.011632,-0.015816,0.005441,0.046586,0.037813,0.023999,0.038468,-0.009844,0.006164,-0.011569,-0.047315:0.212661,0.268077,0.324183,0.345326,0.326143,0.284434,0.203202,0.119987,0.009923,-0.088498,-0.175662:2
0.493004,0.529635,0.572517,0.640085,0.690101,0.623687,0.467923,0.419656,0.39343,0.29119,0.194941,0.089669,0.020748,0.012647,-0.062642,-0.141749,-0.123218:-0.913254,-0.941595,-0.959207,-0.991357,-1.012853,-1.001264,-1.026943,-1.12399,-1.124022,-1.056389,-1.038415,-1.021194,-0.993718,-0.957174,-0.91297,-0.91853,-0.9859:0.416066,0.390324,0.339086,0.276727,0.219451,0.187006,0.190834,0.222686,0.256103,0.314585,0.371006,0.415656,0.464728,0.553093,0.596449,0.64828,0.739582:-0.887927,-0.852572,-0.809445,-0.789268,-0.761325,-0.694603,-0.566164,-0.478611,-0.406874,-0.30399,-0.212592,-0.134411,-0.060938,-0.037621,0.034796,0.12405,0.134414:-0.146317,-0.052126,0.061302,0.171151,0.272255,0.329399,0.357982,0.414614,0.476671,0.511902,0.558039,0.575477,0.558009,0.535335,0.536448,0.540956,0.562597:-0.171286,-0.170119,-0.175728,-0.158061,-0.173237,-0.192636,-0.229197,-0.257737,-0.273611,-0.272721,-0.271497,-0.301884,-0.331643,-0.350585,-0.340889,-0.317533,-0.282038:-0.251783,-0.268648,-0.28719,-0.307434,-0.321754,-0.310341,-0.286343,-0.340509,-0.396618,-0.390265,-0.369323,-0.337514,-0.308411,-0.292046,-0.245176,-0.216785,-0.230899:0.316814,0.29863,0.250302,0.208789,0.184509,0.142492,0.078808,0.030253,-0.029535,-0.06145,-0.05246,-0.065434,-0.09281,-0.084662,-0.081722,-0.069316,-0.052509:-0.005575,-0.050592,-0.101937,-0.174042,-0.267599,-0.34355,-0.407952,-0.41903,-0.419573,-0.425672,-0.447949,-0.462936,-0.453471,-0.43152,-0.385706,-0.358826,-0.34893:-0.221616,-0.237049,-0.244126,-0.287315,-0.324981,-0.3278,-0.297401,-0.237049,-0.168421,-0.131352,-0.119624,-0.082898,-0.027644,0.029978,0.083846,0.089561,0.099982:-0.022077,-0.019907,-0.042095,-0.059623,-0.037847,-3.21E-4,0.013647,0.024074,0.072176,0.092687,0.078534,0.030287,-0.010211,-0.018701,-0.048882,-0.076942,-0.109206:0.165695,0.201951,0.208856,0.221833,0.236771,0.234105,0.219121,0.208769,0.200486,0.147883,0.057541,-0.031355,-0.09643,-0.15694,-0.212478,-0.273759,-0.336968:2
-0.149217,-0.119835,-0.104265,-0.037633,-0.036985,-0.084207,-0.081391,0.060885,0.158954,0.240057,0.232238,0.102138,0.064693,-0.009214,-0.071155:-0.455086,-0.509363,-0.553954,-0.563212,-0.612426,-0.591649,-0.629161,-0.735222,-0.766282,-0.874753,-0.959482,-0.984777,-0.991054,-0.957762,-0.932783:0.366427,0.31717,0.27981,0.233848,0.189665,0.158825,0.175016,0.194633,0.184634,0.222315,0.273334,0.357268,0.426774,0.499592,0.529178:-0.717065,-0.679201,-0.646129,-0.601816,-0.550917,-0.493788,-0.446165,-0.406508,-0.344331,-0.276503,-0.234909,-0.133935,-0.040944,-0.033433,-0.027495:-0.227764,-0.18305,-0.11843,-0.020356,0.076721,0.168107,0.276845,0.372392,0.441073,0.510602,0.560758,0.622979,0.646685,0.66071,0.655998:-0.484738,-0.457573,-0.418482,-0.385797,-0.325607,-0.279982,-0.259689,-0.241765,-0.25756,-0.289382,-0.29146,-0.295604,-0.354812,-0.402886,-0.426882:8.17E-4,-0.008944,-0.005955,-0.03014,-0.072706,-0.098601,-0.102917,-0.131545,-0.204582,-0.290283,-0.311147,-0.29527,-0.310501,-0.336349,-0.327469:0.158829,0.153118,0.142191,0.117472,0.032694,-0.028636,-0.057558,-0.100137,-0.133564,-0.132271,-0.116938,-0.110445,-0.09455,-0.058763,-0.05579:-0.055411,-0.047061,-0.069539,-0.122576,-0.148606,-0.19922,-0.268555,-0.328966,-0.350212,-0.387662,-0.402946,-0.361897,-0.347913,-0.370553,-0.38488:-0.23159,-0.266136,-0.308262,-0.366447,-0.380589,-0.408362,-0.421528,-0.389273,-0.316188,-0.236064,-0.196174,-0.143872,-0.080728,-0.060375,-0.029027:-0.067059,-0.102218,-0.135708,-0.145926,-0.166167,-0.137159,-0.11279,-0.094566,-0.05313,0.014311,0.039745,-9.99E-4,-0.061694,-0.068054,-0.077389:0.240809,0.260148,0.270313,0.294186,0.326731,0.366093,0.364599,0.316972,0.26568,0.214836,0.151958,0.047962,-0.050894,-0.117019,-0.173268:2
0.384145,0.579467,0.745596,0.847141,0.824413,0.79086,0.793027,0.736159,0.678168,0.586107,0.512214,0.460357,0.291183:-0.677712,-0.750992,-0.79156,-0.855563,-0.898416,-0.93569,-0.994536,-1.028987,-1.034899,-1.02047,-1.040613,-1.03718,-1.001768:0.387855,0.366188,0.319148,0.273698,0.271756,0.290576,0.304558,0.325942,0.369875,0.465797,0.540288,0.612764,0.672674:-0.828833,-0.792327,-0.73143,-0.669173,-0.6184,-0.55463,-0.455975,-0.374783,-0.290926,-0.183086,-0.101716,-0.033835,-0.027597:-0.012249,0.052742,0.128225,0.216186,0.287444,0.389443,0.462188,0.508051,0.512447,0.522995,0.541354,0.503508,0.504605:-0.314448,-0.277519,-0.246535,-0.21154,-0.179989,-0.16166,-0.1561,-0.190032,-0.24062,-0.256538,-0.236356,-0.252884,-0.277472:-0.169149,-0.199154,-0.20907,-0.253096,-0.28683,-0.336376,-0.388008,-0.410572,-0.399179,-0.370362,-0.332444,-0.293774,-0.277714:0.273235,0.266948,0.198189,0.152168,0.11545,0.058898,0.006602,-0.024386,-0.033533,-0.02603,-0.035156,-0.063527,-0.077985:-0.220645,-0.255153,-0.305563,-0.314775,-0.33958,-0.371625,-0.388754,-0.397035,-0.403183,-0.394319,-0.392635,-0.394004,-0.408841:-0.247896,-0.308838,-0.328718,-0.355777,-0.361162,-0.317301,-0.276962,-0.229605,-0.160363,-0.100681,-0.068672,-0.030703,1.0E-4:0.006881,-5.22E-4,-0.011285,-0.054961,-0.041001,0.003126,0.03034,0.035585,0.051894,0.049849,0.019878,-0.027078,-0.046958:0.201359,0.217217,0.230307,0.259572,0.246621,0.215521,0.171337,0.135157,0.0653,-0.0377,-0.115547,-0.17586,-0.221834:2
0.302911,0.38476,0.648105,0.8681,0.748002,0.708326,0.679654,0.691665,0.65153,0.543913,0.410337,0.402719:-0.918667,-0.893235,-0.877056,-0.978467,-1.009166,-1.039654,-1.032952,-1.047474,-1.040563,-1.043726,-1.092492,-1.128512:0.405362,0.322835,0.287245,0.259285,0.261709,0.257437,0.278101,0.278164,0.296573,0.384415,0.489134,0.53416:-0.741395,-0.716973,-0.685775,-0.635876,-0.610031,-0.531402,-0.459931,-0.39916,-0.311545,-0.223531,-0.164138,-0.125937:-0.081347,-0.004111,0.054449,0.073404,0.179334,0.277844,0.357352,0.430494,0.450912,0.485496,0.547722,0.528339:-0.302563,-0.274373,-0.230171,-0.178883,-0.175704,-0.160685,-0.18477,-0.215687,-0.230574,-0.228477,-0.22877,-0.248977:-0.115806,-0.155519,-0.177191,-0.205359,-0.24156,-0.276423,-0.317344,-0.382965,-0.39257,-0.388632,-0.399643,-0.373402:0.241078,0.219382,0.177001,0.12032,0.085667,0.041317,0.012768,-0.019638,-0.0705,-0.059428,-0.015682,-0.028498:-0.210939,-0.20178,-0.217094,-0.258104,-0.298067,-0.306873,-0.335355,-0.34897,-0.367908,-0.379734,-0.400561,-0.422629:-0.274169,-0.308353,-0.317902,-0.332144,-0.350567,-0.355897,-0.334625,-0.278863,-0.209864,-0.154406,-0.14943,-0.117384:-0.038208,-0.03445,-0.030474,-0.00913,-0.017878,-0.038603,-0.030556,0.006029,0.059189,0.095383,0.084835,0.059517:0.255192,0.316448,0.344502,0.320187,0.324224,0.30248,0.249721,0.201912,0.155812,0.076241,-0.025092,-0.087021:2
0.013083,-0.05853,-0.02824,0.092031,0.124151,0.228042,0.212937,0.125366,0.131806,0.119316,0.140609,0.075615,0.053288,0.029898:-0.625915,-0.539489,-0.516061,-0.567049,-0.64095,-0.791653,-0.846855,-0.821085,-0.840431,-0.891553,-0.979172,-0.974853,-0.955331,-0.933452:0.235088,0.14765,0.093163,0.064301,0.077944,0.160005,0.183785,0.191472,0.214036,0.298504,0.398101,0.465822,0.523597,0.542633:-0.775933,-0.7254,-0.706658,-0.668151,-0.608826,-0.573168,-0.504095,-0.401063,-0.29498,-0.262212,-0.233046,-0.164788,-0.150804,-0.138149:-0.036806,-9.94E-4,0.092359,0.211583,0.318839,0.428951,0.497322,0.527297,0.547937,0.598405,0.68177,0.705484,0.708949,0.70074:-0.372379,-0.331857,-0.269173,-0.230009,-0.197028,-0.191801,-0.198301,-0.240041,-0.283502,-0.301633,-0.301173,-0.350134,-0.364958,-0.390546:-0.184366,-0.202022,-0.231979,-0.250168,-0.282746,-0.304899,-0.320558,-0.348923,-0.356919,-0.389917,-0.389746,-0.371789,-0.376313,-0.358774:0.285458,0.2322,0.17113,0.113502,0.064618,0.027993,-0.025502,-0.074443,-0.100255,-0.061757,0.010716,0.009508,-0.002267,-0.004665:-0.079644,-0.083027,-0.120277,-0.152976,-0.201886,-0.289503,-0.343318,-0.354522,-0.394141,-0.410684,-0.428505,-0.454337,-0.472542,-0.485961:-0.266055,-0.279867,-0.285777,-0.310733,-0.310042,-0.300313,-0.277317,-0.234611,-0.166578,-0.129506,-0.1073,-0.064621,-0.022811,0.005068:-0.105002,-0.105853,-0.108321,-0.119674,-0.136438,-0.131309,-0.098696,-0.066106,-0.018957,0.015713,0.019703,0.008887,-0.001039,-0.020886:0.200332,0.226422,0.239859,0.260071,0.26349,0.227531,0.186205,0.163179,0.114636,0.060108,-0.034845,-0.134948,-0.204422,-0.23973:2
-0.203587,-0.210631,-0.224325,-0.129585,0.065486,0.105463,0.306111,0.349179,0.308328,0.314044,0.194617,0.186629,0.138809,0.166103,0.163054,0.01307:-0.650871,-0.677287,-0.66269,-0.709796,-0.853893,-0.866609,-0.960353,-1.004018,-0.991146,-0.983395,-0.910435,-0.89639,-0.917251,-0.946737,-0.963609,-0.921741:0.266193,0.232925,0.180949,0.18921,0.266878,0.273748,0.294289,0.367471,0.390204,0.428875,0.474139,0.466631,0.515458,0.561457,0.632635,0.706852:-0.71443,-0.681385,-0.632876,-0.587897,-0.571113,-0.50051,-0.424312,-0.395018,-0.299887,-0.291721,-0.28412,-0.232118,-0.142722,-0.094825,-0.060232,-0.063739:0.0441,0.113678,0.182675,0.279966,0.365316,0.415287,0.443026,0.493176,0.526945,0.551252,0.597076,0.608904,0.59064,0.592547,0.558753,0.574123:-0.309625,-0.305053,-0.2963,-0.288628,-0.27695,-0.274157,-0.242777,-0.24884,-0.269961,-0.279374,-0.315854,-0.347307,-0.331533,-0.305792,-0.280611,-0.309146:-0.116088,-0.155978,-0.193224,-0.24411,-0.261909,-0.251174,-0.273093,-0.329134,-0.320801,-0.346432,-0.358798,-0.348828,-0.305345,-0.268543,-0.258761,-0.276543:0.175169,0.129361,0.085291,0.061417,0.061107,0.028003,-0.001855,0.013684,-0.037362,-0.054718,-0.047867,-0.049049,-0.069228,-0.07153,-0.097335,-0.084081:-0.233761,-0.233888,-0.267231,-0.318046,-0.390118,-0.429842,-0.448325,-0.461616,-0.468365,-0.496527,-0.514718,-0.496199,-0.469633,-0.441775,-0.424268,-0.435335:-0.306957,-0.304104,-0.303615,-0.285706,-0.274151,-0.284878,-0.291643,-0.234392,-0.16754,-0.121118,-0.078082,-0.054313,-0.007955,0.024829,0.040734,0.059798:-0.085915,-0.091655,-0.042257,0.010488,0.028035,0.031608,0.051548,0.076925,0.076256,0.096518,0.097522,0.073143,0.041677,0.013622,-0.020558,-0.040169:0.262609,0.285974,0.334916,0.354751,0.327359,0.304864,0.263105,0.172346,0.08853,0.022483,-0.042183,-0.070095,-0.117001,-0.159312,-0.220257,-0.282819:2
0.1393,0.116235,0.162537,0.336918,0.492906,0.760031,0.808987,0.636834,0.506111,0.437273,0.369828,0.283641:-0.809252,-0.834719,-0.873477,-0.930641,-0.93709,-0.969354,-0.962889,-0.954739,-0.965555,-1.034249,-1.017266,-1.012787:0.338762,0.347342,0.321533,0.290391,0.27261,0.240454,0.212078,0.23985,0.304993,0.388112,0.434716,0.458885:-0.752775,-0.723579,-0.67906,-0.660846,-0.621338,-0.589891,-0.507046,-0.445512,-0.371004,-0.314069,-0.25373,-0.200337:0.116617,0.185023,0.273054,0.33982,0.411175,0.466113,0.497035,0.568993,0.637021,0.633412,0.632986,0.637178:-0.253862,-0.234631,-0.238144,-0.212802,-0.175482,-0.122801,-0.128997,-0.166192,-0.182222,-0.194169,-0.25424,-0.284632:-0.194073,-0.218218,-0.265211,-0.300711,-0.317931,-0.380744,-0.397409,-0.396359,-0.373851,-0.381871,-0.399595,-0.39814:0.277565,0.21779,0.179125,0.153136,0.115088,0.064262,0.009977,0.003491,0.011302,-0.002486,-0.005494,-0.025052:-0.187968,-0.242904,-0.270808,-0.305834,-0.365446,-0.404269,-0.417376,-0.435003,-0.470851,-0.486367,-0.483013,-0.480535:-0.325002,-0.333011,-0.333016,-0.31122,-0.327212,-0.338907,-0.299558,-0.240111,-0.182877,-0.138055,-0.098825,-0.058679:-0.110341,-0.100496,-0.088456,-0.051859,-0.023446,0.02283,0.049135,0.059894,0.069003,0.069531,0.06369,0.052887:0.145693,0.163597,0.198222,0.200482,0.20169,0.185141,0.159995,0.110667,0.014549,-0.077834,-0.130078,-0.168086:2
0.018468,-0.003436,0.065344,0.246277,0.233678,0.148894,0.159032,0.164868,0.089509,-0.005269,-0.011002,0.011576,0.028902,0.057249,0.008549,-0.013844:-0.506258,-0.572692,-0.620996,-0.648278,-0.676684,-0.657226,-0.722831,-0.772915,-0.795893,-0.762448,-0.77575,-0.789197,-0.770581,-0.784134,-0.804604,-0.827396:0.182428,0.180654,0.175989,0.160388,0.21192,0.296246,0.368182,0.365948,0.366757,0.405275,0.472794,0.526066,0.540153,0.536233,0.551034,0.574772:-0.568013,-0.530611,-0.499953,-0.449163,-0.421968,-0.328609,-0.273134,-0.246172,-0.230877,-0.201041,-0.181587,-0.160569,-0.139278,-0.122129,-0.096695,-0.106163:-0.061708,0.008185,0.077327,0.175378,0.257006,0.324426,0.406544,0.449023,0.502735,0.534256,0.591349,0.62755,0.623562,0.621483,0.606729,0.609601:-0.350323,-0.312361,-0.284679,-0.273718,-0.253563,-0.218828,-0.227365,-0.224411,-0.246875,-0.255978,-0.246699,-0.236395,-0.249198,-0.273935,-0.292701,-0.298977:0.037078,0.017155,-0.002941,-0.032545,-0.082377,-0.158201,-0.234109,-0.25866,-0.301457,-0.298609,-0.291989,-0.306717,-0.30287,-0.285796,-0.26973,-0.275853:0.025269,-0.008735,-0.04078,-0.067143,-0.07785,-0.131943,-0.152251,-0.172076,-0.163109,-0.138413,-0.094833,-0.085203,-0.095427,-0.091722,-0.103877,-0.111529:-0.127103,-0.164208,-0.201791,-0.250368,-0.338315,-0.36996,-0.37496,-0.424795,-0.419552,-0.42473,-0.419232,-0.418335,-0.42363,-0.431738,-0.432251,-0.432723:-0.384974,-0.380997,-0.375394,-0.353738,-0.296493,-0.26607,-0.234023,-0.181559,-0.165604,-0.151336,-0.120079,-0.102694,-0.092695,-0.078106,-0.061137,-0.047243:-0.187385,-0.20565,-0.197451,-0.196639,-0.115498,-0.051872,-0.009713,0.046041,0.072924,0.09375,0.089043,0.062747,0.051997,0.034417,0.016981,0.003147:0.357617,0.361105,0.401123,0.380075,0.317284,0.278133,0.228256,0.143451,0.114934,0.083356,0.023646,-0.046609,-0.0862,-0.117289,-0.146769,-0.160494:2
0.425306,0.414407,0.452342,0.527844,0.622956,0.639795,0.675764,0.722474,0.770956,0.845599,0.807429,0.65914,0.435103,0.333324,0.266205:-0.567167,-0.546651,-0.655973,-0.769326,-0.874169,-0.907816,-0.952374,-0.99008,-1.038718,-1.142049,-1.112427,-1.067526,-0.917507,-0.837764,-0.807045:0.336027,0.287073,0.298457,0.322026,0.356307,0.374203,0.374357,0.362404,0.371228,0.408144,0.448397,0.462718,0.428905,0.411334,0.440441:-0.754549,-0.703986,-0.662805,-0.61491,-0.548723,-0.481614,-0.398902,-0.33678,-0.262972,-0.198029,-0.090511,-0.016955,0.039331,0.045877,0.089218:-0.042679,0.017253,0.08993,0.152164,0.22025,0.266529,0.263608,0.27621,0.32889,0.408479,0.461241,0.503527,0.537975,0.554724,0.547845:-0.310813,-0.303961,-0.283859,-0.221614,-0.163377,-0.139499,-0.138902,-0.126118,-0.108708,-0.122266,-0.171418,-0.199376,-0.302103,-0.364065,-0.374363:-0.251647,-0.247881,-0.215368,-0.219598,-0.252797,-0.277493,-0.255401,-0.26433,-0.326566,-0.375746,-0.367139,-0.358462,-0.289548,-0.270625,-0.269168:0.318731,0.32317,0.273686,0.184951,0.093415,0.03086,-0.047653,-0.130176,-0.193522,-0.179959,-0.173297,-0.155672,-0.128835,-0.092078,-0.111051:-0.076602,-0.118308,-0.213405,-0.268784,-0.280997,-0.314431,-0.344344,-0.336207,-0.29806,-0.282091,-0.272806,-0.296493,-0.395694,-0.425392,-0.400842:-0.300767,-0.322856,-0.343531,-0.335297,-0.328172,-0.334256,-0.298292,-0.239925,-0.167986,-0.113878,-0.087792,-0.090295,-0.032554,-0.024145,0.001045:-0.029591,-0.050268,-0.093842,-0.138703,-0.165987,-0.161862,-0.154561,-0.142398,-0.128532,-0.12627,-0.150834,-0.131577,-0.116752,-0.105205,-0.111819:0.154469,0.140555,0.12956,0.147161,0.215305,0.244724,0.242624,0.216011,0.161322,0.116163,0.074038,0.003865,-0.055216,-0.094797,-0.12932:2
0.339393,0.322226,0.316138,0.320305,0.341837,0.374799,0.324299,0.322552,0.397091,0.39422,0.334561,0.298059,0.247335,0.18582,0.164866:-0.872042,-0.901126,-0.960153,-0.996421,-1.016475,-1.022268,-1.104861,-1.148468,-1.216622,-1.233014,-1.222662,-1.220875,-1.21537,-1.1705,-1.140498:0.319477,0.28874,0.293983,0.299245,0.32139,0.339945,0.375945,0.384784,0.407372,0.434365,0.478874,0.520696,0.563706,0.575427,0.577326:-0.760153,-0.72225,-0.661212,-0.613278,-0.553184,-0.457056,-0.395041,-0.345651,-0.29987,-0.238101,-0.122386,-0.079354,-0.066076,-0.049209,-0.040307:0.086432,0.175883,0.232537,0.30016,0.358016,0.396637,0.45334,0.46425,0.479411,0.509182,0.56985,0.601957,0.624391,0.635285,0.631904:-0.2453,-0.216088,-0.197293,-0.177,-0.166647,-0.159058,-0.127502,-0.130909,-0.133249,-0.138203,-0.137954,-0.140658,-0.153405,-0.193341,-0.226613:-0.27115,-0.270695,-0.257184,-0.271372,-0.281027,-0.291993,-0.345775,-0.353862,-0.391257,-0.410044,-0.389644,-0.393104,-0.412847,-0.419783,-0.414334:0.204433,0.167897,0.128068,0.090645,0.061213,-0.010348,-0.080082,-0.119082,-0.130125,-0.125823,-0.114508,-0.10133,-0.08192,-0.075189,-0.08108:-0.147372,-0.172914,-0.211313,-0.232168,-0.255605,-0.27638,-0.333042,-0.346636,-0.336399,-0.302093,-0.276723,-0.281737,-0.300201,-0.322051,-0.353804:-0.281121,-0.301862,-0.326523,-0.33594,-0.347303,-0.325015,-0.279086,-0.255571,-0.224125,-0.176838,-0.125511,-0.112866,-0.112743,-0.09612,-0.062905:-0.151074,-0.191587,-0.213939,-0.227555,-0.232809,-0.210303,-0.13219,-0.116509,-0.099213,-0.094731,-0.108566,-0.107956,-0.08798,-0.074038,-0.058807:0.204373,0.209045,0.224432,0.225351,0.224838,0.219979,0.205399,0.207747,0.179909,0.122687,0.043587,-0.007108,-0.06332,-0.105231,-0.142979:2
0.536101,0.50224,0.514243,0.478245,0.4092,0.585904,0.71479,0.598875,0.523307,0.667536,0.646438,0.653334,0.660178,0.641299,0.650052,0.584047,0.497853,0.449765,0.400964,0.350241,0.300137:-0.059222,-0.325352,-0.419349,-0.444857,-0.442022,-0.433087,-0.354857,-0.268066,-0.247285,-0.259262,-0.297326,-0.38724,-0.478263,-0.54997,-0.618513,-0.51294,-0.429317,-0.378168,-0.458186,-0.521796,-0.45098:0.377188,0.260934,0.248796,0.242071,0.210765,0.220213,0.074718,0.011395,0.030047,0.028549,0.074908,0.079833,0.077119,0.088311,0.09988,0.079303,0.099733,0.098519,0.186814,0.236331,0.212574:-0.939896,-0.785447,-0.757174,-0.776239,-0.774393,-0.759966,-0.593321,-0.609983,-0.652802,-0.622488,-0.58497,-0.513121,-0.401122,-0.312356,-0.205435,-0.142376,-0.04066,0.053073,0.104379,0.123428,0.125256:-0.032969,-0.041444,-0.038397,-0.002421,0.026767,0.008873,-0.085061,-0.013024,0.064486,0.080746,0.102014,0.139794,0.15043,0.153829,0.171087,0.247866,0.290701,0.344421,0.356198,0.371234,0.412555:-0.576061,-0.573343,-0.546779,-0.507895,-0.471997,-0.389208,-0.358878,-0.448404,-0.474141,-0.444185,-0.390265,-0.378448,-0.317758,-0.241766,-0.213505,-0.247328,-0.252016,-0.308226,-0.308648,-0.301218,-0.344224:-0.05925,-0.075504,-0.075617,-0.058679,-0.026532,0.001946,0.055524,0.072772,0.084629,0.068645,0.065585,0.055506,0.036771,0.018113,0.021865,0.030708,0.037468,0.04715,0.023426,0.00602,0.004118:0.3974,0.304371,0.270557,0.2672,0.275224,0.229725,0.093757,0.106026,0.107786,0.074134,-7.76E-4,-0.031569,-0.073604,-0.143355,-0.207951,-0.237445,-0.321325,-0.360766,-0.382843,-0.379169,-0.352539:-0.230451,-0.224849,-0.230378,-0.265472,-0.320409,-0.351443,-0.260155,-0.300157,-0.365403,-0.381367,-0.38916,-0.418541,-0.419034,-0.401049,-0.393042,-0.397951,-0.377885,-0.388067,-0.378867,-0.386367,-0.397501:-0.029647,-0.066158,-0.08987,-0.112395,-0.150611,-0.178556,-0.259384,-0.277006,-0.246529,-0.247167,-0.217134,-0.200727,-0.20127,-0.217763,-0.240507,-0.243623,-0.183858,-0.082463,-0.045616,-0.019233,0.026753:0.03868,0.048295,0.038174,0.023541,0.014752,0.010401,0.020379,0.058283,0.0593,0.055591,0.040203,0.060712,0.070654,0.071995,0.067597,0.066735,0.069404,0.044828,0.034486,0.020287,-0.013369:0.028324,0.089953,0.121422,0.122648,0.109752,0.1253,0.190226,0.201484,0.207958,0.240925,0.256368,0.259485,0.229438,0.195592,0.191585,0.164403,0.097063,0.027897,-0.01919,-0.067704,-0.13136:3
0.386265,0.387725,0.397033,0.374181,0.38541,0.399569,0.403859,0.404317,0.320848,0.133316,0.318705,0.394216,0.310094,0.199469,0.245292,0.258391,0.199186,0.137778,0.127111:0.110745,0.030793,-0.002714,0.027246,-0.011522,-0.092769,-0.127776,-0.108413,-0.265856,-0.37468,-0.208265,-0.105846,-0.022744,0.110637,0.048594,-0.011761,-0.028196,-0.004823,-0.018419:-0.123426,-0.151645,-0.151306,-0.214664,-0.211942,-0.193723,-0.239182,-0.238715,-0.135634,-0.145122,-0.093171,-0.024843,0.058405,0.128027,0.161926,0.175116,0.232944,0.282748,0.308713:-0.739495,-0.744758,-0.697788,-0.630893,-0.594623,-0.539398,-0.444137,-0.358593,-0.364683,-0.365337,-0.306754,-0.239977,-0.219395,-0.184484,-0.074715,0.070031,0.122277,0.092916,0.119901:0.091085,0.099471,0.092894,0.069922,0.036681,0.011851,0.029991,0.034252,0.182922,0.324326,0.376063,0.405827,0.472325,0.550834,0.478819,0.443006,0.433517,0.47288,0.492174:-0.770984,-0.759784,-0.68427,-0.590062,-0.499528,-0.42168,-0.393833,-0.379196,-0.382651,-0.365814,-0.405407,-0.382271,-0.330435,-0.308495,-0.331363,-0.368868,-0.358952,-0.343418,-0.371817:0.163949,0.157168,0.147203,0.167149,0.184521,0.199003,0.196008,0.207395,0.116633,0.146637,0.138794,0.050108,-0.001493,-0.0205,0.013891,0.030703,0.033955,0.002834,-0.028032:0.172385,0.191537,0.152065,0.066674,-0.009165,-0.05976,-0.083979,-0.131466,-0.139606,-0.102528,-0.145017,-0.211341,-0.262987,-0.30261,-0.321325,-0.329187,-0.349924,-0.359816,-0.351043:-0.126992,-0.134395,-0.133883,-0.149501,-0.185675,-0.228044,-0.271609,-0.306226,-0.341308,-0.406784,-0.467304,-0.422342,-0.400391,-0.380356,-0.354747,-0.306343,-0.2587,-0.217011,-0.194511:-0.023599,-0.042447,-0.0886,-0.134868,-0.175764,-0.212327,-0.216071,-0.197048,-0.157548,-0.163267,-0.201547,-0.157419,-0.106009,-0.083625,-0.062963,-0.045658,-0.02108,0.005866,0.006984:-0.133725,-0.152692,-0.151317,-0.115104,-0.071769,-0.044993,-0.009433,0.03646,0.089762,0.102541,0.088273,0.086023,0.082967,0.068566,0.069516,0.039737,-0.008043,-0.059783,-0.07327:0.135999,0.149988,0.157965,0.167116,0.177495,0.187373,0.201749,0.208222,0.215955,0.212679,0.212832,0.162686,0.080664,0.046936,-0.009176,-0.060031,-0.108338,-0.140012,-0.178369:3
0.542669,0.58681,0.556714,0.470772,0.536154,0.683325,0.674252,0.468913,0.377038,0.364251,0.381697,0.231966,0.083447,-0.019766:-0.266103,-0.377989,-0.465708,-0.465892,-0.487318,-0.571668,-0.613393,-0.5607,-0.576312,-0.621256,-0.673951,-0.647587,-0.594708,-0.598304:0.097548,0.074606,0.045941,0.008078,-0.020693,-0.025455,-0.001781,0.008824,0.050635,0.118287,0.22092,0.287461,0.325857,0.446768:-0.763199,-0.795118,-0.759065,-0.690503,-0.641608,-0.578351,-0.479397,-0.339451,-0.225954,-0.128696,-0.069946,-0.012434,0.020038,0.042966:0.010092,0.07247,0.11416,0.090931,0.111523,0.11164,0.105935,0.167202,0.25701,0.331718,0.365657,0.400657,0.448592,0.436387:-0.640112,-0.621768,-0.570374,-0.471634,-0.407896,-0.330197,-0.290312,-0.309064,-0.282417,-0.266009,-0.254244,-0.265297,-0.286586,-0.263943:-0.160703,-0.137943,-0.132016,-0.123894,-0.119774,-0.076747,-0.035858,0.027313,0.037992,0.007327,-0.0267,-0.028059,-0.040531,-0.07786:0.316042,0.329857,0.284533,0.199996,0.138549,0.030899,-0.103096,-0.193067,-0.262529,-0.292511,-0.276566,-0.271718,-0.286925,-0.30215:-0.070793,-0.110228,-0.112609,-0.077343,-0.10586,-0.14359,-0.167833,-0.260805,-0.317205,-0.352784,-0.400228,-0.399256,-0.367195,-0.35157:-0.062645,-0.091649,-0.140913,-0.215706,-0.273164,-0.290144,-0.265808,-0.241497,-0.220676,-0.171493,-0.116675,-0.098944,-0.068398,-0.026583:-0.079388,-0.089105,-0.109343,-0.101156,-0.08074,-0.116579,-0.124367,-0.090018,-0.057991,-0.030458,-0.011365,-2.42E-4,-0.002812,-0.006703:0.064615,0.07189,0.089885,0.110256,0.152981,0.207207,0.250067,0.262454,0.224835,0.174731,0.113375,0.033933,-0.054306,-0.120637:3
0.822468,0.772192,0.713667,0.702366,0.764364,0.808732,0.735065,0.63146,0.607167,0.552641,0.51009,0.37538:-0.178076,-0.184137,-0.089388,-0.052472,-0.091517,-0.205515,-0.204525,-0.268534,-0.380946,-0.510821,-0.525389,-0.412901:-0.063932,-0.088829,-0.167527,-0.213363,-0.237567,-0.184073,-0.212411,-0.133636,-0.004261,0.188749,0.224972,0.220539:-0.58511,-0.540786,-0.524517,-0.467854,-0.430705,-0.389556,-0.266392,-0.162294,-0.023586,-0.019541,0.082721,0.189635:-0.073714,-0.058614,0.052842,0.101006,0.140205,0.203407,0.252869,0.238404,0.222086,0.294303,0.304088,0.339472:-0.585691,-0.539267,-0.570405,-0.522511,-0.451511,-0.427569,-0.373805,-0.31526,-0.294617,-0.26522,-0.246044,-0.292614:-0.088884,-0.073325,-0.025622,-0.012133,0.005368,-0.033845,-0.066049,-0.060592,-0.050157,-0.115293,-0.119273,-0.088454:0.217132,0.192138,0.144521,0.08874,0.03694,0.002993,-0.110741,-0.215905,-0.288579,-0.210734,-0.228796,-0.275797:0.033728,0.010443,-0.031244,-0.073807,-0.132859,-0.222441,-0.263884,-0.296587,-0.302067,-0.384573,-0.335566,-0.247762:-0.246949,-0.294683,-0.307468,-0.335982,-0.376705,-0.342583,-0.310104,-0.258014,-0.202026,-0.12036,-0.125194,-0.128856:-0.069319,-0.090821,-0.109405,-0.087512,-0.061571,-0.057923,-0.005686,0.041404,0.09377,0.094747,0.080668,0.064053:0.108903,0.120017,0.134564,0.14468,0.168375,0.204528,0.221844,0.210251,0.166715,0.059892,-0.004567,-0.070293:3
0.854502,1.022192,1.272338,1.184298,1.050541,0.960993,0.541521,0.350482,0.214402,0.137324,0.149296,0.217238,0.401086,0.181349:0.160201,0.099231,-0.249601,-0.537271,-0.47544,-0.364892,-0.434604,-0.398525,-0.395848,-0.463642,-0.397545,-0.409621,-0.559369,-0.514548:-0.14927,-0.381831,-0.336288,-0.138653,-0.179637,-0.252638,-0.165269,-0.181247,-0.177137,-0.127804,-0.086363,-0.011394,0.090459,0.095338:-0.739906,-0.57823,-0.467707,-0.621612,-0.59155,-0.520728,-0.510591,-0.470132,-0.418709,-0.347633,-0.300749,-0.226704,-0.131367,-0.046627:-0.042727,-0.084137,-0.178403,-0.051629,0.006085,0.07689,0.218692,0.318548,0.396164,0.465421,0.523954,0.531797,0.470928,0.49253:-0.738056,-0.660346,-0.53817,-0.537604,-0.552654,-0.54398,-0.50586,-0.496739,-0.468149,-0.432687,-0.43047,-0.43684,-0.420024,-0.477796:0.012508,-0.014205,-0.027801,-0.057005,-0.050031,-0.01725,-0.016939,-0.007566,0.009747,-0.008663,-0.046837,-0.086605,-0.129306,-0.115794:0.183973,0.121478,0.068194,0.147495,0.13216,0.04938,-0.014462,-0.038443,-0.075881,-0.114841,-0.14633,-0.166893,-0.163293,-0.189115:0.004258,0.119642,0.139991,-0.006014,-0.0188,-0.082098,-0.219046,-0.301226,-0.368583,-0.417464,-0.434159,-0.431432,-0.398226,-0.355656:-0.06309,-0.205098,-0.229205,-0.135231,-0.168739,-0.174306,-0.166856,-0.195256,-0.207864,-0.219161,-0.203459,-0.167793,-0.137183,-0.123423:-0.035737,-0.046514,-0.138855,-0.209474,-0.202709,-0.169187,-0.121684,-0.106347,-0.090996,-0.056601,-0.02153,0.005481,-0.00283,-0.008686:0.101038,0.083346,0.140082,0.196818,0.215924,0.233154,0.254635,0.244391,0.216758,0.197239,0.188579,0.157446,0.10556,0.036435:3
0.268246,0.532917,0.669439,0.568259,0.546384,0.645313,0.383938,0.23209,0.125927,0.078547,0.180885,0.159331,-0.005724,-0.150971,-0.237286:-0.24929,-0.36588,-0.420485,-0.608248,-0.666303,-0.729752,-0.686314,-0.700429,-0.700777,-0.699289,-0.681361,-0.620324,-0.603069,-0.625505,-0.645359:0.096122,0.042262,-0.11116,0.083796,0.11718,0.057617,0.030616,0.070147,0.085271,0.054634,0.102451,0.161355,0.213499,0.276056,0.326582:-0.874813,-0.845838,-0.721581,-0.761359,-0.780146,-0.705342,-0.633009,-0.56908,-0.4879,-0.404551,-0.365182,-0.285497,-0.19744,-0.113279,-0.050644:0.016223,0.001767,-0.015996,-0.021121,0.005764,0.023561,0.100356,0.170464,0.244552,0.350812,0.38831,0.371768,0.39569,0.421069,0.445626:-0.812165,-0.742003,-0.673285,-0.527134,-0.515788,-0.461469,-0.452633,-0.430283,-0.400936,-0.414358,-0.410462,-0.417503,-0.442383,-0.428015,-0.419575:-0.025678,-0.034651,0.011365,-0.106587,-0.127022,-0.094661,-0.072541,-0.053451,-0.049684,-0.070833,-0.108719,-0.129642,-0.120631,-0.090127,-0.074836:0.395293,0.424845,0.339883,0.345909,0.35474,0.309487,0.179272,0.081553,-0.013398,-0.067969,-0.101436,-0.15115,-0.182906,-0.203773,-0.233344:-0.146249,-0.137471,-0.115547,-0.127218,-0.186156,-0.226434,-0.214605,-0.269084,-0.326423,-0.403184,-0.463565,-0.464291,-0.432979,-0.420042,-0.399374:0.07347,-0.008005,-0.069468,-0.09815,-0.120915,-0.176219,-0.22972,-0.224634,-0.182506,-0.134928,-0.10154,-0.057716,-0.013525,3.43E-4,0.01549:0.009038,-0.001967,-0.026378,-0.02813,-0.014442,-0.005597,-0.015623,-0.024867,-0.047152,-0.016874,0.052839,0.125064,0.111997,0.070273,0.019793:0.133445,0.144667,0.183084,0.139724,0.144945,0.180857,0.242787,0.290001,0.307261,0.266204,0.23174,0.18285,0.124178,0.042238,-0.01293:3
0.484703,0.472858,0.442469,0.421506,0.408871,0.489302,0.514769,0.453994,0.394749,0.378347,0.394774,0.423927,0.399298,0.195888,0.100391,0.059175,0.029752,0.029917,0.03371,0.021171:0.162817,0.185875,0.214839,0.148311,0.069339,-0.020169,-0.094779,-0.130846,-0.166382,-0.220239,-0.23369,-0.263585,-0.245233,-0.263398,-0.262345,-0.27373,-0.280503,-0.327709,-0.380109,-0.412502:-0.04348,-0.107837,-0.168296,-0.206735,-0.264634,-0.282437,-0.168665,-0.100202,-0.056069,0.033954,0.097,0.130145,0.147485,0.182428,0.180626,0.219028,0.274573,0.321932,0.359749,0.381326:-0.824301,-0.77067,-0.729557,-0.695682,-0.619262,-0.519692,-0.4391,-0.358948,-0.268071,-0.12935,-0.031471,0.008827,0.065918,0.081733,0.122002,0.162518,0.206131,0.225614,0.240268,0.269292:0.079645,0.129438,0.168112,0.236251,0.304104,0.316705,0.314141,0.365389,0.43207,0.457756,0.449978,0.444252,0.434153,0.539735,0.599573,0.624553,0.633717,0.63497,0.632723,0.630532:-0.644264,-0.575278,-0.520814,-0.503946,-0.528599,-0.550386,-0.521451,-0.511997,-0.484358,-0.454599,-0.456133,-0.438103,-0.448655,-0.497387,-0.515005,-0.506529,-0.504823,-0.497406,-0.479988,-0.46358:0.09863,0.069895,0.080083,0.082176,0.084937,0.097962,0.0839,0.087914,0.086175,0.049311,0.032859,0.028284,0.042241,0.019292,0.010528,0.017821,0.017596,0.021789,0.028464,0.026363:0.134531,0.085369,0.019795,-0.017173,-0.051311,-0.08716,-0.120412,-0.158025,-0.183949,-0.22184,-0.254911,-0.293064,-0.309286,-0.282924,-0.299927,-0.299398,-0.276599,-0.25226,-0.235225,-0.229892:-0.13436,-0.086733,-0.103946,-0.164886,-0.21713,-0.274765,-0.321933,-0.386227,-0.420576,-0.408921,-0.400528,-0.391978,-0.381455,-0.38942,-0.370299,-0.345647,-0.332971,-0.316481,-0.298402,-0.278718:-0.032187,-0.085704,-0.10996,-0.133297,-0.163408,-0.193727,-0.206994,-0.199538,-0.208777,-0.204091,-0.175364,-0.164166,-0.16609,-0.074733,-0.005931,0.038272,0.053784,0.061706,0.073516,0.082327:-0.155727,-0.171531,-0.17899,-0.189478,-0.191583,-0.150753,-0.08973,-0.042218,-0.036359,-0.035352,-0.016486,0.015868,0.04098,-0.00643,-0.026375,-0.039271,-0.045406,-0.063534,-0.091877,-0.120426:0.15184,0.183798,0.195044,0.206034,0.237258,0.289731,0.323273,0.304775,0.268221,0.230245,0.170597,0.124045,0.091669,0.038586,-0.010209,-0.059357,-0.095342,-0.130953,-0.167411,-0.190522:3
0.665642,0.538381,0.479535,0.423398,0.444906,0.525543,0.637937,0.633438,0.605838,0.546321,0.503941,0.463145,0.389428,0.288317:-0.179317,-0.240604,-0.267613,-0.332252,-0.38773,-0.429427,-0.434407,-0.425285,-0.452458,-0.414854,-0.40636,-0.473579,-0.478454,-0.429713:0.094755,0.070684,0.040226,0.018869,0.012276,-0.009258,0.007736,0.020168,0.022565,0.035175,0.080569,0.116112,0.175092,0.235947:-0.86697,-0.877867,-0.857295,-0.817861,-0.782771,-0.726727,-0.668375,-0.528892,-0.439999,-0.339458,-0.194256,-0.112914,-0.056709,-0.033519:0.180786,0.242478,0.270886,0.297796,0.360182,0.439716,0.46499,0.49748,0.560589,0.652163,0.686042,0.665472,0.678947,0.710589:-0.719771,-0.707729,-0.662627,-0.608721,-0.568364,-0.521178,-0.482519,-0.445249,-0.426845,-0.446419,-0.452685,-0.442892,-0.464134,-0.493284:-0.182835,-0.173124,-0.139674,-0.112925,-0.102186,-0.108798,-0.107848,-0.104419,-0.087919,-0.081383,-0.096202,-0.104669,-0.135335,-0.143226:0.384409,0.403963,0.372573,0.313977,0.278131,0.221908,0.151984,0.063032,0.021237,-0.032647,-0.078452,-0.082834,-0.098405,-0.117191:-0.160821,-0.193226,-0.221626,-0.261405,-0.332316,-0.407569,-0.47198,-0.498086,-0.524487,-0.522209,-0.479812,-0.455313,-0.428198,-0.436589:-0.011924,-0.039466,-0.079868,-0.105009,-0.145543,-0.197006,-0.201515,-0.212908,-0.216564,-0.15629,-0.106298,-0.084742,-0.052478,-0.007201:-0.168166,-0.202335,-0.221238,-0.228972,-0.228025,-0.214944,-0.135891,-0.078639,-0.085148,-0.095104,-0.091927,-0.092865,-0.083221,-0.076584:0.042607,0.050923,0.074728,0.080498,0.102334,0.148312,0.180797,0.210156,0.198198,0.145615,0.096208,0.027069,-0.032312,-0.065576:3
0.486189,0.514255,0.450274,0.365411,0.304147,0.21893,0.086433:-0.135315,-0.161761,-0.119937,-0.139214,-0.206522,-0.192665,-0.176224:-0.13684,-0.136399,-0.153601,-0.185432,-0.136432,-0.075176,-0.001702:-0.570488,-0.515083,-0.439828,-0.358531,-0.310749,-0.269058,-0.173613:-0.014225,0.020651,0.090489,0.139577,0.154518,0.194808,0.269605:-0.492548,-0.470181,-0.429767,-0.411964,-0.384026,-0.403788,-0.444665:0.092761,0.089084,0.091283,0.112044,0.115462,0.102441,0.049941:0.044687,-0.004674,-0.075372,-0.137075,-0.20109,-0.223194,-0.242259:-0.055169,-0.078032,-0.127058,-0.208909,-0.264311,-0.312897,-0.313674:-0.298104,-0.306676,-0.304168,-0.316665,-0.300501,-0.2756,-0.228104:0.015013,0.013071,0.022246,0.036996,0.035749,0.07003,0.106538:0.204852,0.245437,0.257791,0.257605,0.270907,0.264162,0.193699:3
0.934919,1.044554,0.954552,0.934799,0.930868,0.885835,0.848076,0.805358,0.5992,0.34662,0.288766,0.179328,0.027917,-0.089912,-0.166136,-0.220031,-0.306241:0.13933,0.068938,-0.103184,-0.153811,-0.152,-0.213221,-0.19422,-0.183261,-0.138637,-0.094302,-0.081762,-0.151669,-0.176414,-0.136144,-0.174875,-0.187524,-0.241849:0.084435,-0.032583,-0.004849,-0.066167,-0.155428,-0.109155,-0.11086,-0.102265,-0.027009,0.095311,0.118346,0.241887,0.394489,0.508935,0.583711,0.647204,0.738773:-0.947243,-0.856612,-0.807474,-0.752418,-0.647047,-0.642299,-0.513985,-0.429461,-0.383166,-0.277699,-0.175759,-0.097653,-0.096104,-0.113134,-0.031616,0.02532,0.086026:0.227614,0.166776,0.159893,0.163151,0.166593,0.285869,0.354405,0.434415,0.554677,0.681201,0.758198,0.759062,0.763877,0.762794,0.760801,0.761579,0.742704:-0.658531,-0.592114,-0.474913,-0.42857,-0.448747,-0.457002,-0.429323,-0.409361,-0.425237,-0.434151,-0.454565,-0.455726,-0.380811,-0.333032,-0.366988,-0.399177,-0.412195:-0.286278,-0.194563,-0.214423,-0.128988,-0.036953,-0.043322,-0.02908,-0.005057,-0.011929,-0.033917,-0.039716,-0.062039,-0.115213,-0.151119,-0.1399,-0.102913,-0.074261:0.290628,0.203144,0.159637,0.103471,0.081257,0.095709,0.021539,-0.063026,-0.107681,-0.129948,-0.152668,-0.185209,-0.207053,-0.220865,-0.191034,-0.164726,-0.128455:-0.014876,-0.043581,-0.034263,-0.097561,-0.205238,-0.324182,-0.367877,-0.385652,-0.450451,-0.488374,-0.44156,-0.421556,-0.402042,-0.345382,-0.298234,-0.28932,-0.316721:0.027675,-0.065716,-0.126708,-0.15707,-0.176246,-0.238465,-0.296876,-0.296415,-0.215902,-0.163199,-0.095588,-0.009433,0.033698,0.081325,0.113342,0.144257,0.140032:-0.162333,-0.154329,-0.173751,-0.216288,-0.221444,-0.178589,-0.151702,-0.155062,-0.108116,-0.075403,-0.107938,-0.094704,-0.089177,-0.124951,-0.147993,-0.162933,-0.132992:-0.054222,-7.74E-4,0.028055,0.056288,0.0766,0.133493,0.208093,0.221108,0.167613,0.144863,0.062597,-0.048736,-0.114768,-0.17233,-0.211954,-0.241643,-0.259917:3
0.946349,0.91856,0.838027,0.772003,0.862468,0.806324,0.756216,0.654924,0.514389,0.387097,0.292653:-0.65529,-0.796767,-0.88016,-0.876239,-1.061797,-1.123175,-1.103318,-1.096409,-1.189018,-1.154316,-1.049932:-0.205982,-0.204944,-0.217378,-0.273892,-0.212339,-0.174921,-0.062226,0.042673,0.104184,0.161195,0.207215:-0.568323,-0.511968,-0.429873,-0.318831,-0.242622,-0.150468,-0.118437,-0.037671,0.134393,0.278983,0.328249:0.04414,0.080739,0.117201,0.190321,0.278199,0.291488,0.284654,0.354513,0.387109,0.432818,0.502858:-0.609592,-0.578938,-0.544185,-0.509749,-0.49272,-0.482432,-0.455199,-0.446339,-0.474001,-0.50331,-0.50631:-0.113313,-0.11759,-0.074269,-0.079846,-0.107737,-0.099715,-0.100386,-0.13009,-0.111953,-0.102851,-0.097303:0.193806,0.146172,0.121612,0.080738,0.017602,-0.031989,-0.064746,-0.09939,-0.142872,-0.176446,-0.206262:-0.006075,-0.055198,-0.135676,-0.201597,-0.288744,-0.373645,-0.407658,-0.410792,-0.428263,-0.406353,-0.373617:0.007862,0.018731,-0.034175,-0.07757,-0.088711,-0.103549,-0.107973,-0.119703,-0.098015,-0.054517,-0.007673:-0.236937,-0.232983,-0.242691,-0.235683,-0.20466,-0.137609,-0.080276,-0.054804,-0.057697,-0.067914,-0.099801:0.069694,0.073136,0.11374,0.122292,0.164658,0.197678,0.213023,0.201425,0.142386,0.050811,-0.027895:3
0.736277,0.601714,0.487441,0.504412,0.525656,0.45389,0.346025,0.230191,0.169226,0.166107,0.171593,0.050328,-0.094932,-0.180895,-0.278691:-0.109217,-0.045193,-0.110414,-0.182609,-0.193844,-0.14486,-0.099081,0.001221,-0.069992,-0.159666,-0.215056,-0.250572,-0.230833,-0.194673,-0.15799:0.226712,0.198672,0.127712,0.025326,0.027099,0.07195,0.05972,0.045285,0.069472,0.040746,0.025243,0.150694,0.313464,0.46357,0.514434:-0.621903,-0.726706,-0.725325,-0.733516,-0.709596,-0.662749,-0.621844,-0.592558,-0.45597,-0.258093,-0.111262,-0.04272,0.006701,0.06659,0.115185:-0.089707,-0.048792,-0.007973,0.115554,0.13961,0.107493,0.20012,0.316945,0.480951,0.557691,0.54492,0.546473,0.551139,0.573916,0.638144:-0.557623,-0.489486,-0.454837,-0.433915,-0.401586,-0.35601,-0.37319,-0.337346,-0.369623,-0.427828,-0.456487,-0.436042,-0.416622,-0.432546,-0.444774:-0.105097,-0.074278,-0.065701,-0.11034,-0.122653,-0.065257,-0.025723,0.035663,-0.009632,-0.035625,-0.036702,-0.040027,-0.033543,-0.028965,-0.013021:0.210881,0.205421,0.174675,0.177713,0.175285,0.099785,0.009965,-0.124177,-0.141496,-0.179548,-0.25424,-0.316646,-0.340295,-0.315412,-0.299126:0.047172,-0.020602,-0.061304,-0.126595,-0.175773,-0.251323,-0.358392,-0.464149,-0.505742,-0.483008,-0.44575,-0.451979,-0.434707,-0.354634,-0.296212:-0.18388,-0.205629,-0.234974,-0.223209,-0.205156,-0.140632,-0.068057,-0.063202,-0.097678,-0.092995,-0.047778,0.008367,0.053881,0.10333,0.145991:-0.166038,-0.124677,-0.134179,-0.157403,-0.167396,-0.139766,-0.072663,-0.031566,-0.030109,-0.032523,-0.005326,0.003197,-0.013785,-0.07924,-0.143445:0.174498,0.13856,0.162059,0.155138,0.166535,0.182831,0.143423,0.127093,0.137553,0.082117,0.005932,-0.026519,-0.061029,-0.11722,-0.17775:3
0.497002,0.576861,0.610997,0.61038,0.402009,0.327596,0.290881,0.125766,-0.069251,-0.123553,-0.169697,-0.21105,-0.199178,-0.192375,-0.197966:-0.07293,-0.062081,-0.051908,0.02084,0.029347,-0.014889,-0.035622,-0.00202,0.035382,-0.018662,-0.104815,-0.135334,-0.125555,-0.199856,-0.287178:-0.108679,-0.125445,-0.171551,-0.099997,-0.06388,-0.072139,-0.060479,0.101299,0.243796,0.296152,0.253006,0.23961,0.212455,0.21592,0.258179:-0.761062,-0.762198,-0.735216,-0.646614,-0.517796,-0.379877,-0.222867,-0.11492,-0.11853,-0.047581,0.088355,0.156874,0.207629,0.294887,0.36099:0.286501,0.343993,0.453233,0.47899,0.566895,0.656713,0.691727,0.764843,0.749118,0.684716,0.687865,0.698986,0.727016,0.675987,0.612991:-0.601468,-0.531414,-0.558721,-0.54219,-0.541547,-0.572228,-0.591389,-0.575091,-0.542322,-0.566555,-0.623815,-0.640175,-0.65635,-0.644897,-0.613896:-0.106932,-0.039405,-0.006083,0.006466,0.003182,0.04624,0.054346,-0.022722,-0.053213,0.001663,0.009201,0.021888,0.029839,0.048235,0.057569:0.121883,0.015561,-0.017227,-0.051917,-0.075438,-0.095552,-0.14041,-0.175975,-0.247229,-0.304407,-0.306014,-0.292406,-0.259625,-0.230978,-0.224888:-0.138017,-0.275608,-0.386964,-0.422312,-0.414909,-0.429029,-0.419168,-0.386088,-0.353303,-0.359798,-0.318907,-0.275323,-0.217092,-0.19087,-0.180942:-0.030872,-0.041594,-0.062032,-0.093745,-0.1147,-0.123989,-0.127977,-0.068685,0.029354,0.081439,0.086201,0.094352,0.083486,0.056336,0.041428:-0.234715,-0.157435,-0.137665,-0.078027,-0.063533,-0.097144,-0.110639,-0.1163,-0.156119,-0.150635,-0.150514,-0.151809,-0.177998,-0.189805,-0.196236:0.085847,0.138299,0.219606,0.278149,0.27246,0.23831,0.172394,0.06957,-0.051937,-0.105845,-0.129694,-0.152886,-0.152107,-0.160658,-0.175376:3
0.669088,0.529058,0.382011,0.310671,0.254614,0.194193,0.093067,-0.017902,-0.108101:0.126628,0.096727,0.075963,0.023286,-0.019488,-0.048452,-0.08352,-0.162331,-0.203899:-0.051337,-0.130877,-0.210633,-0.206869,-0.208555,-0.210458,-0.052691,0.105145,0.259374:-0.600383,-0.452151,-0.340154,-0.200237,-0.021787,0.166705,0.289829,0.347589,0.411004:0.207266,0.241046,0.31964,0.358973,0.367799,0.357258,0.354872,0.383446,0.396202:-0.585189,-0.542198,-0.544194,-0.503066,-0.450671,-0.401071,-0.408888,-0.416598,-0.415471:0.19334,0.211184,0.20932,0.179464,0.20079,0.205151,0.13728,0.108847,0.081257:0.077718,-0.042704,-0.148716,-0.266421,-0.357711,-0.421536,-0.45358,-0.441228,-0.39322:-0.293915,-0.315373,-0.348886,-0.360328,-0.351669,-0.327852,-0.289297,-0.23886,-0.156109:-0.232029,-0.26223,-0.227455,-0.181605,-0.155568,-0.122568,-0.064256,-0.016848,0.003534:-0.102734,-0.033259,-0.020026,0.01785,0.048436,0.049241,0.041212,8.9E-4,-0.042396:0.220207,0.25177,0.229554,0.165716,0.085422,-0.010235,-0.111333,-0.177227,-0.227776:3
0.326581,0.377,0.500328,0.499932,0.41426,0.313296,0.228106,0.174317,0.122175,0.011928,-0.138704,-0.246603:-0.222356,-0.276081,-0.377162,-0.440847,-0.419491,-0.380906,-0.357598,-0.418289,-0.433657,-0.410277,-0.335201,-0.317631:0.049259,0.056569,0.06008,0.071004,0.094217,0.077364,0.128026,0.247142,0.323964,0.341781,0.386954,0.406046:-0.790634,-0.776763,-0.693047,-0.607244,-0.526196,-0.417074,-0.271,-0.131678,-0.047339,-1.06E-4,0.032338,0.102248:0.171613,0.198026,0.262859,0.343158,0.400553,0.47535,0.533823,0.54734,0.53947,0.549643,0.566218,0.599282:-0.370964,-0.37178,-0.387707,-0.380992,-0.336559,-0.314108,-0.371478,-0.376907,-0.392807,-0.450091,-0.499279,-0.546812:-0.136778,-0.165326,-0.196584,-0.205065,-0.183587,-0.12433,-0.083151,-0.088598,-0.09074,-0.074111,-0.070636,-0.077507:0.238513,0.208201,0.159407,0.048591,-0.076013,-0.181119,-0.213141,-0.25217,-0.29268,-0.287158,-0.278553,-0.251047:-0.193366,-0.221863,-0.254001,-0.272443,-0.283798,-0.347229,-0.427873,-0.423968,-0.399789,-0.384355,-0.349229,-0.308695:-0.226839,-0.22963,-0.249389,-0.276356,-0.194476,-0.052678,0.008929,0.003868,0.027408,0.033757,0.042392,0.04367:-0.085567,-0.061883,-0.030955,-0.003036,-0.01238,-0.043855,-0.028548,-0.006405,-0.025532,-0.074431,-0.11246,-0.121192:0.096344,0.118535,0.175386,0.278378,0.321145,0.211402,0.095877,0.035361,-0.022758,-0.067399,-0.11999,-0.163305:3
0.377859,0.256449,0.248377,0.232947,0.193307,0.093637,0.012686,-0.076174,-0.22276,-0.322053,-0.342624,-0.401105,-0.344634,-0.325909,-0.551061,-0.687534,-0.680729,-0.783783:-0.486386,-0.500909,-0.488672,-0.57126,-0.673352,-0.717578,-0.721288,-0.774328,-0.805359,-0.788106,-0.772618,-0.698575,-0.660067,-0.615506,-0.542264,-0.543881,-0.575904,-0.562047:0.02152,-0.019731,-0.042047,-0.034701,-0.020971,0.009605,0.123871,0.246883,0.338604,0.412741,0.47282,0.524214,0.544838,0.55239,0.538631,0.55653,0.601105,0.624879:-0.886635,-0.863992,-0.812835,-0.703009,-0.608045,-0.533066,-0.420037,-0.250678,-0.116283,-0.041385,-0.010989,0.032061,0.059081,0.108649,0.182558,0.222788,0.260682,0.296571:0.165251,0.227513,0.26701,0.310773,0.380558,0.449784,0.429952,0.45924,0.491651,0.540273,0.568764,0.528543,0.494071,0.477029,0.492589,0.513404,0.488225,0.488939:-0.61933,-0.567881,-0.505813,-0.45478,-0.449175,-0.451164,-0.413304,-0.369362,-0.341305,-0.337978,-0.345369,-0.349754,-0.366534,-0.399908,-0.440978,-0.460374,-0.449121,-0.449588:-0.17825,-0.176633,-0.167599,-0.150483,-0.13508,-0.131443,-0.144182,-0.142301,-0.119481,-0.113867,-0.112014,-0.076508,-0.06186,-0.045526,-0.00739,0.030029,0.046317,0.070828:0.336179,0.278165,0.201885,0.104083,0.04883,-0.002076,-0.080007,-0.164068,-0.241604,-0.266647,-0.280134,-0.322792,-0.324222,-0.306778,-0.302587,-0.276068,-0.236964,-0.221443:-0.113505,-0.137524,-0.159944,-0.218626,-0.323332,-0.422041,-0.423581,-0.402229,-0.379141,-0.368945,-0.380118,-0.359398,-0.313953,-0.270723,-0.240751,-0.222741,-0.194132,-0.161629:-0.036146,-0.078775,-0.135911,-0.160133,-0.15438,-0.137549,-0.121178,-0.113902,-0.069397,-0.001643,0.056682,0.091215,0.090312,0.099173,0.112415,0.117599,0.085963,0.067162:-0.092644,-0.10468,-0.098874,-0.09026,-0.073995,-0.019047,0.063364,0.057884,0.02351,-0.008947,-0.048417,-0.083818,-0.133159,-0.177574,-0.196814,-0.213154,-0.22112,-0.234272:0.107699,0.14963,0.225414,0.287781,0.289695,0.245353,0.215983,0.143683,0.046391,-0.072606,-0.161721,-0.202849,-0.220779,-0.259839,-0.278798,-0.268991,-0.249027,-0.240921:3
0.377463,0.397459,0.455239,0.509819,0.673377,0.859195,0.787809,0.44778,0.541664,0.63212,0.575136,0.431326,0.038854:0.039072,0.004078,-0.068376,-0.131371,-0.102094,-0.214347,-0.290372,-0.241285,-0.232254,-0.331071,-0.454252,-0.559178,-0.560722:-0.060005,-0.03308,0.021579,0.028016,0.034419,0.046324,-0.009243,0.033924,-0.030671,-0.047293,0.02545,0.145702,0.326275:-0.689421,-0.736267,-0.80199,-0.8247,-0.80751,-0.738471,-0.56274,-0.41884,-0.31318,-0.184385,-0.056668,0.096532,0.109806:0.012481,0.045939,0.096532,0.150346,0.229462,0.237142,0.228573,0.337383,0.406527,0.365321,0.397753,0.450262,0.524948:-0.83559,-0.77417,-0.683296,-0.614276,-0.600295,-0.525615,-0.456985,-0.420504,-0.44642,-0.404532,-0.373094,-0.360299,-0.355337:-0.042999,-0.067067,-0.101647,-0.11834,-0.108615,-0.079408,-0.009005,-0.016297,0.020582,0.055519,0.045529,0.033832,-0.007639:0.296496,0.326312,0.348314,0.337204,0.31579,0.210593,0.046064,-0.098643,-0.201138,-0.264817,-0.290778,-0.26364,-0.273372:-0.045098,-0.089194,-0.139383,-0.151827,-0.197696,-0.289917,-0.265317,-0.297025,-0.387869,-0.417681,-0.395143,-0.341932,-0.318043:-0.055049,-0.055143,-0.069641,-0.116991,-0.149719,-0.216318,-0.306426,-0.268428,-0.180762,-0.141717,-0.144616,-0.106484,-0.051451:-0.059737,-0.096017,-0.138819,-0.164866,-0.165457,-0.090819,-0.095311,-0.112863,-0.017456,0.024225,0.015759,-0.020074,-0.031547:0.090905,0.091219,0.088096,0.103709,0.133353,0.199956,0.284669,0.323651,0.302959,0.226046,0.152937,0.031376,-0.103618:3
0.424032,0.405137,0.312833,0.2797,0.218244,0.059411,0.05851,0.103422,0.046119,0.159122,0.208252,0.233079:0.025915,-0.006326,-0.124844,-0.168569,-0.162903,-0.203385,-0.142849,-0.014858,-0.048356,-0.119744,-0.314476,-0.452248:-0.119739,-0.134393,-0.110102,-0.083453,-0.139884,-0.162503,-0.181947,-0.164803,-0.042502,0.019518,0.153493,0.215117:-0.460833,-0.476398,-0.47527,-0.4956,-0.492759,-0.414059,-0.338443,-0.279087,-0.126843,-0.023695,0.090486,0.187305:-0.252455,-0.134984,-0.038775,0.049663,0.084457,0.154617,0.213444,0.241132,0.350384,0.443751,0.441668,0.443521:-0.581322,-0.551837,-0.469022,-0.430464,-0.375204,-0.363376,-0.347061,-0.332339,-0.41956,-0.353163,-0.287315,-0.279059:-0.022991,-0.027738,-0.03576,-0.056229,-0.037467,-0.055547,-0.071988,0.014036,-0.001032,-0.021575,-0.047529,-0.060317:0.182595,0.175169,0.177939,0.161566,0.065268,-0.009605,-0.103,-0.278562,-0.250037,-0.289835,-0.324181,-0.358354:0.110181,0.093706,-0.032961,-0.13285,-0.162004,-0.160708,-0.193243,-0.314437,-0.364291,-0.368037,-0.333359,-0.269046:-0.33118,-0.384017,-0.427921,-0.441202,-0.462675,-0.495613,-0.447191,-0.219691,-0.139583,-0.074185,-0.017168,-0.034309:0.13997,0.134305,0.113697,0.097436,0.109425,0.101454,0.121748,0.123445,0.121346,0.064688,0.035191,0.004981:0.048868,0.083027,0.14382,0.155186,0.14814,0.190872,0.214087,0.187123,0.140703,0.032413,-0.093287,-0.125468:3
0.52441,0.472932,0.525259,0.616028,0.55232,0.328907,0.295975,0.315686,0.094798,-0.073679,-0.219852,-0.335809:-0.030505,-0.024882,0.003629,-0.062669,-0.107119,-0.011226,-0.013855,-0.129667,-0.122691,-0.072169,0.007743,0.014447:0.050132,-0.007871,-0.088621,-0.074509,0.061328,0.248949,0.363025,0.438933,0.387417,0.40529,0.513286,0.522874:-0.650246,-0.59252,-0.581311,-0.571176,-0.591956,-0.606687,-0.540583,-0.342836,-0.170115,-0.107673,-0.022362,0.082288:0.064214,0.06228,0.170635,0.206631,0.245025,0.328063,0.424855,0.53064,0.568723,0.609188,0.657181,0.709736:-0.646528,-0.55567,-0.534165,-0.523193,-0.438166,-0.297056,-0.195017,-0.248901,-0.306187,-0.325245,-0.35298,-0.395145:-0.101996,-0.143766,-0.106169,-0.075059,-0.081261,-0.029517,-0.053395,-0.073979,-0.03472,-0.027915,-0.033075,0.006291:0.230814,0.149251,0.133633,0.146556,0.102059,-0.121074,-0.14996,-0.133616,-0.286193,-0.356445,-0.342405,-0.27331:0.059481,0.118261,-0.003059,-0.159609,-0.26513,-0.382722,-0.384659,-0.398785,-0.347743,-0.336869,-0.310713,-0.292465:-0.1368,-0.194439,-0.198303,-0.190152,-0.197521,-0.107641,-0.107845,-0.102191,-0.006663,0.065149,0.09734,0.090587:-0.178448,-0.187956,-0.166722,-0.122647,-0.065475,0.047766,0.011843,-0.00744,-0.035927,-0.074294,-0.101973,-0.090254:0.12526,0.145387,0.127207,0.131449,0.157658,0.155542,0.085433,-0.022412,-0.125505,-0.166159,-0.198115,-0.189863:3
0.871146,0.817534,0.775603,0.657371,0.580338,0.574076,0.516682,0.514875,0.476706,0.414942,0.271818,0.230016,0.085609,-0.080253,-0.101944,-0.15209:0.00214,-0.107652,-0.167255,-0.242705,-0.322963,-0.397419,-0.429233,-0.411908,-0.359405,-0.364359,-0.254979,-0.222553,-0.262964,-0.207698,-0.170484,-0.099106:-0.059705,0.008065,0.003031,0.00909,0.003061,-0.017579,0.030325,0.234679,0.364491,0.433871,0.51622,0.649027,0.718046,0.76974,0.876276,0.815582:-0.418729,-0.661998,-0.711562,-0.719492,-0.691796,-0.654633,-0.6053,-0.596023,-0.440224,-0.257891,-0.221154,-0.233485,-0.155857,-0.096026,-0.082676,-0.114239:-0.188516,-0.101523,-0.023427,0.019659,0.100472,0.197746,0.244942,0.277153,0.340208,0.42538,0.432154,0.408971,0.477104,0.534972,0.571387,0.617194:-0.676569,-0.620433,-0.552323,-0.468504,-0.426225,-0.420288,-0.401139,-0.372269,-0.384873,-0.433696,-0.418111,-0.344139,-0.321782,-0.295317,-0.314652,-0.354551:0.007621,-7.05E-4,-0.018682,-0.054514,-0.091852,-0.118475,-0.127101,-0.117556,-0.096983,-0.10235,-0.071772,-0.099735,-0.148731,-0.1825,-0.118636,-0.098664:0.178807,0.311623,0.322986,0.273264,0.217844,0.175481,0.072502,0.008811,-0.102559,-0.134002,-0.197391,-0.323199,-0.330095,-0.321283,-0.29811,-0.283578:-0.072527,-0.087468,-0.155622,-0.17097,-0.222321,-0.291206,-0.351793,-0.430833,-0.477928,-0.482044,-0.486942,-0.458494,-0.422971,-0.343114,-0.370069,-0.333669:-0.082239,-0.10099,-0.107999,-0.097256,-0.111339,-0.166964,-0.144637,-0.046981,0.046523,0.012893,0.045863,0.16062,0.18514,0.189279,0.250103,0.261257:0.05456,-0.005356,-0.026591,-0.031634,0.002403,0.036692,0.070984,0.120035,0.092022,0.009359,-0.0376,-0.074114,-0.087025,-0.125331,-0.149654,-0.225369:0.179272,0.142423,0.138831,0.158254,0.189326,0.223049,0.265404,0.254836,0.102241,-0.001599,-0.078911,-0.199179,-0.241335,-0.239493,-0.27835,-0.273758:3
0.406995,0.427763,0.425381,0.439965,0.449922,0.450402,0.448836,0.391462,0.278614,0.19447,0.271301,0.261396,0.127985:-0.10796,-0.149462,-0.189207,-0.265798,-0.314483,-0.209745,-0.227299,-0.376165,-0.478323,-0.547394,-0.593775,-0.702789,-0.606061:-0.330156,-0.295396,-0.274616,-0.276406,-0.214264,-0.276053,-0.349944,-0.206213,-0.119046,-0.046056,0.019292,0.185102,0.188738:-0.641194,-0.631726,-0.598744,-0.545603,-0.528957,-0.433097,-0.292875,-0.162941,-0.034439,0.062149,0.217604,0.234351,0.262565:-0.13064,-0.077473,-0.01429,0.050098,0.123691,0.214752,0.296613,0.349817,0.367416,0.417573,0.406987,0.407268,0.40721:-0.578062,-0.540443,-0.496184,-0.432178,-0.371059,-0.388734,-0.422207,-0.378318,-0.326341,-0.30539,-0.338851,-0.333449,-0.346858:-0.078763,-0.113116,-0.11547,-0.111127,-0.111156,-0.091423,-0.09733,-0.111489,-0.059804,-0.03798,-0.039407,-0.035292,-4.21E-4:0.189413,0.186725,0.149091,0.082274,0.034791,-0.012318,-0.045281,-0.108044,-0.212642,-0.270768,-0.298173,-0.34282,-0.371696:0.25195,0.209875,0.139207,0.087991,0.00499,-0.116985,-0.247832,-0.306489,-0.339468,-0.372069,-0.358267,-0.346642,-0.336952:-0.246002,-0.288768,-0.319702,-0.339898,-0.329809,-0.285533,-0.209645,-0.18903,-0.178391,-0.1404,-0.115925,-0.054886,-0.034362:0.003816,0.002966,-3.46E-4,-0.039501,-0.103966,-0.107715,-0.058812,-0.026217,-0.04243,-0.018014,0.008091,-0.01362,-0.012883:0.097053,0.132277,0.179102,0.204386,0.234981,0.263293,0.265845,0.270989,0.239251,0.131831,0.052953,-0.007436,-0.061823:3
0.775704,0.756717,0.646332,0.543675,0.586259,0.548069,0.415086,0.293702,0.252964,0.224208,0.134882,0.043201:-0.143038,-0.253628,-0.309737,-0.300385,-0.451873,-0.456094,-0.369607,-0.444236,-0.555126,-0.580664,-0.525715,-0.503608:0.078264,0.064425,0.014986,-0.075556,-0.067011,-0.12364,0.011614,0.133577,0.198725,0.242961,0.28691,0.290471:-0.954979,-0.925284,-0.883641,-0.763678,-0.639911,-0.57001,-0.52274,-0.392538,-0.211646,0.056388,0.138024,0.183633:0.171376,0.23452,0.319235,0.401779,0.444967,0.486482,0.5701,0.593988,0.601871,0.590014,0.598847,0.583482:-0.510628,-0.469852,-0.456857,-0.45718,-0.423407,-0.459072,-0.51479,-0.501463,-0.509737,-0.500038,-0.517542,-0.538078:-0.257481,-0.273827,-0.276017,-0.224316,-0.183537,-0.09208,-0.095274,-0.117223,-0.139485,-0.126245,-0.114465,-0.08645:0.313622,0.30813,0.285135,0.176795,0.070304,0.009292,-0.014903,-0.055594,-0.089924,-0.159689,-0.170643,-0.180234:-0.070718,-0.110268,-0.162902,-0.208425,-0.313068,-0.468168,-0.54233,-0.542146,-0.480567,-0.396554,-0.376891,-0.358117:-0.008825,-0.069308,-0.124505,-0.15036,-0.143493,-0.138549,-0.090801,-0.072775,-0.038601,-0.004953,0.008597,0.019443:-0.172068,-0.183767,-0.171829,-0.183512,-0.181962,-0.093498,-0.023406,-0.006883,-0.031646,-0.060896,-0.082821,-0.117638:0.007489,0.043644,0.072135,0.150197,0.21265,0.211625,0.199651,0.121194,0.017734,-0.05395,-0.112804,-0.147487:3
0.811896,0.81917,0.873831,0.966283,0.902975,0.777984,0.781329,0.508785,0.451978,0.462406,0.357606,0.482425,0.518953,0.391981,0.165913,0.059411,0.020618:0.215295,0.164802,-0.0282,-0.109545,-0.347681,-0.467513,-0.615296,-0.666015,-0.644499,-0.677312,-0.712867,-0.773799,-0.932588,-0.883026,-0.795883,-0.757249,-0.702102:0.188569,0.036637,-0.054916,-0.118375,-0.035113,-0.015085,0.013103,0.062738,0.060097,0.048134,0.118388,0.179344,0.309391,0.363244,0.396616,0.409122,0.398109:-0.901567,-0.915217,-0.900796,-0.855208,-0.77746,-0.777134,-0.723359,-0.606204,-0.540561,-0.4604,-0.369133,-0.174278,-0.012405,0.026246,0.061067,0.070758,0.108848:0.099848,0.144059,0.20104,0.200969,0.144792,0.22494,0.283856,0.351072,0.421984,0.524116,0.597034,0.557701,0.494254,0.49393,0.495592,0.508443,0.494242:-0.824489,-0.763209,-0.732072,-0.636763,-0.502201,-0.482323,-0.40224,-0.37769,-0.389092,-0.40288,-0.394191,-0.36804,-0.32122,-0.375171,-0.423989,-0.46003,-0.493866:-0.116871,-0.091694,-0.121666,-0.12296,-0.170662,-0.18375,-0.191539,-0.163407,-0.174068,-0.190132,-0.178053,-0.17535,-0.178716,-0.160556,-0.14768,-0.129561,-0.101792:0.341904,0.315061,0.349342,0.292106,0.291664,0.291006,0.180548,0.049025,0.017699,-0.012037,-0.061979,-0.119873,-0.14241,-0.141304,-0.154968,-0.165862,-0.180163:-0.134535,-0.112776,-0.1056,-0.125104,-0.178576,-0.244933,-0.272838,-0.337331,-0.391935,-0.452257,-0.508994,-0.489463,-0.450718,-0.408895,-0.373777,-0.356559,-0.323258:0.092834,0.052582,-0.023724,-0.0795,-0.152043,-0.186803,-0.242373,-0.221971,-0.206707,-0.158714,-0.107957,-0.089766,-0.066782,-0.04657,-0.031735,-0.013795,-0.01286:-0.099907,-0.144314,-0.189804,-0.17913,-0.114367,-0.101233,-0.092172,-0.125508,-0.103391,-0.046367,0.001401,0.015061,-0.013152,-0.057394,-0.079326,-0.103957,-0.130489:0.070945,0.055194,0.069216,0.098656,0.107337,0.122906,0.210264,0.304742,0.305313,0.214168,0.121636,0.079682,-0.011014,-0.063121,-0.111603,-0.135593,-0.144516:3
0.603369,0.569995,0.538853,0.548024,0.469726,0.459439,0.383787,0.394176,0.380876,0.341915,0.281696,0.253993,0.303442,0.305685,0.215066:-0.222085,-0.233428,-0.218654,-0.285705,-0.299737,-0.280656,-0.190027,-0.179964,-0.187579,-0.228301,-0.270751,-0.263172,-0.326449,-0.430566,-0.46209:0.27674,0.229311,0.189242,0.139926,0.094336,0.014159,0.029291,0.022951,-0.006903,-0.053156,-0.054252,-0.013145,0.03635,0.12425,0.210423:-0.845342,-0.851942,-0.830625,-0.8148,-0.81889,-0.795638,-0.737112,-0.673347,-0.538718,-0.421945,-0.328318,-0.2488,-0.136084,0.022754,0.128446:-0.011397,0.02687,0.064247,0.070616,0.097031,0.143502,0.140222,0.199872,0.290574,0.407684,0.512749,0.569544,0.531531,0.442341,0.382668:-0.612467,-0.626286,-0.617574,-0.571299,-0.52782,-0.499056,-0.455238,-0.44778,-0.476347,-0.45968,-0.433072,-0.457592,-0.468174,-0.414785,-0.394839:-0.093119,-0.058152,-0.038497,-0.038493,-0.029027,-0.028469,-0.004422,-0.037272,-0.065705,-0.0776,-0.101173,-0.093647,-0.082556,-0.077028,-0.052424:0.364123,0.352045,0.326406,0.297146,0.246314,0.170854,0.094738,0.027625,-0.044256,-0.153212,-0.238025,-0.273201,-0.297789,-0.369451,-0.43076:-0.168105,-0.211419,-0.238211,-0.230387,-0.244011,-0.206434,-0.184159,-0.170232,-0.189568,-0.257552,-0.316611,-0.35633,-0.355186,-0.309451,-0.24386:-0.085946,-0.088636,-0.105666,-0.156949,-0.188826,-0.227539,-0.239175,-0.197283,-0.154105,-0.146598,-0.120526,-0.065618,-0.048879,-0.061378,-0.055144:-0.033728,-0.035867,-0.033489,-0.026898,-0.003231,-0.007354,0.00248,0.009629,0.006226,-0.016574,-0.036658,-0.026537,-0.011235,-0.010464,-0.054033:0.108295,0.124476,0.160013,0.203529,0.240005,0.300248,0.351187,0.3584,0.32672,0.288038,0.238668,0.133522,0.038517,0.00799,-0.015446:3
0.758624,0.902088,0.893695,0.716316,0.514858,0.500654,0.488229,0.339478,0.253456,0.212637,0.076006,-0.028496,-0.127736:0.03412,-0.118191,-0.450731,-0.590852,-0.550255,-0.520978,-0.578548,-0.648973,-0.548227,-0.405705,-0.363155,-0.380303,-0.32935:-0.35002,-0.410992,-0.138053,-0.020684,-0.001283,0.05314,0.102077,0.176349,0.195167,0.166865,0.195104,0.226161,0.300795:-0.592338,-0.530423,-0.615576,-0.705876,-0.612611,-0.457517,-0.317875,-0.175865,-0.014864,0.104234,0.131581,0.228652,0.251307:0.01609,0.01662,0.089534,0.268214,0.35449,0.372407,0.400068,0.453815,0.488663,0.477654,0.474906,0.427698,0.40898:-0.528204,-0.442392,-0.397746,-0.452034,-0.47823,-0.48678,-0.440729,-0.393384,-0.37435,-0.396046,-0.439768,-0.432521,-0.435191:-0.150238,-0.180097,-0.191922,-0.18438,-0.16629,-0.169286,-0.172393,-0.16654,-0.124937,-0.05716,-0.037692,-0.011348,-0.016133:0.225011,0.182286,0.190984,0.146489,0.064162,-0.021168,-0.117539,-0.214554,-0.29543,-0.360053,-0.353362,-0.386667,-0.379844:0.055907,0.049841,-0.094829,-0.224244,-0.314634,-0.332932,-0.318982,-0.330993,-0.317912,-0.266129,-0.257516,-0.217277,-0.174652:-0.178091,-0.203421,-0.158717,-0.153842,-0.164348,-0.147311,-0.139361,-0.101092,-0.068925,-0.015421,0.015554,0.005684,-0.007109:-0.091523,-0.098514,-0.119912,-0.106062,-0.042858,0.014337,0.002546,-0.028393,-0.048662,-0.075596,-0.101708,-0.120476,-0.145423:0.027003,0.045541,0.084553,0.191992,0.272986,0.298456,0.248379,0.148797,0.055587,-0.081398,-0.161902,-0.188225,-0.206593:3
0.542148,0.524788,0.591399,0.667175,0.66651,0.599783,0.556503,0.421034,0.25126,0.213241,0.153203,0.067215,-0.048775,-0.161357,-0.235903,-0.296106,-0.376634,-0.408866,-0.431292:0.267419,0.29769,0.197013,0.049158,-0.014165,8.11E-4,-0.013804,-0.015751,-0.033476,-0.150356,-0.156996,-0.159427,-0.156833,-0.138595,-0.182973,-0.221774,-0.221714,-0.226364,-0.234441:0.014399,-0.059927,-0.166696,-0.183497,-0.094361,0.029717,0.126775,0.209393,0.257351,0.289432,0.383892,0.40757,0.504693,0.617019,0.652652,0.698043,0.776269,0.800195,0.799006:-0.725725,-0.730358,-0.724752,-0.718015,-0.714905,-0.693762,-0.666424,-0.58169,-0.417868,-0.250098,-0.203436,-0.117617,-0.100783,-0.052528,0.015734,0.05342,0.058819,0.057453,0.119546:-0.092928,-0.019072,0.070654,0.135533,0.198345,0.282629,0.346885,0.405145,0.458334,0.551056,0.627134,0.646391,0.671857,0.691458,0.706003,0.70649,0.696369,0.676969,0.664439:-0.738532,-0.668897,-0.648491,-0.624825,-0.559822,-0.496391,-0.428554,-0.346561,-0.35416,-0.389826,-0.371798,-0.416956,-0.426102,-0.442012,-0.434882,-0.412728,-0.385961,-0.390485,-0.440925:0.020368,0.003782,0.048037,0.064833,0.059892,0.043604,0.03139,0.020568,0.009138,-5.33E-4,-0.068788,-0.060125,-0.086916,-0.08235,-0.041283,-0.026293,-0.032684,-0.023457,-0.002765:0.262659,0.246606,0.239179,0.257675,0.205301,0.143809,0.080518,-0.006516,-0.087064,-0.181276,-0.236184,-0.250306,-0.238239,-0.227808,-0.204236,-0.180321,-0.161428,-0.153316,-0.126372:-0.035952,-0.080689,-0.150913,-0.239175,-0.335639,-0.414778,-0.479514,-0.489338,-0.473478,-0.489045,-0.474082,-0.46408,-0.432421,-0.388328,-0.358288,-0.329677,-0.311271,-0.30163,-0.29308:-0.066526,-0.055992,-0.113438,-0.153778,-0.163556,-0.17504,-0.163286,-0.168985,-0.169849,-0.07085,0.012894,0.048512,0.081916,0.144911,0.180422,0.180182,0.162883,0.151944,0.125945:0.052232,0.012595,-0.025694,-0.07146,-0.074722,-0.05656,-0.039129,-0.042053,-0.054478,-0.037445,-0.047698,-0.059044,-0.094956,-0.13921,-0.145067,-0.167062,-0.180662,-0.198857,-0.212906:0.028715,0.011592,0.049755,0.111922,0.161931,0.207534,0.211996,0.176034,0.144561,0.080547,-0.018307,-0.077015,-0.132369,-0.198634,-0.232427,-0.251966,-0.255839,-0.25622,-0.247606:3
0.904404,0.832254,0.841019,0.708313,0.648861,0.550236,0.414062,0.357065,0.296444,0.220878,0.114424:-0.547015,-0.538375,-0.591303,-0.600777,-0.60882,-0.616241,-0.621772,-0.707761,-0.768978,-0.758638,-0.726143:0.303791,0.26187,0.255549,0.172566,0.126242,0.127687,0.161816,0.288972,0.364617,0.401479,0.441889:-0.769126,-0.72586,-0.6858,-0.516694,-0.440829,-0.349721,-0.26802,-0.108351,0.022091,0.172748,0.25564:-0.089779,-0.029337,0.035422,0.05169,0.087695,0.156457,0.251078,0.291753,0.308202,0.315675,0.366476:-0.429958,-0.402012,-0.358781,-0.331376,-0.328447,-0.344897,-0.363414,-0.338163,-0.31899,-0.319249,-0.337517:-0.052761,-0.03754,-0.047954,-0.017054,0.023041,0.040721,0.016485,-0.023582,-0.031896,-0.009191,0.012546:0.355618,0.313197,0.257612,0.150549,0.009895,-0.125463,-0.187271,-0.233502,-0.232982,-0.245014,-0.30681:-0.266684,-0.31298,-0.3766,-0.379891,-0.343676,-0.36042,-0.455223,-0.473641,-0.454322,-0.390661,-0.341563:-0.201789,-0.228944,-0.251872,-0.30238,-0.29693,-0.198211,-0.066248,-0.00185,0.014207,0.016617,0.057705:-0.037376,-0.037158,-0.006061,0.004315,-0.002818,-0.008308,0.043017,0.041784,0.014289,-0.032164,-0.090008:0.058503,0.093843,0.128492,0.19239,0.26985,0.286022,0.185446,0.12398,0.022594,-0.07781,-0.126201:3
0.636909,0.706112,0.685389,0.666031,0.5375,0.50288,0.510668,0.606459,0.504521,0.533978,0.472062,0.281754,0.1312:0.124506,-0.001377,-0.064652,-0.115462,-0.192805,-0.158121,-0.151634,-0.342764,-0.417156,-0.484939,-0.55787,-0.451994,-0.312184:0.166842,0.125576,0.09526,0.058152,0.053723,0.084429,0.086598,0.046148,0.062857,0.163487,0.245819,0.232302,0.230707:-0.892269,-0.89178,-0.916489,-0.857419,-0.737015,-0.681155,-0.593406,-0.460531,-0.337628,-0.249152,-0.14128,-0.07715,-0.020924:0.139531,0.210046,0.251936,0.254427,0.271352,0.3824,0.523915,0.542131,0.542171,0.545484,0.551753,0.619373,0.68379:-0.775946,-0.719021,-0.641224,-0.587,-0.523203,-0.52026,-0.529994,-0.429153,-0.343848,-0.323212,-0.345313,-0.427348,-0.515568:-0.099227,-0.116812,-0.089913,-0.082423,-0.099459,-0.113881,-0.127327,-0.142156,-0.118809,-0.094743,-0.095901,-0.076226,-0.054191:0.337095,0.366265,0.351239,0.280216,0.185679,0.154084,0.088231,-0.021717,-0.133663,-0.167776,-0.187226,-0.20359,-0.218067:-0.164165,-0.191225,-0.264541,-0.282257,-0.283299,-0.345448,-0.420685,-0.429495,-0.443728,-0.461401,-0.442189,-0.440668,-0.407696:0.052778,-0.026543,-0.084177,-0.136631,-0.19781,-0.202459,-0.158505,-0.184493,-0.159343,-0.106136,-0.04116,0.002113,0.048453:-0.126416,-0.160082,-0.170462,-0.155986,-0.143014,-0.147695,-0.118358,-0.095923,-0.068352,-0.064123,-0.063818,-0.067665,-0.103774:0.052365,0.054856,0.05154,0.078231,0.152327,0.20902,0.212184,0.202726,0.164636,0.103507,-0.007875,-0.066019,-0.097751:3
0.178844,0.176643,0.139312,0.138072,0.146419,0.174523,0.17235,0.108371,-3.45E-4,-0.097823:-0.288337,-0.337196,-0.361659,-0.40001,-0.413674,-0.428144,-0.453632,-0.496727,-0.547687,-0.590104:0.024375,0.013127,0.010007,-0.008701,-0.024348,-0.001106,0.006652,0.018451,0.12104,0.24534:-0.756008,-0.709732,-0.65082,-0.598873,-0.512984,-0.411548,-0.281107,-0.168158,-0.066279,0.010729:0.051871,0.087818,0.117672,0.171997,0.223991,0.280185,0.299914,0.36665,0.421051,0.461368:-0.652581,-0.611052,-0.567322,-0.524759,-0.486294,-0.450804,-0.414743,-0.414565,-0.422813,-0.427773:-0.024363,-0.034896,-0.039054,-0.055458,-0.090236,-0.117263,-0.048413,0.001545,-0.011912,-0.040467:0.28919,0.264649,0.210059,0.148058,0.053185,-0.065071,-0.174039,-0.219129,-0.252638,-0.252267:-0.138734,-0.169983,-0.199097,-0.247781,-0.265462,-0.254809,-0.271132,-0.384998,-0.416899,-0.401472:-0.144559,-0.196324,-0.25213,-0.296668,-0.313463,-0.29122,-0.222457,-0.144088,-0.089685,-0.042893:-0.061147,-0.053531,-0.030797,0.005677,0.064959,0.103448,0.0541,0.020876,0.022482,-0.018592:0.110538,0.126892,0.160637,0.210481,0.262912,0.327703,0.343444,0.197311,0.086741,-0.015187:3
-0.050141,0.058364,0.060896,0.098231,0.093132,0.039392,-0.075655,-0.113839,-0.057902,-0.097887,-0.118965,4.71E-4,0.003499,-0.09122,-0.225122:-0.07764,-0.130567,-0.138777,0.098039,0.246048,0.245791,0.204024,0.092981,0.092393,0.119658,0.071612,-0.068064,-0.09493,-0.085115,-0.06516:-0.153971,-0.104699,-0.121032,-0.128754,-0.14726,-0.229803,-0.199644,-0.155614,-0.109512,0.008912,0.081453,0.085186,0.078506,0.133759,0.160369:-0.46636,-0.411991,-0.382846,-0.367069,-0.288039,-0.177259,-0.09469,-0.084584,-0.003527,0.075368,0.117685,0.144816,0.149302,0.158513,0.220382:-0.151513,-0.123404,-0.062438,-0.006393,0.061399,0.238,0.369096,0.399264,0.406654,0.499381,0.506331,0.443961,0.4205,0.514109,0.579089:-0.541829,-0.459041,-0.419168,-0.402039,-0.399666,-0.433352,-0.421401,-0.408337,-0.427476,-0.425666,-0.395523,-0.379912,-0.354272,-0.417693,-0.496275:0.086712,0.071504,0.092675,0.098539,0.138101,0.132163,0.096214,0.110709,0.137446,0.078974,0.010961,-0.016629,-0.022617,-0.056762,-0.047977:0.12718,0.034329,3.81E-4,-0.016641,-0.08862,-0.199957,-0.290318,-0.319172,-0.35031,-0.374963,-0.395058,-0.371859,-0.370735,-0.331328,-0.316049:-0.053504,-0.103938,-0.154593,-0.198848,-0.271932,-0.322323,-0.352618,-0.386938,-0.414662,-0.352519,-0.283976,-0.268208,-0.247367,-0.221269,-0.19844:-0.417819,-0.411839,-0.489935,-0.496239,-0.444864,-0.367452,-0.290906,-0.257305,-0.208989,-0.135786,-0.101645,-0.109034,-0.10975,-0.102163,-0.075504:0.087089,0.102676,0.101109,0.109357,0.150786,0.136983,0.14237,0.137775,0.174227,0.124801,0.094105,0.097838,0.073086,0.005765,-0.045513:0.032021,0.06042,0.077625,0.086267,0.103988,0.129666,0.099177,0.03592,-0.010968,-0.045137,-0.124271,-0.185144,-0.229491,-0.219622,-0.232523:3
1.249295,1.179345,0.955956,0.919834,0.935967,1.206042,1.04848,1.098444,1.113015,0.997412,0.802481,0.679091,0.539369,0.386432,0.261094,0.203949,0.143598,0.098281,0.065355,-0.004991,-0.078153:-0.826702,-1.000126,-0.820447,-0.792808,-0.847713,-0.968944,-0.825389,-0.917811,-1.029688,-0.999755,-0.85951,-0.812715,-0.803626,-0.814636,-0.819653,-0.828701,-0.816461,-0.845004,-0.853742,-0.796132,-0.779204:0.248125,0.376428,0.213084,0.094948,0.111301,0.189241,0.06279,0.183095,0.344515,0.353622,0.28648,0.308733,0.361109,0.373283,0.395863,0.43945,0.471927,0.516033,0.571792,0.608617,0.647766:-0.628095,-0.665439,-0.586273,-0.541819,-0.528436,-0.536712,-0.449172,-0.504847,-0.552297,-0.518625,-0.463812,-0.403782,-0.350081,-0.322317,-0.31391,-0.29915,-0.258473,-0.195799,-0.167419,-0.161152,-0.151124:-0.432325,-0.428287,-0.403933,-0.347483,-0.336155,-0.299628,-0.266953,-0.160062,-0.042251,5.8E-4,0.06881,0.101027,0.105687,0.128469,0.155278,0.175522,0.206798,0.237958,0.249299,0.269218,0.303799:-0.223031,-0.158255,-0.177661,-0.184594,-0.114715,-0.037379,-0.019562,-0.004529,0.040513,0.063019,0.027901,0.033002,0.043422,0.020997,0.02761,0.056315,0.064619,0.090459,0.114543,0.093572,0.050419:-0.265178,-0.295691,-0.259493,-0.212082,-0.222951,-0.27399,-0.248978,-0.276576,-0.355393,-0.358044,-0.320034,-0.325008,-0.340763,-0.321236,-0.330447,-0.359527,-0.309686,-0.281626,-0.308816,-0.308944,-0.294917:0.163395,0.154479,0.128398,0.085932,0.050201,0.024686,-0.019119,-0.031499,-0.043697,-0.088409,-0.147347,-0.193907,-0.235884,-0.270951,-0.316727,-0.319041,-0.349988,-0.37315,-0.387568,-0.425929,-0.443371:0.238961,0.210734,0.200159,0.153618,0.104134,0.10814,0.065036,-0.0036,-0.098042,-0.144808,-0.174707,-0.19243,-0.213587,-0.238126,-0.234019,-0.229913,-0.218617,-0.206463,-0.197774,-0.186871,-0.181559:-0.13398,-0.174068,-0.193395,-0.223762,-0.24923,-0.269916,-0.295913,-0.329912,-0.363203,-0.365437,-0.33601,-0.315164,-0.297732,-0.284437,-0.249236,-0.227131,-0.203925,-0.198171,-0.180321,-0.138475,-0.102026:-0.116953,-0.133499,-0.145624,-0.145553,-0.131591,-0.143443,-0.141961,-0.121017,-0.059881,-0.015227,-0.008116,0.013418,0.041699,0.053082,0.057975,0.069339,0.04586,0.010031,-0.001766,-0.016496,-0.044341:0.084122,0.087399,0.140636,0.18927,0.20951,0.214148,0.23346,0.239321,0.268709,0.29377,0.310312,0.282398,0.245789,0.23385,0.20837,0.173763,0.138618,0.084441,0.033211,0.005706,-0.011856:4
0.970149,1.082127,0.921065,0.883377,0.815359,0.815754,0.862021,0.955805,0.947888,0.803204,0.688232,0.637708,0.647095,0.6078,0.476895,0.358467,0.276752,0.263322:-0.381591,-0.552859,-0.426369,-0.487833,-0.552716,-0.6114,-0.707973,-0.826742,-0.92816,-0.965462,-0.950378,-0.939481,-0.975236,-0.977803,-0.961037,-0.964571,-0.955284,-0.953628:0.328763,0.392097,0.242345,0.187752,0.172676,0.174501,0.174207,0.134695,0.142457,0.171921,0.183258,0.244788,0.330382,0.393625,0.429137,0.4549,0.493915,0.524208:-0.606231,-0.652773,-0.568487,-0.592438,-0.587331,-0.586864,-0.583111,-0.552019,-0.501616,-0.482797,-0.419635,-0.328361,-0.3015,-0.293173,-0.251743,-0.208299,-0.180155,-0.174049:-0.528747,-0.49072,-0.466769,-0.388691,-0.353747,-0.281438,-0.189527,-0.108445,-0.06377,0.020966,0.088016,0.126979,0.124196,0.1206,0.131251,0.149682,0.167597,0.19086:-0.414908,-0.347348,-0.326293,-0.326446,-0.265429,-0.226066,-0.206076,-0.170826,-0.105668,-0.097854,-0.122587,-0.091358,-0.055639,-0.065911,-0.052968,-0.0388,-0.0308,-0.017729:-0.136522,-0.186868,-0.161501,-0.109866,-0.122181,-0.139825,-0.142779,-0.146908,-0.177687,-0.184173,-0.139963,-0.146616,-0.160525,-0.128733,-0.122452,-0.126633,-0.145012,-0.15186:0.027313,0.108018,0.083337,0.043589,0.044986,0.047674,0.025779,-0.021194,-0.057013,-0.100827,-0.167095,-0.207936,-0.2373,-0.292999,-0.363213,-0.418265,-0.425025,-0.41207:0.210455,0.168129,0.206131,0.186876,0.157837,0.112253,0.049223,-0.02232,-0.09086,-0.153758,-0.18447,-0.19888,-0.2442,-0.286094,-0.284492,-0.282065,-0.282273,-0.273488:-0.135908,-0.170131,-0.242858,-0.270976,-0.305848,-0.337241,-0.348725,-0.373871,-0.403764,-0.389558,-0.367552,-0.349512,-0.307257,-0.247728,-0.216996,-0.184398,-0.161574,-0.134761:-0.059757,-0.084733,-0.114211,-0.155988,-0.170224,-0.181365,-0.185524,-0.172423,-0.134191,-0.122517,-0.118028,-0.083269,-0.048427,-0.034732,-0.025716,-0.013428,0.004102,0.007527:0.220222,0.205304,0.215604,0.247725,0.240935,0.247,0.276806,0.328417,0.35092,0.367654,0.397431,0.362761,0.302503,0.273201,0.234004,0.206992,0.189515,0.167334:4
0.606796,0.665848,0.627813,0.572351,0.564513,0.591159,0.562459,0.528272,0.488615,0.485418,0.518752,0.545801,0.544987,0.488708,0.403045,0.3598,0.305535,0.284815,0.252713,0.229972,0.20964,0.149903,0.066792:-0.021949,-0.083322,-0.114907,-0.115088,-0.087492,-0.142172,-0.188867,-0.247113,-0.297662,-0.361114,-0.440442,-0.521317,-0.592157,-0.626545,-0.618545,-0.617888,-0.597479,-0.626508,-0.652158,-0.675728,-0.708146,-0.727656,-0.736954:0.089904,0.083932,0.053302,-0.002577,-0.076001,-0.099871,-0.108745,-0.080182,-0.057743,-0.041471,-0.021883,-0.001203,0.032407,0.096353,0.146481,0.198358,0.238656,0.293396,0.358763,0.433261,0.499275,0.548639,0.626083:-0.781485,-0.797516,-0.762124,-0.709991,-0.671616,-0.664942,-0.627033,-0.598211,-0.552002,-0.505065,-0.467022,-0.420162,-0.362164,-0.297043,-0.217718,-0.200547,-0.153775,-0.118488,-0.123464,-0.149603,-0.159617,-0.133894,-0.115322:0.050177,0.088125,0.111505,0.117584,0.117965,0.155698,0.173985,0.202625,0.20866,0.200785,0.196478,0.190341,0.20642,0.231826,0.249237,0.256061,0.263927,0.277062,0.28288,0.297623,0.298436,0.295261,0.302967:-0.562018,-0.518016,-0.482243,-0.442648,-0.411768,-0.395192,-0.376745,-0.363439,-0.343044,-0.318388,-0.282717,-0.24016,-0.207599,-0.176643,-0.150071,-0.131248,-0.126537,-0.134319,-0.129021,-0.121238,-0.108552,-0.092892,-0.04726:-0.273558,-0.280235,-0.275785,-0.26292,-0.21972,-0.201693,-0.187279,-0.173556,-0.14148,-0.108018,-0.094986,-0.093579,-0.100506,-0.130845,-0.155757,-0.139177,-0.139438,-0.138936,-0.156716,-0.172145,-0.177941,-0.180811,-0.185935:0.199821,0.171341,0.150754,0.118115,0.075297,0.062764,0.050502,0.043811,-0.001645,-0.063407,-0.114018,-0.1676,-0.218403,-0.253849,-0.299636,-0.359079,-0.374147,-0.381325,-0.369275,-0.365627,-0.372651,-0.370932,-0.356676:0.132953,0.141583,0.147638,0.149199,0.142714,0.10149,0.059568,0.012266,-0.015254,-0.033741,-0.05773,-0.07993,-0.104694,-0.12128,-0.134473,-0.1507,-0.173308,-0.203302,-0.243528,-0.275724,-0.283851,-0.262374,-0.245508:-0.039853,-0.054892,-0.087467,-0.121873,-0.1509,-0.170168,-0.198725,-0.222378,-0.248811,-0.269364,-0.290536,-0.301435,-0.290396,-0.289108,-0.290831,-0.273413,-0.288314,-0.293591,-0.257924,-0.203342,-0.149443,-0.110065,-0.055192:-0.161803,-0.176441,-0.193559,-0.203323,-0.207181,-0.201863,-0.181408,-0.177169,-0.188237,-0.200158,-0.198662,-0.183214,-0.172057,-0.143023,-0.093279,-0.068479,-0.03611,-0.030331,-0.031709,-0.034334,-0.040062,-0.044628,-0.042318:0.062492,0.066682,0.085014,0.112977,0.127298,0.135713,0.163023,0.211076,0.277538,0.324231,0.341017,0.34273,0.33857,0.341422,0.333708,0.326992,0.315934,0.317136,0.284106,0.24585,0.201573,0.147191,0.065588:4
0.550025,0.56324,0.52547,0.507601,0.500812,0.44184,0.38435,0.3177,0.287305,0.256351,0.234726,0.199166,0.17058,0.164448,0.14322,0.101377,0.070015,0.051674,0.057521,0.080361,0.086334,0.04598,0.00696:-0.250069,-0.281507,-0.302257,-0.364552,-0.430778,-0.455256,-0.509879,-0.577913,-0.663949,-0.683087,-0.707085,-0.751893,-0.796918,-0.80081,-0.785419,-0.779178,-0.796212,-0.807069,-0.852591,-0.912184,-0.948831,-0.953787,-0.954827:0.265131,0.210903,0.146153,0.093732,0.062693,0.04274,0.06347,0.101576,0.168907,0.217797,0.2457,0.270726,0.305423,0.387528,0.455053,0.47049,0.477121,0.495161,0.573024,0.664483,0.71777,0.757896,0.782512:-0.905631,-0.873787,-0.828631,-0.789605,-0.752283,-0.670546,-0.591025,-0.538507,-0.483932,-0.398794,-0.330571,-0.271797,-0.274259,-0.350702,-0.306491,-0.231803,-0.17019,-0.143969,-0.16478,-0.173121,-0.164639,-0.119943,-0.090705:0.030278,0.085144,0.133005,0.172368,0.211527,0.234155,0.249995,0.263229,0.285006,0.316935,0.34083,0.34558,0.346466,0.305237,0.265143,0.25762,0.280206,0.309371,0.31377,0.324429,0.353627,0.379721,0.400321:-0.551431,-0.534631,-0.482828,-0.446529,-0.419878,-0.381855,-0.328606,-0.2922,-0.248696,-0.200372,-0.152849,-0.128443,-0.092631,-0.026321,-0.055805,-0.096535,-0.122226,-0.102967,-0.063064,-0.070432,-0.086179,-0.103813,-0.095478:-0.289565,-0.261449,-0.218014,-0.189782,-0.177551,-0.15317,-0.141037,-0.1432,-0.167822,-0.176936,-0.180933,-0.206304,-0.20926,-0.165638,-0.147488,-0.172842,-0.213436,-0.240059,-0.237003,-0.212108,-0.195326,-0.193872,-0.189491:0.344699,0.316311,0.257119,0.217714,0.172319,0.085113,0.007553,-0.045444,-0.094579,-0.148719,-0.185279,-0.232447,-0.294461,-0.374682,-0.376054,-0.328432,-0.283366,-0.280105,-0.283187,-0.268645,-0.251682,-0.237098,-0.23726:-0.024081,-0.040281,-0.070063,-0.101475,-0.145226,-0.1929,-0.243571,-0.261932,-0.271852,-0.279179,-0.283056,-0.259567,-0.261209,-0.31013,-0.318914,-0.282576,-0.220236,-0.190467,-0.221716,-0.269706,-0.303751,-0.296419,-0.284985:-0.122572,-0.15794,-0.212859,-0.264715,-0.2776,-0.276819,-0.288194,-0.288907,-0.279787,-0.284437,-0.309187,-0.319479,-0.26961,-0.186191,-0.18345,-0.21689,-0.222811,-0.185825,-0.130142,-0.073451,-0.033685,-0.017209,-0.019008:-0.106563,-0.13584,-0.156956,-0.188483,-0.195659,-0.176629,-0.16644,-0.171132,-0.14652,-0.102629,-0.067639,-0.068332,-0.084213,-0.045728,-0.009784,-0.011112,-0.043295,-0.061878,-0.062893,-0.062936,-0.066918,-0.080609,-0.091695:0.014502,0.052987,0.107749,0.139838,0.165203,0.225545,0.303798,0.349387,0.358582,0.338315,0.303157,0.295756,0.25404,0.181607,0.184673,0.193383,0.179014,0.141531,0.08121,0.035538,-5.77E-4,-0.036734,-0.052403:4
0.726697,0.750053,0.754311,0.704445,0.738686,0.68258,0.657987,0.604455,0.548527,0.479004,0.403713,0.366344,0.318214,0.280427,0.237125,0.208677,0.20583,0.141409,0.055592,0.038212,-0.016858:-0.366465,-0.377117,-0.428167,-0.502104,-0.603761,-0.623726,-0.693982,-0.756895,-0.799739,-0.821617,-0.840159,-0.892354,-0.893718,-0.870312,-0.87317,-0.906988,-0.954224,-0.95441,-0.922053,-0.936663,-0.947048:0.283572,0.212593,0.182876,0.173761,0.180353,0.140738,0.15336,0.166175,0.181022,0.205252,0.239841,0.28114,0.296992,0.319415,0.360337,0.420005,0.487497,0.531303,0.603675,0.688026,0.728645:-0.75139,-0.766707,-0.762611,-0.753265,-0.781398,-0.757023,-0.739974,-0.684799,-0.584933,-0.512387,-0.447924,-0.387975,-0.351414,-0.321632,-0.310409,-0.295607,-0.27769,-0.213715,-0.169963,-0.153059,-0.124034:-0.169149,-0.104403,-0.084044,-0.067867,-0.004391,0.048125,0.097427,0.144517,0.190945,0.250177,0.315299,0.351763,0.364568,0.367805,0.384637,0.403784,0.39201,0.375285,0.396466,0.423147,0.447116:-0.494655,-0.504364,-0.451442,-0.362866,-0.294811,-0.25328,-0.2256,-0.204475,-0.164558,-0.143844,-0.144106,-0.132076,-0.151591,-0.17511,-0.173182,-0.153317,-0.128621,-0.151986,-0.159397,-0.127184,-0.104696:-0.309603,-0.277849,-0.274303,-0.288142,-0.300416,-0.292791,-0.29936,-0.300671,-0.318614,-0.318979,-0.30472,-0.31575,-0.31483,-0.314603,-0.350123,-0.391737,-0.407677,-0.366489,-0.335097,-0.318934,-0.284543:0.248352,0.235606,0.230485,0.219716,0.198696,0.159944,0.145143,0.103634,0.043468,-0.004774,-0.047317,-0.079096,-0.12171,-0.164088,-0.182058,-0.201195,-0.206047,-0.212454,-0.178048,-0.139485,-0.142618:0.145008,0.150157,0.134423,0.093713,0.025846,-0.010612,-0.062096,-0.108818,-0.139356,-0.172425,-0.202422,-0.22633,-0.22631,-0.224365,-0.224088,-0.231418,-0.240208,-0.218239,-0.212084,-0.219145,-0.210541:-0.188817,-0.197819,-0.222607,-0.256124,-0.274919,-0.304326,-0.321465,-0.335476,-0.364533,-0.37666,-0.376235,-0.377702,-0.350502,-0.309422,-0.271723,-0.222076,-0.187776,-0.163479,-0.15252,-0.139019,-0.131069:-0.060941,-0.113861,-0.125048,-0.115435,-0.116772,-0.119644,-0.112665,-0.089225,-0.058882,-0.049581,-0.061262,-0.062563,-0.065065,-0.059053,-0.044644,-0.026575,-0.006749,-0.01668,-0.025501,-0.03472,-0.067447:0.142675,0.158998,0.151194,0.125521,0.129099,0.158357,0.17959,0.221594,0.272788,0.297296,0.300323,0.276488,0.25277,0.23641,0.196986,0.145444,0.097051,0.06581,0.034938,-0.011801,-0.046254:4
1.043366,0.977336,0.958083,0.891564,0.784918,0.65121,0.520547,0.437697,0.477344,0.530797,0.490219,0.398073,0.298968,0.213072,0.146799,0.121418,0.114251,0.135705,0.120215,0.102381,0.049517:-0.823232,-0.785242,-0.769611,-0.744989,-0.708866,-0.62991,-0.58192,-0.58824,-0.644018,-0.696964,-0.701258,-0.686266,-0.653758,-0.629134,-0.609004,-0.621189,-0.667795,-0.646906,-0.586096,-0.53471,-0.523609:0.768786,0.706898,0.669825,0.607243,0.53509,0.431495,0.346604,0.309277,0.279136,0.299439,0.339815,0.4022,0.44541,0.506665,0.555329,0.617883,0.675209,0.689202,0.703042,0.714563,0.746564:-0.645892,-0.667793,-0.685728,-0.670871,-0.643897,-0.589773,-0.508626,-0.449005,-0.418386,-0.38517,-0.333541,-0.274654,-0.245094,-0.196435,-0.156565,-0.140953,-0.118262,-0.092271,-0.050809,-0.028519,-0.028099:-0.549469,-0.495126,-0.431832,-0.346375,-0.244093,-0.108466,0.041228,0.166032,0.203215,0.182466,0.191083,0.220075,0.240713,0.249214,0.282847,0.31789,0.340832,0.324077,0.30709,0.313154,0.329411:-0.271415,-0.244841,-0.21586,-0.187563,-0.145512,-0.165283,-0.181112,-0.174224,-0.172442,-0.147708,-0.167271,-0.159895,-0.113766,-0.055969,-0.019961,-8.34E-4,0.017545,0.043831,0.065403,0.046815,0.019407:-0.475487,-0.478199,-0.48642,-0.455153,-0.387732,-0.302271,-0.224646,-0.168649,-0.155954,-0.196285,-0.200893,-0.219342,-0.199778,-0.161246,-0.131402,-0.097185,-0.099673,-0.096893,-0.126614,-0.130564,-0.133166:0.168219,0.176256,0.192891,0.205987,0.190126,0.128537,0.039526,-0.053118,-0.116981,-0.148421,-0.207516,-0.272364,-0.320754,-0.33335,-0.33306,-0.345674,-0.358957,-0.399782,-0.406115,-0.404454,-0.405616:0.237722,0.243792,0.230607,0.180874,0.08596,-0.031536,-0.135333,-0.223288,-0.254446,-0.255677,-0.257771,-0.267785,-0.284607,-0.290967,-0.285918,-0.285182,-0.288191,-0.286615,-0.28434,-0.281608,-0.249592:-0.200655,-0.220769,-0.25487,-0.305113,-0.360786,-0.373197,-0.389203,-0.416529,-0.424305,-0.406313,-0.351386,-0.286986,-0.243058,-0.219251,-0.213733,-0.186008,-0.147972,-0.129786,-0.132566,-0.118219,-0.092548:0.069428,0.023062,-0.007312,-0.037287,-0.056587,-0.044757,-0.018241,-0.019865,-0.02612,-0.004549,0.021024,0.077211,0.121561,0.129854,0.102701,0.060858,0.034738,0.04717,0.079832,0.075662,0.035127:0.198061,0.170607,0.147399,0.137756,0.148932,0.189146,0.244275,0.312522,0.357938,0.352155,0.327559,0.289355,0.24379,0.197787,0.147723,0.082397,0.009379,-0.03806,-0.08312,-0.10092,-0.107785:4
0.40144,0.441855,0.459728,0.444296,0.383602,0.302615,0.266431,0.201414,0.102743,0.064246,0.046507,0.00557,-0.074394,-0.147497,-0.192194,-0.181325,-0.134346,-0.108969,-0.117339,-0.134713,-0.141573,-0.148003,-0.167449:-0.208446,-0.285241,-0.367399,-0.426015,-0.471156,-0.508905,-0.596225,-0.657714,-0.672062,-0.689088,-0.690003,-0.680687,-0.652053,-0.635072,-0.637882,-0.66192,-0.712955,-0.745498,-0.744799,-0.722291,-0.713889,-0.725749,-0.740202:0.082381,0.016056,-0.019547,-0.022764,-0.004176,0.01994,0.091148,0.189951,0.243884,0.257727,0.263817,0.290106,0.334771,0.382019,0.41095,0.426878,0.442533,0.447755,0.454818,0.475428,0.497604,0.516476,0.528678:-0.849228,-0.870546,-0.831436,-0.742339,-0.649289,-0.581697,-0.519409,-0.472305,-0.43246,-0.415121,-0.392703,-0.36564,-0.336781,-0.302881,-0.24718,-0.212684,-0.18183,-0.146869,-0.122223,-0.109072,-0.089836,-0.066096,-0.036744:-0.044314,0.01512,0.053102,0.091093,0.128911,0.188564,0.256306,0.297037,0.329718,0.352604,0.373582,0.375179,0.358657,0.357963,0.389432,0.411718,0.42096,0.425664,0.433278,0.444172,0.463403,0.481808,0.498652:-0.575251,-0.555459,-0.511868,-0.441437,-0.365155,-0.321531,-0.28822,-0.264992,-0.265887,-0.25642,-0.260644,-0.275094,-0.290824,-0.292772,-0.272773,-0.245478,-0.217653,-0.204457,-0.20168,-0.207778,-0.206666,-0.199436,-0.188894:-0.089211,-0.061139,-0.052296,-0.051595,-0.065694,-0.082504,-0.111925,-0.168097,-0.181343,-0.194454,-0.206694,-0.207002,-0.210665,-0.214405,-0.224452,-0.218859,-0.213391,-0.206536,-0.19773,-0.200804,-0.209225,-0.211235,-0.204863:0.285791,0.276737,0.252319,0.171166,0.072276,0.015211,-0.025385,-0.05575,-0.124195,-0.174271,-0.193034,-0.181085,-0.158118,-0.152085,-0.175125,-0.20295,-0.22547,-0.232415,-0.227148,-0.210148,-0.202474,-0.202407,-0.200182:0.056958,-0.001041,-0.035781,-0.056529,-0.074217,-0.125382,-0.2378,-0.315751,-0.331447,-0.333308,-0.32752,-0.3187,-0.276595,-0.234543,-0.21627,-0.198002,-0.187907,-0.183191,-0.184809,-0.197298,-0.203726,-0.203018,-0.200566:-0.133434,-0.156284,-0.192,-0.266293,-0.373861,-0.440591,-0.457923,-0.403553,-0.355318,-0.318278,-0.305777,-0.311037,-0.30844,-0.286363,-0.251846,-0.230387,-0.223317,-0.228801,-0.238221,-0.242184,-0.233054,-0.225787,-0.22785:-0.13932,-0.126901,-0.136728,-0.150281,-0.119212,-0.059774,0.018574,0.073759,0.08019,0.095905,0.104758,0.093417,0.054668,0.021789,0.024433,0.020092,0.019786,0.022049,0.022898,0.025657,0.02399,0.020098,0.012221:0.185728,0.144294,0.149101,0.211309,0.31632,0.352176,0.330014,0.283493,0.260117,0.232972,0.220874,0.215517,0.182496,0.139346,0.111006,0.09913,0.090954,0.078932,0.061886,0.038035,0.011442,-0.0114,-0.032301:4
0.909682,0.949401,0.956582,0.988149,0.917249,0.845189,0.760064,0.74846,0.768235,0.697218,0.610209,0.567795,0.491495,0.416518,0.38402,0.386508,0.322216,0.206697,0.097131,0.044297,0.03256:-0.303354,-0.314815,-0.338238,-0.38836,-0.3852,-0.42595,-0.5085,-0.596502,-0.660721,-0.701224,-0.696037,-0.751126,-0.843344,-0.906022,-0.951383,-0.99109,-0.996684,-0.985835,-0.987771,-0.998937,-1.016907:0.24826,0.178906,0.109567,0.01944,-0.055384,-0.08978,-0.103279,-0.109953,-0.079057,0.01189,0.017025,0.127555,0.233284,0.316617,0.356119,0.369125,0.412399,0.474712,0.52116,0.555197,0.579142:-0.612561,-0.650738,-0.70283,-0.760032,-0.765705,-0.756812,-0.708251,-0.645572,-0.559782,-0.501048,-0.44696,-0.400249,-0.326726,-0.239613,-0.175559,-0.124935,-0.08611,-0.055537,-0.028306,-0.004304,0.011939:-0.190048,-0.163452,-0.101203,-0.010014,0.049213,0.125272,0.206187,0.254915,0.310231,0.426472,0.525158,0.553298,0.522385,0.467858,0.437906,0.430558,0.464071,0.510319,0.550164,0.57765,0.58224:-0.625519,-0.5831,-0.525361,-0.488187,-0.445193,-0.371709,-0.298691,-0.248373,-0.199554,-0.164523,-0.179954,-0.150205,-0.119101,-0.149457,-0.169534,-0.172797,-0.181565,-0.181189,-0.164811,-0.14145,-0.118439:-0.282008,-0.304087,-0.320107,-0.284331,-0.259057,-0.247509,-0.24925,-0.23992,-0.224924,-0.245855,-0.262495,-0.333165,-0.332287,-0.2841,-0.271878,-0.262646,-0.280885,-0.309847,-0.306534,-0.295968,-0.28987:0.110109,0.098945,0.13954,0.145762,0.108447,0.084138,0.048411,0.008789,-0.062717,-0.083824,-0.094155,-0.15381,-0.210388,-0.217433,-0.20592,-0.212449,-0.211987,-0.186642,-0.166195,-0.154359,-0.163585:0.142346,0.174816,0.167957,0.15875,0.158833,0.090666,-0.004344,-0.069373,-0.134869,-0.249873,-0.317485,-0.300794,-0.304456,-0.322565,-0.283093,-0.219992,-0.194998,-0.198663,-0.209364,-0.22236,-0.231007:-0.068602,-0.062187,-0.057467,-0.07333,-0.119558,-0.188179,-0.259005,-0.299776,-0.317756,-0.298213,-0.256315,-0.216523,-0.194829,-0.202591,-0.217599,-0.21626,-0.178687,-0.138567,-0.111624,-0.091312,-0.075463:-0.065465,-0.087533,-0.126577,-0.190738,-0.221479,-0.225428,-0.226555,-0.222713,-0.19585,-0.171948,-0.148455,-0.118534,-0.09484,-0.051215,-0.055205,-0.078414,-0.08301,-0.079406,-0.077699,-0.072604,-0.07494:0.191012,0.155802,0.078132,0.054692,0.042252,0.051035,0.092306,0.126855,0.204986,0.217571,0.153063,0.148323,0.151662,0.17173,0.178156,0.168896,0.132499,0.075196,0.018853,-0.029333,-0.062905:4
1.140397,1.097022,1.03986,0.92131,0.914884,0.844523,0.761959,0.700707,0.665892,0.667414,0.641937,0.600763,0.562865,0.474365,0.434956,0.319153,0.241772,0.201867,0.150091,0.110138,0.102357,0.115988,0.085938,0.016706:-0.53651,-0.500817,-0.479642,-0.408784,-0.448556,-0.458962,-0.46977,-0.525197,-0.590688,-0.656099,-0.707434,-0.735083,-0.76323,-0.764518,-0.804686,-0.787816,-0.801904,-0.834455,-0.859151,-0.872369,-0.872662,-0.900662,-0.903005,-0.87722:0.350962,0.297504,0.262758,0.204965,0.194279,0.176355,0.15774,0.150625,0.147601,0.138003,0.149792,0.202483,0.282146,0.327463,0.384089,0.404124,0.424789,0.442423,0.472075,0.504128,0.530732,0.579766,0.624493,0.631859:-0.771004,-0.757636,-0.76686,-0.767781,-0.80549,-0.7955,-0.771181,-0.734528,-0.700289,-0.663782,-0.620663,-0.56085,-0.490098,-0.432511,-0.428333,-0.379237,-0.327501,-0.294981,-0.269816,-0.246347,-0.233425,-0.231916,-0.198376,-0.142249:-0.208347,-0.181378,-0.135661,-0.091391,-0.020005,0.013867,0.05492,0.088864,0.12075,0.153753,0.190882,0.245663,0.277482,0.287364,0.32782,0.356794,0.400157,0.454486,0.484566,0.48231,0.46988,0.462485,0.450129,0.436773:-0.300488,-0.278417,-0.262733,-0.239899,-0.244329,-0.221698,-0.188084,-0.165248,-0.138295,-0.1161,-0.107183,-0.09362,-0.048571,0.002646,0.001925,-0.022579,-0.041314,-0.045683,-0.042827,-0.040109,-0.043156,-0.060442,-0.08796,-0.115751:-0.401253,-0.378882,-0.346057,-0.312331,-0.291303,-0.262717,-0.235308,-0.22989,-0.256738,-0.288443,-0.317552,-0.362447,-0.408079,-0.427062,-0.402176,-0.363309,-0.376637,-0.417858,-0.45531,-0.476388,-0.487506,-0.494237,-0.489077,-0.462358:0.307689,0.308105,0.308141,0.274832,0.254885,0.201963,0.136656,0.109763,0.094208,0.072518,0.050299,0.018401,-0.003741,-0.021933,-0.048485,-0.10738,-0.145645,-0.156726,-0.159025,-0.160586,-0.148933,-0.125082,-0.112057,-0.123421:0.083275,0.07459,0.039,2.94E-4,-0.054483,-0.102414,-0.15647,-0.197087,-0.216591,-0.227014,-0.24263,-0.268358,-0.288642,-0.294732,-0.323607,-0.331586,-0.323713,-0.325166,-0.319739,-0.310646,-0.300729,-0.300986,-0.288803,-0.251891:-0.286078,-0.319622,-0.345111,-0.356056,-0.355528,-0.362868,-0.383431,-0.414965,-0.434817,-0.441699,-0.432944,-0.41067,-0.409044,-0.407902,-0.384146,-0.345997,-0.307819,-0.281263,-0.272736,-0.268235,-0.269536,-0.258198,-0.239879,-0.220359:0.007641,-0.018568,-0.043056,-0.058664,-0.077204,-0.069657,-0.049466,-0.03686,-0.024091,-0.012383,0.008649,0.055507,0.099742,0.113799,0.106272,0.089192,0.081019,0.086725,0.088568,0.09015,0.086902,0.082986,0.071195,0.0432:0.044222,0.043953,0.039581,0.030223,0.034391,0.06073,0.111887,0.155859,0.182305,0.197495,0.200555,0.216833,0.224472,0.198102,0.16318,0.135223,0.099977,0.062611,0.043269,0.028954,0.017013,-0.004571,-0.02442,-0.037246:4
0.769272,0.733159,0.696003,0.650497,0.62614,0.606109,0.575463,0.532529,0.483488,0.469156,0.414325,0.390112,0.318188,0.273828,0.252108,0.210025,0.21367,0.180862,0.121299:-0.070254,-0.089799,-0.105576,-0.136863,-0.189177,-0.27907,-0.38604,-0.481415,-0.55946,-0.61151,-0.608011,-0.655538,-0.712622,-0.725363,-0.743767,-0.738778,-0.757791,-0.780062,-0.776928:0.196578,0.134677,0.110614,0.096435,0.096016,0.08708,0.061353,0.061287,0.062467,0.071878,0.100029,0.153388,0.224806,0.267924,0.315295,0.343772,0.348963,0.390616,0.437992:-0.723836,-0.703302,-0.70759,-0.715629,-0.730839,-0.733084,-0.689012,-0.615027,-0.533964,-0.45169,-0.347957,-0.280645,-0.224289,-0.171757,-0.149878,-0.122701,-0.077362,-0.063799,-0.059061:-0.347412,-0.304399,-0.260876,-0.188175,-0.100566,-0.040544,0.023348,0.099682,0.149068,0.187628,0.236282,0.276596,0.292635,0.298358,0.297746,0.303268,0.309591,0.328332,0.345105:-0.547292,-0.531955,-0.491542,-0.418399,-0.342908,-0.310566,-0.284578,-0.256651,-0.237258,-0.233188,-0.234422,-0.208422,-0.163723,-0.179113,-0.204226,-0.219192,-0.233045,-0.222427,-0.209092:-0.02017,-0.024925,-0.026507,-0.03146,-0.033717,-0.035466,-0.057595,-0.10532,-0.149821,-0.181713,-0.189244,-0.190521,-0.184979,-0.193874,-0.212683,-0.226394,-0.234664,-0.264031,-0.279767:0.064025,0.083606,0.083574,0.062997,0.03937,0.006553,-0.045382,-0.094082,-0.126604,-0.172316,-0.240649,-0.277052,-0.311149,-0.32489,-0.328344,-0.354072,-0.387115,-0.387412,-0.392033:0.174926,0.183396,0.164575,0.096637,0.013353,-0.030594,-0.065604,-0.108791,-0.123571,-0.116112,-0.108583,-0.12406,-0.165538,-0.163037,-0.14958,-0.127133,-0.098728,-0.108113,-0.112295:-0.173769,-0.224942,-0.265784,-0.306346,-0.34875,-0.380983,-0.403428,-0.417651,-0.425612,-0.404473,-0.370234,-0.344134,-0.329033,-0.322779,-0.29997,-0.271088,-0.247708,-0.210846,-0.172899:0.026719,0.005505,-0.011748,-0.02932,-0.057673,-0.082382,-0.068365,-0.039921,-0.024588,-0.005941,0.031765,0.036894,0.035613,0.021269,-0.009646,-0.024877,-0.026958,-0.026396,-0.034752:0.206613,0.197911,0.189849,0.18684,0.215582,0.253958,0.299647,0.363323,0.403234,0.417331,0.414162,0.357552,0.285049,0.272223,0.256483,0.225752,0.200578,0.168206,0.144705:4
1.03122,0.972634,0.92822,0.871246,0.82354,0.753399,0.684744,0.616327,0.577936,0.518337,0.413392,0.328972,0.295486,0.246528,0.163146,0.15751,0.117842,0.070335,0.075025,0.037362,0.002568,-0.037411,-0.079693:-0.541376,-0.539046,-0.571808,-0.582422,-0.585031,-0.608511,-0.628553,-0.673642,-0.729419,-0.791845,-0.821566,-0.849175,-0.880405,-0.892673,-0.871512,-0.862028,-0.852156,-0.828616,-0.840316,-0.817393,-0.804668,-0.783781,-0.767759:0.25046,0.169226,0.108475,0.051853,0.0,-0.024263,-0.032604,-0.007282,0.042539,0.133654,0.204804,0.25089,0.274275,0.300141,0.335469,0.350727,0.360619,0.372537,0.393244,0.402931,0.433517,0.47703,0.511448:-0.682311,-0.694179,-0.720906,-0.703933,-0.663642,-0.618852,-0.579271,-0.541266,-0.516633,-0.50491,-0.483305,-0.437902,-0.371228,-0.278275,-0.235532,-0.220567,-0.209277,-0.200515,-0.198334,-0.178197,-0.170682,-0.166425,-0.158564:-0.318182,-0.26071,-0.176746,-0.133087,-0.099536,-0.04575,0.006816,0.017629,0.021114,0.036641,0.050868,0.071474,0.090779,0.118255,0.160809,0.172048,0.191085,0.19653,0.205426,0.210295,0.224953,0.238635,0.250727:-0.388674,-0.35449,-0.330974,-0.296845,-0.249814,-0.209422,-0.17356,-0.134533,-0.086923,-0.034369,0.002163,0.005775,0.003805,0.015749,0.026172,0.027006,0.017851,0.015317,-0.006849,-0.022149,-0.033459,-0.042505,-0.033874:-0.326179,-0.304211,-0.276738,-0.245612,-0.220551,-0.212484,-0.208153,-0.218919,-0.241488,-0.261125,-0.264316,-0.261802,-0.259526,-0.251969,-0.219365,-0.220647,-0.228167,-0.227732,-0.204396,-0.19575,-0.203779,-0.211475,-0.210605:0.145304,0.138464,0.128568,0.096872,0.048439,-0.001132,-0.03407,-0.061151,-0.086251,-0.123417,-0.170295,-0.196604,-0.213399,-0.238266,-0.293899,-0.326788,-0.359603,-0.3871,-0.41767,-0.444836,-0.453918,-0.454905,-0.465049:0.246835,0.245642,0.230437,0.220131,0.191574,0.141185,0.07904,0.009247,-0.05047,-0.121199,-0.184622,-0.223988,-0.231807,-0.232526,-0.245767,-0.242754,-0.231849,-0.216832,-0.206773,-0.186625,-0.171922,-0.159537,-0.148833:-0.162486,-0.191213,-0.21663,-0.247749,-0.287803,-0.334504,-0.380895,-0.404727,-0.393479,-0.365062,-0.346302,-0.344059,-0.347668,-0.359354,-0.346047,-0.321823,-0.298312,-0.277028,-0.245084,-0.22342,-0.193452,-0.160333,-0.132345:-0.080911,-0.126108,-0.183561,-0.212374,-0.210527,-0.18923,-0.151331,-0.1052,-0.057852,-0.008303,0.040976,0.068803,0.075654,0.066294,0.046127,0.04938,0.047957,0.038113,0.019758,0.018343,0.007704,-0.001154,-0.004342:0.176163,0.163273,0.165767,0.166486,0.177896,0.220169,0.26288,0.290671,0.288022,0.284205,0.295003,0.304982,0.295552,0.264965,0.230213,0.19503,0.171191,0.147868,0.133441,0.109899,0.09191,0.072769,0.050283:4
1.198139,1.080101,0.952076,0.868217,0.786393,0.684751,0.627838,0.626863,0.562245,0.545705,0.490851,0.369667,0.271182,0.254301,0.234645,0.177414,0.139449,0.110423,0.132332,0.146792,0.138146,0.097588,0.112173:-0.723237,-0.733395,-0.739199,-0.755368,-0.753686,-0.739329,-0.778355,-0.830189,-0.855646,-0.908827,-0.954339,-0.962959,-0.962596,-0.973874,-0.982581,-0.996972,-1.01426,-1.01544,-1.028518,-1.03999,-1.024814,-0.982894,-0.968012:0.433617,0.388771,0.321584,0.281927,0.244531,0.195947,0.154965,0.129391,0.132143,0.145623,0.136039,0.13539,0.18782,0.264318,0.341714,0.40691,0.472862,0.533341,0.564383,0.590349,0.621405,0.64308,0.659008:-0.871601,-0.857189,-0.86174,-0.858827,-0.839666,-0.795949,-0.75025,-0.723554,-0.686843,-0.635183,-0.539208,-0.427876,-0.360432,-0.329329,-0.295293,-0.246244,-0.223057,-0.211671,-0.209784,-0.199892,-0.194568,-0.180303,-0.183443:-0.13323,-0.115276,-0.077221,-0.038545,0.008743,0.055748,0.108476,0.158698,0.19328,0.233352,0.253423,0.268171,0.2917,0.279118,0.264384,0.295986,0.30253,0.2906,0.285235,0.286861,0.297834,0.298486,0.301938:-0.433255,-0.427777,-0.401838,-0.355011,-0.322052,-0.289474,-0.254867,-0.230755,-0.218036,-0.203798,-0.197309,-0.200595,-0.189105,-0.143364,-0.115493,-0.119856,-0.118197,-0.113006,-0.100315,-0.091179,-0.091627,-0.090616,-0.090804:-0.437571,-0.387905,-0.329385,-0.276508,-0.238136,-0.204707,-0.195651,-0.204234,-0.214806,-0.233115,-0.220349,-0.195298,-0.201136,-0.186335,-0.154058,-0.182896,-0.199001,-0.206678,-0.204551,-0.210198,-0.208554,-0.204755,-0.196175:0.383855,0.369699,0.351175,0.322295,0.280671,0.219074,0.158765,0.106734,0.028923,-0.048141,-0.133407,-0.217165,-0.265158,-0.304036,-0.335215,-0.351414,-0.368836,-0.386154,-0.412127,-0.424044,-0.41916,-0.419088,-0.409945:-0.017725,-0.011661,-0.023807,-0.034737,-0.045047,-0.066637,-0.103041,-0.146242,-0.192605,-0.230324,-0.247667,-0.253049,-0.261293,-0.269806,-0.287684,-0.285508,-0.290674,-0.291308,-0.288121,-0.281895,-0.276486,-0.256556,-0.242974:-0.10712,-0.099574,-0.101982,-0.121633,-0.143987,-0.180403,-0.229777,-0.251789,-0.242701,-0.232156,-0.236307,-0.231332,-0.208457,-0.179493,-0.151147,-0.118643,-0.080113,-0.052383,-0.018406,0.009369,0.033461,0.039376,0.041254:0.071585,0.004815,-0.050524,-0.114838,-0.164884,-0.187617,-0.182125,-0.168735,-0.139532,-0.083342,-0.039678,-0.017676,-0.015328,-0.00718,5.18E-4,-0.013005,-0.033512,-0.044787,-0.05463,-0.059998,-0.0738,-0.085183,-0.103924:-0.010264,-5.92E-4,-1.25E-4,0.01388,0.044037,0.102474,0.176324,0.223561,0.272654,0.329395,0.373544,0.388877,0.370288,0.306906,0.231038,0.172177,0.119078,0.086294,0.065548,0.040108,0.019188,0.005409,-0.004591:4
0.791016,0.754177,0.729065,0.750145,0.765318,0.696192,0.563855,0.471953,0.427836,0.373248,0.340416,0.317834,0.297257,0.285009,0.222165,0.17775,0.150783:-0.577073,-0.564144,-0.569345,-0.579534,-0.612735,-0.621686,-0.57001,-0.512938,-0.460675,-0.459883,-0.552008,-0.637849,-0.681853,-0.696715,-0.687766,-0.68869,-0.699915:0.504691,0.402782,0.303621,0.207529,0.161851,0.146047,0.115702,0.088662,0.093336,0.099511,0.12173,0.161358,0.216548,0.302483,0.369586,0.3906,0.406021:-0.863302,-0.860797,-0.844592,-0.846538,-0.826449,-0.76387,-0.679986,-0.592615,-0.515304,-0.471961,-0.421979,-0.373081,-0.339119,-0.291277,-0.236518,-0.179421,-0.127156:-0.296507,-0.244942,-0.180162,-0.081899,-0.002625,0.078648,0.17343,0.247554,0.303368,0.356046,0.380227,0.336398,0.310016,0.324196,0.357563,0.374767,0.367783:-0.322484,-0.314434,-0.311077,-0.324174,-0.265413,-0.212748,-0.20911,-0.199375,-0.186057,-0.160973,-0.152769,-0.117129,-0.096128,-0.121686,-0.127866,-0.110073,-0.085025:-0.344411,-0.293882,-0.253613,-0.211221,-0.179449,-0.18074,-0.169372,-0.159134,-0.191553,-0.237148,-0.269746,-0.297539,-0.323939,-0.344103,-0.33602,-0.307736,-0.298065:0.31573,0.31409,0.310952,0.287868,0.211241,0.117918,0.017093,-0.100231,-0.215934,-0.299109,-0.339201,-0.368729,-0.374892,-0.360008,-0.362148,-0.381195,-0.389124:0.017744,-0.006486,-0.032823,-0.083069,-0.15112,-0.210291,-0.240838,-0.233912,-0.217876,-0.218235,-0.216371,-0.194114,-0.173455,-0.156419,-0.137789,-0.105473,-0.080921:-0.22343,-0.258328,-0.292868,-0.300872,-0.322252,-0.352997,-0.366697,-0.372173,-0.339074,-0.280663,-0.250342,-0.22761,-0.194627,-0.157669,-0.135066,-0.129969,-0.147086:0.086328,0.042175,0.003273,-0.015623,-0.007937,5.87E-4,-0.004851,0.005923,0.053577,0.064196,0.060811,0.076316,0.078193,0.064481,0.038471,0.002737,-0.011216:0.032379,0.037353,0.049051,0.079405,0.140945,0.206734,0.264688,0.284693,0.272151,0.230214,0.211251,0.170093,0.115881,0.087608,0.062532,0.040718,0.008515:4
0.829493,0.920807,0.874715,0.936269,0.959046,0.860191,0.749503,1.083557,1.364184,1.221321,1.246783,1.244446,1.171319,1.051351,0.828177,0.622839,0.553395,0.481003,0.370286,0.302177,0.245527,0.197086,0.163168:-0.545719,-0.611405,-0.547031,-0.607762,-0.643224,-0.638235,-0.632708,-0.711289,-0.86962,-0.799921,-0.876175,-0.920188,-0.920776,-1.003296,-0.976166,-0.931321,-1.011217,-1.017818,-0.975858,-0.952146,-0.933913,-0.966517,-0.961486:0.464492,0.414177,0.292267,0.307201,0.250365,0.109969,0.011782,0.005023,0.005997,-0.129307,-0.107804,-0.052359,-0.004734,0.085004,0.060143,0.019475,0.098843,0.192559,0.26444,0.309758,0.35894,0.440862,0.463275:-0.728181,-0.664304,-0.640623,-0.681458,-0.683288,-0.624314,-0.586716,-0.599107,-0.59106,-0.522455,-0.522922,-0.50092,-0.403499,-0.37399,-0.339477,-0.283939,-0.236008,-0.209423,-0.16548,-0.127471,-0.116431,-0.164143,-0.158402:-0.450787,-0.492717,-0.415776,-0.352641,-0.313976,-0.274248,-0.227324,-0.212496,-0.21027,-0.187193,-0.115044,-0.045532,-0.038892,-0.010143,0.040228,0.075628,0.079166,0.105895,0.125666,0.110035,0.095829,0.14969,0.154975:-0.323422,-0.29943,-0.297081,-0.264405,-0.266847,-0.277175,-0.265675,-0.189237,-0.108416,-0.069702,-0.068217,-0.062566,-0.039154,-0.015368,-0.030361,-0.068257,-0.026874,-0.010264,2.56E-4,0.042578,0.064508,0.035102,0.020367:-0.27608,-0.250568,-0.249839,-0.264742,-0.262032,-0.234815,-0.208581,-0.242443,-0.238159,-0.248748,-0.279783,-0.319862,-0.338941,-0.352335,-0.336242,-0.299612,-0.339691,-0.349763,-0.31359,-0.302335,-0.291619,-0.280539,-0.284347:0.31087,0.302403,0.271892,0.249467,0.240095,0.21149,0.187537,0.208987,0.170111,0.100676,0.059297,0.017882,-0.055634,-0.103956,-0.186651,-0.277509,-0.304301,-0.332982,-0.385001,-0.43023,-0.472575,-0.48566,-0.500158:0.047935,0.068291,0.076115,0.060543,0.051939,0.054814,0.053782,0.013277,-0.016424,-0.026599,-0.054268,-0.101712,-0.130234,-0.157043,-0.164151,-0.125044,-0.153029,-0.161992,-0.157589,-0.155224,-0.164333,-0.186403,-0.169483:-0.210966,-0.220867,-0.234983,-0.238854,-0.250217,-0.27743,-0.325893,-0.345174,-0.342522,-0.343499,-0.349766,-0.339261,-0.320864,-0.306133,-0.280113,-0.26815,-0.226326,-0.194022,-0.1716,-0.151093,-0.1284,-0.090956,-0.078858:0.175199,0.160207,0.141871,0.11682,0.097675,0.076632,0.056133,0.053495,0.038347,0.033231,0.05714,0.114707,0.155329,0.167202,0.151234,0.122406,0.141689,0.137915,0.110562,0.094513,0.091052,0.056269,0.029717:0.074737,0.100793,0.128085,0.132385,0.138757,0.158137,0.178673,0.190228,0.195102,0.217152,0.25848,0.295456,0.330849,0.315415,0.293564,0.281303,0.219026,0.178596,0.131987,0.065337,0.004421,-0.008844,-0.013417:4
0.817669,0.790207,0.755552,0.828496,0.884186,0.947652,0.942501,0.930471,0.904793,0.846237,0.708476,0.588546,0.459944,0.426955,0.389667,0.341147,0.385247,0.388427,0.315397:-0.180316,-0.185355,-0.175618,-0.229348,-0.297565,-0.404161,-0.509407,-0.584766,-0.643765,-0.699216,-0.72335,-0.725666,-0.755579,-0.846519,-0.89133,-0.876418,-0.894837,-0.899692,-0.876594:0.352488,0.291333,0.186719,0.096842,0.002931,-0.091084,-0.073687,-0.039257,-0.021623,-0.004055,0.0285,0.075002,0.175491,0.286312,0.338163,0.360009,0.40947,0.462005,0.517811:-0.833488,-0.828752,-0.791969,-0.769337,-0.749936,-0.669868,-0.599712,-0.551591,-0.50634,-0.426721,-0.316689,-0.229265,-0.144134,-0.114721,-0.094617,-0.081199,-0.083646,-0.038593,-0.00926:-0.211467,-0.171436,-0.130855,-0.068959,0.001402,0.048964,0.109228,0.157444,0.210412,0.238111,0.283338,0.31377,0.304551,0.297246,0.302244,0.296661,0.266062,0.209986,0.191579:-0.544303,-0.4964,-0.445367,-0.419155,-0.371931,-0.328722,-0.265864,-0.216686,-0.182964,-0.156246,-0.170544,-0.181418,-0.128885,-0.082196,-0.075296,-0.07443,-0.048444,-0.019887,-0.029674:-0.20473,-0.169807,-0.146396,-0.125442,-0.124011,-0.124216,-0.149442,-0.167891,-0.176883,-0.207833,-0.21258,-0.214315,-0.208489,-0.239433,-0.233246,-0.209574,-0.225367,-0.252732,-0.24066:0.239993,0.211937,0.188546,0.163064,0.11531,0.040199,-0.009281,-0.069919,-0.143569,-0.205487,-0.270481,-0.302921,-0.327133,-0.323397,-0.346611,-0.367612,-0.353054,-0.347945,-0.36413:0.110265,0.117634,0.138513,0.134793,0.117587,0.090063,8.37E-4,-0.060679,-0.105643,-0.136659,-0.15802,-0.140823,-0.142198,-0.169776,-0.179812,-0.18134,-0.203239,-0.195244,-0.178649:-0.116494,-0.151288,-0.201411,-0.243177,-0.295414,-0.363656,-0.416225,-0.428978,-0.41347,-0.404921,-0.40451,-0.386891,-0.352409,-0.292318,-0.264907,-0.255785,-0.229596,-0.208908,-0.182119:-0.023935,-0.073818,-0.117701,-0.164657,-0.18582,-0.179824,-0.157969,-0.138607,-0.108662,-0.03758,0.026993,0.027291,0.03046,0.02093,0.004844,0.006326,0.016587,0.029384,0.025104:0.200338,0.205388,0.195807,0.198795,0.201506,0.244549,0.319106,0.367308,0.379678,0.352348,0.350162,0.317323,0.230488,0.153268,0.123482,0.097322,0.056166,0.008232,-0.008063:4
1.174881,1.211482,1.139367,1.297954,1.295945,1.279402,1.237675,1.189073,1.106647,0.934463,0.890393,0.799598,0.70849,0.615303,0.542924,0.475703,0.450488:-0.612849,-0.652035,-0.616063,-0.737759,-0.740371,-0.728394,-0.710726,-0.780617,-0.882057,-0.890875,-0.997738,-0.989437,-0.984526,-1.022824,-1.027339,-1.006461,-0.977913:0.412032,0.320587,0.208459,0.165061,0.101981,0.069051,0.006665,0.005576,0.010104,-0.006533,0.106078,0.18885,0.257772,0.326629,0.372901,0.424826,0.514675:-0.856111,-0.879798,-0.819682,-0.880483,-0.860199,-0.831886,-0.783824,-0.72237,-0.631062,-0.509065,-0.475757,-0.360643,-0.268591,-0.250319,-0.236732,-0.205666,-0.216699:-0.267613,-0.204205,-0.181113,-0.098302,-0.039222,0.012819,0.067427,0.121478,0.158932,0.179358,0.204451,0.191862,0.21597,0.268363,0.274542,0.262941,0.263442:-0.462896,-0.448795,-0.423254,-0.367577,-0.32571,-0.281926,-0.269635,-0.230272,-0.188705,-0.162671,-0.143993,-0.120332,-0.089829,-0.058108,-0.043142,-0.052782,-0.043666:-0.356293,-0.359327,-0.333194,-0.338946,-0.314279,-0.303348,-0.264092,-0.231265,-0.213424,-0.199172,-0.21131,-0.201277,-0.173867,-0.175479,-0.187199,-0.173411,-0.175669:0.357882,0.354301,0.318237,0.316343,0.266718,0.211396,0.142323,0.052695,-0.041434,-0.149079,-0.179891,-0.228084,-0.276428,-0.319682,-0.360062,-0.402828,-0.415653:0.068633,0.067568,0.087822,0.037628,0.008431,-0.015659,-0.062201,-0.135385,-0.186924,-0.212587,-0.282405,-0.292718,-0.302417,-0.326029,-0.316464,-0.297701,-0.309183:-0.093139,-0.099629,-0.111127,-0.146125,-0.167263,-0.188936,-0.215337,-0.23745,-0.257921,-0.272584,-0.268011,-0.275064,-0.248187,-0.19369,-0.152353,-0.117423,-0.064102:0.041809,0.007375,-0.030143,-0.070307,-0.124381,-0.15875,-0.155132,-0.148193,-0.141511,-0.074841,-0.027971,0.005816,0.004512,-0.016136,-0.030181,-0.040351,-0.032326:0.035664,0.036165,0.021089,0.046782,0.068405,0.093373,0.154464,0.231715,0.295431,0.335255,0.380321,0.364733,0.278562,0.18591,0.136327,0.116554,0.07604:4
1.067787,1.006168,0.994013,0.954183,0.829759,0.680633,0.633252,0.651333,0.646969,0.5842,0.513726,0.440193,0.33346,0.238698,0.175187,0.126925,0.120896,0.147194:-0.415719,-0.395319,-0.401096,-0.377794,-0.330918,-0.300508,-0.297756,-0.351612,-0.403606,-0.442956,-0.501876,-0.57866,-0.652002,-0.662171,-0.7084,-0.753668,-0.776287,-0.791849:0.567151,0.531612,0.488909,0.447771,0.370649,0.280484,0.215663,0.193528,0.176132,0.151733,0.156254,0.178846,0.217886,0.251623,0.307117,0.413124,0.455474,0.471128:-0.75036,-0.762368,-0.781206,-0.796161,-0.779324,-0.741383,-0.70795,-0.652655,-0.577129,-0.505446,-0.43329,-0.367789,-0.27209,-0.174891,-0.106219,-0.084092,-0.058193,-0.03393:-0.341131,-0.310972,-0.279108,-0.226723,-0.151484,-0.084701,-0.040081,0.021759,0.080687,0.081253,0.106915,0.150632,0.191684,0.236546,0.264192,0.288749,0.290899,0.272572:-0.444746,-0.456343,-0.435968,-0.423047,-0.403994,-0.37407,-0.35693,-0.357643,-0.33565,-0.312421,-0.28123,-0.241015,-0.216491,-0.184878,-0.132879,-0.112207,-0.11922,-0.118134:-0.400398,-0.381893,-0.358002,-0.327417,-0.273846,-0.223723,-0.177867,-0.14394,-0.129891,-0.108883,-0.111739,-0.138409,-0.187974,-0.208602,-0.205894,-0.221757,-0.209734,-0.197477:0.232845,0.238798,0.225613,0.213325,0.197537,0.172135,0.133665,0.069921,-0.006673,-0.079916,-0.166548,-0.224253,-0.272001,-0.331104,-0.359542,-0.374557,-0.399096,-0.426481:0.168614,0.170422,0.157819,0.135463,0.110288,0.080603,0.054262,0.025044,-0.010104,-0.029978,-0.078118,-0.137139,-0.152452,-0.143626,-0.153305,-0.204519,-0.211744,-0.19547:-0.132383,-0.131222,-0.128569,-0.12472,-0.145141,-0.195426,-0.226513,-0.263365,-0.317504,-0.370183,-0.380685,-0.375597,-0.34348,-0.297623,-0.285202,-0.226652,-0.197211,-0.178006:0.001483,-0.044901,-0.070866,-0.104127,-0.158517,-0.220218,-0.250747,-0.257257,-0.214548,-0.147464,-0.057013,0.010915,0.056315,0.083522,0.071561,0.050788,0.033742,0.021684:0.148808,0.14922,0.142986,0.140918,0.15749,0.187555,0.212101,0.276208,0.351217,0.37546,0.391515,0.392509,0.347966,0.282352,0.189941,0.139262,0.117907,0.096685:4
0.743394,0.795709,0.857321,0.89788,0.847827,0.808952,0.782686,0.697954,0.581131,0.515013,0.391525,0.3674,0.326707,0.284618,0.293116,0.285004,0.254755,0.2723,0.202333:-0.33081,-0.400653,-0.496495,-0.581013,-0.59908,-0.661161,-0.728694,-0.760104,-0.780081,-0.832898,-0.842615,-0.95264,-0.994403,-1.017309,-1.062217,-1.08806,-1.064318,-1.084921,-1.067387:0.174714,0.135416,0.096677,0.05235,-0.026207,-0.073122,-0.089741,-0.088656,-0.078894,-0.025962,0.079261,0.228521,0.266745,0.309644,0.369036,0.399363,0.398853,0.432946,0.486956:-0.623668,-0.677976,-0.698671,-0.694856,-0.666803,-0.624813,-0.576887,-0.499424,-0.385189,-0.30163,-0.210578,-0.18925,-0.164634,-0.124631,-0.100635,-0.082076,-0.04679,-0.030357,-0.014887:-0.346249,-0.275039,-0.216297,-0.150408,-0.085914,-0.036332,0.018843,0.054427,0.065768,0.078046,0.105361,0.172681,0.199761,0.188606,0.175578,0.167587,0.156704,0.160045,0.175259:-0.498548,-0.487326,-0.455975,-0.405319,-0.331517,-0.274745,-0.243539,-0.216569,-0.197508,-0.171745,-0.122618,-0.081369,-0.071896,-0.081592,-0.075547,-0.060643,-0.064708,-0.063411,-0.051657:-0.192322,-0.195162,-0.202293,-0.173523,-0.126133,-0.09962,-0.066966,-0.036742,-0.018726,-0.017018,-0.037988,-0.052509,-0.056892,-0.057269,-0.071225,-0.075412,-0.052812,-0.040161,-0.062071:0.161956,0.16082,0.158979,0.133877,0.060809,-0.018242,-0.109066,-0.208274,-0.295783,-0.363123,-0.403503,-0.448826,-0.504822,-0.536777,-0.525831,-0.513873,-0.537972,-0.559419,-0.57128:0.172816,0.158544,0.137405,0.090597,0.043251,0.008248,-0.04095,-0.085567,-0.104927,-0.123147,-0.176345,-0.243955,-0.250313,-0.257687,-0.277509,-0.279262,-0.242024,-0.223173,-0.214473:-0.10367,-0.076122,-0.046846,-0.065571,-0.116464,-0.15762,-0.184254,-0.216294,-0.259713,-0.2701,-0.242451,-0.172673,-0.135714,-0.109096,-0.08133,-0.065249,-0.049007,-0.003835,0.037506:-0.10445,-0.121938,-0.148802,-0.173626,-0.199055,-0.234361,-0.242457,-0.204198,-0.16106,-0.136308,-0.095098,-0.094231,-0.094391,-0.076451,-0.06488,-0.061291,-0.071388,-0.099061,-0.106205:0.138613,0.124044,0.101379,0.114246,0.150744,0.180326,0.234831,0.315561,0.377149,0.387275,0.32501,0.270641,0.249084,0.233805,0.200872,0.162301,0.129273,0.090184,0.045084:4
1.327838,1.330871,1.297679,1.251519,1.099318,1.00973,0.807895,0.652352,0.522921,0.384023,0.292653,0.182106,0.048603,-0.0388,-0.058504:-0.332592,-0.342182,-0.360481,-0.41007,-0.416246,-0.511319,-0.556821,-0.571101,-0.600058,-0.631161,-0.646954,-0.698276,-0.716473,-0.690907,-0.695714:0.546751,0.470645,0.377296,0.297452,0.224442,0.20038,0.169831,0.183029,0.21761,0.252661,0.325379,0.417678,0.514503,0.566067,0.576807:-0.872172,-0.910126,-0.932995,-0.941191,-0.888988,-0.863369,-0.764466,-0.64354,-0.492736,-0.393224,-0.297191,-0.197129,-0.151979,-0.115129,-0.079003:-0.191518,-0.142894,-0.088622,-0.022226,0.028878,0.147457,0.249833,0.336268,0.433163,0.466586,0.476591,0.475726,0.476317,0.492761,0.504115:-0.497121,-0.440901,-0.396697,-0.374833,-0.307932,-0.230393,-0.201703,-0.199451,-0.201814,-0.19928,-0.191915,-0.152757,-0.116438,-0.110324,-0.108272:-0.458289,-0.474502,-0.458429,-0.426172,-0.36814,-0.338329,-0.317139,-0.289527,-0.302032,-0.295801,-0.323734,-0.333577,-0.244668,-0.223829,-0.206237:0.314739,0.329121,0.324883,0.319326,0.252383,0.216481,0.151701,0.093882,-7.95E-4,-0.078438,-0.128006,-0.147019,-0.190564,-0.237563,-0.258499:0.079463,0.119828,0.138479,0.113795,0.059147,-0.066309,-0.124444,-0.17167,-0.205109,-0.208178,-0.1839,-0.151885,-0.126371,-0.116751,-0.115777:-0.128538,-0.12923,-0.133584,-0.163819,-0.217859,-0.305046,-0.368888,-0.405963,-0.399714,-0.372734,-0.323809,-0.280269,-0.210079,-0.170866,-0.15963:0.025527,-0.017058,-0.077216,-0.132544,-0.150167,-0.172138,-0.203351,-0.204726,-0.158856,-0.130969,-0.101582,-0.085128,-0.103668,-0.109518,-0.106314:0.122738,0.062219,0.017385,0.004776,0.008023,0.045092,0.100512,0.147367,0.183435,0.160113,0.12124,0.079935,0.019761,-0.027191,-0.046737:4
1.098436,1.11777,1.177488,1.222346,1.279431,1.282359,1.220623,1.146283,1.079729,0.983517,0.902824,0.920623,0.975028,0.777416,0.681776,0.791421,0.768676,0.736434,0.831372,0.758778,0.790989,0.792767:-0.358393,-0.375029,-0.428225,-0.473878,-0.530365,-0.558491,-0.547331,-0.536196,-0.549434,-0.575181,-0.642152,-0.718226,-0.778504,-0.652026,-0.594858,-0.680852,-0.663901,-0.639567,-0.722663,-0.658417,-0.646124,-0.658614:0.382133,0.344222,0.342536,0.315938,0.331803,0.3666,0.366767,0.293849,0.204688,0.161347,0.158751,0.168362,0.197762,0.157623,0.143755,0.246433,0.252429,0.243539,0.293659,0.274469,0.276343,0.272628:-0.658555,-0.695136,-0.724355,-0.729309,-0.73445,-0.75052,-0.765585,-0.796734,-0.770103,-0.739195,-0.732108,-0.709422,-0.666322,-0.563374,-0.515474,-0.537631,-0.499854,-0.466251,-0.485471,-0.426966,-0.402802,-0.408608:-0.49357,-0.413041,-0.378279,-0.341263,-0.266561,-0.143759,-0.021476,0.054398,0.123348,0.187223,0.245436,0.270102,0.273952,0.314764,0.363273,0.377886,0.392408,0.424251,0.466153,0.498591,0.518498,0.530472:-0.247135,-0.256348,-0.19172,-0.132843,-0.117542,-0.106157,-0.079304,-0.057546,-0.052308,-0.062446,-0.073981,-0.056596,-0.010669,-0.038244,-0.059604,-0.008277,0.006932,0.009442,0.017873,5.77E-4,-0.001869,0.002411:-0.499921,-0.492067,-0.506709,-0.502716,-0.494099,-0.488072,-0.454933,-0.385508,-0.345384,-0.335141,-0.325646,-0.335713,-0.350981,-0.310553,-0.304873,-0.347902,-0.34021,-0.332051,-0.36751,-0.361008,-0.344832,-0.325273:0.171407,0.182169,0.166575,0.142986,0.149244,0.158825,0.145903,0.115059,0.079782,0.063628,0.061464,0.049661,-9.03E-4,-0.088859,-0.10262,-0.072869,-0.091502,-0.113345,-0.099401,-0.143663,-0.186415,-0.227527:0.279348,0.284179,0.296068,0.287584,0.244854,0.150735,0.035468,-0.042852,-0.08405,-0.1136,-0.165261,-0.20042,-0.23568,-0.255642,-0.265787,-0.298237,-0.290333,-0.270196,-0.267573,-0.232203,-0.224052,-0.228748:-0.16102,-0.168561,-0.16841,-0.184191,-0.228316,-0.279341,-0.322049,-0.343539,-0.377495,-0.402714,-0.413449,-0.417039,-0.406636,-0.38727,-0.388783,-0.37819,-0.364755,-0.349403,-0.324186,-0.3002,-0.269669,-0.229234:0.003906,-0.032203,-0.06183,-0.086522,-0.100785,-0.097509,-0.105667,-0.148032,-0.183331,-0.202872,-0.199634,-0.16867,-0.103932,-0.064406,-0.048404,-0.029925,-0.039191,-0.058093,-0.06644,-0.090622,-0.107541,-0.108296:0.06278,0.037525,0.002022,-0.022182,-0.028829,-0.018833,-0.003521,-0.005088,0.027035,0.061887,0.089121,0.109265,0.144323,0.206523,0.225106,0.200094,0.187273,0.177131,0.152882,0.161213,0.168875,0.156482:4
0.435945,0.359379,0.313025,0.345921,0.284422,0.275702,0.286868,0.260429,0.169258,0.169453,0.171125,0.13329,0.109062,0.074276,0.034133,-3.8E-5,-0.0146,-0.004054:-0.422234,-0.425838,-0.419396,-0.407658,-0.40768,-0.394387,-0.394406,-0.419464,-0.444432,-0.450534,-0.530264,-0.611538,-0.665556,-0.676436,-0.688056,-0.697937,-0.691988,-0.723653:0.560329,0.523795,0.45179,0.360834,0.332265,0.311467,0.244947,0.176203,0.168828,0.110112,0.11353,0.138113,0.159661,0.18193,0.240454,0.321446,0.350301,0.358539:-0.78253,-0.826027,-0.830727,-0.799061,-0.761475,-0.728196,-0.664845,-0.607753,-0.557416,-0.497979,-0.455833,-0.373605,-0.243549,-0.142669,-0.10682,-0.085113,0.034387,0.114856:-0.307469,-0.235748,-0.171876,-0.113035,-0.080365,-0.011342,0.071628,0.136842,0.206112,0.282574,0.342701,0.396214,0.491473,0.5639,0.57784,0.562666,0.546885,0.574822:-0.523295,-0.534643,-0.533763,-0.527336,-0.506222,-0.471915,-0.423498,-0.37696,-0.336328,-0.314147,-0.250107,-0.172632,-0.143114,-0.15804,-0.149542,-0.151705,-0.175599,-0.153621:-0.341618,-0.30295,-0.261105,-0.22842,-0.196769,-0.178585,-0.154123,-0.132327,-0.164195,-0.179174,-0.172516,-0.186558,-0.216133,-0.259567,-0.303458,-0.304075,-0.287199,-0.243816:0.316166,0.35239,0.372491,0.364203,0.357883,0.360426,0.303832,0.226232,0.175939,0.131234,0.072002,0.012408,-0.07358,-0.133762,-0.158755,-0.186218,-0.203362,-0.174813:0.03769,-0.003425,-0.027276,-0.031288,-0.069169,-0.140626,-0.197246,-0.226127,-0.277018,-0.311525,-0.335762,-0.320026,-0.274169,-0.258943,-0.246673,-0.22888,-0.162692,-0.104058:-0.162727,-0.159142,-0.169602,-0.208048,-0.250731,-0.316041,-0.36667,-0.395655,-0.398675,-0.416767,-0.435903,-0.430293,-0.392614,-0.353718,-0.323357,-0.266529,-0.248957,-0.23761:0.136774,0.099849,0.055831,0.003739,-0.015016,-0.034941,-0.051476,-0.058012,-0.029938,-0.004527,0.016321,0.022417,0.031433,0.038397,0.04521,0.04287,0.057146,0.060417:0.091159,0.051859,0.012304,0.006932,0.00474,0.012957,0.033794,0.059644,0.090304,0.151156,0.179073,0.148276,0.124941,0.099798,0.060894,0.007614,-0.018366,-0.027115:4
0.692819,0.659821,0.588679,0.588333,0.627348,0.559909,0.413144,0.288518,0.124989,-0.031103,-0.106619,-0.198003,-0.181746,-0.126574,-0.217004:-0.258496,-0.266231,-0.236974,-0.286706,-0.418919,-0.491971,-0.5406,-0.562116,-0.620895,-0.685591,-0.701455,-0.655495,-0.667269,-0.718356,-0.672351:0.051255,-0.010163,-0.06597,-0.079446,-0.034091,-0.024828,-0.004412,0.04512,0.108501,0.194472,0.287763,0.368633,0.422732,0.451747,0.489717:-0.86491,-0.837286,-0.790782,-0.776393,-0.780147,-0.686067,-0.606111,-0.497295,-0.35314,-0.262299,-0.220127,-0.155483,-0.095341,-0.052407,-0.059263:-0.019178,0.045994,0.076325,0.122806,0.222727,0.319532,0.365737,0.420706,0.479369,0.507008,0.502221,0.50232,0.49503,0.478411,0.51544:-0.366389,-0.351462,-0.300925,-0.266344,-0.227617,-0.198153,-0.180733,-0.168694,-0.152229,-0.145938,-0.161607,-0.184318,-0.183449,-0.163298,-0.185061:-0.329836,-0.286989,-0.217419,-0.181486,-0.194189,-0.222398,-0.240748,-0.237892,-0.26599,-0.327841,-0.33265,-0.284055,-0.254182,-0.270442,-0.294254:0.086135,0.085872,0.040693,-0.003831,-0.040044,-0.101413,-0.140219,-0.19215,-0.262773,-0.291894,-0.287539,-0.285958,-0.273624,-0.250788,-0.232083:0.171274,0.130183,0.063362,0.018688,-0.062979,-0.132854,-0.171212,-0.194578,-0.201131,-0.213733,-0.220906,-0.181617,-0.14227,-0.148199,-0.157585:0.007165,-0.070078,-0.143237,-0.200463,-0.247337,-0.313142,-0.344925,-0.349123,-0.332118,-0.286032,-0.234401,-0.192631,-0.193327,-0.209263,-0.186441:-0.156441,-0.180309,-0.182099,-0.169251,-0.146749,-0.112378,-0.067803,-0.030689,0.013224,0.05025,0.056901,0.037433,0.026572,0.036473,0.009383:0.031967,0.077584,0.136638,0.172854,0.212451,0.28056,0.291525,0.266181,0.193977,0.132659,0.088791,0.038535,-0.016901,-0.062206,-0.062645:4
0.537922,0.500515,0.472552,0.464428,0.412319,0.42519,0.402519,0.381979,0.32309,0.253603,0.209179,0.162261,0.104178,0.048495,0.010341,0.006055,-0.011587:-0.293037,-0.303985,-0.333052,-0.351647,-0.334911,-0.354326,-0.361556,-0.410437,-0.447247,-0.467147,-0.492487,-0.50433,-0.515678,-0.519006,-0.524456,-0.541537,-0.552906:0.145809,0.110117,0.091904,0.003321,-0.057272,-0.041748,-3.58E-4,0.03047,0.024458,0.044179,0.082482,0.11079,0.152584,0.21001,0.244968,0.269393,0.324885:-0.712939,-0.713668,-0.730445,-0.689061,-0.610494,-0.579493,-0.560933,-0.503242,-0.451172,-0.449159,-0.462117,-0.449751,-0.427293,-0.400448,-0.352853,-0.310493,-0.278041:-0.205517,-0.09078,0.001726,0.086059,0.148211,0.241031,0.329752,0.411679,0.448182,0.444224,0.425622,0.427963,0.441806,0.455855,0.473923,0.496923,0.517588:-0.439589,-0.407865,-0.375359,-0.321456,-0.262736,-0.211084,-0.152925,-0.136703,-0.104044,-0.041043,0.002978,-0.010639,-0.022145,-0.032269,-0.048713,-0.060502,-0.062012:-0.185043,-0.175292,-0.169599,-0.177049,-0.173273,-0.166032,-0.197467,-0.231405,-0.272816,-0.311054,-0.314895,-0.303553,-0.316945,-0.341436,-0.354063,-0.347544,-0.318141:0.205299,0.179888,0.165092,0.10694,0.041473,-0.037092,-0.103726,-0.158798,-0.214536,-0.274381,-0.3396,-0.376473,-0.376596,-0.355099,-0.325292,-0.291768,-0.272152:0.102029,0.052073,-0.004652,-0.036728,-0.060098,-0.110775,-0.170372,-0.201986,-0.199158,-0.192578,-0.187417,-0.176273,-0.173368,-0.186229,-0.187905,-0.179722,-0.172555:-0.271996,-0.303649,-0.332523,-0.375924,-0.415637,-0.43073,-0.399633,-0.372875,-0.360809,-0.327029,-0.273335,-0.246011,-0.228671,-0.197631,-0.186857,-0.199217,-0.206715:0.013575,-0.022982,-0.050997,-0.053336,-0.048291,-0.041327,-0.036217,-0.043481,-0.023175,-0.003715,0.008834,0.011712,0.01039,0.010306,0.008016,0.00759,-0.001213:0.114192,0.14664,0.148038,0.129706,0.138976,0.181455,0.198519,0.215772,0.179033,0.124817,0.085471,0.083647,0.082837,0.065969,0.051043,0.047497,0.039526:4
0.714627,0.710543,0.689175,0.637202,0.563329,0.48316,0.462844,0.456747,0.427421,0.375143,0.325729,0.337561,0.31399,0.241925,0.209916,0.154645,0.093215,0.021885,0.043734,0.039664,0.019,0.015918,0.011564,-0.021468,-0.049102:-0.487022,-0.502552,-0.465995,-0.433172,-0.523373,-0.59432,-0.643219,-0.680449,-0.704962,-0.721508,-0.754699,-0.779874,-0.798341,-0.796023,-0.817634,-0.817319,-0.816819,-0.809946,-0.844111,-0.850464,-0.840263,-0.852997,-0.869134,-0.863572,-0.849705:0.507183,0.451643,0.404784,0.325228,0.276212,0.233806,0.200403,0.192895,0.220701,0.240321,0.260272,0.277011,0.288257,0.306345,0.334188,0.353965,0.364715,0.370515,0.386515,0.394502,0.406784,0.434177,0.46611,0.494096,0.521294:-0.95711,-0.957525,-0.957445,-0.935373,-0.897919,-0.867708,-0.83464,-0.78858,-0.747063,-0.68066,-0.628073,-0.601576,-0.541343,-0.469851,-0.428636,-0.402613,-0.378452,-0.340904,-0.305546,-0.26675,-0.235227,-0.216685,-0.198972,-0.168658,-0.131128:-0.162806,-0.081412,-0.020738,0.050301,0.087652,0.136511,0.188038,0.236394,0.262937,0.2997,0.36836,0.402547,0.441443,0.473918,0.494762,0.507348,0.506611,0.494132,0.481443,0.476406,0.469988,0.461289,0.452391,0.443167,0.425683:-0.373718,-0.360421,-0.317987,-0.287442,-0.260613,-0.254312,-0.235804,-0.20148,-0.148542,-0.103448,-0.082238,-0.081149,-0.089221,-0.10677,-0.128016,-0.149555,-0.157171,-0.160233,-0.178525,-0.195747,-0.201134,-0.194409,-0.186006,-0.18717,-0.18466:-0.427863,-0.41211,-0.365468,-0.323543,-0.277517,-0.257986,-0.252755,-0.251194,-0.250644,-0.244147,-0.265607,-0.309377,-0.325963,-0.320146,-0.320588,-0.323077,-0.30674,-0.299104,-0.291947,-0.293539,-0.294372,-0.300518,-0.307316,-0.310388,-0.30496:0.313823,0.313234,0.281101,0.245906,0.209085,0.178258,0.140001,0.086757,0.019112,-0.047752,-0.07292,-0.076679,-0.104923,-0.15758,-0.168086,-0.167172,-0.183642,-0.208254,-0.219821,-0.233067,-0.254613,-0.268751,-0.269826,-0.262001,-0.261713:0.033008,-0.00115,-0.068202,-0.120733,-0.16878,-0.196725,-0.242388,-0.303384,-0.343234,-0.347725,-0.359608,-0.365489,-0.370439,-0.388059,-0.406769,-0.410258,-0.407233,-0.390411,-0.375526,-0.359963,-0.345773,-0.338098,-0.337217,-0.333466,-0.318212:-0.106216,-0.126748,-0.155301,-0.190156,-0.222349,-0.223852,-0.219587,-0.219815,-0.219359,-0.227816,-0.238781,-0.229737,-0.20536,-0.161299,-0.153662,-0.159418,-0.160244,-0.152004,-0.138659,-0.123379,-0.102485,-0.080064,-0.065421,-0.055074,-0.042274:0.002503,-0.035006,-0.053002,-0.094557,-0.135214,-0.153987,-0.135521,-0.103694,-0.082609,-0.103959,-0.108562,-0.081841,-0.076478,-0.064249,-0.039008,-0.026741,-0.032505,-0.044058,-0.055962,-0.059472,-0.059281,-0.05362,-0.040015,-0.030014,-0.036294:-0.017769,-0.014102,4.6E-5,0.014295,0.026824,0.036636,0.059329,0.100589,0.151824,0.188703,0.174764,0.147419,0.113427,0.09198,0.09252,0.102259,0.109077,0.100841,0.09572,0.087402,0.076366,0.056503,0.035126,0.014012,8.93E-4:4
0.401209,0.391543,0.435057,0.481464,0.486009,0.511099,0.471792,0.481355,0.461477,0.440537,0.356106,0.326197,0.289465,0.182088,0.122706,0.068329,0.016018,-0.014412,-0.032581,-0.080992,-0.190539:-0.174091,-0.174884,-0.239905,-0.33462,-0.406168,-0.48515,-0.533509,-0.619506,-0.675676,-0.760876,-0.828494,-0.792032,-0.802491,-0.814888,-0.827707,-0.801789,-0.769895,-0.777264,-0.806508,-0.799533,-0.743797:0.741654,0.663257,0.591809,0.520577,0.44448,0.374771,0.298857,0.243796,0.235701,0.276531,0.346058,0.418245,0.461222,0.519238,0.573843,0.620644,0.652394,0.704067,0.764478,0.769678,0.761921:-0.912472,-0.921904,-0.943015,-0.944924,-0.919201,-0.879014,-0.840738,-0.787998,-0.696143,-0.630315,-0.576516,-0.496658,-0.383832,-0.347,-0.28786,-0.22731,-0.199468,-0.160747,-0.109918,-0.105168,-0.11156:-0.221091,-0.185515,-0.146167,-0.124305,-0.070369,0.006567,0.090122,0.179754,0.264976,0.361297,0.42029,0.428311,0.460169,0.482812,0.474918,0.473315,0.479682,0.49259,0.510695,0.541902,0.576538:-0.589246,-0.588037,-0.56733,-0.52214,-0.50933,-0.459061,-0.3784,-0.317196,-0.239907,-0.182981,-0.098172,-0.069269,-0.123048,-0.164452,-0.185029,-0.190194,-0.169513,-0.141607,-0.124476,-0.138819,-0.168043:-0.408945,-0.378395,-0.34696,-0.327267,-0.286125,-0.244831,-0.215174,-0.226078,-0.243079,-0.277596,-0.281113,-0.307946,-0.33015,-0.34879,-0.363803,-0.356957,-0.330856,-0.322682,-0.305499,-0.2786,-0.270998:0.414012,0.45869,0.471809,0.467999,0.45391,0.399094,0.321008,0.240376,0.118471,0.053241,-0.028825,-0.156964,-0.206773,-0.162632,-0.139947,-0.137211,-0.140134,-0.152027,-0.164124,-0.165582,-0.148604:-0.123273,-0.124208,-0.131596,-0.120855,-0.139545,-0.193126,-0.253952,-0.292498,-0.326849,-0.36486,-0.423775,-0.398981,-0.376917,-0.420262,-0.40032,-0.364458,-0.351392,-0.322553,-0.282073,-0.280095,-0.295555:-0.089584,-0.115081,-0.123278,-0.139401,-0.158052,-0.19166,-0.23851,-0.264059,-0.289478,-0.307659,-0.252974,-0.166359,-0.141239,-0.128547,-0.120448,-0.088523,-0.040236,-0.002272,0.006523,0.015817,0.027063:0.20667,0.171176,0.122865,0.066768,5.98E-4,-0.055979,-0.108061,-0.129636,-0.120965,-0.09669,-0.051781,-0.022294,-0.017377,0.03605,0.047742,0.043847,0.034028,0.0026,-0.045788,-0.083071,-0.097954:0.024159,0.007088,-0.02108,-0.04209,-0.028664,0.013068,0.053714,0.105106,0.224188,0.253265,0.141364,0.106709,0.125284,0.05677,0.019375,-0.017911,-0.073636,-0.121542,-0.1298,-0.155083,-0.21355:4
0.563627,0.530344,0.545917,0.513214,0.474467,0.550167,0.55686,0.497502,0.477737,0.436426,0.442105,0.331393,0.279873,0.198322,0.123521,0.101725,0.074044,0.056373,0.040367:-0.116404,-0.105376,-0.145918,-0.169954,-0.142326,-0.207968,-0.285645,-0.353535,-0.458003,-0.519584,-0.566651,-0.60302,-0.64697,-0.660384,-0.707543,-0.764547,-0.788649,-0.807865,-0.817331:0.62109,0.567807,0.525802,0.441025,0.342817,0.307621,0.271827,0.212622,0.168425,0.189936,0.224602,0.26124,0.337828,0.357919,0.38054,0.422677,0.486707,0.529171,0.547986:-0.732322,-0.743408,-0.771613,-0.748447,-0.7455,-0.781126,-0.764676,-0.744464,-0.700914,-0.633858,-0.557624,-0.44645,-0.370314,-0.324942,-0.285917,-0.228601,-0.18638,-0.153796,-0.134031:-0.397379,-0.372453,-0.336292,-0.316027,-0.26121,-0.150521,-0.04494,0.038047,0.122694,0.20607,0.272973,0.334992,0.372871,0.417337,0.435273,0.425847,0.414811,0.412006,0.432676:-0.596205,-0.581615,-0.560571,-0.545125,-0.531268,-0.505248,-0.440568,-0.394572,-0.335861,-0.279025,-0.24568,-0.231171,-0.218204,-0.19752,-0.191707,-0.205427,-0.209697,-0.185749,-0.167078:-0.269158,-0.247426,-0.217425,-0.203846,-0.198031,-0.194351,-0.171797,-0.137583,-0.134878,-0.175153,-0.186125,-0.208849,-0.262016,-0.274326,-0.275674,-0.276971,-0.271032,-0.262654,-0.260089:0.180587,0.210434,0.230101,0.254951,0.267048,0.255158,0.223769,0.16678,0.080464,0.014599,-0.061176,-0.126727,-0.183884,-0.246106,-0.277529,-0.278351,-0.26838,-0.261072,-0.257293:0.019063,0.030023,0.042212,0.060316,0.053213,0.020677,-0.03418,-0.083961,-0.133605,-0.190156,-0.228375,-0.230591,-0.224861,-0.243166,-0.255507,-0.233152,-0.208517,-0.193719,-0.189383:5.58E-4,-0.016318,-0.049947,-0.110187,-0.122995,-0.127509,-0.197896,-0.257086,-0.287409,-0.318674,-0.326608,-0.30777,-0.252403,-0.21594,-0.19907,-0.189939,-0.163892,-0.152048,-0.145271:0.066948,0.021676,-0.03555,-0.070836,-0.102654,-0.15088,-0.198263,-0.227684,-0.221286,-0.175204,-0.136922,-0.120942,-0.095838,-0.068287,-0.048692,-0.041815,-0.044695,-0.046538,-0.051298:0.170409,0.169227,0.171283,0.163108,0.133818,0.129399,0.181806,0.21496,0.24303,0.302903,0.351249,0.30139,0.231593,0.206719,0.200082,0.179981,0.137974,0.097617,0.06725:4
1.144161,1.029766,0.883019,0.745215,0.662598,0.615029,0.602833,0.631337,0.643795,0.603513,0.591434,0.618833,0.599584,0.535474,0.498859,0.499048,0.475522,0.412454,0.358836,0.342121,0.343431,0.339492,0.319452:-0.611784,-0.572593,-0.510568,-0.450937,-0.431763,-0.44039,-0.459454,-0.456424,-0.455184,-0.487315,-0.544519,-0.590949,-0.596721,-0.568768,-0.562112,-0.576112,-0.579264,-0.574882,-0.561564,-0.578184,-0.628481,-0.678649,-0.686377:0.765783,0.671982,0.54561,0.412906,0.321683,0.266533,0.231129,0.206837,0.175917,0.143187,0.110312,0.076426,0.053843,0.029149,0.060277,0.105601,0.134734,0.153787,0.170893,0.180049,0.182079,0.182898,0.210755:-0.846177,-0.831008,-0.828369,-0.821992,-0.788748,-0.758695,-0.734106,-0.709562,-0.666839,-0.613957,-0.582566,-0.549272,-0.524485,-0.51495,-0.495067,-0.477371,-0.463003,-0.433897,-0.393024,-0.335269,-0.302867,-0.276832,-0.232001:-0.331975,-0.303472,-0.252654,-0.190425,-0.13986,-0.081758,-0.032038,0.035367,0.149754,0.264805,0.327175,0.369172,0.42259,0.501524,0.532207,0.570519,0.625472,0.682106,0.720422,0.738746,0.752582,0.735865,0.708023:-0.335629,-0.333828,-0.358438,-0.372519,-0.375078,-0.37902,-0.355154,-0.310234,-0.280907,-0.246802,-0.200198,-0.169876,-0.161082,-0.17103,-0.134611,-0.09945,-0.069234,-0.032475,-0.02158,-0.035239,-0.053648,-0.058248,-0.080334:-0.576753,-0.536162,-0.441721,-0.343984,-0.279078,-0.228405,-0.211271,-0.202532,-0.185371,-0.186411,-0.196583,-0.227554,-0.259467,-0.273409,-0.285679,-0.30038,-0.315616,-0.325595,-0.331793,-0.330107,-0.307979,-0.276385,-0.280978:0.309973,0.311747,0.312479,0.304621,0.294756,0.281089,0.262471,0.21268,0.137374,0.068415,-0.009296,-0.06553,-0.082631,-0.089112,-0.122351,-0.149323,-0.175186,-0.197279,-0.223769,-0.251744,-0.272608,-0.298156,-0.307272:0.120853,0.138644,0.098302,0.083064,0.073304,0.035729,-0.002231,-0.037311,-0.095347,-0.170898,-0.203658,-0.183212,-0.185436,-0.214853,-0.228561,-0.24505,-0.262642,-0.274762,-0.275366,-0.268446,-0.27978,-0.28973,-0.276016:-0.20962,-0.208058,-0.204746,-0.220959,-0.274605,-0.322519,-0.35227,-0.376716,-0.398875,-0.420629,-0.420459,-0.410497,-0.388795,-0.35803,-0.321352,-0.27699,-0.230711,-0.189754,-0.157417,-0.139305,-0.123165,-0.118181,-0.121307:0.156006,0.094968,0.035793,-0.044422,-0.10752,-0.149665,-0.168803,-0.193285,-0.210053,-0.195533,-0.192707,-0.217755,-0.221515,-0.185607,-0.131752,-0.100127,-0.085955,-0.091829,-0.096365,-0.101991,-0.105427,-0.100572,-0.09898:0.063332,0.041399,0.027781,0.042285,0.06098,0.065339,0.054007,0.069466,0.103966,0.129437,0.164145,0.200903,0.202658,0.174525,0.161724,0.149528,0.117346,0.07274,0.048278,0.034719,0.020613,0.015661,0.02114:4
1.049807,1.16086,1.068091,0.942702,0.810152,0.744964,0.659422,0.635872,0.585551,0.475624,0.373654,0.260583,0.197016,0.117321,0.085363,0.063246:-0.659494,-0.768935,-0.730629,-0.716399,-0.618784,-0.571984,-0.542145,-0.58495,-0.614086,-0.639875,-0.633887,-0.633731,-0.676273,-0.720883,-0.753726,-0.748566:0.622677,0.557022,0.438809,0.368282,0.281062,0.215333,0.176195,0.17866,0.14377,0.124234,0.173437,0.261177,0.33637,0.380718,0.416071,0.464281:-0.773797,-0.858942,-0.855003,-0.83554,-0.796638,-0.73688,-0.697631,-0.637234,-0.537028,-0.461001,-0.380263,-0.311495,-0.246084,-0.169959,-0.115226,-0.075235:-0.485876,-0.37929,-0.288101,-0.19028,-0.084765,0.013376,0.100813,0.191025,0.261672,0.337495,0.39559,0.434444,0.430873,0.423439,0.401501,0.376992:-0.294637,-0.280717,-0.27457,-0.246372,-0.213215,-0.181767,-0.170992,-0.157529,-0.16987,-0.188407,-0.159637,-0.104314,-0.098298,-0.135751,-0.160521,-0.178373:-0.429164,-0.411244,-0.369547,-0.360145,-0.325948,-0.293529,-0.263739,-0.247753,-0.233795,-0.244702,-0.299757,-0.301565,-0.261647,-0.246843,-0.24296,-0.232833:0.259635,0.301873,0.293805,0.271065,0.207896,0.139279,0.070245,-0.019053,-0.116593,-0.187619,-0.240981,-0.308748,-0.355807,-0.377006,-0.379372,-0.372352:0.24019,0.192039,0.168251,0.121533,0.050818,-0.019688,-0.07761,-0.146628,-0.183362,-0.197124,-0.188798,-0.186391,-0.20119,-0.191153,-0.165176,-0.143748:-0.166244,-0.17572,-0.181632,-0.232395,-0.284203,-0.335546,-0.348561,-0.330871,-0.323345,-0.316276,-0.277981,-0.225171,-0.196311,-0.187819,-0.182991,-0.167154:0.027635,0.006367,-0.053362,-0.0946,-0.129863,-0.140556,-0.134662,-0.102009,-0.083698,-0.065784,-0.020749,-0.027771,-0.028237,-0.0393,-0.048504,-0.056455:0.140125,0.103667,0.08338,0.080994,0.131277,0.205612,0.244537,0.287003,0.321478,0.322255,0.283302,0.212899,0.158495,0.134218,0.110689,0.078701:4
0.627726,0.672426,0.666868,0.620744,0.617482,0.599547,0.566213,0.587461,0.661623,0.70085,0.700421,0.648817,0.553062,0.429596,0.337922,0.260146,0.229494,0.25081,0.286429,0.276791:-0.484084,-0.561043,-0.567249,-0.528719,-0.545197,-0.564324,-0.53295,-0.521727,-0.582568,-0.669127,-0.717133,-0.683636,-0.663349,-0.679726,-0.727597,-0.74539,-0.761417,-0.796778,-0.819712,-0.82187:0.767235,0.735459,0.643361,0.517253,0.436496,0.376646,0.297139,0.261579,0.268893,0.270253,0.230469,0.185005,0.191794,0.214172,0.25874,0.34049,0.418498,0.472059,0.51007,0.538498:-0.687871,-0.707469,-0.704257,-0.677019,-0.672444,-0.6905,-0.684626,-0.653116,-0.631807,-0.593709,-0.564947,-0.538374,-0.513559,-0.460806,-0.424667,-0.401992,-0.362248,-0.30031,-0.242215,-0.234936:-0.519869,-0.453637,-0.390394,-0.334557,-0.275559,-0.195009,-0.074062,0.01248,0.093315,0.217861,0.310355,0.380152,0.443652,0.454319,0.448058,0.453537,0.466593,0.456967,0.441605,0.467269:-0.480874,-0.49195,-0.478466,-0.441595,-0.383791,-0.318894,-0.306164,-0.299522,-0.248785,-0.165222,-0.126446,-0.124625,-0.090332,-0.035784,0.005074,0.042163,0.054004,0.052875,0.029597,0.003629:-0.326254,-0.315859,-0.280627,-0.273735,-0.26221,-0.258533,-0.240488,-0.195975,-0.181502,-0.214063,-0.238232,-0.258188,-0.299429,-0.30208,-0.270008,-0.238538,-0.202957,-0.160426,-0.13536,-0.138669:0.212356,0.232872,0.213002,0.197984,0.211997,0.213532,0.18517,0.145494,0.080502,-0.015175,-0.072339,-0.116761,-0.185444,-0.275125,-0.314036,-0.318681,-0.315809,-0.315018,-0.308366,-0.283647:0.045339,0.047325,0.062047,0.10864,0.098122,0.058174,0.040106,0.024221,-0.035288,-0.13231,-0.172596,-0.186682,-0.198825,-0.205237,-0.223859,-0.23731,-0.238082,-0.241909,-0.260509,-0.303173:-0.024415,-0.042725,-0.05274,-0.099331,-0.173592,-0.22982,-0.235014,-0.240169,-0.248533,-0.254401,-0.252405,-0.244416,-0.221675,-0.185373,-0.148015,-0.112891,-0.095293,-0.096961,-0.102697,-0.107897:0.005748,-0.041104,-0.118542,-0.201908,-0.240695,-0.273004,-0.358804,-0.421633,-0.426728,-0.404214,-0.404182,-0.375827,-0.312646,-0.267527,-0.235044,-0.207275,-0.203566,-0.199885,-0.181051,-0.157725:0.079415,0.087471,0.096652,0.116207,0.117828,0.08689,0.078534,0.100073,0.123353,0.159246,0.168776,0.180064,0.194579,0.208417,0.174636,0.113508,0.083831,0.071811,0.065991,0.062914:4
0.675518,0.67012,0.639993,0.637341,0.624764,0.646855,0.696933,0.736928,0.706912,0.650814,0.627043,0.607326,0.527412,0.469378,0.419516,0.353992,0.328667,0.274907,0.21807,0.156686,0.124788,0.094774:-0.444676,-0.460492,-0.49932,-0.535871,-0.551199,-0.590101,-0.651895,-0.684043,-0.695671,-0.719892,-0.750775,-0.785277,-0.799897,-0.852105,-0.87898,-0.867107,-0.889309,-0.888749,-0.874559,-0.854238,-0.858964,-0.860325:0.66085,0.568052,0.478999,0.410827,0.337418,0.289449,0.287594,0.290358,0.275047,0.277286,0.307776,0.325511,0.342041,0.408311,0.520924,0.580759,0.588762,0.62519,0.680131,0.727297,0.751014,0.773661:-0.81584,-0.808053,-0.805782,-0.798291,-0.775108,-0.745803,-0.694575,-0.655636,-0.590381,-0.509878,-0.465038,-0.446773,-0.414832,-0.417034,-0.401235,-0.318032,-0.275844,-0.25795,-0.244103,-0.225102,-0.193515,-0.16699:-0.29698,-0.233962,-0.174306,-0.134392,-0.080766,-0.006226,0.077135,0.165826,0.246049,0.316024,0.376802,0.415917,0.409386,0.379105,0.316454,0.302771,0.341468,0.359909,0.365704,0.371339,0.38286,0.396448:-0.502844,-0.478107,-0.421661,-0.382619,-0.367644,-0.312648,-0.209113,-0.168514,-0.164426,-0.152978,-0.128321,-0.098132,-0.058097,-0.02147,0.003742,-0.016666,-0.030793,-0.042627,-0.029526,-0.018183,-0.022865,-0.024902:-0.395453,-0.364049,-0.316501,-0.281036,-0.250325,-0.256676,-0.291842,-0.28185,-0.237598,-0.233294,-0.277956,-0.339952,-0.367229,-0.355364,-0.292868,-0.243871,-0.253586,-0.247356,-0.242148,-0.236974,-0.229702,-0.238849:0.315835,0.32204,0.314697,0.30394,0.266413,0.20981,0.154167,0.114067,0.035406,-0.061297,-0.118966,-0.143944,-0.198543,-0.25398,-0.300566,-0.296392,-0.259072,-0.24532,-0.258126,-0.273963,-0.27896,-0.274238:0.004582,0.004272,-0.005025,-0.01382,-0.030136,-0.062495,-0.118622,-0.166003,-0.200454,-0.236707,-0.284069,-0.285519,-0.261376,-0.272946,-0.317525,-0.331075,-0.30144,-0.286952,-0.288189,-0.277203,-0.259936,-0.238802:-0.085659,-0.115972,-0.170732,-0.216046,-0.234448,-0.258602,-0.308447,-0.329358,-0.318164,-0.285829,-0.262974,-0.261686,-0.232139,-0.166917,-0.111061,-0.11253,-0.122813,-0.100776,-0.069711,-0.050361,-0.040834,-0.036912:0.064522,-0.008189,-0.095654,-0.15686,-0.196844,-0.210344,-0.202683,-0.223892,-0.262628,-0.254708,-0.19012,-0.151357,-0.144305,-0.114979,-0.042701,-0.002533,-0.036467,-0.061324,-0.053519,-0.060038,-0.079639,-0.097276:0.039081,0.032827,0.042511,0.055998,0.070421,0.093151,0.137528,0.18144,0.216803,0.234999,0.247077,0.24189,0.214867,0.154024,0.104331,0.116006,0.107305,0.06131,0.018006,-0.013313,-0.036296,-0.058695:4
1.423299,1.51271,1.316088,1.567542,1.646371,1.736118,1.545387,1.578386,1.546769,1.459222,1.279478,1.493977,1.355767:-0.414029,-0.468143,-0.418181,-0.693991,-0.759338,-0.914596,-0.892691,-1.024239,-1.066782,-1.036079,-0.936983,-1.173086,-1.124219:-0.135408,-0.208892,-0.231306,0.011871,-0.022119,0.034293,0.134156,0.338193,0.376109,0.404104,0.367466,0.556026,0.601446:-0.471968,-0.467885,-0.357043,-0.430096,-0.301961,-0.331694,-0.317395,-0.322948,-0.219322,-0.087852,0.049154,0.026073,0.09906:-0.003805,0.139967,0.122023,0.221587,0.230017,0.369124,0.467599,0.457118,0.439708,0.395648,0.341947,0.304578,0.276299:-0.333599,-0.288206,-0.144719,-0.076938,-0.041806,-0.034913,0.004263,0.079629,0.076948,0.034823,0.005999,-0.036419,-0.038903:-0.12126,-0.227572,-0.305955,-0.373547,-0.399531,-0.466226,-0.505521,-0.565506,-0.526996,-0.444659,-0.389738,-0.400689,-0.374191:0.198925,0.183572,0.104178,0.038176,-0.051384,-0.123744,-0.154759,-0.196184,-0.234147,-0.226915,-0.200393,-0.150435,-0.160207:-0.163834,-0.208869,-0.174431,-0.166935,-0.14587,-0.18954,-0.224498,-0.202749,-0.216835,-0.261594,-0.27666,-0.254235,-0.224864:-0.213314,-0.190845,-0.209544,-0.225777,-0.217794,-0.121112,-0.068414,-0.030452,0.011606,0.013222,-0.014538,-0.019306,-0.04111:-0.001098,0.012327,0.050033,0.082913,0.071226,0.057831,0.070245,0.049441,0.03548,0.055443,0.085854,0.055749,0.04539:0.15489,0.122456,0.133596,0.151499,0.162623,0.075046,0.009985,-0.061762,-0.132469,-0.169838,-0.194153,-0.220323,-0.196958:5
0.968259,1.009694,1.055981,1.086332,1.194308,1.416073,1.505777,1.402726,1.343842,1.202014,1.075136:-0.310344,-0.312461,-0.389265,-0.44674,-0.576587,-0.892707,-1.025985,-1.016966,-1.063252,-1.045305,-1.024802:-0.294631,-0.320287,-0.300259,-0.288291,-0.211835,0.007157,0.152731,0.154017,0.231529,0.354702,0.441615:-0.395854,-0.383801,-0.353002,-0.313069,-0.232207,-0.170209,-0.16223,-0.034751,0.053239,0.158995,0.173176:-0.120295,-0.033889,0.030768,0.096398,0.123737,0.213224,0.370992,0.414086,0.395905,0.365717,0.363456:-0.348526,-0.34772,-0.302531,-0.248294,-0.135673,-0.072094,-0.09708,-0.156856,-0.199295,-0.227616,-0.228571:0.112427,0.010413,-0.063143,-0.17401,-0.346117,-0.440909,-0.484261,-0.450079,-0.442178,-0.457161,-0.461955:-0.009704,-0.018865,-0.020671,-0.022601,-0.017941,-0.083643,-0.139822,-0.15621,-0.134458,-0.113958,-0.105361:0.016268,-0.029629,-0.091713,-0.117539,-0.160237,-0.149415,-0.200703,-0.229135,-0.206459,-0.168939,-0.144419:-0.358537,-0.362775,-0.318199,-0.298818,-0.235664,-0.196795,-0.07713,-0.01481,-0.025576,-0.052928,-0.042665:0.031831,0.086264,0.09675,0.092587,0.120479,0.117897,0.078677,0.048812,0.024098,0.006907,-0.022855:0.223209,0.249808,0.268845,0.251158,0.185499,0.134372,0.033109,-0.039615,-0.073237,-0.095739,-0.130102:5
1.460184,1.481248,1.488989,1.521577,1.414392,1.220458,1.181318,1.273802,1.352568,1.50684,1.469265,1.523045:-0.419061,-0.446401,-0.45848,-0.500324,-0.488299,-0.521564,-0.527674,-0.569659,-0.650796,-0.729928,-0.764466,-0.873381:-0.449685,-0.438623,-0.506995,-0.51118,-0.428191,-0.315639,-0.301415,-0.324179,-0.269556,-0.122864,-0.05418,0.058842:-0.407162,-0.349564,-0.225123,-0.16872,-0.179561,-0.303776,-0.26709,-0.045546,0.122775,0.150184,0.233852,0.295965:-0.13141,-0.16879,-0.175932,-0.103736,0.018462,0.136148,0.214532,0.201809,0.20718,0.301873,0.30205,0.294035:-0.437533,-0.39363,-0.404462,-0.44069,-0.413768,-0.337659,-0.312721,-0.222935,-0.099386,-0.150092,-0.212957,-0.204062:0.02268,0.067769,0.106157,0.112718,-0.004342,-0.142241,-0.210192,-0.319196,-0.427504,-0.428773,-0.400465,-0.425868:0.062809,0.006778,-0.037616,-0.078429,-0.103604,-0.114608,-0.120955,-0.144409,-0.175706,-0.161398,-0.199714,-0.178325:0.053023,0.009928,-0.013201,-0.053242,-0.111672,-0.117787,-0.148457,-0.145334,-0.136814,-0.177214,-0.147303,-0.122029:-0.238976,-0.248703,-0.263606,-0.247487,-0.182928,-0.190993,-0.192994,-0.170642,-0.139423,-0.102674,-0.063998,-0.08858:-0.083079,-0.045771,-0.011092,-0.006176,0.02559,0.049871,0.070366,0.08142,0.048929,0.054251,0.006016,-0.010793:0.209395,0.233601,0.242513,0.272839,0.291522,0.289347,0.260837,0.187774,0.118576,0.047119,-0.01425,-0.039726:5
1.001909,1.034091,1.153011,1.269204,1.594572,1.487305,1.313672,1.119014,1.076517,1.123845:-0.600488,-0.668848,-0.807632,-0.8814,-1.138333,-1.076212,-0.94253,-0.86543,-0.912544,-1.01755:-0.365683,-0.300521,-0.193335,-0.161929,0.048048,0.093809,0.02025,0.021891,0.161416,0.309484:-0.216401,-0.247796,-0.237088,-0.130679,-0.186205,-0.161295,0.029266,0.17473,0.190611,0.212752:-0.126352,0.00535,0.106433,0.163067,0.277043,0.376174,0.407339,0.346745,0.329108,0.307567:-0.280886,-0.258479,-0.188212,-0.109365,-0.107219,-0.160132,-0.219219,-0.210339,-0.215056,-0.208421:-0.007227,-0.146745,-0.325421,-0.448799,-0.499928,-0.496678,-0.481766,-0.513045,-0.523115,-0.507223:-0.105053,-0.063927,-0.010328,-0.012861,-0.072863,-0.142198,-0.148423,-0.113385,-0.08548,-0.067031:-0.04352,-0.12014,-0.167821,-0.166338,-0.134129,-0.120436,-0.108128,-0.104371,-0.110145,-0.125508:-0.29953,-0.235718,-0.197471,-0.187251,-0.141464,-0.024697,-0.045409,-0.09215,-0.116203,-0.128774:0.07327,0.09615,0.141937,0.177548,0.144652,0.03308,0.013009,0.021596,0.017846,0.016498:0.298139,0.296338,0.237748,0.189453,0.125573,0.06049,0.035822,-0.015491,-0.069757,-0.111355:5
1.399389,1.222501,1.110164,1.091252,1.153992,1.203706,1.324598,1.278327,1.33413,1.155002,1.193511:-0.525987,-0.608337,-0.620099,-0.611233,-0.611841,-0.7024,-0.899121,-0.90118,-0.933526,-0.827375,-0.877399:-0.699447,-0.543824,-0.467431,-0.459416,-0.472109,-0.358294,-0.140846,-0.0801,-0.017055,-0.041476,0.029014:0.047228,0.002436,-0.04427,-0.008709,0.066097,0.132887,0.135051,0.171048,0.254673,0.398457,0.479003:-0.042897,-0.092829,0.017884,0.147061,0.159227,0.190012,0.250867,0.230936,0.235285,0.172985,0.120887:-0.373916,-0.269787,-0.255227,-0.291743,-0.229957,-0.202394,-0.163108,-0.143027,-0.187809,-0.216222,-0.249215:0.070351,0.018717,-0.074644,-0.141929,-0.250878,-0.341246,-0.446975,-0.438256,-0.396394,-0.362945,-0.337342:-0.143958,-0.254017,-0.275251,-0.299598,-0.344607,-0.296584,-0.213893,-0.255925,-0.246338,-0.239645,-0.258349:-0.046557,-0.010362,-0.012167,-0.026029,0.01007,-0.037877,-0.093426,-0.045879,-0.07442,-0.078931,-0.051209:-0.253743,-0.252102,-0.227331,-0.181988,-0.15303,-0.098351,-0.069076,-0.069016,-0.057431,-0.072089,-0.073274:0.078602,0.081377,0.069297,0.061359,0.057171,0.02498,0.03573,-0.007007,-0.025877,-0.041592,-0.074506:0.223686,0.230008,0.253986,0.232897,0.162639,0.131354,0.079174,0.053941,0.01452,-0.01912,-0.052642:5
1.748348,1.75211,1.620847,1.451666,1.478104,1.261016,1.245165,1.378144,1.564721,1.417681:-0.213537,-0.360151,-0.367283,-0.283055,-0.347217,-0.35662,-0.364924,-0.516564,-0.764386,-0.70597:-0.432946,-0.463486,-0.476241,-0.554693,-0.614836,-0.509185,-0.526216,-0.379771,-0.036176,0.01598:-0.344879,-0.277267,-0.198582,-0.077336,0.091919,0.11725,0.246891,0.293294,0.21593,0.284295:0.056325,0.113012,0.134512,0.085679,0.070515,0.191792,0.224767,0.246043,0.321797,0.306757:-0.313737,-0.285806,-0.295413,-0.2362,-0.199531,-0.227838,-0.18291,-0.127002,-0.102883,-0.1272:-0.219456,-0.196319,-0.174386,-0.181804,-0.147186,-0.21919,-0.312961,-0.372499,-0.418928,-0.411638:0.133358,0.111667,0.032707,-0.109402,-0.310147,-0.395267,-0.437445,-0.400821,-0.228563,-0.22707:-0.14872,-0.2126,-0.227484,-0.176021,-0.099429,-0.028748,0.018289,-0.03696,-0.158748,-0.096186:-0.149659,-0.161062,-0.175373,-0.203813,-0.202588,-0.183142,-0.127761,-0.036015,-0.035155,-0.050196:0.013329,0.013507,0.01794,0.050268,0.084793,0.072998,0.056044,-0.00823,0.011189,-0.058259:0.174369,0.197495,0.229835,0.223889,0.145157,0.100514,0.005564,-0.014708,-0.052285,-0.074795:5
1.60387,1.588405,1.542914,1.402007,1.281099,1.5208,1.671929,1.452984,1.589042,1.719842,1.646328,1.48459,1.390018,1.395188,1.308697,1.169598:-0.826244,-0.856742,-0.885524,-0.888306,-0.879627,-1.065622,-1.221153,-1.0452,-1.127176,-1.116784,-1.123695,-0.99015,-0.966942,-0.958825,-0.872517,-0.787962:-0.182649,-0.182532,-0.143206,-0.050137,-0.051464,0.01806,0.192228,0.120786,0.255492,0.370739,0.467433,0.462853,0.603473,0.686934,0.68956,0.687643:-0.38279,-0.373585,-0.361334,-0.227847,-0.092266,-0.018996,0.039724,0.228942,0.279326,0.320788,0.355183,0.453526,0.394724,0.362835,0.402868,0.437293:-0.136875,-0.021065,0.068621,0.043107,0.103925,0.170371,0.060493,0.040759,0.110282,0.127164,0.109969,0.110831,0.131508,0.165073,0.21327,0.258623:-0.28534,-0.320881,-0.281885,-0.191579,-0.204031,-0.230173,-0.197698,-0.208839,-0.279621,-0.299521,-0.236511,-0.298635,-0.302571,-0.295655,-0.350567,-0.381691:-0.034262,-0.040746,-0.112965,-0.213159,-0.318001,-0.371765,-0.359444,-0.359762,-0.339351,-0.327162,-0.377541,-0.310347,-0.256162,-0.216076,-0.159206,-0.132303:0.192808,0.132663,0.078184,-0.027122,-0.034575,-0.044843,-0.186673,-0.234219,-0.221758,-0.192112,-0.158311,-0.138778,-0.09402,-0.088268,-0.086878,-0.089175:-0.235538,-0.321181,-0.369033,-0.294062,-0.276514,-0.263086,-0.145267,-0.062172,-0.074325,-0.094182,-0.015314,-0.038433,-0.097887,-0.174491,-0.228204,-0.226352:-0.152638,-0.106415,-0.108857,-0.136896,-0.147338,-0.180539,-0.131538,-0.119372,-0.054021,-0.052542,-0.114233,-0.097119,-0.075977,-0.051398,-0.033979,-0.022753:0.15501,0.172335,0.196705,0.198388,0.194702,0.177772,0.033355,-0.030076,-0.073565,-0.09881,-0.142456,-0.139427,-0.11934,-0.118374,-0.148677,-0.200541:0.161899,0.183583,0.178259,0.178723,0.153037,0.13668,0.14161,0.118469,0.044609,-0.005373,-0.03595,-0.069742,-0.107242,-0.157154,-0.173186,-0.1828:5
1.770142,1.767525,1.713222,1.684382,1.687577,1.673291,1.531162,1.388998,1.272126,1.32788,1.254334,1.147437,1.106027:-0.447507,-0.451937,-0.424716,-0.484778,-0.477237,-0.504103,-0.54466,-0.497741,-0.535238,-0.757166,-0.787372,-0.760258,-0.747171:-0.327904,-0.377286,-0.400731,-0.382934,-0.479146,-0.512959,-0.282666,-0.11833,0.038888,0.2542,0.335716,0.398406,0.461208:-0.099235,-0.099952,-0.084833,-0.038123,0.180229,0.293891,0.123535,0.052825,0.138766,0.171098,0.239595,0.310894,0.385662:-0.204079,-0.139337,-0.08065,-0.029512,-0.123488,-0.043976,0.145676,0.248434,0.270448,0.279139,0.250844,0.22745,0.198324:-0.4953,-0.432889,-0.377412,-0.330876,-0.242549,-0.256272,-0.21111,-0.152284,-0.069086,-0.01637,-0.033707,-0.068287,-0.084397:0.133017,0.07254,0.027675,-0.014656,-0.055356,-0.079768,-0.196701,-0.327102,-0.409946,-0.390387,-0.337279,-0.308118,-0.304805:0.083897,0.065335,0.038919,0.023732,-0.156878,-0.255478,-0.21661,-0.223815,-0.251833,-0.206154,-0.172237,-0.135063,-0.117923:-0.077626,-0.113919,-0.144564,-0.182053,-0.134329,-0.146231,-0.176539,-0.111138,-0.077893,-0.148803,-0.167453,-0.185613,-0.168476:-0.175459,-0.17491,-0.174708,-0.194373,-0.215633,-0.228437,-0.205507,-0.194271,-0.116656,-0.062508,-0.060381,-0.058997,-0.073638:-2.16E-4,0.018106,0.020592,0.019428,0.06535,0.106515,0.032719,-0.00544,-0.026886,-0.001005,-0.022559,-0.04066,-0.061945:0.186314,0.206948,0.211507,0.220892,0.201934,0.190864,0.219282,0.143619,0.035552,-0.057411,-0.110606,-0.166425,-0.200954:5
1.72988,1.748611,1.688752,1.595383,1.433396,1.396363,1.527701,1.60134,1.635056,1.646816,1.715973:-0.501307,-0.454131,-0.436952,-0.471569,-0.516403,-0.501067,-0.579897,-0.740714,-0.864132,-0.817267,-0.859732:-0.293007,-0.379859,-0.530808,-0.552539,-0.356275,-0.314771,-0.267117,-0.088245,0.115757,0.052091,0.096773:-0.445558,-0.336968,-0.148462,-0.069147,-0.154531,-0.167316,-0.126891,-0.101505,-0.155892,-0.030052,0.120457:-0.060728,-0.074796,-0.149036,-0.17078,0.0148,0.141736,0.22174,0.303478,0.397316,0.379207,0.267847:-0.212499,-0.195179,-0.16707,-0.10145,-0.055343,-0.044578,-0.009134,0.0415,0.028482,0.006747,-0.059297:-0.21741,-0.193609,-0.123274,-0.117679,-0.25741,-0.299162,-0.356131,-0.463039,-0.498837,-0.477097,-0.39679:0.203038,0.155637,-0.036024,-0.178685,-0.14564,-0.209598,-0.254738,-0.22155,-0.218746,-0.199804,-0.186029:-0.003312,-0.027842,0.006591,0.03651,-0.032252,-0.058382,-0.096883,-0.144459,-0.179566,-0.177213,-0.147885:-0.207509,-0.209991,-0.215807,-0.238066,-0.239205,-0.219943,-0.152792,-0.132821,-0.088907,-0.091712,-0.100391:-0.031733,-0.04336,-0.075275,-0.078716,-0.035463,-0.018684,-0.021038,0.042637,0.066511,0.076532,0.054407:0.110097,0.150329,0.175529,0.168775,0.201736,0.167217,0.10181,0.032774,-0.028838,-0.052886,-0.031585:5
1.662041,1.739663,1.628943,1.447523,1.378272,1.502423,1.64623,1.680896,1.492372,1.672588,1.542639,1.297767,1.238633,1.178052,1.143014:-0.354907,-0.579203,-0.654443,-0.604071,-0.594551,-0.715501,-0.915923,-1.038834,-0.876709,-1.037287,-1.028665,-0.879507,-0.849246,-0.894896,-0.91715:-0.342654,-0.192513,-0.170419,-0.195346,-0.202481,-0.12256,0.031449,0.195475,0.101402,0.303466,0.408481,0.350573,0.387479,0.506227,0.59874:-0.195395,-0.312483,-0.358178,-0.351915,-0.330984,-0.259096,-0.091997,-0.099125,0.032403,-0.005894,0.031003,0.143274,0.168194,0.153077,0.181026:-0.258822,-0.207655,-0.083412,0.047501,0.137901,0.150372,0.162767,0.256331,0.269569,0.303815,0.285781,0.301959,0.315274,0.292469,0.264313:-0.204335,-0.124857,-0.095546,-0.144905,-0.111833,0.025277,0.066929,0.031974,-0.030788,-0.101322,-0.079966,-0.108699,-0.113125,-0.109377,-0.094927:-0.077488,-0.174699,-0.228882,-0.218202,-0.301674,-0.462018,-0.524795,-0.552822,-0.53485,-0.536678,-0.515314,-0.480246,-0.459811,-0.42115,-0.414282:-0.027152,-0.010406,-0.027968,-0.097133,-0.143548,-0.157005,-0.189083,-0.192073,-0.159992,-0.134071,-0.135101,-0.080946,-0.072763,-0.079026,-0.047893:0.04786,0.034306,-0.007292,-0.03262,-0.050188,-0.053552,-0.047101,-0.05855,-0.070996,-0.083794,-0.094505,-0.138448,-0.150343,-0.166481,-0.174088:-0.222493,-0.254112,-0.257778,-0.239622,-0.244157,-0.251683,-0.238569,-0.192868,-0.179795,-0.147286,-0.160051,-0.203561,-0.18389,-0.151084,-0.167153:-0.040611,-0.045798,-0.019536,-0.030546,0.011157,0.074289,0.094972,0.098135,0.091629,0.059397,0.053923,0.079933,0.070376,0.069882,0.088972:0.21331,0.264923,0.245126,0.249863,0.249741,0.223278,0.219112,0.161358,0.127671,0.066117,0.02968,0.008538,-0.025494,-0.073496,-0.128101:5
1.922817,1.912945,1.896985,1.525179,1.336438,1.345409,1.400484,1.395274,1.593758,1.75814,1.79038:-0.56836,-0.552464,-0.54173,-0.50801,-0.449485,-0.419459,-0.559314,-0.66638,-0.919763,-1.101076,-1.037525:-0.291337,-0.460799,-0.510057,-0.319601,-0.270414,-0.292573,-0.24572,-0.098185,0.210136,0.43003,0.40059:-0.406118,-0.199297,-0.095613,-0.274393,-0.284047,-0.189698,-0.051041,0.070569,0.07914,0.075229,0.220838:0.142871,0.09059,0.037217,0.180777,0.292059,0.335546,0.393359,0.383609,0.379153,0.31512,0.261863:-0.330526,-0.351441,-0.315686,-0.182003,-0.175014,-0.165592,-0.186718,-0.143892,-0.197501,-0.17132,-0.158905:-0.246207,-0.116801,-0.106708,-0.344703,-0.450078,-0.446055,-0.38821,-0.410095,-0.412028,-0.460928,-0.433381:0.189814,-0.008514,-0.141978,-0.041774,-0.06004,-0.205181,-0.268839,-0.243137,-0.223057,-0.203818,-0.170579:-0.179272,-0.123704,-0.064107,-0.127324,-0.151297,-0.104647,-0.15096,-0.171368,-0.175847,-0.188268,-0.14167:-0.107565,-0.114526,-0.146237,-0.173385,-0.16165,-0.116184,-0.00785,0.013125,0.043715,0.032145,-0.07768:0.053891,-8.17E-4,0.003212,0.065756,0.114595,0.089922,0.042904,0.042996,-0.009724,-0.007339,0.01755:0.132842,0.234424,0.250779,0.192663,0.128417,0.128793,0.104253,0.041813,-0.036,-0.115793,-0.077926:5
1.546996,1.754347,1.693531,1.505526,1.60383,1.38199,1.337336,1.564253,1.470411,1.279952,1.361118,1.356745,1.378065,1.28204,1.27188:-0.598716,-0.861942,-0.9176,-0.776513,-0.829211,-0.800872,-0.861817,-1.135149,-1.130426,-1.012413,-1.091154,-1.113761,-1.135371,-1.052619,-1.014657:-0.207235,-0.118766,-0.054606,-0.181409,-0.169911,-0.203757,-0.110927,0.141895,0.199036,0.152732,0.282088,0.404718,0.508954,0.495373,0.489636:-0.527667,-0.442036,-0.463647,-0.339018,-0.32048,-0.204455,-0.139855,-0.140094,-0.119247,0.059928,0.056665,0.028648,0.089196,0.170552,0.208683:0.030746,0.097884,0.094252,0.022857,0.055428,0.146018,0.181964,0.236326,0.334219,0.334716,0.349046,0.35576,0.344602,0.345114,0.323105:-0.306251,-0.318425,-0.269348,-0.153415,0.024936,0.065602,0.090899,0.095158,-0.038853,-0.092653,-0.131711,-0.172081,-0.20878,-0.225174,-0.224143:-0.186709,-0.203324,-0.161514,-0.171467,-0.362632,-0.473968,-0.519094,-0.556639,-0.533329,-0.45537,-0.430876,-0.428624,-0.444945,-0.438354,-0.414873:0.288002,0.272758,0.12257,-0.046987,-0.090526,-0.16235,-0.211486,-0.249157,-0.23998,-0.24563,-0.19222,-0.104775,-0.052049,-0.042692,-0.061712:-0.149093,-0.229396,-0.22326,-0.086553,-0.033337,-0.03145,-0.034914,-0.042238,-0.103014,-0.170102,-0.230894,-0.265656,-0.263721,-0.25437,-0.257328:-0.209914,-0.181805,-0.16019,-0.232367,-0.285844,-0.251024,-0.217876,-0.175991,-0.079321,-0.029076,-0.014921,-0.06225,-0.094897,-0.113202,-0.090609:-0.035129,6.7E-4,-0.069482,-0.082585,-0.010038,0.02313,0.040254,0.069223,0.012323,0.037235,0.053531,0.066314,0.066134,0.062984,0.05926:0.037672,0.028829,0.145932,0.235945,0.22612,0.192803,0.176731,0.127296,0.058159,-0.002641,-0.068146,-0.085427,-0.116146,-0.145563,-0.18154:5
1.755041,1.710863,1.746167,1.50984,1.321895,1.270163,1.262094,1.374747,1.42307,1.540644,1.69507,1.491456,1.329822,1.182707,1.227005,1.284823:-0.638123,-0.654687,-0.649083,-0.646007,-0.656835,-0.682978,-0.681443,-0.744319,-0.835929,-0.981518,-1.182098,-1.118505,-1.018258,-0.950971,-1.011976,-1.105233:-0.300339,-0.280749,-0.304607,-0.193041,-0.181663,-0.147993,-0.141573,-0.111164,-0.023031,0.169627,0.415842,0.436871,0.46717,0.464283,0.555243,0.700763:-0.152404,-0.078974,-0.045844,-0.167874,-0.132188,-0.090765,0.005302,0.127123,0.210086,0.184625,0.138869,0.199416,0.232575,0.376907,0.397608,0.359481:-0.075077,-0.078887,-0.133468,1.47E-4,0.100303,0.183345,0.16497,0.103139,0.103279,0.181722,0.208217,0.200161,0.223856,0.197198,0.19106,0.160869:-0.389822,-0.381196,-0.240739,-0.146639,-0.140179,-0.167712,-0.107663,-0.078362,-0.082244,-0.120662,-0.12305,-0.099049,-0.088365,-0.09829,-0.1328,-0.140686:0.077029,0.046801,-0.051984,-0.175192,-0.26383,-0.321073,-0.386882,-0.373627,-0.389201,-0.403278,-0.455414,-0.451847,-0.46738,-0.422229,-0.361978,-0.332656:0.003134,-0.089458,-0.160721,-0.136054,-0.145414,-0.189202,-0.225653,-0.291249,-0.24317,-0.193961,-0.186499,-0.207606,-0.191485,-0.187567,-0.175746,-0.128187:-0.121792,-0.088533,-0.064456,-0.105213,-0.092936,-0.063904,-0.056536,-0.057091,-0.115667,-0.145635,-0.142085,-0.121377,-0.092797,-0.099937,-0.130597,-0.142434:-0.133251,-0.122094,-0.134352,-0.169658,-0.165753,-0.132444,-0.106999,-0.06408,-0.055651,-0.085472,-0.085025,-0.099413,-0.114139,-0.086594,-0.054128,-0.068887:0.009349,0.023585,0.039899,0.081705,0.083648,0.064532,0.073226,0.036372,0.046467,0.060721,0.047093,0.028079,0.00805,-0.002111,7.75E-4,0.001512:0.250985,0.271394,0.260696,0.289485,0.258746,0.218667,0.16447,0.1202,0.067751,0.015369,-0.044808,-0.054023,-0.056008,-0.077571,-0.128311,-0.164092:5
1.299392,1.366765,1.319906,1.283447,1.185227,1.091419,1.165801,1.090753,1.104012,1.220469,1.177543,1.118386,1.127855:-0.12667,-0.284393,-0.252485,-0.211805,-0.216307,-0.301233,-0.479606,-0.548473,-0.717071,-0.919114,-0.885241,-0.836398,-0.90395:-0.604044,-0.58063,-0.579133,-0.695265,-0.710176,-0.521411,-0.283695,-0.190518,-0.022708,0.219881,0.291425,0.355181,0.490317:-0.313858,-0.160223,-0.063994,0.103142,0.211977,0.13751,0.049464,0.117174,0.230701,0.221974,0.21468,0.222211,0.265124:0.088027,0.11904,0.136886,0.144228,0.142556,0.097974,0.152473,0.166647,0.170169,0.233595,0.265679,0.277589,0.292118:-0.443261,-0.44868,-0.463274,-0.391113,-0.285911,-0.134664,-0.076,-0.064019,-0.035772,-0.093007,-0.07804,-0.064657,-0.076849:-0.005616,-0.023954,0.011497,-0.008101,-0.130357,-0.326613,-0.412065,-0.424278,-0.462915,-0.426083,-0.441085,-0.442679,-0.439088:-0.048637,-0.012534,-0.096327,-0.233461,-0.310726,-0.320587,-0.288765,-0.305881,-0.250634,-0.160715,-0.125379,-0.115795,-0.095586:-0.045513,-0.120944,-0.092461,-0.054865,-0.019971,0.044116,0.016554,0.02387,-0.052244,-0.154975,-0.169887,-0.167451,-0.156674:-0.199639,-0.153217,-0.178769,-0.193373,-0.196288,-0.220417,-0.213622,-0.187141,-0.104943,-0.119071,-0.141467,-0.147301,-0.150637:-0.033302,-0.057804,-0.028188,0.051773,0.103125,0.109115,0.053114,0.015685,-0.013333,0.050038,0.055429,0.045144,0.039638:0.239255,0.26804,0.29806,0.238552,0.143171,0.100321,0.156473,0.118749,0.060936,-0.015431,-0.067608,-0.107523,-0.138726:5
2.155408,1.973524,1.591861,1.355199,1.376594,1.481708,1.691958,1.692228,1.890113,1.653559,1.535545,1.3926,1.446593,1.421477,1.281972,1.088593,1.099712:-1.158249,-1.217638,-1.073162,-0.90003,-0.886301,-1.003036,-1.20242,-1.245346,-1.460497,-1.360295,-1.25091,-1.171693,-1.284933,-1.319728,-1.31705,-1.208712,-1.249126:-0.203715,-0.098435,-0.125487,-0.217096,-0.240316,-0.194116,-0.025834,0.012114,0.154921,0.199084,0.205811,0.240308,0.365134,0.407481,0.484141,0.466064,0.558733:-0.248647,-0.365268,-0.418323,-0.372664,-0.362973,-0.30884,-0.305574,-0.222295,-0.209624,-0.10196,-0.032065,0.013281,0.024417,0.105612,0.131743,0.195704,0.157548:-0.287806,-0.170218,-0.063529,-0.028256,0.037165,0.120138,0.193954,0.249942,0.243039,0.275144,0.308975,0.356371,0.3448,0.329498,0.307984,0.308404,0.313545:-0.117102,-0.091826,-0.098494,-0.075395,-0.078697,-0.037053,-0.023236,-0.024732,-0.02927,-0.058949,-0.115751,-0.163675,-0.190184,-0.217486,-0.194849,-0.159652,-0.145454:-0.109316,-0.184538,-0.234393,-0.270137,-0.268713,-0.365522,-0.444454,-0.496865,-0.549218,-0.540866,-0.501496,-0.484313,-0.485434,-0.444164,-0.427458,-0.410378,-0.397761:0.05586,0.055163,6.77E-4,-0.073471,-0.173463,-0.17317,-0.147247,-0.141424,-0.138585,-0.178553,-0.199336,-0.164984,-0.101426,-0.099466,-0.098059,-0.129843,-0.133634:-0.026856,-0.045932,-0.047717,-0.009744,0.005577,-0.059969,-0.129458,-0.156477,-0.155809,-0.130382,-0.149566,-0.206436,-0.239798,-0.241269,-0.215239,-0.193623,-0.204844:-0.240746,-0.263036,-0.23713,-0.260933,-0.225279,-0.170718,-0.142686,-0.148384,-0.125215,-0.110208,-0.072828,-0.060051,-0.066483,-0.041644,-0.050285,-0.050154,0.002413:-0.040158,-0.028516,-0.029984,-0.017276,-0.046424,0.012667,0.083581,0.140534,0.123328,0.075661,0.028305,0.046235,0.050701,0.029349,0.005466,0.004007,-0.032238:0.19501,0.194783,0.217569,0.272094,0.293689,0.211426,0.135833,0.088514,-0.003656,0.016347,-0.005444,-0.061098,-0.121314,-0.146577,-0.160047,-0.175651,-0.249195:5
1.249807,1.283523,1.25931,1.428841,1.421192,1.244462,1.128602,0.980392,0.886651,1.014829,1.344021,1.391887,1.307744,1.179044:-0.207269,-0.284112,-0.330734,-0.52533,-0.634027,-0.605778,-0.598502,-0.533146,-0.518596,-0.619201,-0.971182,-1.04149,-1.013905,-0.918959:-0.713856,-0.740845,-0.745858,-0.609818,-0.43004,-0.285868,-0.226464,-0.243711,-0.232363,-0.133452,0.192526,0.359664,0.410172,0.39137:-0.17548,-0.120427,-0.003484,0.066923,-0.010591,-0.098955,0.016889,0.206605,0.32421,0.344036,0.253105,0.216891,0.279698,0.344871:-0.027406,0.01597,0.024436,0.020582,0.092374,0.213693,0.228302,0.166718,0.14962,0.133415,0.221512,0.247975,0.222175,0.208578:-0.371625,-0.331744,-0.278896,-0.261589,-0.217984,-0.151713,-0.10441,-0.104031,-0.131912,-0.096982,-0.056464,-0.083956,-0.101982,-0.112593:0.042353,0.022673,-0.008122,-0.017541,-0.11954,-0.319375,-0.431145,-0.40711,-0.383052,-0.410475,-0.469726,-0.452384,-0.419264,-0.409046:-0.096435,-0.144858,-0.205201,-0.252228,-0.290108,-0.285054,-0.306054,-0.390291,-0.404676,-0.366996,-0.260594,-0.211643,-0.183793,-0.160424:0.081202,0.02289,-0.017477,-0.104204,-0.112721,-0.063142,-0.02803,0.064236,0.090673,0.044713,-0.062999,-0.096977,-0.103462,-0.08005:-0.307478,-0.301371,-0.289277,-0.217014,-0.160151,-0.162331,-0.169447,-0.194515,-0.197412,-0.15361,-0.121436,-0.134288,-0.140803,-0.150476:-0.050133,-0.014923,0.015958,0.025035,-0.005578,0.016837,0.047216,0.029286,0.024145,-0.037871,-0.034727,-0.023884,-0.025144,-0.046161:0.12961,0.157076,0.152902,0.169847,0.191262,0.179529,0.143457,0.097859,0.033263,0.034572,0.001297,-0.029821,-0.048493,-0.060619:5
1.130519,1.18189,1.224508,1.380101,1.447833,1.532136,1.621891,1.74663,1.656105,1.820898,1.582431,1.492526,1.346958,1.471634,1.391841,1.141134:-0.519982,-0.632413,-0.692391,-0.781057,-0.84542,-0.976843,-1.121597,-1.233805,-1.137711,-1.341841,-1.280889,-1.281561,-1.185063,-1.286196,-1.300697,-1.192192:-0.178532,-0.18824,-0.198983,-0.155016,-0.139901,-0.086709,-0.035189,0.004446,-0.105593,0.107954,0.209233,0.260483,0.250021,0.376879,0.452772,0.529097:-0.540106,-0.444173,-0.377872,-0.409464,-0.382263,-0.328722,-0.194148,-0.111706,0.089322,0.034889,0.02749,0.087058,0.164442,0.146264,0.175306,0.186111:0.008564,0.01791,0.064239,0.11531,0.177907,0.245146,0.249304,0.237379,0.196752,0.257468,0.32155,0.338048,0.391603,0.415481,0.423721,0.450969:-0.309625,-0.288221,-0.264716,-0.224015,-0.226469,-0.221882,-0.173904,-0.180272,-0.138395,-0.106535,-0.11992,-0.176448,-0.23842,-0.302252,-0.30343,-0.275116:-0.192313,-0.22753,-0.257128,-0.28633,-0.298333,-0.335355,-0.395839,-0.352441,-0.352709,-0.446837,-0.462885,-0.442788,-0.413752,-0.402843,-0.382481,-0.390694:0.257031,0.259864,0.226779,0.162066,0.121012,0.066521,-0.017964,-0.175046,-0.277684,-0.231694,-0.213668,-0.197307,-0.175647,-0.101355,-0.060105,-0.04373:-0.111029,-0.173892,-0.224626,-0.236823,-0.29157,-0.308727,-0.252132,-0.227785,-0.15989,-0.193519,-0.226233,-0.21113,-0.214006,-0.257881,-0.25916,-0.225231:-0.274902,-0.245525,-0.227047,-0.210757,-0.185607,-0.145131,-0.152761,-0.051328,-0.065105,-0.052514,0.00141,0.014747,0.011363,0.048184,0.037974,0.008563:0.017606,0.04929,0.081144,0.108599,0.138937,0.153119,0.16261,0.035714,0.029224,0.087133,0.090179,0.024182,-0.017986,-0.083281,-0.109343,-0.119639:0.116174,0.125122,0.1369,0.131721,0.133112,0.122537,0.131336,0.104095,0.109562,0.005736,-0.093471,-0.115149,-0.118604,-0.188185,-0.219809,-0.221551:5
1.230398,1.231134,1.098764,1.050631,1.229118,1.260656,1.270842,1.213678,1.12355,1.15003,1.240346,1.399282,1.440981,1.308008,1.316323:-0.030643,-0.156609,-0.148553,-0.170413,-0.297681,-0.447592,-0.520676,-0.64781,-0.663078,-0.738368,-0.88537,-1.070935,-1.176805,-1.125547,-1.13659:-0.518542,-0.435772,-0.433825,-0.515685,-0.545203,-0.478134,-0.453751,-0.252412,-0.183239,-0.082353,0.128964,0.355736,0.481216,0.464175,0.509776:-0.37281,-0.357963,-0.405003,-0.403839,-0.313287,-0.182953,-0.018978,-0.108975,0.018334,0.103292,0.084213,0.023436,0.036306,0.156079,0.218263:-0.042613,0.007101,0.181533,0.286926,0.243395,0.199315,0.123415,0.284836,0.29458,0.321335,0.40806,0.403018,0.358733,0.339999,0.318558:-0.331788,-0.317158,-0.375816,-0.363844,-0.228439,-0.131891,-0.052065,-0.061741,-0.061165,-0.064336,-0.095323,-0.109994,-0.114949,-0.119791,-0.11368:-0.130243,-0.133727,-0.111843,-0.118189,-0.186359,-0.239173,-0.296518,-0.415813,-0.457092,-0.493031,-0.546418,-0.546203,-0.562496,-0.543627,-0.52093:0.091874,0.091174,0.055965,-0.004694,-0.03443,-0.120675,-0.292939,-0.250694,-0.267327,-0.253646,-0.169089,-0.145808,-0.126202,-0.119953,-0.109016:0.103976,0.040191,-0.057393,-0.147789,-0.167168,-0.138204,-0.02104,-0.055917,-0.069904,-0.104977,-0.16799,-0.186547,-0.157426,-0.127181,-0.105388:-0.279761,-0.246805,-0.191548,-0.18864,-0.21982,-0.225515,-0.234036,-0.205849,-0.145276,-0.084204,-0.062618,-0.060652,-0.090333,-0.137741,-0.154052:-0.040443,-0.069909,-0.063814,-0.021451,0.018076,0.046176,0.036649,0.036779,0.035949,0.027778,0.070632,0.060903,0.03255,0.024906,-8.03E-4:0.061319,0.114797,0.150383,0.194006,0.194729,0.206352,0.201348,0.16368,0.104279,0.038104,-0.071433,-0.13205,-0.142315,-0.127642,-0.132004:5
1.526301,1.415691,1.277618,1.151898,1.102075,1.153958,1.233105,1.265676,1.350301,1.412096,1.297884,1.272737,1.230836,1.186856,1.025153:-0.486333,-0.535632,-0.466523,-0.393179,-0.364531,-0.3434,-0.394168,-0.508189,-0.657762,-0.761975,-0.700666,-0.672332,-0.643823,-0.597067,-0.433934:-0.257145,-0.193298,-0.191236,-0.272755,-0.306085,-0.327998,-0.290097,-0.225113,-0.119203,0.032521,0.069361,0.135594,0.18765,0.197186,0.223899:-0.240068,-0.275869,-0.242046,-0.164681,-0.097778,-0.034728,0.052094,0.202282,0.314191,0.331262,0.389202,0.418508,0.407994,0.383667,0.347582:-0.005696,0.09164,0.085859,0.056697,0.081606,0.154702,0.234405,0.2492,0.257793,0.329618,0.344532,0.303457,0.333053,0.380322,0.361335:-0.241896,-0.206792,-0.160263,-0.110968,-0.078958,-0.07826,-0.081715,-0.076193,-0.059611,-0.098293,-0.09684,-0.103586,-0.137984,-0.152083,-0.121354:-0.094353,-0.137633,-0.169782,-0.19431,-0.230299,-0.268919,-0.303382,-0.331346,-0.358944,-0.322418,-0.346489,-0.334913,-0.347697,-0.402919,-0.388825:-0.040407,-0.056579,-0.163426,-0.238871,-0.302152,-0.385443,-0.435691,-0.355174,-0.299382,-0.283948,-0.207952,-0.167882,-0.096301,-0.061596,-0.140304:-0.042048,-0.108849,-0.031064,0.010774,0.032701,0.078523,0.094718,-0.010224,-0.072144,-0.110271,-0.13368,-0.129856,-0.146826,-0.134751,-0.078335:-0.207862,-0.189839,-0.26858,-0.336102,-0.33215,-0.291311,-0.232138,-0.138194,-0.085831,-0.070174,-0.088392,-0.10868,-0.127513,-0.124105,-0.099115:-0.078995,-0.051519,-0.038602,0.021666,0.047081,0.049173,0.011757,-0.030574,-0.0582,-0.084783,-0.07755,-0.078665,-0.071534,-0.073807,-0.098313:0.201097,0.211602,0.265043,0.252681,0.221306,0.166333,0.136356,0.079396,0.022742,-0.027736,-0.067318,-0.081426,-0.107363,-0.164377,-0.200853:5
1.570668,1.267867,1.245996,1.404003,1.197055,1.041587,0.958736,1.133215,1.353092,1.337928:-0.593899,-0.3745,-0.434283,-0.719145,-0.741532,-0.737811,-0.723183,-0.883253,-1.050504,-1.083261:-0.331384,-0.510466,-0.418046,-0.087808,0.01076,0.083378,0.149518,0.33103,0.521715,0.593297:-0.125316,-0.001935,-0.018644,-0.181703,-0.164155,-0.062769,0.010157,0.009518,-0.014904,0.008724:0.093562,0.185174,0.220659,0.3229,0.395771,0.360321,0.338441,0.369391,0.343364,0.309948:-0.216672,-0.296855,-0.197726,-0.022806,-0.022147,0.010434,0.068066,0.047233,-0.006946,-0.027043:-0.195081,-0.107916,-0.18826,-0.389683,-0.385053,-0.352126,-0.37194,-0.360896,-0.356042,-0.352804:-0.115169,-0.262963,-0.342263,-0.287988,-0.311323,-0.327821,-0.308852,-0.286167,-0.235439,-0.208999:-0.145788,-0.081037,-0.046293,-0.11911,-0.170247,-0.233591,-0.257283,-0.271437,-0.296389,-0.306973:-0.198155,-0.229471,-0.214569,-0.134527,-0.068172,-0.002226,0.028796,0.039431,0.052834,0.033019:-0.02441,-0.016414,-0.020451,-0.039322,-0.069915,-0.065101,-0.050577,-0.028261,-0.024667,-0.007869:0.212642,0.209941,0.174523,0.122807,0.063271,-0.021153,-0.111846,-0.190146,-0.259201,-0.294171:5
1.58341,1.739226,1.851196,1.53491,1.406083,1.293973,1.188739,1.203384,1.24948,1.329428,1.42761,1.244784,1.054814,1.182488,1.272596:-0.296294,-0.4476,-0.703973,-0.63074,-0.655586,-0.637631,-0.603397,-0.625077,-0.693706,-0.838033,-0.968755,-0.863934,-0.75198,-0.853402,-0.908471:-0.321318,-0.349438,-0.276686,-0.322918,-0.259771,-0.21587,-0.221612,-0.200326,-0.103707,0.082767,0.241756,0.233917,0.221842,0.325886,0.39611:-0.320653,-0.229136,-0.203538,-0.173946,-0.193113,-0.148121,-0.023996,0.077546,0.173354,0.22239,0.175664,0.2819,0.334171,0.334307,0.377472:-0.174438,-0.108732,0.008677,0.056774,0.148343,0.211836,0.191031,0.19251,0.189848,0.213276,0.273364,0.259634,0.241766,0.253584,0.224031:-0.131914,-0.188459,-0.154665,-0.124797,-0.112909,-0.123614,-0.080185,-0.069705,-0.045613,-0.007355,-0.038183,-0.0166,-0.015113,0.00106,8.34E-4:-0.235671,-0.219653,-0.204799,-0.231496,-0.296459,-0.310226,-0.327298,-0.359238,-0.398722,-0.434656,-0.430744,-0.452615,-0.462397,-0.464156,-0.428234:0.025245,0.078641,-0.013281,-0.177528,-0.235546,-0.324728,-0.423925,-0.414148,-0.352998,-0.286745,-0.220005,-0.185754,-0.169854,-0.157948,-0.178598:0.073504,-0.090687,-0.139131,-0.045931,-0.025853,-0.015456,0.032681,0.020453,-0.049804,-0.135741,-0.175805,-0.161269,-0.132904,-0.132604,-0.121551:-0.331927,-0.231951,-0.18982,-0.200242,-0.220675,-0.212679,-0.202469,-0.16899,-0.13457,-0.124786,-0.14388,-0.151447,-0.150053,-0.168642,-0.181681:-0.053182,-0.00802,0.014005,-0.055895,-0.049869,-0.042525,-0.026632,-0.036349,-0.039604,-0.004194,0.038405,0.035106,0.009568,0.02383,-0.004882:0.209883,0.189923,0.177992,0.201431,0.221402,0.230649,0.19355,0.136499,0.088283,0.029766,-0.028876,-0.062855,-0.081935,-0.1111,-0.105115:5
1.427072,1.44371,1.438543,1.481347,1.565607,1.544981,1.625813,1.548601,1.394779,1.326866,1.412961,1.526085,1.534825,1.383175:-0.222422,-0.244394,-0.335646,-0.466287,-0.626038,-0.701536,-0.837721,-0.885484,-0.855231,-0.847615,-0.959283,-1.098841,-1.178025,-1.082219:-0.469086,-0.535972,-0.47826,-0.397246,-0.37206,-0.380964,-0.298488,-0.233792,-0.167857,-0.101614,0.051419,0.185668,0.317576,0.326443:-0.186184,-0.112787,-0.214565,-0.288006,-0.245182,-0.099162,-0.051591,-0.040407,-0.020565,0.102772,0.141901,0.247919,0.289823,0.352626:-0.380881,-0.415374,-0.323251,-0.192153,-0.059836,-0.006392,0.005473,0.037683,0.132738,0.129636,0.135555,0.112619,0.150434,0.112249:-0.317965,-0.248766,-0.206607,-0.193075,-0.209722,-0.28107,-0.254178,-0.131074,-0.077011,-0.070759,-0.012428,0.041174,-0.006176,0.056178:0.058207,0.002799,-0.053461,-0.110216,-0.125326,-0.057083,-0.068869,-0.232934,-0.375436,-0.352374,-0.392227,-0.424873,-0.41088,-0.395705:-0.118218,-0.072243,-0.052457,-0.023034,-0.004926,-0.122997,-0.242779,-0.286562,-0.308447,-0.346211,-0.319049,-0.267575,-0.229065,-0.25728:0.230241,0.198299,0.125849,0.004323,-0.126243,-0.151394,-0.146445,-0.093575,-0.038351,-0.060035,-0.097243,-0.13102,-0.145749,-0.140433:-0.324402,-0.36947,-0.362883,-0.307231,-0.237144,-0.17368,-0.125591,-0.137514,-0.156353,-0.119843,-0.119619,-0.174617,-0.20051,-0.15988:-0.068986,-0.074413,-0.069531,-0.038147,-0.012356,-0.015145,-0.035103,-0.035397,-0.025073,-0.031275,-0.022457,0.023097,0.022224,0.003285:0.037855,0.063554,0.163945,0.218216,0.204746,0.203762,0.204309,0.201527,0.183144,0.136165,0.080507,0.055513,0.023695,-0.01905:5
1.284522,1.196714,1.413169,1.309015,1.26798,1.395919,1.475957,1.430299,1.486687,1.404189,1.174027,1.089506,1.082318,1.426947,1.362538,1.185653,1.020894,0.993937:0.08736,0.182789,-0.114233,-0.141086,-0.211863,-0.374314,-0.451238,-0.48459,-0.661397,-0.760437,-0.743172,-0.749555,-0.803542,-1.132396,-1.138022,-1.084,-0.961654,-0.948789:-0.569067,-0.601179,-0.672964,-0.69672,-0.650913,-0.570787,-0.579512,-0.565636,-0.369753,-0.214134,-0.144236,-0.055509,0.042086,0.324592,0.39962,0.424746,0.374054,0.413034:-0.218471,-0.24243,-0.129153,-0.07238,-0.062356,-0.059455,0.040956,0.148931,0.172873,0.182364,0.188414,0.21381,0.243998,0.204386,0.224847,0.265119,0.327317,0.340192:-0.085278,0.050858,0.011789,0.017051,0.078395,0.15754,0.161245,0.152465,0.253765,0.302969,0.303088,0.308395,0.294858,0.317222,0.303134,0.284402,0.260995,0.259029:-0.56198,-0.496921,-0.456565,-0.404203,-0.385193,-0.375625,-0.264031,-0.178173,-0.202093,-0.211098,-0.15907,-0.146365,-0.088814,-0.002327,0.010634,-0.027445,-0.036313,-0.059934:0.111052,0.149135,0.079841,0.039713,-0.001179,-0.039399,-0.137571,-0.21256,-0.218854,-0.212316,-0.326789,-0.37813,-0.433359,-0.481901,-0.466242,-0.414298,-0.393134,-0.370047:9.64E-4,-0.017583,-0.052622,-0.11201,-0.132261,-0.16122,-0.203731,-0.293072,-0.34547,-0.38105,-0.310607,-0.280032,-0.239495,-0.194475,-0.204567,-0.18255,-0.159277,-0.155906:0.108022,0.041636,0.001869,0.00193,-0.040828,-0.094111,-0.111678,-0.055629,-0.091067,-0.108435,-0.079045,-0.077805,-0.11082,-0.156826,-0.132712,-0.129565,-0.119997,-0.111621:-0.281549,-0.288046,-0.256602,-0.319004,-0.312376,-0.266083,-0.244285,-0.217352,-0.123891,-0.078751,-0.137534,-0.155817,-0.145476,-0.145653,-0.119413,-0.111714,-0.122455,-0.116041:-0.138328,-0.129554,-0.093148,-0.050128,-0.052807,-0.05931,-0.009219,0.006285,-0.021107,-0.052449,-0.040198,-0.031615,-0.018186,0.056035,0.037185,0.008991,-0.012815,-0.046145:0.109298,0.148261,0.181971,0.180729,0.21473,0.250322,0.217061,0.142611,0.129109,0.106485,0.060874,0.029817,-0.01785,-0.103273,-0.126507,-0.140532,-0.155403,-0.177676:5
1.754105,1.672261,1.765035,1.715652,1.530256,1.345346,1.3156,1.335297,1.415601,1.543845,1.444757,1.388096,1.329183,1.186839,1.186448:-0.477001,-0.552808,-0.658372,-0.731903,-0.724932,-0.681674,-0.727997,-0.908991,-1.046368,-1.182332,-1.155642,-1.131296,-1.097706,-1.02698,-1.059051:-0.541131,-0.512037,-0.506375,-0.441361,-0.324955,-0.239609,-0.130688,0.046159,0.160381,0.310187,0.360442,0.369396,0.370595,0.369375,0.451183:-0.09751,-0.087024,0.026859,0.078872,0.036389,0.059445,0.124081,0.198099,0.256929,0.230419,0.269311,0.316341,0.367501,0.412522,0.396831:-0.132758,-0.033733,0.051923,0.037781,0.090999,0.178622,0.176933,0.165261,0.15485,0.174571,0.19241,0.205837,0.197912,0.163099,0.152035:-0.328344,-0.302149,-0.290406,-0.212731,-0.154392,-0.130219,-0.101091,-0.028856,0.030165,0.023452,8.12E-4,-0.03921,-0.046236,-0.033896,-0.034944:0.017222,-0.001881,-0.044595,-0.111453,-0.180671,-0.256721,-0.315085,-0.417843,-0.448059,-0.422106,-0.416361,-0.404633,-0.391933,-0.37693,-0.350827:-0.040387,-0.091005,-0.144911,-0.244916,-0.346158,-0.380363,-0.354875,-0.270848,-0.245656,-0.248083,-0.225512,-0.190651,-0.199101,-0.19272,-0.18259:-0.049375,-0.118479,-0.153422,-0.132913,-0.06276,-0.039782,-0.059769,-0.105445,-0.124542,-0.120664,-0.11581,-0.114351,-0.099964,-0.117937,-0.143479:-0.255922,-0.227058,-0.184995,-0.155701,-0.151937,-0.143847,-0.112285,-0.115997,-0.145967,-0.153495,-0.14376,-0.149326,-0.128478,-0.118432,-0.123987:-0.04178,-0.012872,0.004036,0.007122,-0.025162,-0.016899,-0.019007,0.017829,0.051948,0.048154,0.031365,0.021599,-0.003912,-0.006272,0.008499:0.208076,0.220381,0.211206,0.191989,0.20544,0.186542,0.126407,0.070324,0.046408,0.017462,-0.018381,-0.033667,-0.064524,-0.101827,-0.138591:5
1.328452,1.281947,1.211843,0.913774,0.96167,1.242162,1.335007,1.334165,1.365381,1.15056,1.276637,1.198017,0.993412,0.926219,0.82741:-0.06694,-0.140351,-0.174621,-0.124908,-0.368058,-0.683096,-0.848006,-0.882186,-1.003984,-0.949744,-1.143228,-1.191046,-1.112678,-1.083178,-1.013843:-0.599347,-0.589119,-0.617249,-0.607067,-0.450931,-0.224234,-0.073118,-0.09642,0.022482,0.079734,0.306721,0.393187,0.385796,0.400716,0.403757:-0.091574,-0.087374,-0.095685,-0.185896,-0.118063,-0.198377,-0.27097,-0.152286,-0.051025,0.091092,0.077877,0.117822,0.237706,0.287811,0.334675:-0.244481,-0.258673,-0.159486,0.031377,0.014778,0.072317,0.240413,0.286934,0.313644,0.245837,0.266014,0.292138,0.25195,0.244819,0.245574:-0.449364,-0.371572,-0.38362,-0.405,-0.290055,-0.126352,-0.09207,-0.045694,0.009016,0.043004,0.010005,-0.028503,-0.046992,-0.060633,-0.076583:0.070383,0.044306,0.040047,-0.009284,-0.035043,-0.229872,-0.356556,-0.413106,-0.498773,-0.491819,-0.471255,-0.45944,-0.387113,-0.351316,-0.334864:-0.050554,-0.072465,-0.07344,-0.057911,-0.172402,-0.16371,-0.132675,-0.166122,-0.156905,-0.178644,-0.178431,-0.132495,-0.11582,-0.10803,-0.093406:0.21713,0.193587,0.113282,-0.007337,-0.010303,-0.035194,-0.103059,-0.121077,-0.135972,-0.155032,-0.151437,-0.150845,-0.166681,-0.171287,-0.183422:-0.309628,-0.349493,-0.340115,-0.290658,-0.279302,-0.248659,-0.213001,-0.206058,-0.220434,-0.198294,-0.194214,-0.193854,-0.192912,-0.178256,-0.160795:0.003574,0.009897,0.001192,-0.003214,0.01671,-0.033521,-0.008814,0.019859,0.061343,0.062511,0.066249,0.057114,0.053128,0.037421,0.027802:0.049969,0.068061,0.118331,0.171349,0.219555,0.259038,0.19452,0.124288,0.057128,0.014948,-0.027455,-0.057114,-0.074913,-0.101242,-0.140846:5
1.293741,1.466211,1.529395,1.478278,1.609979,1.512172,1.447055,1.481786,1.469383,1.362661,1.42773,1.433821:-0.168266,-0.252414,-0.369914,-0.359759,-0.479754,-0.471217,-0.478625,-0.60545,-0.716187,-0.731116,-0.964488,-1.066264:-0.111755,-0.114538,-0.122101,-0.211398,-0.253022,-0.435147,-0.430517,-0.277618,-0.120876,-0.098,0.085409,0.154224:-0.474528,-0.537394,-0.509075,-0.409229,-0.355703,-0.101508,0.02299,0.019639,0.036927,0.194823,0.198893,0.245947:-0.027538,-6.49E-4,0.123348,0.193053,0.258078,0.226235,0.166219,0.190468,0.21426,0.125142,0.173813,0.18469:-0.240926,-0.183427,-0.150184,-0.138637,-0.156435,-0.200682,-0.147331,-0.077171,-0.062856,-0.100875,-0.067643,-0.082314:-0.186474,-0.192019,-0.287131,-0.349286,-0.384306,-0.280791,-0.302133,-0.410603,-0.41494,-0.346839,-0.424291,-0.435213:0.059859,0.038196,0.025529,0.029851,-0.020489,-0.235983,-0.390772,-0.329164,-0.274924,-0.278555,-0.210669,-0.193723:-0.019746,-0.139825,-0.232566,-0.239453,-0.198021,-0.116023,-0.003263,-0.051064,-0.120681,-0.146438,-0.164712,-0.151183:-0.314709,-0.256012,-0.174177,-0.16422,-0.15996,-0.111557,-0.117755,-0.082372,-0.067168,-0.066116,-0.099919,-0.13071:0.054716,0.088074,0.16137,0.155912,0.094395,0.022133,0.030682,0.029284,0.05029,0.034771,0.072025,0.063683:0.202777,0.192467,0.147641,0.126712,0.121941,0.146977,0.114033,0.096534,0.04336,0.020301,-0.018645,-0.013147:5
1.200538,1.326864,1.430494,1.492266,1.58927,1.681634,1.435818,1.488936,1.46971,1.297884,1.185564,1.368:-0.632286,-0.633506,-0.766296,-0.914237,-1.136697,-1.350162,-1.217141,-1.330903,-1.351816,-1.275111,-1.233551,-1.43098:-0.202171,-0.263534,-0.236271,-0.166626,0.015917,0.192652,0.137141,0.271382,0.344968,0.373579,0.403094,0.580717:-0.403487,-0.354945,-0.328537,-0.301903,-0.32777,-0.331728,-0.182225,-0.197281,-0.139462,-0.046537,0.045875,0.047385:-0.074027,0.006232,0.039232,0.074488,0.081827,0.024815,0.090343,0.165651,0.215548,0.265198,0.275804,0.226982:-0.322489,-0.373588,-0.331313,-0.316366,-0.284571,-0.017777,-0.001567,-0.004481,-0.046014,-0.08505,-0.093852,-0.079322:-0.157124,-0.179471,-0.169495,-0.152974,-0.161586,-0.39918,-0.430968,-0.485416,-0.488568,-0.481927,-0.480545,-0.502498:0.266058,0.271455,0.219986,0.140817,0.006893,-0.059506,-0.110306,-0.127433,-0.129699,-0.12705,-0.127349,-0.099456:-0.12536,-0.207859,-0.230424,-0.257156,-0.270636,-0.12837,-0.126761,-0.143253,-0.173068,-0.168907,-0.162773,-0.155433:-0.199477,-0.163945,-0.16644,-0.150861,-0.07867,-0.250819,-0.242576,-0.199308,-0.146591,-0.123621,-0.12898,-0.143514:0.029096,0.027105,0.053895,0.064813,0.007615,0.122402,0.144768,0.132323,0.104934,0.071528,0.067285,0.05634:0.102552,0.110386,0.133908,0.168548,0.199167,0.218881,0.194681,0.117274,0.034266,-0.007959,-0.045311,-0.103822:5
1.757843,1.761805,1.734457,1.641859,1.716474,1.51516,1.458099,1.694941,1.762353,1.631243:-0.434884,-0.488634,-0.635882,-0.633238,-0.69801,-0.667248,-0.652855,-0.823753,-0.915903,-0.946059:-0.238122,-0.29443,-0.274342,-0.234421,-0.089796,-0.061542,-0.060338,0.074333,0.297221,0.364825:-0.294485,-0.185087,-0.100627,-0.079227,-0.143826,-0.104572,0.047181,0.115195,0.070868,0.118168:0.024159,0.01275,0.04021,0.069887,0.129365,0.277913,0.282159,0.270204,0.312907,0.344031:-0.301494,-0.211007,-0.217508,-0.184457,-0.118361,-0.137815,-0.144145,-0.09739,-0.161683,-0.199109:-0.179291,-0.227138,-0.161639,-0.198131,-0.338997,-0.376317,-0.340353,-0.397605,-0.491042,-0.462489:0.220661,0.080052,-0.0702,-0.123943,-0.154395,-0.200556,-0.195868,-0.163384,-0.106666,-0.091425:-0.233898,-0.191481,-0.187669,-0.163003,-0.095707,-0.112987,-0.196863,-0.198979,-0.116712,-0.181895:-0.213769,-0.241047,-0.177093,-0.183512,-0.222728,-0.118101,-0.062689,-0.102393,-0.140214,-0.110583:0.047246,0.0414,0.035218,0.030995,0.017807,0.032691,0.078116,0.115128,0.026536,0.048926:0.16375,0.224822,0.228364,0.24706,0.260839,0.157386,0.06707,0.022023,-0.012791,-0.076418:5
1.149417,1.218825,1.219672,1.356462,1.447528,1.43551,1.370486,1.20659,1.164008,1.211504,1.238183,1.21014:0.013535,-0.101502,-0.162765,-0.378769,-0.528439,-0.62436,-0.691169,-0.692015,-0.749234,-0.821612,-0.862831,-0.8819:-0.6724,-0.621343,-0.588668,-0.470577,-0.388463,-0.302249,-0.215354,-0.154495,-0.090417,-0.007172,0.056746,0.101647:-0.162901,-0.172255,-0.198931,-0.228353,-0.180867,-0.086394,0.011175,0.078376,0.187968,0.265472,0.306083,0.341678:-0.058608,-0.050907,0.055333,0.21925,0.309474,0.311202,0.23076,0.259545,0.241917,0.218227,0.206569,0.18596:-0.469225,-0.401091,-0.377571,-0.410628,-0.399381,-0.346798,-0.250178,-0.202774,-0.189972,-0.170367,-0.135139,-0.078307:0.15402,0.078749,0.006125,-2.7E-4,-0.043164,-0.098214,-0.156195,-0.253818,-0.301692,-0.360071,-0.400424,-0.413421:-0.057525,-0.059237,-0.063871,-0.074409,-0.147051,-0.258332,-0.396941,-0.393888,-0.349089,-0.294301,-0.269678,-0.261721:0.04342,0.003727,-0.064218,-0.240861,-0.267202,-0.214447,-0.078463,-0.050366,-0.09398,-0.118673,-0.105741,-0.100848:-0.321989,-0.338164,-0.306439,-0.172315,-0.107381,-0.086873,-0.107364,-0.12911,-0.112836,-0.10925,-0.12147,-0.114575:-0.040288,-0.021201,-0.027101,-0.0651,-0.067404,-0.045201,-0.052634,-0.037502,-0.024722,-0.015513,-0.021737,-0.032808:0.154218,0.16376,0.211148,0.281694,0.280365,0.250453,0.20714,0.151667,0.08353,0.037358,0.013224,-0.018708:5
1.547025,1.591367,1.697042,1.826782,1.932798,1.986048,1.703573,1.58118,1.723696,1.830505:-0.169179,-0.181477,-0.24934,-0.530024,-0.737179,-0.859154,-0.808919,-0.796836,-0.956813,-1.079096:-0.469685,-0.50978,-0.566157,-0.406699,-0.292076,-0.223645,-0.239785,-0.217892,-0.038553,0.141773:-0.325841,-0.337816,-0.2332,-0.135887,-0.130142,-0.146315,-0.01621,0.10486,0.12247,0.16599:-0.118199,-0.021246,0.051682,0.037916,0.122987,0.259968,0.247263,0.237413,0.291658,0.297632:-0.287513,-0.252123,-0.235179,-0.156509,-0.152351,-0.168306,-0.117394,-0.050359,-0.024845,-0.079487:-0.146008,-0.187161,-0.213569,-0.211057,-0.258601,-0.324831,-0.341657,-0.40718,-0.465681,-0.457069:-0.031809,-0.055205,-0.091118,-0.207585,-0.262287,-0.24228,-0.294742,-0.274664,-0.210335,-0.181606:0.038549,-0.009956,-0.105736,-0.11592,-0.13006,-0.17616,-0.126934,-0.125814,-0.154826,-0.150298:-0.329958,-0.299848,-0.20237,-0.151062,-0.093529,-0.043968,-0.038552,-0.048093,-0.099794,-0.12904:-0.037561,-0.042032,-0.012585,0.016508,0.016606,0.028738,0.025018,0.038591,0.087659,0.061538:0.200816,0.193342,0.204406,0.221923,0.215362,0.152266,0.0963,0.041658,-0.005172,-0.032349:5
1.151251,1.2212,1.223573,1.369715,1.317588,1.186293,1.361011,1.324493,1.37503,1.260158,1.144657,1.104098,1.020869,0.911925,0.80034,0.720083,0.73386:-0.952718,-1.040333,-1.044781,-1.043369,-1.016685,-0.960792,-1.102286,-1.087569,-1.147743,-1.156741,-1.207021,-1.277153,-1.271765,-1.241939,-1.244351,-1.248745,-1.269867:0.483543,0.482849,0.500538,0.561381,0.534455,0.484947,0.581784,0.569206,0.579394,0.607864,0.63105,0.689334,0.772789,0.82314,0.850174,0.860185,0.878355:-0.525355,-0.503852,-0.471102,-0.448128,-0.371035,-0.284935,-0.323107,-0.228294,-0.225269,-0.206224,-0.144623,-0.108642,-0.038555,0.01095,0.020409,0.046556,0.05915:-0.485023,-0.464585,-0.42988,-0.401298,-0.347071,-0.295014,-0.243465,-0.17008,-0.113953,-0.067169,-0.034535,-0.003541,0.033328,0.058694,0.082392,0.098526,0.106934:-0.275942,-0.246076,-0.231809,-0.16924,-0.119071,-0.09735,-0.067908,-0.063938,-0.05038,-0.018895,-0.001288,0.004088,-0.018788,-0.038564,-0.051735,-0.074948,-0.073395:0.240847,0.20405,0.195969,0.152889,0.116855,0.102646,0.059175,0.034611,-0.0045,-0.078661,-0.131218,-0.165412,-0.177,-0.162152,-0.172007,-0.177173,-0.206733:-0.045554,-0.04776,-0.062259,-0.056636,-0.064215,-0.119071,-0.128409,-0.158723,-0.178446,-0.214138,-0.263495,-0.276568,-0.286395,-0.305362,-0.301851,-0.30536,-0.296858:-0.364141,-0.379581,-0.410112,-0.458082,-0.440084,-0.444337,-0.517972,-0.534194,-0.564033,-0.518327,-0.481424,-0.473594,-0.469871,-0.467499,-0.444351,-0.422878,-0.396619:0.019879,-0.018275,-0.038043,-0.085293,-0.180963,-0.20252,-0.177241,-0.193693,-0.174411,-0.173142,-0.126764,-0.068456,-0.004739,0.040712,0.059209,0.075051,0.070074:-0.085712,-0.065883,-0.050381,-0.002576,0.009068,0.031834,0.064379,0.086107,0.104116,0.113683,0.127096,0.141789,0.137358,0.098615,0.050061,0.008098,-0.009147:3.36E-4,0.010861,0.023622,0.004894,0.043438,0.092771,0.081982,0.095149,0.07185,0.082491,0.049261,-0.027461,-0.104682,-0.153711,-0.199094,-0.225075,-0.247348:6
1.65007,1.749386,1.71939,1.55444,1.36433,1.402664,1.562402,1.559021,1.680635,1.570967,1.629553,1.581731,1.32041,1.351488,1.172638,1.154291:-0.384465,-0.387238,-0.470892,-0.463463,-0.493167,-0.578764,-0.720773,-0.74463,-0.703323,-0.670136,-0.729641,-0.746556,-0.589709,-0.738951,-0.716513,-0.761958:0.434693,0.452712,0.47216,0.382609,0.437519,0.467206,0.495548,0.442482,0.27699,0.23024,0.377582,0.534403,0.412244,0.594308,0.664027,0.636781:-0.222556,-0.260257,-0.215039,-0.169298,-0.121605,-0.07811,-0.075234,0.03598,0.176527,0.258328,0.170569,0.229844,0.392346,0.345793,0.37758,0.49555:-0.241074,-0.10323,-0.090117,-0.051732,-0.09734,-0.038869,0.071141,0.092571,0.103241,0.074694,0.191586,0.207881,0.191295,0.220954,0.209481,0.158456:-0.471484,-0.425346,-0.420276,-0.405914,-0.317745,-0.286821,-0.27683,-0.249964,-0.244984,-0.180683,-0.218477,-0.204637,-0.173743,-0.192196,-0.200228,-0.169462:0.178141,0.128176,0.12597,0.150082,0.146788,0.130277,0.070398,0.056499,0.079918,0.044077,-0.011226,-0.119436,-0.085557,-0.096595,-0.101709,-0.155202:0.152036,0.151718,0.121316,0.094665,0.034456,-0.029554,-0.038039,-0.06626,-0.108039,-0.161652,-0.175352,-0.220838,-0.240432,-0.261117,-0.300698,-0.245875:-0.336297,-0.381841,-0.428383,-0.47157,-0.485038,-0.49556,-0.531178,-0.524707,-0.482485,-0.433996,-0.45245,-0.409589,-0.405965,-0.398728,-0.32907,-0.296803:-0.037507,-0.053068,-0.088172,-0.144677,-0.176488,-0.16842,-0.150184,-0.195773,-0.252288,-0.280246,-0.187757,-0.097292,-0.119674,-0.092172,-0.072823,-0.077315:-0.068991,-0.088715,-0.058325,-0.02646,0.016343,0.003436,-0.016803,0.044227,0.052675,0.051478,-0.001561,0.01946,0.074584,0.03594,5.22E-4,0.045134:-0.06062,-0.030676,0.020593,0.068678,0.071166,0.121351,0.151632,0.182472,0.226873,0.209148,0.138895,-0.0045,-0.036795,-0.027243,-0.026189,-0.108478:6
1.537754,1.411688,1.277078,1.548617,1.524787,1.455725,1.323756,1.266799,1.29096,1.366752,1.212875,1.252105,0.996303,1.078551,1.046742,1.012976:-0.884614,-0.942843,-0.714258,-0.860445,-0.939863,-0.937155,-0.901407,-0.89034,-0.919349,-0.986418,-0.908981,-1.022949,-0.921873,-1.105681,-1.179816,-1.221625:0.665898,0.660752,0.490018,0.535232,0.565626,0.53505,0.523545,0.558054,0.564853,0.585388,0.525706,0.641025,0.577538,0.716876,0.795208,0.874407:-0.346353,-0.361506,-0.232486,-0.287879,-0.294776,-0.178808,-0.126657,-0.189271,-0.208675,-0.185879,-0.08162,-0.061077,0.111016,0.069091,0.124423,0.210524:-0.623877,-0.574064,-0.525238,-0.407175,-0.331877,-0.293732,-0.218275,-0.091401,-0.044598,-0.016359,0.066345,0.090503,0.088486,0.123476,0.129708,0.153267:-0.26516,-0.201127,-0.2221,-0.280581,-0.27325,-0.242438,-0.205386,-0.208002,-0.168651,-0.121234,-0.132583,-0.049519,-0.028842,-0.095328,-0.134217,-0.153903:0.182508,0.167939,0.20759,0.2041,0.203694,0.189666,0.122608,0.091315,0.037183,-0.016194,-0.01324,-0.099357,-0.106595,-0.131841,-0.192657,-0.250887:-0.047751,-0.035186,-0.038779,0.001652,-0.016369,-0.046094,-0.075324,-0.088512,-0.108603,-0.148888,-0.191427,-0.192124,-0.228597,-0.234709,-0.232203,-0.215715:-0.327433,-0.336328,-0.333275,-0.444758,-0.517664,-0.508099,-0.476769,-0.539919,-0.556117,-0.551158,-0.526807,-0.489312,-0.443242,-0.449163,-0.401507,-0.352223:-0.002846,-0.067457,-0.129593,-0.113683,-0.09426,-0.156922,-0.188041,-0.15705,-0.170989,-0.160551,-0.140311,-0.140697,-0.136332,-0.042222,-0.008625,-0.001176:-0.005986,-0.005454,0.001918,-0.009443,-0.027475,8.75E-4,0.009529,0.007839,0.047959,0.076406,0.065493,0.084653,0.100167,0.047065,0.018989,1.68E-4:-0.08673,-0.061137,-0.017275,-0.00794,-0.01406,0.030919,0.070812,0.112401,0.13399,0.124506,0.132559,0.07542,0.003855,-0.088188,-0.158989,-0.220976:6
1.219808,1.266343,1.322054,1.392235,1.406885,1.482831,1.309937,1.409937,1.687347,1.643645,1.555553,1.585563,1.557021,1.486729,1.360158,1.421565,1.25884,1.114463,0.994108,0.956185,0.949055:-0.228764,-0.1874,-0.242582,-0.455849,-0.596214,-0.718835,-0.781048,-0.6443,-0.729438,-0.572955,-0.541,-0.671334,-0.838004,-1.05047,-1.09245,-1.250671,-1.290891,-1.344685,-1.382573,-1.429491,-1.471241:0.703155,0.412579,0.258361,0.40368,0.427015,0.356371,0.437318,0.28906,0.253854,0.177592,0.239064,0.205887,0.246054,0.386677,0.388214,0.543197,0.601203,0.648359,0.720929,0.759146,0.768753:-0.331165,-0.268484,-0.171667,-0.230663,-0.180064,-0.031067,0.088379,0.112613,0.063705,0.048489,-0.010042,0.063115,0.146923,0.220242,0.393092,0.335835,0.381861,0.397203,0.39564,0.396994,0.426289:-0.388024,-0.255068,-0.212668,-0.251208,-0.239299,-0.156688,-0.112419,-0.009,0.060012,0.135271,0.191594,0.274892,0.296836,0.205125,0.104973,0.155196,0.128833,0.080216,0.067652,0.083524,0.084327:-0.412572,-0.457762,-0.464168,-0.427469,-0.427522,-0.483515,-0.44184,-0.374404,-0.337822,-0.314497,-0.292919,-0.281969,-0.330237,-0.304846,-0.187287,-0.240181,-0.177396,-0.092406,-0.082371,-0.084218,-0.073253:0.292996,0.23154,0.26142,0.269663,0.244841,0.220791,0.125871,0.092945,0.083503,0.064427,0.027822,0.017184,0.002959,-0.065583,-0.145918,-0.176262,-0.211151,-0.236018,-0.251889,-0.270554,-0.292648:-0.24003,-0.181512,-0.113133,-0.133541,-0.152226,-0.101895,-0.127516,-0.103005,-0.122032,-0.163214,-0.269125,-0.352005,-0.31303,-0.295805,-0.325855,-0.254522,-0.251285,-0.275194,-0.269468,-0.244929,-0.231873:-0.3225,-0.333326,-0.326657,-0.385206,-0.450922,-0.517655,-0.49907,-0.504296,-0.533888,-0.549002,-0.512567,-0.47331,-0.53708,-0.519175,-0.39843,-0.417773,-0.323931,-0.256161,-0.227697,-0.210441,-0.189062:0.105597,0.032621,-0.050929,-0.078245,-0.071671,-0.092328,-0.071926,-0.112789,-0.152687,-0.161411,-0.129704,-0.042831,0.008268,0.014355,-0.049064,0.006871,-0.014035,-0.039602,-0.043614,-0.064195,-0.095768:-0.07784,-0.047144,-0.077742,-0.093025,-0.05347,0.004776,0.074535,0.098397,0.085572,0.1059,0.046579,-0.051181,-0.015229,0.036516,0.088346,0.07974,0.059151,0.037723,0.012775,-0.007794,-0.016896:0.059854,0.065197,0.080551,0.133724,0.13421,0.125726,0.097706,0.097856,0.164785,0.165217,0.184112,0.140078,0.058526,-0.026132,-0.061924,-0.132376,-0.150272,-0.156069,-0.17554,-0.187815,-0.191449:6
1.342985,1.4305,1.49841,1.319533,1.262147,1.414591,1.559114,1.351581,1.175591,1.045429,1.119219,1.055957,1.066539,1.018673,0.933719,1.004419,0.958107,0.877551:-0.623658,-0.682263,-0.724408,-0.707706,-0.720194,-0.811567,-0.840308,-0.743712,-0.839404,-0.881489,-0.994522,-0.977197,-1.076494,-1.026106,-0.914907,-0.993125,-1.062814,-1.094953:0.399461,0.446907,0.379188,0.429396,0.402325,0.423172,0.449118,0.360741,0.428865,0.475233,0.572916,0.634906,0.755918,0.726705,0.688899,0.727944,0.722159,0.7812:-0.243448,-0.169684,-0.082444,-0.089066,-0.056176,-0.034972,0.016687,0.135509,0.166146,0.187389,0.162099,0.150934,0.043529,0.128842,0.205825,0.173976,0.164126,0.174076:-0.225568,-0.136181,-0.070627,-0.022544,-0.029622,-0.01456,0.070584,0.113426,0.131887,0.200912,0.191824,0.143241,0.145799,0.191259,0.207117,0.205145,0.232161,0.197912:-0.360431,-0.290573,-0.3414,-0.321138,-0.218057,-0.132424,-0.103337,-0.120227,-0.139428,-0.224781,-0.256237,-0.172841,-0.158595,-0.157903,-0.185988,-0.19813,-0.188488,-0.157892:0.278055,0.248924,0.273917,0.20191,0.167583,0.064834,-0.012105,0.017796,-0.009429,-0.071264,-0.10154,-0.161625,-0.174008,-0.21861,-0.195898,-0.206769,-0.232534,-0.223011:0.085157,0.006536,-0.096358,-0.078872,-0.106318,-0.110268,-0.113292,-0.225724,-0.292033,-0.275849,-0.264427,-0.240907,-0.244166,-0.250353,-0.298879,-0.280122,-0.263764,-0.279412:-0.392653,-0.446507,-0.495667,-0.491747,-0.502403,-0.509004,-0.508543,-0.438544,-0.430204,-0.443684,-0.461165,-0.431899,-0.468092,-0.406701,-0.340836,-0.346799,-0.320124,-0.288617:-0.002145,-0.006462,-0.008367,-0.041152,-0.131431,-0.182575,-0.179547,-0.113986,-0.048737,-0.008957,0.035684,-0.033734,0.029196,0.017336,0.031947,0.06717,0.073545,0.074953:-0.026374,-0.008788,-0.039341,-0.022529,0.050427,0.137348,0.184054,0.108417,0.08647,0.049311,0.027828,0.085184,0.075637,0.075071,0.025401,0.012436,-0.017305,-0.043418:-0.057805,-0.04707,0.053201,0.094088,0.131783,0.12671,0.113046,0.115777,0.056965,0.010444,-0.035572,-0.056334,-0.093144,-0.106081,-0.091022,-0.144797,-0.170016,-0.190064:6
1.15577,1.389369,1.233381,1.171224,1.308639,1.32373,1.483637,1.567174,1.418995,1.369186,1.194605,1.14551,1.097178:-0.095411,-0.381255,-0.459052,-0.586258,-0.815586,-0.937638,-1.059998,-1.031524,-0.863782,-0.90096,-1.093216,-1.257088,-1.300952:0.423142,0.475453,0.331602,0.248552,0.297869,0.355136,0.455992,0.463114,0.317632,0.394997,0.539698,0.611026,0.604672:-0.257039,-0.285353,-0.334856,-0.277358,-0.135098,-0.054497,0.030255,0.055434,0.182833,0.173281,0.147224,0.145172,0.217458:-0.162121,-0.082522,0.015759,0.099921,0.028968,-0.066298,-0.10462,-0.04025,0.099637,0.186336,0.165389,0.142952,0.122077:-0.28455,-0.235433,-0.223898,-0.258647,-0.219399,-0.115553,-0.042413,-0.102651,-0.130826,-0.216715,-0.207491,-0.190546,-0.163317:0.2618,0.157299,0.124449,0.114382,0.136527,0.088305,-0.005923,0.013355,-0.022531,-0.046238,-0.085063,-0.112241,-0.13383:-0.111227,-0.061518,-0.076648,-0.099659,-0.191209,-0.25751,-0.257137,-0.269174,-0.287509,-0.303261,-0.280007,-0.272154,-0.298689:-0.27316,-0.466491,-0.48745,-0.509411,-0.506852,-0.485975,-0.457195,-0.4869,-0.42985,-0.399764,-0.416479,-0.440652,-0.399446:-0.201246,-0.182634,-0.208923,-0.180957,-0.130543,-0.132027,-0.174918,-0.103798,-0.067933,0.009598,0.036281,0.055587,0.028682:-0.065139,-0.00708,-0.040209,-0.07099,-0.059611,0.013244,0.083897,0.092228,0.094616,0.007693,-0.004141,0.007868,0.011797:0.184339,0.150395,0.178429,0.189897,0.150585,0.089962,0.085789,0.069005,0.030622,-0.006636,-0.071048,-0.136342,-0.148371:6
1.044594,1.134296,1.042541,1.02813,0.99449,1.151274,1.15755,1.156326,1.140564,1.093679,1.05121,0.989325,0.988817,0.988261,1.000859,0.983112:-0.422311,-0.600592,-0.699623,-0.747823,-0.702427,-0.800814,-0.853699,-0.905892,-0.909721,-0.890176,-0.934125,-1.02497,-1.091187,-1.077683,-1.11817,-1.190784:0.421516,0.52078,0.564219,0.551661,0.523737,0.576535,0.584415,0.563282,0.530171,0.511056,0.527458,0.531266,0.563477,0.618553,0.665088,0.686154:-0.598698,-0.62839,-0.618917,-0.572556,-0.492169,-0.522087,-0.461785,-0.387796,-0.327382,-0.283116,-0.271893,-0.20026,-0.159827,-0.075863,0.013947,0.060315:-0.302855,-0.289009,-0.259205,-0.217673,-0.174493,-0.138364,-0.081941,-0.014174,0.051565,0.112872,0.206634,0.254108,0.236925,0.226322,0.230404,0.23927:-0.273057,-0.247834,-0.211572,-0.173859,-0.160397,-0.120475,-0.085015,-0.060629,-0.063895,-0.06753,-0.019161,0.017412,0.007473,-0.032685,-0.079898,-0.110886:0.174,0.168767,0.156928,0.161817,0.151168,0.13757,0.118506,0.083256,0.060564,0.0327,-0.039713,-0.059016,-0.065027,-0.087386,-0.114813,-0.146348:-0.007691,0.007651,0.007691,-0.019068,-7.78E-4,0.011378,0.005763,8.06E-4,-0.029019,-0.073191,-0.087512,-0.140195,-0.199656,-0.218068,-0.220212,-0.215701:-0.32423,-0.392731,-0.435893,-0.456747,-0.474967,-0.525642,-0.547965,-0.562547,-0.555655,-0.513742,-0.456958,-0.456935,-0.490023,-0.500693,-0.478806,-0.453873:0.018747,-0.004586,-0.033546,-0.050387,-0.114783,-0.148469,-0.17631,-0.206126,-0.209852,-0.209911,-0.195384,-0.120349,-0.043463,-0.025077,-0.005576,0.012906:-0.145149,-0.121946,-0.085336,-0.076962,-0.040374,-0.033061,-0.007484,0.018211,0.019025,-0.016294,-0.05342,-0.052036,-7.08E-4,0.036402,0.027556,0.007294:-0.112026,-0.085633,-0.069458,-0.049522,-0.02009,0.01983,0.045371,0.04339,0.078057,0.134664,0.126902,0.028461,-0.058365,-0.088014,-0.118388,-0.153508:6
1.480478,1.799996,1.676919,1.448602,1.342211,1.27057,1.44553,1.226343,1.133543,1.356069,1.206636,1.132536,1.202831,1.127434,1.043803,0.994364,0.984165:-0.437051,-0.709259,-0.664771,-0.555741,-0.665576,-0.740027,-0.949079,-0.869456,-0.829893,-1.004551,-0.973368,-0.991285,-1.077646,-1.062593,-1.073847,-1.110241,-1.162008:0.52699,0.649404,0.561146,0.491243,0.544706,0.569457,0.696673,0.619727,0.582524,0.695837,0.664602,0.6932,0.765655,0.788179,0.816905,0.82726,0.866177:-0.322641,-0.362026,-0.330865,-0.273606,-0.269618,-0.223137,-0.312655,-0.226281,-0.152822,-0.183471,-0.075203,-0.015753,-0.027317,-0.023752,0.017112,0.051601,0.094641:-0.311905,-0.359183,-0.334785,-0.287899,-0.224587,-0.228792,-0.210542,-0.141473,-0.08883,-0.069915,-0.023574,-0.009635,0.001872,0.029604,0.049242,0.05905,0.052841:-0.273493,-0.257263,-0.24037,-0.265822,-0.224236,-0.143638,-0.089529,-0.085924,-0.085014,-0.060473,-0.030989,-0.006049,-0.011774,-0.050822,-0.071275,-0.084048,-0.073424:0.145977,0.120661,0.134757,0.197266,0.105796,0.053528,1.11E-4,0.004993,-0.018554,-0.095841,-0.124287,-0.131501,-0.146711,-0.13837,-0.164768,-0.193145,-0.215793:-0.051057,-0.013181,-0.050334,-0.135172,-0.096637,-0.086048,-0.102348,-0.128149,-0.147506,-0.173134,-0.23262,-0.276586,-0.277184,-0.282364,-0.275149,-0.270894,-0.27456:-0.339981,-0.435177,-0.413447,-0.429254,-0.458868,-0.457561,-0.515259,-0.489995,-0.477668,-0.47705,-0.430462,-0.440224,-0.470853,-0.477082,-0.441399,-0.409966,-0.393578:-0.077544,-0.110902,-0.167882,-0.153039,-0.172657,-0.218746,-0.19633,-0.233539,-0.241176,-0.18373,-0.156517,-0.115971,-0.077108,-0.03449,-0.028026,-0.030866,-0.027201:-0.070926,-0.048698,-0.049878,-0.034656,0.019003,0.066948,0.079237,0.05965,0.070996,0.080601,0.089594,0.121519,0.138689,0.109452,0.083525,0.05797,0.060175:0.018598,0.018007,0.086557,0.137447,0.121947,0.094729,0.086814,0.142769,0.157854,0.112647,0.090298,0.047441,-0.006218,-0.03358,-0.069619,-0.103438,-0.140775:6
1.208522,1.174753,1.158825,1.161796,1.175731,1.156281,0.989063,0.956566,1.008235,0.913275,0.93476,0.918344,0.89097,0.902571,0.871849,0.863657,0.859705,0.793543,0.749964,0.740949,0.664113:-0.668567,-0.676605,-0.711738,-0.822381,-0.90102,-0.92887,-0.897113,-0.883322,-0.920206,-0.888831,-0.932778,-0.92639,-0.930964,-0.969916,-0.977714,-0.974897,-0.95844,-0.969947,-0.998637,-1.064942,-1.063378:0.534545,0.502322,0.417634,0.470884,0.514296,0.496657,0.462111,0.481889,0.509439,0.469765,0.4448,0.505941,0.523129,0.527345,0.566983,0.606588,0.610632,0.620827,0.663414,0.6814,0.644832:-0.662619,-0.629942,-0.54142,-0.483,-0.468902,-0.46717,-0.432223,-0.385802,-0.358545,-0.311549,-0.277601,-0.240324,-0.188745,-0.177102,-0.150111,-0.13011,-0.088605,-0.050419,-0.008325,0.029439,0.08085:-0.471138,-0.413987,-0.390073,-0.3833,-0.379771,-0.338058,-0.211201,-0.153546,-0.111067,-0.023356,0.0581,0.117148,0.144425,0.114709,0.126626,0.155786,0.18251,0.207348,0.209648,0.20821,0.213036:-0.331085,-0.304136,-0.302265,-0.302009,-0.279881,-0.232374,-0.231835,-0.21173,-0.163606,-0.169568,-0.175575,-0.161804,-0.140525,-0.112993,-0.125549,-0.133535,-0.140943,-0.160696,-0.171672,-0.177137,-0.196688:0.221182,0.19038,0.232376,0.231481,0.208024,0.191297,0.174942,0.169385,0.141101,0.114164,0.01665,-0.071553,-0.098642,-0.065366,-0.074988,-0.074029,-0.073323,-0.086315,-0.102334,-0.11712,-0.128109:0.012652,0.003038,-0.045361,-0.038721,-0.037847,-0.042961,-0.048738,-0.056209,-0.076236,-0.116932,-0.135783,-0.149535,-0.216583,-0.283685,-0.283587,-0.274119,-0.282476,-0.278585,-0.274921,-0.27269,-0.274932:-0.359739,-0.347035,-0.352644,-0.406492,-0.449413,-0.461831,-0.481564,-0.519655,-0.540833,-0.531784,-0.496545,-0.454173,-0.429339,-0.4665,-0.493468,-0.508901,-0.503672,-0.491544,-0.484097,-0.466558,-0.444642:0.073643,0.014471,-0.030446,-0.026335,-0.039773,-0.085653,-0.109347,-0.132168,-0.163821,-0.168555,-0.174714,-0.168451,-0.096238,-0.015456,0.018577,0.039613,0.05455,0.064148,0.063435,0.058589,0.03971:-0.116394,-0.12631,-0.132137,-0.114764,-0.073625,-0.053228,-0.048307,-0.033413,-0.034523,-0.039382,-0.020362,-0.036177,-0.065347,-0.024289,0.028436,0.050485,0.054905,0.042032,0.031821,0.00862,-0.002679:-0.092964,-0.049887,2.77E-4,-0.009678,-0.006924,0.028211,0.08074,0.105322,0.112556,0.148047,0.176142,0.188424,0.137909,0.04868,0.009634,-0.007706,-0.021571,-0.053896,-0.085599,-0.110944,-0.118847:6
1.173553,1.038906,0.953278,1.002924,1.183021,1.229059,1.030415,1.032692,1.077259,1.197588,1.312346,1.270725,0.971115,1.069798,1.233906,1.259887,1.222697,1.179429,1.217336,1.211162,1.176832,1.218443,1.153808:-0.782457,-0.804366,-0.805273,-0.851086,-0.949607,-0.983084,-0.960132,-1.014263,-1.052987,-1.110272,-1.15263,-1.107518,-0.812927,-0.891074,-1.014394,-1.094256,-1.252605,-1.241287,-1.261128,-1.271359,-1.251187,-1.309053,-1.308717:0.608306,0.654488,0.619248,0.606813,0.627658,0.602047,0.565793,0.597096,0.588527,0.529931,0.46302,0.461426,0.573559,0.597506,0.525687,0.536349,0.619947,0.633976,0.686906,0.705417,0.641524,0.647323,0.624679:-0.517251,-0.539939,-0.520163,-0.49593,-0.467142,-0.425931,-0.393493,-0.40763,-0.332859,-0.239478,-0.214574,-0.233422,-0.218338,-0.251374,-0.186012,-0.097197,-0.098945,-0.001892,0.008353,0.035396,0.1549,0.13229,0.145097:-0.667466,-0.605999,-0.550001,-0.537024,-0.562388,-0.534981,-0.425686,-0.34398,-0.326796,-0.344775,-0.297803,-0.186625,-0.066473,0.002727,-0.050553,-0.071358,-0.113921,-0.155343,-0.142204,-0.107215,-0.118931,-0.080154,-0.058358:-0.171801,-0.133369,-0.155413,-0.151413,-0.094207,-0.089988,-0.124474,-0.116716,-0.0994,-0.059126,-0.05353,-0.073376,-0.067048,-0.02685,-0.022857,-0.061756,0.008366,0.002901,-0.016626,-0.044482,-0.028825,-0.06369,-0.095551:0.42411,0.363208,0.359406,0.355356,0.319071,0.309319,0.313124,0.260073,0.226827,0.19798,0.137873,0.05199,6.46E-4,-0.076149,-0.046588,-0.00903,-0.038766,-0.025958,-0.047108,-0.075871,-0.100247,-0.116407,-0.091938:-0.229932,-0.19587,-0.184712,-0.186414,-0.191207,-0.201792,-0.22652,-0.186568,-0.18821,-0.23825,-0.258803,-0.253548,-0.238951,-0.296177,-0.310249,-0.330005,-0.352516,-0.385275,-0.370516,-0.352395,-0.380626,-0.355591,-0.347558:-0.315374,-0.330881,-0.353414,-0.385255,-0.410323,-0.431494,-0.445273,-0.486294,-0.4981,-0.473978,-0.459047,-0.445985,-0.434206,-0.449384,-0.476992,-0.480581,-0.488896,-0.472107,-0.472697,-0.456611,-0.374984,-0.383177,-0.403499:0.125181,0.083935,0.040088,0.015447,-0.020882,-0.045112,-0.039864,-0.064508,-0.108958,-0.148362,-0.16606,-0.166414,-0.189806,-0.085344,-0.081261,-0.022483,-0.029004,-0.023388,-6.0E-4,0.012081,-0.027949,-0.007341,0.007754:-0.188459,-0.18885,-0.18184,-0.164841,-0.126316,-0.101525,-0.127649,-0.118469,-0.078691,-0.053564,-0.029972,-0.023475,-0.008475,0.020332,0.060106,0.0724,0.099741,0.109617,0.114087,0.100267,0.074407,0.064727,0.063868:-0.058638,-0.049858,-0.001983,0.015845,0.010699,0.028665,0.074386,0.083871,0.084555,0.110203,0.15201,0.191355,0.237433,0.135301,0.095398,0.063672,0.013952,0.005806,-0.034048,-0.062321,-0.029162,-0.06048,-0.07973:6
1.176314,1.167001,1.26988,1.167989,1.166328,1.053133,1.016627,0.981533,0.974857,1.001886,1.022126,1.001942,0.934019,0.894965,0.915999,0.876196,0.889857,0.885939,0.884329:-0.981809,-1.047658,-1.170186,-1.245131,-1.363611,-1.27194,-1.083592,-1.179474,-1.113195,-1.135677,-1.212709,-1.167614,-1.167878,-1.200602,-1.223488,-1.199185,-1.216154,-1.236532,-1.264267:0.535088,0.49397,0.510818,0.505818,0.531281,0.49697,0.539836,0.549567,0.487868,0.45352,0.525833,0.553182,0.570926,0.577637,0.606887,0.604114,0.601039,0.596414,0.617089:-0.284245,-0.238024,-0.260364,-0.22383,-0.207249,-0.191927,-0.234624,-0.222871,-0.217176,-0.132154,-0.082547,-0.102878,-0.030677,0.043462,0.04557,0.086597,0.087577,0.108376,0.128158:-0.486747,-0.427064,-0.355538,-0.302081,-0.27267,-0.192602,-0.074081,-0.047827,-0.00317,0.115667,0.091944,0.097596,0.129757,0.150905,0.157806,0.158042,0.175917,0.199083,0.19987:-0.255266,-0.241725,-0.211898,-0.169252,-0.082607,-0.08273,-0.089161,-0.059747,-0.125808,-0.162673,-0.117306,-0.096746,-0.101933,-0.121947,-0.1314,-0.134261,-0.148584,-0.176437,-0.175169:0.339015,0.302457,0.234177,0.17505,0.09763,0.094633,0.095626,0.070337,0.055941,-0.017057,-0.045279,0.0062,0.004562,-0.04316,-0.075507,-0.093673,-0.096061,-0.106079,-0.134931:-0.118773,-0.119316,-0.094313,-0.120006,-0.136587,-0.169096,-0.182153,-0.210976,-0.226274,-0.179184,-0.185759,-0.211984,-0.248201,-0.246518,-0.232556,-0.242259,-0.241755,-0.228015,-0.212908:-0.402925,-0.408704,-0.452264,-0.439206,-0.420051,-0.427106,-0.483726,-0.512682,-0.516381,-0.470328,-0.475569,-0.527317,-0.502253,-0.468924,-0.463461,-0.437886,-0.426921,-0.406257,-0.374708:-0.060924,-0.093536,-0.11206,-0.150527,-0.205531,-0.208225,-0.155874,-0.106654,-0.078527,-0.060744,-0.082287,-0.073507,-0.0451,-0.038384,-0.02632,-0.030357,-0.010349,-3.77E-4,-0.009982:-0.149605,-0.146995,-0.130835,-0.121783,-0.10934,-0.135458,-0.118711,-0.04705,-0.027756,-0.012694,0.015081,0.015666,-0.0047,0.005107,0.006114,0.014269,-0.00713,-0.03101,-0.031706:-0.001053,0.019109,0.032193,0.068131,0.089319,0.133491,0.140161,0.07272,0.117013,0.065077,0.014697,0.036718,0.024485,-0.019132,-0.054069,-0.06479,-0.070152,-0.067703,-0.069715:6
0.968072,1.053614,1.188992,1.280359,1.353872,1.390753,1.202609,1.319799,1.269814,1.17138,1.179243,1.147548,1.12081,1.059607,1.041023,1.144191:-0.564234,-0.603734,-0.581785,-0.572903,-0.730013,-0.794464,-0.770579,-0.911877,-0.833131,-0.729289,-0.876156,-0.987124,-1.066713,-1.0845,-1.101541,-1.233464:0.488448,0.480568,0.460916,0.430588,0.483419,0.483446,0.399345,0.458729,0.405055,0.341509,0.326179,0.38021,0.423738,0.444897,0.488765,0.585421:-0.541101,-0.490818,-0.432378,-0.420444,-0.39934,-0.370232,-0.218946,-0.239542,-0.274627,-0.298654,-0.186819,-0.142086,-0.105805,-0.040295,0.031043,0.04263:-0.297557,-0.253366,-0.21442,-0.160304,-0.127788,-0.112931,-0.063646,-0.003679,0.103292,0.228666,0.240996,0.211386,0.200778,0.183181,0.164178,0.152126:-0.269363,-0.252423,-0.266325,-0.274334,-0.205194,-0.175288,-0.143018,-0.112719,-0.151464,-0.164756,-0.10136,-0.043087,-0.023111,-0.034537,-0.054671,-0.051157:0.288969,0.3122,0.312353,0.277544,0.177635,0.165794,0.10648,0.0404,0.034413,0.004197,-0.024473,-0.04316,-0.065992,-0.056647,-0.06688,-0.114183:0.006278,0.025586,0.03165,0.016482,0.021753,-0.006868,-0.040512,-0.053628,-0.089858,-0.146133,-0.205223,-0.226025,-0.246475,-0.271109,-0.287984,-0.258134:-0.324058,-0.385591,-0.438096,-0.46004,-0.503218,-0.518054,-0.483271,-0.517534,-0.527037,-0.496992,-0.470905,-0.478775,-0.475319,-0.469624,-0.46786,-0.480029:-0.037358,-0.056625,-0.097267,-0.135357,-0.179879,-0.196683,-0.256878,-0.251998,-0.232716,-0.200274,-0.141575,-0.118727,-0.086955,-0.053725,-0.035278,-0.027583:-0.140908,-0.148474,-0.137434,-0.14554,-0.088916,-0.071276,-0.008048,0.023529,-0.012294,-0.067775,-0.09501,-0.054866,-0.024298,0.003853,0.038933,0.067992:-0.008648,-0.045337,-0.016853,0.035138,0.02985,0.058425,0.075576,0.101678,0.183561,0.230934,0.151223,0.069394,-0.002242,-0.059344,-0.094241,-0.142588:6
1.166885,1.314486,1.386109,1.395632,1.503074,1.359232,1.28199,1.209892,1.220011,1.261221,1.140293,1.053194,1.245524,1.259135,1.131168,1.115187,0.89791,0.969876:-1.058701,-1.206997,-1.208225,-1.229923,-1.537533,-1.561995,-1.530071,-1.526735,-1.528527,-1.633366,-1.725398,-1.578802,-1.687822,-1.752936,-1.742735,-1.807625,-1.686478,-1.852765:0.643376,0.725743,0.650846,0.575259,0.625197,0.584365,0.467718,0.408885,0.484571,0.637408,0.63716,0.539617,0.625131,0.669216,0.650539,0.663074,0.561044,0.630921:-0.343935,-0.281886,-0.171221,-0.06397,-0.033976,-0.047177,-0.017642,0.010347,0.084296,0.057131,0.075343,0.209487,0.217983,0.226585,0.297053,0.320551,0.441633,0.424528:-0.567667,-0.622669,-0.612767,-0.590289,-0.561301,-0.475491,-0.358489,-0.30331,-0.318936,-0.317054,-0.277922,-0.275381,-0.244893,-0.222314,-0.204024,-0.194149,-0.196476,-0.161527:-0.179445,-0.058425,-0.087554,-0.068184,-0.009368,-0.025992,-0.059696,-0.044595,-0.048204,0.038495,0.07276,0.027722,0.029679,0.031425,0.010862,0.012938,-0.008565,-0.027159:0.273135,0.223163,0.232853,0.21405,0.128098,0.101505,0.070957,0.03398,0.032443,0.011412,0.014443,0.018737,-0.029432,-0.053492,-0.066159,-0.081518,-0.08404,-0.103705:-0.101406,-0.125967,-0.122666,-0.164128,-0.192177,-0.198733,-0.212796,-0.222797,-0.236962,-0.291373,-0.325554,-0.358525,-0.361598,-0.367515,-0.38066,-0.382721,-0.394398,-0.37396:-0.425044,-0.399508,-0.409642,-0.402571,-0.374559,-0.418703,-0.454449,-0.446057,-0.449311,-0.443129,-0.45863,-0.436774,-0.429734,-0.440654,-0.422863,-0.419177,-0.390638,-0.382033:-0.012201,-0.094655,-0.131985,-0.166663,-0.230772,-0.226201,-0.214985,-0.234013,-0.207425,-0.154864,-0.139466,-0.121522,-0.096056,-0.076336,-0.067546,-0.070338,-0.070865,-0.07614:-0.033872,0.003245,0.024247,0.021555,0.028913,0.054569,0.087243,0.10822,0.128075,0.13382,0.121332,0.118478,0.142402,0.16047,0.14828,0.155247,0.127858,0.116788:-0.102353,-0.080244,-0.059476,0.007984,0.089436,0.089725,0.111356,0.137671,0.118467,0.052127,0.019741,0.040027,-0.008031,-0.0498,-0.050267,-0.059042,-0.044533,-0.069894:6
1.162161,1.252185,1.005866,1.363127,1.398381,1.306316,1.524073,1.411958,1.471838,1.403123,1.52483,1.307871,1.375833,1.293287,1.227089,1.236985,1.15405,1.11199:-0.928977,-0.903323,-0.60855,-0.801483,-0.786492,-0.690842,-0.832782,-0.814214,-0.908688,-0.880055,-1.018474,-0.923638,-1.042004,-1.054171,-1.061336,-1.120574,-1.109256,-1.133576:0.584828,0.615969,0.445197,0.538697,0.492452,0.401341,0.457625,0.381178,0.409414,0.374137,0.471986,0.373273,0.503603,0.528528,0.551779,0.614223,0.638659,0.676188:-0.48556,-0.48139,-0.35298,-0.510372,-0.455969,-0.348967,-0.361938,-0.261254,-0.276371,-0.197148,-0.16794,-0.006159,-0.0187,0.059673,0.086574,0.05292,0.088248,0.129072:-0.488109,-0.453664,-0.386929,-0.313265,-0.266664,-0.172996,-0.110897,-0.03975,-0.003157,0.004415,0.015951,0.047673,0.087968,0.15043,0.188938,0.200491,0.228351,0.238506:-0.256917,-0.256145,-0.271013,-0.271571,-0.269141,-0.230557,-0.186117,-0.139051,-0.086809,-0.04364,-0.028231,-0.042382,-0.087643,-0.116366,-0.129837,-0.153114,-0.193114,-0.207399:0.170366,0.166163,0.151032,0.146848,0.144285,0.108543,0.042189,0.002071,-0.027112,-0.016917,-0.029521,-0.024033,-0.053101,-0.09435,-0.115575,-0.128626,-0.133101,-0.128647:0.014956,0.043239,0.039579,0.024999,0.010743,-3.31E-4,0.011508,-0.024034,-0.056307,-0.090428,-0.113249,-0.21209,-0.218936,-0.192345,-0.174822,-0.168188,-0.172762,-0.165088:-0.367377,-0.410723,-0.373485,-0.462699,-0.473878,-0.472374,-0.489282,-0.466238,-0.487297,-0.493706,-0.501783,-0.468366,-0.511697,-0.51446,-0.508196,-0.492402,-0.471025,-0.454307:-0.061888,-0.08263,-0.150561,-0.108096,-0.153278,-0.217887,-0.242915,-0.278973,-0.257604,-0.277449,-0.233007,-0.176713,-0.092182,-0.085414,-0.077596,-0.019324,0.024167,0.050162:-0.056842,-0.049393,-0.03916,-0.071471,-0.059268,-0.02781,-0.037883,5.0E-6,0.017888,0.065628,0.058556,0.05215,0.083279,0.109744,0.102449,0.06302,0.032451,0.015813:-0.064352,-0.06615,-0.033287,-0.006742,0.035373,0.051337,0.088513,0.117888,0.106139,0.097693,0.070605,0.04707,-0.011618,-0.060069,-0.100282,-0.14604,-0.165645,-0.190043:6
1.259534,1.219327,1.241188,1.268577,1.146398,1.128901,1.11705,1.061848,1.002779,0.889897,0.899646,0.897661,0.902069,0.73602,0.786048:-0.631236,-0.707684,-0.74088,-0.779133,-0.777563,-0.806188,-0.85726,-0.918267,-0.957505,-0.982985,-1.095182,-1.152463,-1.208824,-1.110916,-1.188755:0.643496,0.6554,0.615651,0.599912,0.604159,0.616599,0.611355,0.615991,0.626199,0.613971,0.632156,0.662897,0.708058,0.665117,0.733441:-0.494182,-0.456533,-0.422633,-0.429587,-0.392916,-0.371544,-0.381858,-0.348399,-0.286339,-0.206479,-0.164232,-0.11451,-0.063894,0.058079,0.075772:-0.254993,-0.26537,-0.204815,-0.161519,-0.135031,-0.103122,-0.047734,-0.018156,-0.005473,0.023625,0.030434,0.031028,0.045809,0.078794,0.114855:-0.16659,-0.138909,-0.155757,-0.14715,-0.100074,-0.071264,-0.052746,-0.038553,-0.024808,-0.020845,-0.024014,-0.043124,-0.069504,-0.108833,-0.109624:0.192962,0.171791,0.172212,0.165541,0.14555,0.102573,0.047696,0.029499,0.026188,0.019899,-0.004403,-0.038781,-0.086225,-0.095201,-0.133172:-0.004144,-0.009636,-0.008574,-0.006357,-0.041911,-0.068942,-0.096986,-0.154764,-0.220196,-0.250536,-0.240497,-0.218511,-0.204549,-0.220656,-0.233188:-0.508749,-0.515449,-0.549111,-0.572398,-0.558354,-0.547875,-0.54673,-0.556857,-0.566175,-0.574625,-0.578241,-0.556533,-0.517578,-0.469347,-0.440615:-0.117363,-0.147923,-0.162118,-0.189696,-0.223499,-0.235126,-0.216438,-0.16363,-0.119322,-0.113826,-0.110826,-0.113451,-0.084725,-0.066468,-0.002848:-0.101869,-0.065765,-0.062803,-0.05968,-0.048889,-0.049804,-0.04969,-0.035215,-0.013191,0.017189,0.037891,0.056394,0.069341,0.078646,0.060805:-0.063942,-0.057546,-0.019773,0.010036,0.021309,0.032855,0.03002,0.005903,-0.008671,-0.011221,-0.028253,-0.047631,-0.0873,-0.093301,-0.133361:6
1.247432,1.259919,1.231621,1.175893,1.147569,1.119814,1.213177,1.18781,1.047909,1.254715,1.154768,0.997716,0.883507,0.758811,0.746688,0.646436:-0.351998,-0.52683,-0.590266,-0.599842,-0.705144,-0.729736,-0.724959,-0.682594,-0.677509,-0.742876,-0.766031,-0.830662,-0.974007,-1.027839,-1.039713,-1.039991:0.643287,0.72644,0.756347,0.755808,0.737772,0.69884,0.705807,0.654174,0.650338,0.714928,0.674113,0.658813,0.678095,0.672855,0.705754,0.84121:-0.562987,-0.554489,-0.574608,-0.575116,-0.53244,-0.452105,-0.393058,-0.298021,-0.250373,-0.200601,-0.140098,-0.153213,-0.148293,-0.031906,0.128445,0.177871:-0.293332,-0.303177,-0.297781,-0.225938,-0.179866,-0.115581,-0.067878,0.032687,0.170938,0.1784,0.198913,0.270923,0.298674,0.318513,0.319486,0.317965:-0.254712,-0.194913,-0.14374,-0.109637,-0.081251,-0.087091,-0.081048,-0.074635,-0.081675,-0.027172,-0.003686,-0.007215,-0.052798,-0.142713,-0.226575,-0.224438:0.09257,0.065669,0.054087,0.024894,0.008685,0.011443,0.008386,-0.020156,-0.09389,-0.087639,-0.085101,-0.138711,-0.167562,-0.19205,-0.225315,-0.262748:0.035554,0.007444,0.01096,0.026432,0.026815,0.041225,0.042743,0.018933,-0.010656,-0.099519,-0.163386,-0.14594,-0.134617,-0.12944,-0.113998,-0.093805:-0.380405,-0.410185,-0.417975,-0.439207,-0.483501,-0.513962,-0.543918,-0.544283,-0.528945,-0.548303,-0.541916,-0.543328,-0.541571,-0.513453,-0.455107,-0.392087:-0.048545,-0.068284,-0.112886,-0.17525,-0.196796,-0.241009,-0.26527,-0.287597,-0.262668,-0.187308,-0.135561,-0.126671,-0.092579,-0.046534,-0.01605,0.007793:-0.063068,-0.030606,-0.026832,-0.005177,0.016401,0.014978,0.047879,0.072969,0.059184,0.072544,0.07741,0.086084,0.071941,0.047561,0.015006,-0.008393:-0.087306,-0.061972,-0.043463,-0.008498,-0.02865,-0.017239,0.003413,0.047657,0.089834,0.0606,-0.00895,-0.066871,-0.104327,-0.163385,-0.22363,-0.280224:6
1.18932,1.207945,1.110709,1.229591,1.295878,1.441959,1.307743,1.424946,1.400902,1.349196,1.210844,1.258704,1.330195,1.162821,1.170109,1.101746,1.086524,1.046857:-0.522429,-0.464615,-0.438088,-0.629124,-0.748952,-0.811758,-0.657408,-0.74441,-0.726092,-0.751511,-0.846461,-1.006641,-1.147983,-1.123237,-1.243554,-1.2916,-1.330334,-1.311115:0.637606,0.635242,0.489849,0.500685,0.529249,0.484955,0.318177,0.362647,0.266147,0.308052,0.375743,0.448347,0.53372,0.502587,0.582585,0.630001,0.66328,0.680509:-0.637568,-0.711588,-0.564828,-0.488385,-0.469044,-0.41553,-0.305186,-0.306547,-0.176355,-0.183281,-0.121858,-0.107993,-0.062651,0.072713,0.070688,0.119372,0.153483,0.18575:-0.333684,-0.240508,-0.163023,-0.167432,-0.129947,-0.070676,0.069665,0.168556,0.192787,0.229138,0.210028,0.224752,0.212172,0.232718,0.23618,0.243279,0.245296,0.25549:-0.20493,-0.246199,-0.292704,-0.212137,-0.111428,-0.142634,-0.203824,-0.18711,-0.173405,-0.168975,-0.146894,-0.118254,-0.105697,-0.127463,-0.175814,-0.186848,-0.187325,-0.204137:0.194753,0.112248,0.126496,0.116963,0.025266,0.019961,0.013412,-0.051735,0.005442,-0.001578,-0.060757,-0.148557,-0.207437,-0.220405,-0.214074,-0.220989,-0.2325,-0.236487:0.008195,0.10601,0.095931,0.066347,0.034936,0.076318,0.079388,0.022747,-0.098757,-0.145555,-0.155236,-0.169015,-0.153542,-0.170105,-0.155807,-0.145535,-0.125189,-0.109916:-0.406871,-0.490479,-0.487186,-0.500928,-0.499993,-0.514388,-0.54292,-0.547223,-0.534396,-0.534696,-0.518749,-0.508067,-0.488959,-0.445814,-0.45335,-0.419942,-0.380573,-0.345942:-0.089503,-0.088601,-0.093752,-0.166752,-0.245053,-0.282507,-0.306689,-0.254454,-0.15687,-0.106812,-0.109442,-0.079886,-0.082427,-0.088225,-0.019861,6.65E-4,0.006493,0.00888:-0.088683,-0.004272,-0.025184,-5.35E-4,0.052866,0.020599,0.040119,0.036751,0.019766,-0.014855,0.043853,0.082036,0.106287,0.107888,0.065102,0.042978,0.022881,-0.00393:-0.015278,-0.084557,-0.056335,-0.019616,-0.005711,0.021697,0.073753,0.122666,0.100155,0.083367,0.019775,-0.042625,-0.088095,-0.105509,-0.144637,-0.163223,-0.193766,-0.21283:6
1.475315,1.465673,1.470111,1.536809,1.549377,1.350322,1.502901,1.528807,1.416561,1.318397,1.287884,1.430056,1.346722,1.470437,1.324942,1.353363,1.470096,1.317183,1.566602:-0.003594,-6.96E-4,-0.13314,-0.171874,-0.0941,-0.041887,-0.302647,-0.374301,-0.482543,-0.454654,-0.412934,-0.533702,-0.514749,-0.615006,-0.507445,-0.671092,-0.720329,-0.578943,-0.780984:0.3809,0.346916,0.478691,0.544604,0.488985,0.39133,0.51486,0.486975,0.556639,0.555724,0.52418,0.665118,0.628079,0.644612,0.50106,0.647623,0.730096,0.577404,0.678739:-0.56837,-0.563932,-0.650543,-0.638105,-0.630247,-0.472288,-0.499267,-0.510741,-0.440805,-0.377696,-0.313651,-0.335892,-0.255251,-0.247634,-0.116176,-0.15655,-0.194822,-0.115483,-0.056945:-0.356883,-0.3045,-0.223546,-0.153005,-0.110229,-0.106455,-0.039997,0.046059,0.073915,0.036719,0.028615,0.08462,0.143667,0.172849,0.197186,0.226385,0.288787,0.393529,0.357666:-0.224953,-0.194011,-0.197467,-0.19137,-0.138143,-0.110611,-0.117004,-0.082028,0.028283,0.058569,0.068264,0.022438,-0.033423,-0.066612,-0.080097,-0.101804,-0.093392,-0.072647,-0.083299:0.191555,0.209599,0.224249,0.147419,0.099511,0.111156,0.064353,-0.021063,-0.077499,-0.056829,-0.04368,-0.062262,-0.076787,-0.152016,-0.154119,-0.260498,-0.378543,-0.349053,-0.3751:0.019597,0.013715,0.050794,0.074154,0.015569,-0.029323,-0.049241,-0.088537,-0.178188,-0.212574,-0.226185,-0.213842,-0.199741,-0.164135,-0.192511,-0.168349,-0.172143,-0.195512,-0.210109:-0.416828,-0.42662,-0.487602,-0.516139,-0.534686,-0.570914,-0.590414,-0.577163,-0.531552,-0.542493,-0.566543,-0.599271,-0.57501,-0.547175,-0.474172,-0.445111,-0.410763,-0.379701,-0.375556:0.025104,-0.03775,-0.075771,-0.154361,-0.140826,-0.131989,-0.162105,-0.187307,-0.161313,-0.145898,-0.119602,-0.078319,-0.086118,-0.118564,-0.113788,-0.083964,-0.068693,-0.064702,-0.039639:-0.057017,-0.054144,-0.083618,-0.084752,-0.070017,-0.025498,0.005921,0.031677,0.055274,0.112564,0.158485,0.147162,0.133562,0.123681,0.094162,0.078226,0.05437,0.019578,-0.003697:-0.188528,-0.151718,-0.152217,-0.116875,-0.11965,-0.129095,-0.051134,0.030679,0.039498,-1.54E-4,-0.049367,-0.051755,-0.044638,-0.035026,-0.081155,-0.132759,-0.137891,-0.152505,-0.156123:6
1.481975,1.361194,1.25817,1.299703,1.470224,1.545818,1.418215,1.391589,1.360944,1.332752,1.08703,1.000728,1.061807,1.055924,1.166903,1.180265:-1.010089,-0.953543,-0.926415,-1.033326,-1.131631,-1.209313,-1.234137,-1.30125,-1.364934,-1.407902,-1.309947,-1.311801,-1.457912,-1.461475,-1.508719,-1.510219:0.556735,0.516016,0.483102,0.50682,0.491344,0.444745,0.444746,0.486193,0.520066,0.550565,0.507233,0.490099,0.556591,0.580394,0.631688,0.649464:-0.474556,-0.418132,-0.346821,-0.387111,-0.408561,-0.34876,-0.276417,-0.2243,-0.198988,-0.14208,-0.014253,0.026306,-0.02946,0.035645,0.068592,0.099096:-0.361992,-0.2869,-0.234243,-0.168471,-0.148337,-0.135206,-0.07688,-0.038115,-0.005368,0.011942,0.055577,0.075969,0.101989,0.09932,0.084305,0.078444:-0.183942,-0.19278,-0.201052,-0.14331,-0.099243,-0.073235,-0.052089,-0.007237,-0.005563,0.006857,-0.009868,-0.043534,-0.04503,-0.075678,-0.095872,-0.109984:0.113469,0.127962,0.136011,0.098481,0.06509,0.021694,-0.029326,-0.07196,-0.103245,-0.130171,-0.13657,-0.128623,-0.167034,-0.183885,-0.207832,-0.209346:0.082758,0.063525,0.061309,0.054313,0.052988,0.038223,-0.023102,-0.105643,-0.145513,-0.176086,-0.218698,-0.22634,-0.200683,-0.215045,-0.214742,-0.217641:-0.426734,-0.46678,-0.499281,-0.508302,-0.520042,-0.48945,-0.446,-0.445557,-0.481615,-0.49241,-0.465858,-0.468943,-0.473186,-0.440456,-0.434575,-0.441445:-0.197955,-0.228084,-0.244179,-0.262963,-0.298735,-0.343275,-0.310322,-0.238107,-0.212072,-0.216083,-0.23347,-0.207379,-0.16227,-0.124599,-0.075766,-0.056113:-0.043035,-0.036304,-0.020271,-0.045136,-0.035935,-0.017613,-0.022137,0.003723,0.037442,0.070219,0.073087,0.065434,0.053943,0.04736,0.06333,0.082004:-0.050021,0.004969,0.017621,0.045909,0.07311,0.088134,0.091122,0.043426,0.040297,0.046225,0.081377,0.065339,0.004117,-0.031727,-0.10268,-0.140684:6
1.340998,1.322174,1.323448,1.144672,1.270489,1.248704,1.17798,1.172725,1.167371,1.208245,1.169629,1.196778,1.113333,1.189472,1.203066,1.0471:-0.917866,-0.940527,-0.924705,-0.823903,-0.933509,-0.951991,-0.972939,-1.016678,-1.057366,-1.159131,-1.193498,-1.246502,-1.220508,-1.278137,-1.255112,-1.191087:0.594291,0.586035,0.587984,0.506087,0.565285,0.566627,0.574267,0.626404,0.681929,0.735369,0.762117,0.822365,0.835326,0.878847,0.865743,0.786197:-0.447085,-0.372946,-0.352111,-0.235601,-0.251313,-0.200236,-0.174995,-0.173006,-0.108504,-0.028937,0.044068,0.056387,0.116477,0.119991,0.141739,0.258341:-0.287023,-0.252619,-0.210136,-0.134834,-0.058706,-0.01068,0.049724,0.106946,0.089327,0.041546,0.044864,0.049954,0.067573,0.062837,0.073089,0.086126:-0.143762,-0.134868,-0.145645,-0.13062,-0.106294,-0.092332,-0.061949,-0.035895,-0.001106,0.013347,-0.003801,-0.026691,-0.052884,-0.071735,-0.10519,-0.129702:0.146041,0.142054,0.156904,0.126118,0.054382,0.013473,-0.051633,-0.091697,-0.075732,-0.089747,-0.120274,-0.160175,-0.173044,-0.208164,-0.211178,-0.185686:-0.023717,-0.076002,-0.088083,-0.102252,-0.111099,-0.14271,-0.154218,-0.179859,-0.222424,-0.229277,-0.234051,-0.232131,-0.239434,-0.228689,-0.239379,-0.274345:-0.489052,-0.510933,-0.550035,-0.53082,-0.56199,-0.562472,-0.533046,-0.506292,-0.513995,-0.495248,-0.465345,-0.448366,-0.417449,-0.405271,-0.386626,-0.339493:-0.152256,-0.159493,-0.153397,-0.213699,-0.197054,-0.195898,-0.197312,-0.155241,-0.095265,-0.086669,-0.084485,-0.057758,-0.057728,-0.042509,-0.021346,-0.036399:-0.047034,-0.027642,-0.026638,0.018864,0.044682,0.083771,0.102178,0.063861,0.072911,0.10503,0.101165,0.080872,0.05115,0.040606,0.009106,-0.016863:0.020057,0.060542,0.071684,0.098839,0.117194,0.135795,0.137966,0.12544,0.023566,-0.070874,-0.106801,-0.146546,-0.146887,-0.182912,-0.18565,-0.156776:6
1.034653,1.081954,1.065152,1.23081,1.202659,1.194171,1.051271,1.038615,0.987194,0.930006,0.947893,0.956988,0.935017,0.797955,0.863298,0.844102,0.802628,0.638825:-0.67631,-0.739473,-0.750934,-0.891865,-0.908279,-0.934876,-0.875806,-0.926484,-1.03451,-1.062901,-1.139863,-1.188002,-1.218541,-1.173301,-1.246822,-1.253039,-1.23337,-1.1489:0.497124,0.503994,0.464517,0.486675,0.530077,0.58329,0.550846,0.594705,0.632073,0.654087,0.678234,0.691794,0.700593,0.679055,0.735786,0.769955,0.785141,0.793079:-0.523016,-0.450451,-0.352645,-0.312746,-0.255568,-0.242101,-0.160076,-0.211489,-0.197158,-0.188168,-0.175902,-0.154097,-0.121257,-0.04174,-0.038704,0.013546,0.049695,0.11199:-0.066238,-0.031666,0.001901,-0.001963,0.010076,0.039716,0.116929,0.194008,0.164917,0.151374,0.141149,0.144386,0.160158,0.179831,0.165516,0.176106,0.19741,0.223545:-0.190942,-0.160427,-0.164626,-0.166147,-0.141989,-0.119451,-0.111413,-0.071219,0.00245,0.032728,0.019074,-0.002145,-0.024999,-0.056598,-0.070686,-0.106298,-0.126181,-0.126349:0.106408,0.119798,0.123266,0.052857,-0.007799,-0.046345,-0.07716,-0.116189,-0.10165,-0.128539,-0.153029,-0.169618,-0.184188,-0.181939,-0.206676,-0.234228,-0.242808,-0.247107:-0.007786,-0.052189,-0.08752,-0.10523,-0.120294,-0.12539,-0.142695,-0.159342,-0.241471,-0.264959,-0.265024,-0.260291,-0.252703,-0.262005,-0.245385,-0.240296,-0.234102,-0.245278:-0.539378,-0.557942,-0.56824,-0.560473,-0.560617,-0.570005,-0.537294,-0.511842,-0.508532,-0.513603,-0.507352,-0.500657,-0.495831,-0.478136,-0.449422,-0.406021,-0.382505,-0.342357:-0.144293,-0.143105,-0.13113,-0.139083,-0.171713,-0.173631,-0.169629,-0.141475,-0.068177,-0.057649,-0.045945,-0.040874,-0.032292,-0.031822,-0.012402,0.010798,0.02906,0.038391:-0.040289,-0.036842,-0.051614,-0.036536,0.02646,0.069119,0.09536,0.057744,0.020144,0.047432,0.043998,0.035799,0.033726,0.029826,0.005856,-0.02241,-0.034022,-0.033492:0.020843,0.052935,0.054464,0.074463,0.085202,0.092788,0.106315,0.112759,0.018206,-0.052639,-0.083725,-0.095322,-0.114736,-0.123794,-0.153371,-0.174831,-0.193895,-0.200758:6
1.158061,1.089483,1.140121,1.200164,1.31022,1.309911,1.172387,1.1015,1.058928,1.015742,0.947489,0.9494,0.966281,0.781054:-0.948163,-0.888355,-1.00086,-1.050984,-1.095431,-1.194915,-1.239765,-1.31243,-1.410315,-1.438532,-1.42149,-1.47882,-1.504167,-1.39408:0.634999,0.6358,0.649631,0.654163,0.673583,0.726867,0.732661,0.750933,0.752932,0.745623,0.737022,0.791224,0.806866,0.765083:-0.432067,-0.369385,-0.304563,-0.25566,-0.166199,-0.156287,-0.13188,-0.128598,-0.13226,-0.097464,-0.01611,-0.005851,0.025356,0.101649:-0.162264,-0.111068,-0.053447,-0.02858,-0.07936,-0.112809,-0.088137,-0.067159,-0.050453,-0.025198,-0.002465,0.007652,0.017483,0.071765:-0.073968,-0.059296,-0.024393,0.005184,0.041746,0.056348,0.056646,0.053295,0.047059,0.012593,-0.023101,-0.031177,-0.027836,-0.071973:0.06721,0.037917,-0.064925,-0.112941,-0.086472,-0.065795,-0.103302,-0.15458,-0.17999,-0.199062,-0.219634,-0.257486,-0.270959,-0.251327:-0.09661,-0.105577,-0.100297,-0.134182,-0.198097,-0.235567,-0.249728,-0.24362,-0.241781,-0.246622,-0.247393,-0.233523,-0.231116,-0.236143:-0.543469,-0.544757,-0.472287,-0.439093,-0.450522,-0.50222,-0.480188,-0.468906,-0.468898,-0.455209,-0.421241,-0.394729,-0.372256,-0.362436:-0.219391,-0.230968,-0.268626,-0.262296,-0.231737,-0.177514,-0.176951,-0.182049,-0.15748,-0.120688,-0.116705,-0.091481,-0.079807,-0.062525:-0.016955,0.025278,0.032843,0.040476,0.062278,0.107541,0.108801,0.128103,0.131414,0.113733,0.10013,0.0889,0.085298,0.068438:0.105845,0.112358,0.151389,0.161975,0.122723,0.0271,0.002915,-0.017411,-0.062843,-0.098037,-0.10705,-0.148543,-0.17053,-0.158809:6
1.259954,1.328669,1.264963,1.110724,1.292981,1.301962,1.274794,1.250819,1.214587,1.117069,1.081924,0.963658,0.964237,0.98958,1.073091,0.963196:-0.787096,-0.916602,-1.003192,-0.927659,-1.087232,-1.130021,-1.164505,-1.200268,-1.206208,-1.165213,-1.169429,-1.094936,-1.037881,-0.992231,-0.974883,-0.826938:0.592038,0.515903,0.523521,0.415219,0.460873,0.500083,0.531434,0.536094,0.538666,0.533815,0.563366,0.572057,0.578177,0.628068,0.684889,0.600913:-0.553397,-0.497382,-0.480716,-0.341517,-0.344661,-0.310538,-0.283951,-0.250094,-0.19238,-0.122257,-0.084532,0.010807,0.052143,0.061931,0.09784,0.188064:-0.371521,-0.328866,-0.284084,-0.25483,-0.19783,-0.097062,-0.019695,0.023409,0.05936,0.098339,0.114016,0.162846,0.216898,0.224444,0.243227,0.294375:-0.153607,-0.148446,-0.129507,-0.137854,-0.126266,-0.093219,-0.062209,-0.034995,-0.017521,-0.059447,-0.101377,-0.142882,-0.173997,-0.188834,-0.190471,-0.173696:0.18248,0.168169,0.118706,0.124636,0.084686,-0.012022,-0.087908,-0.130611,-0.156707,-0.134984,-0.13167,-0.169064,-0.204597,-0.184421,-0.185529,-0.192243:-0.036644,-0.051392,-0.049242,-0.087807,-0.093195,-0.129883,-0.151933,-0.183315,-0.229629,-0.270541,-0.273681,-0.26596,-0.25351,-0.261913,-0.235134,-0.221483:-0.465397,-0.491678,-0.513488,-0.503343,-0.548121,-0.525539,-0.512111,-0.496115,-0.475687,-0.507875,-0.522008,-0.485315,-0.464574,-0.456215,-0.444021,-0.393161:-0.075288,-0.105866,-0.147933,-0.200975,-0.161981,-0.1386,-0.138705,-0.141576,-0.122522,-0.054826,-0.018124,-0.012769,0.02301,0.068472,0.087624,0.067005:-0.049486,-0.036374,-0.007547,0.036791,0.057613,0.087528,0.12059,0.115373,0.095953,0.086655,0.079687,0.072918,0.069784,0.057945,0.061282,0.066119:-0.050991,-0.011316,0.020504,0.07355,0.05744,0.073592,0.076986,0.072407,0.059757,0.003551,-0.040794,-0.072287,-0.118261,-0.136569,-0.162343,-0.170751:6
1.10737,1.205153,1.223575,1.243636,1.110465,1.071542,0.986075,0.932707,1.034924,0.994368,0.831805,0.965232,0.962015,0.740723,0.77402,0.878465,0.849991,0.746579,0.77128:-0.605332,-0.73885,-0.792125,-0.893632,-0.90106,-0.953312,-0.940167,-0.976817,-1.006721,-0.900134,-0.800299,-0.933789,-1.092693,-1.090271,-1.156905,-1.209675,-1.204969,-1.224672,-1.307162:0.661735,0.694854,0.694628,0.728275,0.715304,0.714142,0.753731,0.768095,0.829548,0.882401,0.889818,0.832187,0.745396,0.807756,0.873211,0.87703,0.901927,0.904829,0.921189:-0.503308,-0.492392,-0.390969,-0.420055,-0.422569,-0.386054,-0.365487,-0.337055,-0.272737,-0.115993,-0.03679,-0.147503,-0.114167,0.016566,0.089143,0.142344,0.14526,0.176387,0.200274:-0.429914,-0.428205,-0.409554,-0.349834,-0.278344,-0.234379,-0.20869,-0.179324,-0.157446,-0.096797,-0.015062,0.114736,0.132173,0.118379,0.108222,0.111733,0.158626,0.194943,0.204535:-0.24088,-0.148922,-0.098558,-0.106033,-0.114396,-0.07743,-0.048645,-0.02244,0.030738,0.055576,0.035859,-0.02603,-0.069491,-0.075239,-0.058414,-0.042732,-0.051869,-0.04448,-0.050875:0.208082,0.161521,0.171398,0.143801,0.119108,0.077866,0.076433,0.032593,-0.002831,0.028302,0.001694,-0.110081,-0.137107,-0.135928,-0.180032,-0.19645,-0.211561,-0.223119,-0.22288:-0.049979,-0.048028,-0.048136,-0.006322,-0.009146,-0.049628,-0.088579,-0.086049,-0.117107,-0.181653,-0.155162,-0.1346,-0.132191,-0.190924,-0.203516,-0.194072,-0.17956,-0.169585,-0.138727:-0.382169,-0.388136,-0.401536,-0.43769,-0.455898,-0.446999,-0.471299,-0.470287,-0.476136,-0.489784,-0.461888,-0.469463,-0.474639,-0.429563,-0.401796,-0.401479,-0.408869,-0.377184,-0.337455:-0.05621,-0.127261,-0.209825,-0.208483,-0.222478,-0.253104,-0.264286,-0.279371,-0.261788,-0.183852,-0.169619,-0.144421,-0.151247,-0.138141,-0.125242,-0.125774,-0.089407,-0.06955,-0.055442:-0.12227,-0.092452,-0.068045,-0.081148,-0.099773,-0.105461,-0.100473,-0.062722,5.66E-4,0.045175,0.057458,0.041704,0.020851,-0.017253,0.010086,0.060217,0.070039,0.06026,0.030553:-0.053564,-0.041208,0.010986,-0.006195,0.003359,0.042403,0.090767,0.090801,0.087962,0.070579,0.031703,0.001223,-0.026937,-0.020647,-0.060287,-0.106988,-0.151467,-0.172243,-0.185787:6
1.476116,1.483,1.356828,1.352387,1.497337,1.572841,1.441644,1.322181,1.280128,1.339393,1.292445,1.208549,1.138174,1.090906,1.090386,0.930633,0.931108,0.967345,0.911327,0.689207,0.854157,0.790754,0.773523:-0.431381,-0.484287,-0.50516,-0.575318,-0.820831,-0.984496,-1.027775,-1.141936,-1.285297,-1.431136,-1.515696,-1.550089,-1.531207,-1.517946,-1.547776,-1.474761,-1.499134,-1.564415,-1.53941,-1.399435,-1.578688,-1.589402,-1.621559:0.500206,0.467696,0.558085,0.558668,0.56663,0.531606,0.469282,0.525423,0.592337,0.6327,0.642562,0.661287,0.693824,0.741775,0.779651,0.781919,0.80801,0.844262,0.858975,0.806121,0.917331,0.926438,0.955955:-0.486574,-0.491289,-0.562218,-0.492096,-0.389477,-0.325024,-0.254219,-0.25459,-0.242184,-0.186249,-0.175019,-0.124531,-0.067221,-0.002102,0.057335,0.099054,0.118332,0.127402,0.137653,0.241176,0.158939,0.190566,0.195903:-0.302261,-0.304173,-0.211929,-0.176872,-0.182923,-0.191842,-0.132398,-0.120174,-0.137212,-0.178269,-0.158117,-0.127899,-0.095868,-0.064291,-0.046176,-0.011079,-0.011681,-0.01654,-0.006664,0.007185,0.021866,0.045545,0.060906:-0.245085,-0.236406,-0.187443,-0.184703,-0.14572,-0.085718,-0.053491,-0.006015,0.042735,0.090132,0.089277,0.074759,0.03781,0.036377,0.073985,0.055198,0.053033,0.052651,0.019671,-0.018692,-0.001841,0.002589,0.013032:0.293794,0.265742,0.167755,0.173964,0.110275,0.052575,0.002349,-0.038116,-0.062135,-0.10121,-0.148907,-0.185433,-0.208636,-0.219771,-0.225614,-0.219881,-0.228213,-0.237556,-0.243787,-0.232525,-0.278118,-0.288792,-0.308575:-0.102038,-0.082567,-0.011211,-0.045067,-0.062363,-0.118874,-0.17947,-0.212327,-0.230899,-0.254574,-0.265141,-0.280762,-0.284456,-0.287282,-0.287864,-0.287593,-0.279029,-0.26713,-0.259006,-0.285879,-0.235521,-0.239591,-0.234849:-0.383325,-0.400275,-0.495178,-0.574958,-0.570959,-0.529082,-0.46036,-0.462702,-0.47937,-0.456808,-0.440025,-0.418726,-0.408831,-0.387038,-0.348912,-0.339138,-0.32647,-0.318748,-0.308545,-0.272159,-0.271116,-0.25238,-0.238649:-0.078616,-0.140942,-0.179937,-0.141366,-0.167417,-0.176606,-0.183034,-0.174191,-0.179867,-0.201837,-0.177949,-0.156737,-0.121423,-0.095707,-0.103679,-0.094106,-0.09904,-0.096537,-0.078947,-0.071388,-0.063062,-0.063572,-0.06174:-0.177148,-0.146832,-0.036894,0.007583,0.047676,0.074958,0.038645,0.049427,0.083922,0.131122,0.151491,0.154132,0.159305,0.152737,0.139114,0.115566,0.10675,0.096583,0.072521,0.043413,0.024703,0.005329,-0.009798:0.094089,0.11785,0.099139,0.085496,0.110126,0.107055,0.13824,0.107788,0.07877,0.0622,0.028312,0.015082,-0.014137,-0.048005,-0.059486,-0.068869,-0.088879,-0.124222,-0.144778,-0.12718,-0.202084,-0.216147,-0.242715:6
1.603599,1.580632,1.394119,1.545045,1.394987,1.38088,1.361857,1.330718,1.242638,1.196743,1.179397,1.094117,1.126969,1.097545,1.118958,1.083565,1.047572:-0.854714,-0.935021,-0.842547,-1.04488,-1.024594,-1.088884,-1.127691,-1.161525,-1.179714,-1.203635,-1.255387,-1.252446,-1.2948,-1.298518,-1.335508,-1.355381,-1.391221:0.465069,0.420516,0.337951,0.449866,0.447252,0.434862,0.466987,0.495923,0.52405,0.52053,0.535601,0.537616,0.570054,0.567811,0.59873,0.634809,0.662749:-0.44174,-0.394744,-0.295848,-0.341064,-0.286633,-0.258334,-0.232226,-0.21428,-0.165074,-0.116091,-0.073899,-0.0091,0.040193,0.092415,0.096198,0.149027,0.201307:-0.308291,-0.29973,-0.255927,-0.198937,-0.109301,-0.057178,-0.02932,-0.003152,-0.00736,-0.005658,0.006212,0.03006,0.048719,0.085883,0.110555,0.120886,0.121449:-0.249908,-0.237974,-0.212102,-0.183007,-0.167045,-0.160456,-0.127703,-0.113902,-0.112715,-0.110528,-0.108286,-0.121733,-0.146305,-0.176722,-0.199761,-0.223928,-0.221925:0.154271,0.133882,0.107081,0.073316,0.046543,-0.005354,-0.033718,-0.039891,-0.023096,-0.030277,-0.065782,-0.095492,-0.124812,-0.137656,-0.130551,-0.149001,-0.174932:0.074124,0.064622,0.028158,0.039108,0.035974,-0.006995,-0.054818,-0.093025,-0.140802,-0.172409,-0.174976,-0.178261,-0.18584,-0.19885,-0.182906,-0.160657,-0.170679:-0.439309,-0.452322,-0.421091,-0.484482,-0.507682,-0.503244,-0.509588,-0.543587,-0.575784,-0.576026,-0.568769,-0.546786,-0.519575,-0.48597,-0.484801,-0.448988,-0.413261:-0.109583,-0.154193,-0.202157,-0.197735,-0.224243,-0.224272,-0.218698,-0.186327,-0.149782,-0.132519,-0.129898,-0.124415,-0.084449,-0.042017,-0.001983,0.001553,0.009987:-0.038042,-0.006302,-0.004194,0.019005,0.053333,0.042211,0.040627,0.05457,0.071877,0.095037,0.124839,0.13501,0.130188,0.101551,0.071378,0.048794,0.046101:-0.055254,-0.046571,-0.001833,0.01983,0.041537,0.06548,0.081899,0.059376,0.021667,-0.00647,-0.030892,-0.045494,-0.075355,-0.093998,-0.122479,-0.144016,-0.171098:6
1.181048,1.150096,1.123556,1.097707,1.099359,1.169148,1.076546,1.127856,1.079024,1.095119,1.066176,1.03734,1.005823,0.909669,0.898349,0.930363,0.855688,0.62619:-0.3578,-0.421398,-0.478166,-0.509407,-0.556266,-0.610125,-0.55557,-0.628892,-0.654572,-0.658545,-0.701104,-0.729928,-0.764569,-0.774773,-0.841082,-0.936547,-0.952561,-0.879055:0.661938,0.603048,0.613227,0.652308,0.621079,0.677433,0.643228,0.670321,0.689991,0.748849,0.742634,0.735715,0.754002,0.780904,0.829244,0.860894,0.874124,0.861277:-0.438535,-0.430003,-0.431595,-0.421148,-0.377981,-0.387634,-0.361558,-0.403553,-0.376072,-0.4044,-0.388113,-0.370837,-0.333315,-0.245667,-0.18249,-0.119368,-0.05077,0.096518:-0.050509,-0.001233,0.025728,0.03737,0.049686,0.069538,0.104745,0.128764,0.175756,0.197077,0.216058,0.232453,0.222728,0.213615,0.198387,0.184104,0.208106,0.238168:-0.227421,-0.229908,-0.218733,-0.202089,-0.18131,-0.1396,-0.146838,-0.116904,-0.073509,-0.029426,0.004589,0.04171,0.060289,0.024467,-0.020213,-0.054906,-0.08901,-0.124827:0.142114,0.106716,0.074722,0.03806,0.041597,0.003933,-0.001351,-0.041367,-0.075891,-0.103647,-0.126046,-0.144266,-0.151573,-0.142376,-0.163584,-0.194335,-0.231108,-0.244472:-5.42E-4,-0.016474,0.004881,0.021318,-0.022297,-0.039692,-0.017327,-0.006429,-0.028217,-0.047705,-0.08168,-0.114775,-0.154358,-0.165697,-0.154856,-0.144847,-0.120152,-0.126765:-0.533345,-0.550235,-0.55799,-0.573267,-0.602418,-0.607221,-0.604904,-0.600627,-0.596072,-0.589923,-0.568224,-0.553161,-0.544925,-0.552074,-0.534631,-0.50946,-0.479897,-0.426022:-0.074131,-0.109317,-0.160457,-0.19817,-0.175806,-0.179056,-0.204557,-0.221439,-0.228822,-0.22583,-0.207388,-0.187216,-0.147358,-0.1256,-0.1115,-0.092925,-0.100117,-0.070556:-0.032611,-0.031891,-0.022397,0.004121,0.020346,0.037517,0.060815,0.079984,0.104838,0.099085,0.077311,0.060592,0.055327,0.074719,0.080832,0.078573,0.087155,0.082275:-0.023583,0.005921,0.027792,0.030465,0.022966,0.046272,0.046093,0.062461,0.066532,0.06158,0.03245,-0.009417,-0.06156,-0.101964,-0.135315,-0.1696,-0.186521,-0.227512:6
1.256069,1.198657,1.128482,1.235712,1.320994,1.400772,1.349601,1.253826,1.322338,1.411989,1.398039,1.401812,1.301663,1.298085,1.144795,1.075241:-0.526357,-0.594007,-0.654465,-0.737539,-0.751425,-0.640919,-0.448581,-0.579812,-0.816828,-1.044377,-1.135426,-1.168996,-1.122131,-1.30772,-1.329349,-1.328752:0.466377,0.422178,0.414107,0.465291,0.521521,0.539861,0.530376,0.442106,0.503305,0.610495,0.662155,0.669745,0.596436,0.700503,0.730744,0.712629:-0.612471,-0.518505,-0.458253,-0.423216,-0.385579,-0.392223,-0.424426,-0.265848,-0.211526,-0.171258,-0.099369,-0.06018,0.082245,0.108739,0.130372,0.17937:-0.292177,-0.221645,-0.169476,-0.157336,-0.111612,-0.016884,0.099865,0.104222,0.082521,0.013834,-0.001912,0.041458,0.043244,0.018764,0.041549,0.04461:-0.164393,-0.191629,-0.174776,-0.164891,-0.173793,-0.166158,-0.103916,0.005311,-0.016969,-0.018225,-0.009968,-0.036182,-0.026478,-0.005041,-0.020189,-0.007362:0.175305,0.219928,0.193418,0.191581,0.171389,0.081029,-0.026187,-0.076707,-0.052918,-0.024709,-0.035877,-0.068033,-0.09238,-0.154181,-0.169543,-0.174582:-0.030676,-0.034923,-0.051219,-0.07816,-0.101022,-0.113247,-0.089946,-0.204776,-0.231834,-0.224349,-0.236596,-0.231904,-0.297886,-0.295119,-0.290997,-0.30743:-0.37889,-0.439069,-0.462841,-0.532678,-0.600861,-0.566484,-0.533859,-0.443379,-0.459799,-0.532384,-0.536046,-0.524948,-0.437665,-0.406942,-0.406587,-0.383663:-0.035565,-0.076824,-0.103143,-0.106469,-0.093159,-0.141091,-0.183821,-0.134814,-0.108558,-0.064478,-0.062039,-0.047173,-0.080423,-0.075928,-0.066015,-0.065465:-0.138636,-0.11865,-0.095769,-0.055405,-0.016519,-0.022639,0.019147,0.005578,-0.003337,0.066504,0.098503,0.08348,0.06567,0.070203,0.077655,0.091121:-0.087781,-0.03698,-0.001982,0.019296,0.042387,0.131888,0.102953,0.068214,0.081322,-0.003302,-0.051084,-0.080986,-0.052089,-0.09636,-0.105285,-0.100907:6
1.004513,1.16922,1.244426,1.368325,1.425748,1.461222,1.415053,1.257947,1.43927,1.530038,1.325889,1.336233,1.201294,1.133428,1.098069,0.810968,0.622752,0.694512:-0.499973,-0.641545,-0.59982,-0.571296,-0.497343,-0.595732,-0.697745,-0.768455,-0.87426,-0.97121,-0.971994,-1.101578,-1.19464,-1.298368,-1.357499,-1.339541,-1.320937,-1.410857:0.500392,0.359847,0.441967,0.51881,0.472648,0.400818,0.406259,0.378137,0.376952,0.447154,0.458697,0.579537,0.678235,0.729998,0.767398,0.833911,0.860476,0.850765:-0.610621,-0.572922,-0.577377,-0.493638,-0.380089,-0.328032,-0.260107,-0.154935,-0.102012,-0.091374,-0.045473,-0.084292,-0.053973,0.018945,0.053158,0.090119,0.131111,0.114904:-0.26145,-0.135464,-0.095188,-0.109403,-0.020198,-0.003454,0.040571,0.082684,0.109828,0.098096,0.116355,0.107026,0.101259,0.089451,0.125358,0.187902,0.231664,0.244578:-0.235527,-0.228687,-0.198948,-0.183541,-0.210628,-0.214698,-0.226653,-0.184693,-0.115004,-0.090164,-0.024857,-0.007139,-0.0017,-0.003499,-0.061698,-0.063727,-0.064475,-0.033879:0.147833,0.13841,0.101102,0.084193,0.073453,0.071472,0.04772,-2.41E-4,-0.030819,-0.049441,-0.116176,-0.192587,-0.234878,-0.259848,-0.265815,-0.260481,-0.254404,-0.2951:0.067185,0.142058,0.165765,0.116392,0.060825,0.012056,0.016126,-0.027844,-0.110279,-0.205767,-0.26153,-0.250247,-0.24615,-0.239089,-0.201264,-0.181129,-0.162812,-0.141479:-0.355655,-0.448694,-0.425678,-0.434307,-0.519335,-0.56218,-0.581574,-0.528154,-0.49789,-0.507063,-0.447076,-0.441745,-0.42953,-0.40206,-0.384147,-0.331848,-0.300756,-0.264368:-0.14257,-0.194981,-0.249824,-0.261492,-0.271067,-0.24633,-0.24136,-0.232747,-0.194121,-0.121341,-0.120348,-0.108521,-0.098847,-0.094141,-0.027998,0.014186,0.026563,0.008985:-0.055246,-0.063488,-0.110264,-0.101845,-0.027126,0.011094,0.048252,0.056291,0.043872,0.026305,0.040217,0.07535,0.096879,0.110387,0.070592,0.019407,-0.006559,-0.021132:-0.01954,-0.02398,-0.002252,0.018133,0.075473,0.085075,0.10035,0.103342,0.090632,0.055239,0.011919,-0.051305,-0.101101,-0.15121,-0.224239,-0.249478,-0.268214,-0.307895:6
1.284445,1.364664,1.514501,1.467328,1.486222,1.398857,1.504959,1.531179,1.437946,1.331841,1.26088,1.318568,1.331593,1.062083,1.039478:-0.757409,-0.79345,-0.840579,-0.812496,-0.838016,-0.843555,-0.980107,-1.027116,-1.005841,-0.981198,-0.997824,-1.113749,-1.243777,-1.223951,-1.342883:0.461098,0.486713,0.526016,0.484999,0.439936,0.419714,0.491495,0.518359,0.532637,0.519193,0.551437,0.637821,0.69626,0.724928,0.797611:-0.418506,-0.419918,-0.449961,-0.38406,-0.325918,-0.260312,-0.288554,-0.230613,-0.173631,-0.072367,-0.008171,-0.019539,0.028462,0.103454,0.065107:-0.433144,-0.36805,-0.281604,-0.201052,-0.119964,-0.074811,-0.08904,-0.075758,0.017931,0.045304,0.052535,0.041922,0.028159,0.099742,0.118014:-0.268315,-0.245936,-0.238572,-0.222844,-0.233653,-0.219191,-0.166141,-0.106192,-0.064419,-0.023913,-0.005522,-0.044897,-0.053134,-0.091787,-0.077913:0.188045,0.160919,0.144086,0.145388,0.125171,0.091789,0.052588,-0.00253,-0.064826,-0.064468,-0.08154,-0.103664,-0.159412,-0.21272,-0.261272:-0.011427,0.010935,0.027994,-0.009637,-0.034476,-0.065808,-0.085489,-0.121558,-0.164543,-0.24675,-0.270718,-0.244629,-0.231706,-0.252339,-0.248671:-0.346821,-0.384593,-0.450759,-0.456715,-0.507134,-0.503989,-0.538262,-0.529184,-0.482945,-0.425153,-0.414714,-0.442896,-0.422072,-0.382005,-0.368653:-0.144014,-0.168379,-0.166211,-0.187982,-0.187466,-0.218947,-0.205292,-0.216737,-0.200339,-0.160943,-0.137798,-0.106613,-0.091522,-0.046379,-0.003345:-0.092516,-0.082432,-0.096325,-0.106431,-0.075315,-0.04885,-0.024444,0.036463,0.03363,0.002498,0.016235,0.04102,0.059937,0.033678,0.014439:0.009954,0.027343,0.060684,0.10198,0.1128,0.139438,0.12213,0.106708,0.121073,0.102852,0.035156,-0.028466,-0.105762,-0.154875,-0.200121:6
0.270476,0.284982,0.302741,0.260881,0.288063,0.29364,0.277221,0.203877,0.212564,0.201364,0.148459,0.089105,0.059269,0.029695,-0.00381,0.036188:0.098453,0.092512,0.035903,0.006115,-0.04937,-0.096783,-0.129859,-0.13379,-0.177629,-0.236191,-0.292103,-0.307422,-0.331437,-0.376396,-0.42039,-0.451585:-0.267792,-0.329693,-0.298024,-0.246145,-0.252133,-0.296357,-0.326199,-0.287951,-0.276083,-0.264897,-0.211948,-0.136119,-0.049039,0.028613,0.130114,0.154886:-0.54662,-0.511112,-0.50045,-0.538635,-0.526488,-0.46816,-0.420824,-0.414723,-0.345903,-0.277923,-0.223347,-0.179931,-0.152731,-0.120745,-0.083383,-0.033464:0.116515,0.127773,0.14133,0.222047,0.275424,0.288203,0.326922,0.425166,0.479798,0.535859,0.560816,0.604005,0.650818,0.633195,0.590851,0.554506:-0.46075,-0.433444,-0.379288,-0.31564,-0.271148,-0.221655,-0.201319,-0.203538,-0.192577,-0.183579,-0.185919,-0.195046,-0.175265,-0.147233,-0.148937,-0.16086:-0.126412,-0.09361,-0.110061,-0.181907,-0.203542,-0.217182,-0.228941,-0.262818,-0.293437,-0.337114,-0.359755,-0.369272,-0.395092,-0.40659,-0.394848,-0.345244:0.208075,0.150256,0.107191,0.095921,0.096465,0.055182,-0.012461,-0.053209,-0.090196,-0.106824,-0.112216,-0.118221,-0.089274,-0.067195,-0.055324,-0.081654:0.079692,0.099022,0.080943,0.029666,-0.036681,-0.053875,-0.056093,-0.12114,-0.150675,-0.185612,-0.214759,-0.225139,-0.253034,-0.267707,-0.258838,-0.271531:-0.191732,-0.258941,-0.272467,-0.256613,-0.270462,-0.322153,-0.35858,-0.305376,-0.299412,-0.273583,-0.240224,-0.205109,-0.171063,-0.16585,-0.175741,-0.166301:-0.031982,-0.012201,-0.024626,-0.044449,-0.065457,-0.050468,-0.007337,0.007968,0.027717,0.027242,0.029637,0.019123,-0.001468,0.007001,8.53E-4,0.028735:-0.041928,-0.063243,-0.036182,-0.002522,0.020918,0.014123,9.48E-4,0.013844,0.021909,0.01469,0.010479,0.008935,0.010849,-0.005511,-0.015109,-0.053305:7
0.79038,0.774632,0.651157,0.607521,0.562894,0.677368,0.877874,0.875748,0.735151,0.648092,0.665054,0.654801,0.631147,0.522577,0.554101:-0.138758,-0.088985,-0.047365,0.087523,0.135599,0.062947,-0.154097,-0.186202,-0.101555,-0.11136,-0.005056,-0.032105,-0.141348,-0.063791,-0.249099:0.012358,-0.067976,0.029222,-0.114,-0.0141,0.062029,0.074888,-0.075255,-0.149772,-0.013503,-0.134014,-0.110844,0.066141,-0.034528,0.092946:-0.403113,-0.235511,-0.253112,-0.258665,-0.506949,-0.543795,-0.407528,-0.25034,-0.199733,-0.107982,0.019208,-0.024932,-0.088292,0.132922,0.31078:0.062791,0.073462,0.212237,0.298024,0.333246,0.321176,0.350877,0.481669,0.650803,0.554774,0.509268,0.573408,0.61085,0.553406,0.489052:-0.24999,-0.199881,-0.222108,-0.126101,-0.171163,-0.096911,-0.100082,-0.220148,-0.184737,-0.046395,-0.021679,-0.033073,-0.030966,-0.083428,-0.093039:-0.188509,-0.186207,-0.259933,-0.266776,-0.143669,-0.125659,-0.192568,-0.176695,-0.254935,-0.373743,-0.401146,-0.369212,-0.345191,-0.3459,-0.38648:0.067043,-0.032335,-0.070679,-0.073884,0.062846,0.068755,0.076126,0.035322,0.020467,-0.016395,-0.10908,-0.103315,-0.052832,-0.10268,-0.106867:0.232258,0.238448,0.226877,0.21704,0.013247,0.003425,0.037061,-0.066948,-0.08686,-0.03744,0.091641,0.029875,-0.073009,0.055291,0.170561:-0.276177,-0.300173,-0.28454,-0.302956,-0.248889,-0.28279,-0.309518,-0.153697,-0.096168,-0.115084,-0.208879,-0.203188,-0.192487,-0.271922,-0.214704:-0.090851,-0.070663,0.027267,0.074169,-0.011843,-0.008992,-0.06804,-0.113877,-0.047707,-0.014273,0.098537,0.116421,0.111793,0.155577,0.011271:0.185411,0.202732,0.202159,0.128942,0.172583,0.200055,0.158784,0.105832,0.022479,0.080149,0.066528,0.062104,0.083348,0.006428,-0.025375:7
0.730195,0.763428,0.776739,0.72583,0.639676,0.565237,0.535934,0.530718,0.658059,0.607636,0.637075,0.586814,0.474634,0.601774,0.682617:-0.204716,-0.268447,-0.255931,-0.197195,-0.223721,-0.113186,-0.171206,-0.193599,-0.24168,-0.153301,-0.194839,-0.265163,-0.35558,-0.547324,-0.65817:-0.15991,-0.123506,-0.110159,-0.084453,-0.03383,-0.208459,-0.217951,-0.188115,-0.091001,-0.144844,-0.147311,-0.023279,0.076711,0.127115,0.242356:-0.493037,-0.511376,-0.493745,-0.475174,-0.43968,-0.302928,-0.230098,-0.168379,-0.051294,0.031987,0.066371,0.075461,0.157199,0.224132,0.260405:0.096264,0.186524,0.245103,0.289589,0.335584,0.306674,0.326363,0.375714,0.400764,0.466647,0.570665,0.598891,0.527434,0.421391,0.352451:-0.277894,-0.280354,-0.241153,-0.206188,-0.200952,-0.140532,-0.131845,-0.134012,-0.070575,-0.136877,-0.21965,-0.171597,-0.099101,-0.084698,-0.077406:-0.134821,-0.187328,-0.20989,-0.200711,-0.269946,-0.230392,-0.205911,-0.230663,-0.30039,-0.255536,-0.256223,-0.319011,-0.278555,-0.115623,-0.052303:-0.030484,-0.018254,-0.015478,-0.064349,-0.028719,-0.165924,-0.207607,-0.183821,-0.206751,-0.273719,-0.245473,-0.142927,-0.116862,-0.221208,-0.244964:0.227274,0.152138,0.057852,0.034126,0.0702,0.110929,0.052677,0.020211,0.041989,0.05992,-0.004172,-0.077995,-0.064139,0.027114,-0.012514:-0.250995,-0.229896,-0.207986,-0.235114,-0.267728,-0.382808,-0.403211,-0.430068,-0.385496,-0.328963,-0.247728,-0.207877,-0.247026,-0.310719,-0.255894:-0.106156,-0.079937,-0.08897,-0.079077,-0.069653,0.021243,0.041411,0.072029,0.039136,0.01096,-0.012567,0.007932,0.063898,0.028623,-0.024792:0.132879,0.142682,0.125638,0.137687,0.128041,0.097223,0.113318,0.113871,0.134485,0.111778,0.091247,0.062894,0.056111,0.127094,0.126863:7
0.902153,0.720054,0.627705,0.713655,0.679819,0.726379,0.858397,0.839697,0.556553,0.422316,0.351058,0.358272,0.417844,0.406895,0.403286,0.419164,0.346265:0.123377,0.09003,0.167462,0.222301,0.258023,0.260105,0.125327,-0.032307,0.156199,0.245855,0.136234,0.023361,-0.127413,-0.228547,-0.28882,-0.349052,-0.335656:-0.038666,0.061797,0.061156,-0.019891,-0.098039,-0.125494,-0.202058,-0.109941,-0.200506,-0.359272,-0.239619,-0.192843,-0.081788,0.057846,0.029327,0.097237,0.073745:-0.742025,-0.703073,-0.636077,-0.572527,-0.574506,-0.59203,-0.4684,-0.377445,-0.290508,-0.162428,-0.078564,-0.009388,0.128534,0.149494,0.231738,0.309367,0.400296:0.35075,0.25802,0.238338,0.280094,0.326123,0.469809,0.599942,0.618927,0.619252,0.668178,0.618622,0.566652,0.513444,0.568954,0.524862,0.450941,0.531391:-0.6093,-0.414263,-0.387392,-0.415087,-0.376286,-0.281562,-0.310248,-0.198915,-0.122021,-0.147432,-0.017526,-0.036375,-0.080386,-0.089752,-0.044455,-0.061245,-0.121883:-0.086326,-0.149997,-0.160236,-0.049934,0.005047,-0.011175,-0.105602,-0.179193,-0.162035,-0.178808,-0.242059,-0.159902,-0.076521,-0.096248,-0.12252,-0.094968,-0.122007:0.24408,0.199849,0.180512,0.117692,0.035314,-0.08087,-0.104535,-0.140367,-0.187474,-0.209232,-0.294022,-0.336436,-0.338347,-0.3265,-0.351875,-0.343055,-0.292892:0.009915,0.147352,0.173535,0.10597,0.021382,-0.098089,-0.063001,-0.067781,-0.036557,-0.006985,0.144256,0.107171,0.012412,0.046002,0.089907,0.096372,0.086418:0.031003,-0.049842,-0.089087,-0.099011,-0.113177,-0.087209,-0.040194,-0.082237,-0.160846,-0.164149,-0.293782,-0.235743,-0.160086,-0.193454,-0.221178,-0.249291,-0.214471:-0.248772,-0.254755,-0.271151,-0.267878,-0.233397,-0.184442,-0.218035,-0.152367,-0.095459,-0.022173,0.08124,0.024699,-0.071202,-0.102433,-0.044241,-0.039222,-0.043681:0.048195,0.10526,0.140432,0.150671,0.166125,0.186664,0.147661,0.201499,0.171187,0.057185,0.029821,0.062999,0.159135,0.170672,0.071006,0.079409,0.04056:7
1.194775,1.214958,1.135349,0.918991,0.937885,0.912545,0.838215,0.673434,0.66569,0.577588,0.599668,0.40669,0.381127,0.437844,0.370719:-0.462486,-0.397175,-0.163906,0.0423,-0.096322,-0.213157,-0.231375,-0.129584,-0.174976,-0.205036,-0.345307,-0.307235,-0.354712,-0.479207,-0.518045:0.227398,0.151269,-0.017786,-0.076187,5.24E-4,0.008972,0.009023,0.064194,-0.031377,0.020344,0.168561,0.176845,0.198766,0.271182,0.269944:-0.431797,-0.3007,-0.27966,-0.280914,-0.279735,-0.279044,-0.286517,-0.143003,-0.048315,-0.004735,0.060909,0.157082,0.205211,0.220401,0.343891:0.079123,0.025897,0.052679,0.219866,0.338871,0.432266,0.510858,0.419341,0.401867,0.461831,0.456091,0.426065,0.455367,0.488943,0.420634:-0.230045,-0.067949,-0.117538,-0.201805,-0.128599,-0.063385,-0.007418,0.046975,0.078077,0.030604,0.001132,-0.061839,-0.036841,-0.025621,-0.017033:-0.109375,-0.148034,0.02297,0.012126,-0.047182,-0.063307,-0.050501,0.020218,-0.001286,-0.027867,-0.035219,-0.025723,-0.096439,-0.092027,-0.060386:-0.057774,-0.105565,-0.185628,-0.171802,-0.258002,-0.29576,-0.325293,-0.294192,-0.303694,-0.305754,-0.27258,-0.267501,-0.268225,-0.286087,-0.280185:0.137441,0.172683,0.221246,0.185472,0.154544,0.092337,0.07267,0.027578,0.051749,0.105371,0.157247,0.061007,0.082613,0.100709,0.133462:-0.06556,-0.172706,-0.257527,-0.20501,-0.184215,-0.154655,-0.13856,-0.24682,-0.260411,-0.264089,-0.285678,-0.255282,-0.240919,-0.209208,-0.23871:-0.357976,-0.275474,-0.24496,-0.227861,-0.182567,-0.204752,-0.245809,-0.150704,-0.024093,-0.029368,-0.036327,-0.00266,-0.005935,-0.038245,-0.022181:0.174829,0.180626,0.200014,0.156605,0.259986,0.28117,0.274428,0.254569,0.155977,0.193629,0.22197,0.115614,0.103587,0.143372,0.097341:7
0.751368,0.870508,1.162422,1.09559,0.954703,0.856404,0.726771,0.520171,0.433318,0.310066,0.161717,0.113237:-0.38529,-0.278949,-0.231121,-0.147706,-0.218083,-0.136714,-0.126238,-0.067206,-0.026723,0.010263,0.003943,-0.078871:0.363311,0.288143,0.174308,0.088658,0.172138,0.288482,0.13895,0.018076,0.071304,-0.019539,-0.01723,0.265486:-0.624651,-0.67124,-0.590169,-0.627827,-0.631099,-0.615342,-0.383747,-0.201061,-0.163512,-0.05794,0.034545,-0.022787:-0.048582,-0.035475,-0.037654,0.104575,0.102223,0.005861,0.027579,0.050443,0.239392,0.390281,0.404944,0.389378:-0.439491,-0.463218,-0.451904,-0.41991,-0.300104,-0.117167,-0.079243,-0.017061,-0.007162,-0.012961,0.011999,0.01837:-0.162832,-0.15806,-0.107628,-0.104858,-0.146355,-0.157958,-0.204808,-0.264669,-0.256158,-0.268539,-0.287385,-0.340597:0.174025,0.224485,0.140492,0.124009,0.12038,0.058649,0.001875,-0.090686,-0.203925,-0.317458,-0.350034,-0.247731:0.121268,0.075503,0.116039,0.070925,0.039392,0.030243,0.099414,0.10179,0.062396,0.123698,0.182909,0.145906:-0.032977,-0.078325,-0.065414,-0.091796,-0.159711,-0.177854,-0.283707,-0.305821,-0.301177,-0.306437,-0.260738,-0.182154:-0.190445,-0.149308,-0.215855,-0.244149,-0.229809,-0.179237,-0.181269,-0.054685,0.064261,0.105707,0.037462,-0.07335:0.190638,0.122562,0.143814,0.133406,0.160441,0.189393,0.27114,0.229715,0.221221,0.16726,0.10205,0.075498:7
0.703713,0.764757,0.87756,0.980254,1.118897,1.206608,1.014535,0.8593,0.812438,0.776777,0.731671,0.711652,0.754927,0.749386,0.643784,0.534509:0.306394,0.147362,0.038182,0.093507,-0.00372,-0.088925,0.102065,0.120359,0.188438,0.204795,0.203906,0.1388,-0.025743,-0.113751,-0.201254,-0.222463:-0.196537,-0.115803,-0.025716,-0.158372,-0.183199,-0.097985,-0.15473,-0.201216,-0.202446,-0.206386,-0.17272,-0.045262,0.031459,-0.031027,0.006383,0.080409:-0.436165,-0.506976,-0.625674,-0.574882,-0.514221,-0.561938,-0.519289,-0.398492,-0.336469,-0.284199,-0.190215,-0.032919,-0.003068,0.048173,0.121646,0.196957:0.06201,0.067324,0.061544,0.107726,0.094271,0.145483,0.115894,0.09004,0.098581,0.197523,0.223806,0.113212,0.162514,0.325329,0.334174,0.400351:-0.583281,-0.489535,-0.329284,-0.239226,-0.166366,-0.136174,-0.10738,0.015459,0.069988,0.089725,0.115915,0.138384,0.167657,0.151343,0.12242,0.04956:-0.161898,-0.200693,-0.135636,-0.136223,-0.141794,-0.138851,-0.070462,-0.120501,-0.112247,-0.124193,-0.146444,-0.130763,-0.138643,-0.15565,-0.104284,-0.111527:0.0053,0.058418,-0.011393,-0.102524,-0.109135,-0.052434,-0.057929,-0.241466,-0.275844,-0.33388,-0.391278,-0.45486,-0.44611,-0.412618,-0.382721,-0.319572:0.208565,0.17837,0.100497,0.192952,0.246137,0.11919,0.054918,0.204424,0.194366,0.193546,0.220323,0.189614,0.132829,0.137711,0.111452,0.12667:0.073781,0.099282,0.107749,0.052039,-0.050955,-0.032189,-0.156508,-0.326814,-0.385642,-0.339024,-0.328178,-0.310239,-0.297557,-0.352777,-0.316538,-0.259622:-0.144255,-0.214002,-0.243882,-0.231219,-0.240771,-0.260543,-0.161515,-0.085227,-0.013411,0.012246,0.021537,0.085686,0.139653,0.117364,0.053713,0.006396:0.051012,0.02297,0.042841,0.037589,0.002738,0.010129,0.070649,0.110785,0.0743,0.044273,0.041868,0.056645,0.084126,0.125905,0.118162,0.075474:7
1.070879,1.09602,0.934346,0.954628,0.986026,0.873611,0.746344,0.703244,0.790754,0.868898,0.702161,0.564374,0.515545,0.475899,0.475791,0.371621,0.242802,0.355298:-0.150548,-0.146752,-0.116284,-0.16793,-0.144583,-0.023981,0.014601,0.099851,0.041629,-0.058017,-0.007596,0.024939,0.074505,0.061478,-0.014732,-0.138429,-0.142445,-0.197174:0.22419,0.166483,0.181779,0.224789,0.16201,0.017128,-0.072506,-0.117714,-0.089151,-0.028115,-0.099788,-0.184054,-0.23112,-0.32,-0.228719,-0.127157,-0.117264,-0.019066:-0.199109,-0.18897,-0.198908,-0.228967,-0.275671,-0.284459,-0.334399,-0.379426,-0.335268,-0.415441,-0.401013,-0.254175,-0.115949,-0.039319,-0.039474,-0.020467,0.047272,0.124511:-0.138297,-0.051525,-0.0529,-0.073453,-0.110157,-0.134012,-0.064172,0.00465,-0.010831,0.127581,0.215422,0.205845,0.249978,0.373034,0.430947,0.516823,0.543094,0.531389:-0.600274,-0.607151,-0.520199,-0.46085,-0.429524,-0.368215,-0.32515,-0.299586,-0.255361,-0.202123,-0.082547,0.013213,0.068378,0.097619,0.141989,0.112698,0.100009,0.121905:-0.080412,-0.063264,-0.109674,-0.079965,-0.010034,0.06066,0.037121,0.009877,0.047227,0.035926,-0.056655,-0.108647,-0.087664,-0.077577,-0.105945,-0.168334,-0.199595,-0.199062:0.094137,0.075765,0.060996,0.008564,-0.026822,-0.100929,-0.062665,-0.098502,-0.21399,-0.172358,-0.149143,-0.254242,-0.40721,-0.457756,-0.433738,-0.389438,-0.387438,-0.382257:0.009706,0.00889,0.012423,0.032422,0.066143,0.087929,0.067163,0.112813,0.180814,0.105458,0.095219,0.202694,0.235423,0.190917,0.174031,0.131768,0.13897,0.165872:0.27783,0.222402,0.208651,0.216906,0.203964,0.169734,0.11149,0.025636,0.062573,0.024978,-0.00986,-0.124875,-0.219098,-0.197295,-0.244279,-0.175161,-0.169692,-0.207812:-0.185975,-0.216841,-0.266168,-0.32255,-0.357063,-0.357017,-0.357734,-0.295874,-0.343058,-0.352699,-0.34137,-0.229219,-0.124596,-0.076749,-0.023965,-0.104436,-0.099782,-0.061924:-1.81E-4,0.031977,0.019906,0.005052,0.009797,0.034666,0.063287,0.091672,0.082165,0.113522,0.116966,0.117785,0.173756,0.176271,0.177425,0.219361,0.203728,0.117038:7
1.363378,1.156297,1.101213,1.139012,1.202413,1.235588,1.253363,1.183576,1.057944,0.939227,0.764103,0.80328,0.793699,0.751475,0.694662,0.698632,0.820575,0.671629:-0.358834,-0.185644,-0.050451,-0.153881,-0.231033,-0.173101,-0.099956,-0.113412,-0.019077,0.136501,0.167663,0.030748,0.06172,-0.133045,-0.237237,-0.247022,-0.316212,-0.279357:0.131645,0.066343,0.014013,-0.006289,0.004585,0.0732,-0.045515,-0.102302,-0.153857,-0.229893,-0.169035,-0.168784,-0.126923,-0.091844,-0.048835,-0.028292,0.011797,0.083082:-0.644438,-0.565661,-0.558147,-0.524026,-0.515272,-0.574897,-0.55553,-0.547663,-0.415058,-0.27259,-0.228981,-0.174638,-0.169866,-0.024303,0.045111,0.099093,0.079225,0.119866:-0.077857,0.033979,0.04646,0.012412,0.034719,0.112237,0.15524,0.242348,0.258274,0.218956,0.296024,0.443282,0.397638,0.404658,0.438568,0.428761,0.499611,0.479148:-0.264122,-0.331191,-0.38676,-0.314122,-0.236199,-0.218425,-0.177468,-0.107258,-0.057572,0.013812,0.058144,0.027086,0.135321,0.123541,0.107709,0.096403,0.012904,0.009585:-0.033536,-0.092838,-0.078329,-0.032306,-0.043448,-0.095956,-0.103305,-0.119214,-0.118614,-0.159209,-0.173638,-0.156976,-0.154747,-0.229884,-0.248873,-0.280441,-0.260009,-0.239633:0.042273,0.106038,0.074737,-0.044458,-0.079742,-0.003633,-0.046456,-0.139069,-0.180259,-0.186673,-0.259427,-0.329658,-0.385241,-0.337413,-0.334405,-0.346294,-0.347335,-0.3468:0.189287,0.139354,0.191253,0.235331,0.267786,0.201157,0.181655,0.139522,0.132834,0.175316,0.179628,0.153879,0.133355,0.089209,0.073028,0.155164,0.200648,0.167605:0.11682,-0.003834,-0.060727,-0.106654,-0.157689,-0.130344,-0.197442,-0.204364,-0.281487,-0.428743,-0.411664,-0.373783,-0.376372,-0.298829,-0.270523,-0.322611,-0.256103,-0.227574:-0.297872,-0.238914,-0.249844,-0.280883,-0.329022,-0.321495,-0.236633,-0.193147,-0.125807,0.016362,0.074537,0.084535,0.134027,0.091141,0.05555,0.073573,0.008808,-0.001791:0.084266,0.096384,0.144467,0.193137,0.220682,0.202852,0.169804,0.173388,0.180004,0.123597,0.125755,0.156531,0.13837,0.098654,0.097304,0.083447,0.066524,0.043064:7
0.548104,0.670835,0.577584,0.58471,0.588989,0.447857,0.240954,0.110646,0.113997,0.210251,0.144708,0.094089,0.11879,0.024138:0.274866,-0.028446,0.100419,0.197262,0.169054,0.160534,0.19523,0.259182,0.37093,0.355076,0.299555,0.393493,0.309464,0.135502:0.118615,0.317136,0.318291,0.245418,0.173294,0.217448,0.330976,0.355309,0.357314,0.357306,0.346215,0.300407,0.366659,0.441591:-0.756206,-0.784261,-0.793402,-0.733009,-0.639831,-0.608348,-0.643625,-0.664998,-0.605788,-0.50093,-0.426521,-0.342607,-0.232219,-0.214072:0.220663,0.2072,0.166042,0.202826,0.270091,0.41284,0.478077,0.376459,0.330507,0.307736,0.391121,0.5054,0.485348,0.516995:-0.286738,-0.068017,-0.006859,0.050857,0.037269,-0.020214,0.02857,0.133911,0.207682,0.235986,0.202977,0.117104,0.076239,0.104728:-0.064831,-0.263079,-0.126772,-0.111176,-0.090024,-0.113581,-0.105401,-0.006476,-0.007448,-0.023874,-0.050558,-0.065473,-0.021241,-0.067859:0.007564,0.112666,0.021863,-0.020089,-0.099298,-0.148112,-0.19881,-0.259095,-0.312505,-0.376218,-0.33516,-0.261031,-0.230139,-0.18985:-0.113411,-0.198725,-0.260434,-0.267981,-0.197408,-0.144841,-0.171915,-0.185538,-0.163158,-0.119844,-0.132221,-0.155345,-0.14021,-0.057288:-0.197765,-0.190141,-0.179965,-0.191991,-0.228095,-0.177833,-0.12606,-0.205749,-0.234173,-0.23276,-0.197433,-0.170864,-0.122743,-0.13523:-0.002322,-0.013576,-0.036973,-0.058939,-0.043654,-0.005622,0.00657,-0.018595,0.004435,0.067159,0.057069,0.026359,-0.048374,-0.034955:0.051623,0.017349,0.062204,0.078991,0.085067,0.049561,0.029987,0.055693,0.040287,0.001061,-0.020543,-0.017601,0.004037,-0.023099:7
0.716836,0.725534,0.688316,0.565081,0.648325,0.572164,0.493768,0.569942,0.825991,1.065389,1.071243,0.913232,0.811688,0.743329,0.719351,0.655654,0.741097,0.701835,0.581816,0.528385:0.103005,0.117655,0.17218,0.167608,0.080283,0.036461,0.058252,0.0402,-0.039023,-0.177448,-0.151289,-0.036372,-0.041195,-0.001359,0.05934,0.131103,0.144215,0.030347,-0.031937,-0.107958:0.020043,-0.085199,-0.207963,-0.222292,-0.158763,-0.204269,-0.282994,-0.339593,-0.326757,-0.307652,-0.359024,-0.441218,-0.402919,-0.366396,-0.352855,-0.418584,-0.405692,-0.219217,-0.022543,0.053873:-0.608663,-0.635749,-0.602582,-0.572433,-0.572833,-0.557616,-0.588192,-0.626963,-0.608232,-0.512901,-0.422499,-0.308177,-0.241807,-0.233604,-0.218685,-0.076802,-0.039482,-0.004521,-0.018539,0.015416:0.131365,0.17485,0.206958,0.225449,0.209411,0.216621,0.273668,0.39004,0.431427,0.368211,0.356582,0.37135,0.394471,0.461575,0.5366,0.583625,0.649303,0.590363,0.553016,0.577099:-0.50103,-0.481153,-0.49205,-0.457759,-0.3659,-0.306309,-0.290566,-0.300065,-0.250491,-0.105637,-0.021803,-0.010545,0.043401,0.086403,0.107294,0.1032,0.106067,0.080515,0.031488,-0.032083:-0.2229,-0.188076,-0.1413,-0.135347,-0.166841,-0.144118,-0.12347,-0.096903,-0.098979,-0.157278,-0.222403,-0.233029,-0.244001,-0.226518,-0.165271,-0.132816,-0.157984,-0.160759,-0.124791,-0.098971:0.040351,0.039896,0.013163,0.003001,0.001616,-0.059896,-0.090827,-0.09263,-0.126114,-0.161018,-0.16583,-0.225099,-0.285334,-0.345604,-0.409795,-0.438268,-0.408523,-0.364684,-0.300488,-0.261075:0.145841,0.15118,0.174879,0.111169,0.12946,0.116818,0.083296,0.042916,0.02375,0.034288,0.017524,-0.007103,0.007795,0.001421,1.96E-4,-0.007453,0.022394,0.056529,0.011053,-0.004431:0.053422,0.034164,-1.82E-4,0.019479,-0.011893,-0.068791,-0.080584,-0.06091,-0.09317,-0.202501,-0.270575,-0.250282,-0.269369,-0.279955,-0.269763,-0.229515,-0.248256,-0.306423,-0.324473,-0.310102:-0.162706,-0.17163,-0.16682,-0.204295,-0.218786,-0.17567,-0.174066,-0.175218,-0.192192,-0.15005,-0.073985,-0.010836,0.023862,0.100352,0.150521,0.142599,0.171706,0.13567,0.130112,0.11442:0.063287,0.038639,0.026259,0.041928,0.036313,0.038849,0.031883,0.0086,0.030871,0.035195,0.013764,0.017514,0.030839,0.053456,0.054229,0.002983,-0.067994,-0.02646,0.010339,0.007618:7
0.650159,0.773239,0.904218,0.938675,0.848725,0.916589,0.984334,0.830802,0.722474,0.810859,0.985914,0.860405,0.719533,0.614402,0.733068,0.610691,0.359302,0.387342,0.419765:0.155664,0.152211,-0.004576,0.023574,0.296991,0.376917,0.500038,0.392278,0.249703,0.246529,0.094765,0.038344,0.121478,0.19358,-0.001347,-0.078456,-0.083524,-0.109611,-0.195546:0.173922,0.261752,0.181403,0.084784,-0.050698,-0.161634,-0.341242,-0.220569,-0.152376,-0.344302,-0.344447,-0.262211,-0.239961,-0.249888,-0.24271,-0.207199,-0.114448,-0.042045,-0.010002:-0.738689,-0.769157,-0.667094,-0.655138,-0.665804,-0.625643,-0.509376,-0.533332,-0.504859,-0.307832,-0.335217,-0.449754,-0.497921,-0.465526,-0.312746,-0.231089,-0.246095,-0.276858,-0.172654:0.113113,0.095864,0.129488,0.184891,0.164584,0.240534,0.234451,0.141774,0.159391,0.106458,0.174459,0.320435,0.393719,0.411273,0.349113,0.411206,0.477124,0.546174,0.525422:-0.337403,-0.298104,-0.253842,-0.253405,-0.150966,-0.317035,-0.370253,-0.207904,-0.140313,-0.04001,0.031181,-0.007659,0.014247,0.010476,0.036849,0.018073,0.042602,0.057677,0.057725:-0.048256,-0.132626,-0.226739,-0.194068,-0.187742,-0.078787,-0.064773,-0.046733,-0.078585,-0.100592,-0.022828,-0.089679,-0.109037,-0.054348,-0.040773,-0.054186,-0.066355,-0.088576,-0.106152:0.171061,0.186494,0.190839,0.12137,0.053567,0.107591,0.099809,0.011193,-0.032098,-0.139689,-0.230124,-0.194997,-0.203665,-0.217718,-0.235751,-0.279123,-0.310251,-0.309022,-0.307305:0.074121,0.084616,0.141335,0.181675,0.122063,-0.010355,0.060814,0.037707,0.063032,0.195593,0.151646,0.072535,-0.014659,-0.061283,-5.26E-4,0.016798,-0.011409,-0.063023,-0.035977:0.073482,0.062151,0.039045,0.032298,0.065002,0.093918,0.016511,-0.075405,-0.134368,-0.261719,-0.207754,-0.186491,-0.147381,-0.177295,-0.283642,-0.23859,-0.178323,-0.118781,-0.168374:-0.141652,-0.109979,-0.099425,-0.139064,-0.113035,-0.132539,-0.099015,-0.051165,-0.099379,-0.004813,-0.103292,-0.119881,-0.087308,-0.029119,0.019444,-0.052587,-0.057698,-0.032784,0.009737:0.053097,0.040085,-0.009617,0.020327,0.025737,0.00432,-0.046389,0.020682,0.073077,-0.0088,0.058162,0.095684,0.103975,0.082027,0.077892,0.125214,0.157072,0.132467,0.101812:7
1.285348,1.234952,1.323329,1.437674,1.321933,1.157555,1.121419,1.192538,1.120257,1.098037,0.896141,0.838705,1.086322,1.125552,0.901329,0.69927,0.755943:0.111532,0.256511,0.065829,-0.17565,-0.153052,0.069387,0.263271,0.208497,0.221327,0.208307,0.092572,-0.028597,-0.123785,-0.177788,-0.117416,-0.139315,-0.234192:-0.060241,-0.14721,0.058051,0.183853,0.173866,0.036665,-0.077006,-0.199273,-0.260917,-0.164377,-0.203808,-0.157815,-0.10298,-0.14411,-0.047357,0.043776,0.131946:-0.492503,-0.60801,-0.604627,-0.523521,-0.565434,-0.492347,-0.437653,-0.325455,-0.297754,-0.403886,-0.279805,-0.243073,-0.191042,-0.080991,-0.093151,-0.038256,-0.022576:0.198828,0.344945,0.231969,0.094097,0.200283,0.233644,0.245918,0.383742,0.482467,0.533379,0.438773,0.473924,0.514085,0.536563,0.526941,0.611083,0.657428:-0.361884,-0.372668,-0.219829,-0.046512,-0.007391,-0.072328,-0.09215,-0.089884,0.004486,0.017218,0.04175,0.031096,0.049436,0.0414,0.14643,0.109343,0.046258:-0.13872,-0.168556,-0.205612,-0.24437,-0.271259,-0.185873,-0.095798,-0.064346,-0.067867,-0.020951,-0.034183,-0.062836,-0.030148,0.055871,-0.00493,-0.097136,-0.121304:0.006787,0.054191,0.027793,-0.055487,-0.045796,-0.10399,-0.180984,-0.249768,-0.286448,-0.256557,-0.31276,-0.332914,-0.426636,-0.459455,-0.452857,-0.420825,-0.390504:0.128374,0.094094,0.125151,0.193996,0.122709,0.147703,0.134539,0.074518,0.016583,-0.042874,0.081443,0.120144,0.105672,0.003831,0.016302,0.047383,0.051343:0.149877,0.072406,0.024491,0.032223,0.046206,-0.004642,-0.057826,-0.078695,-0.116442,-0.135296,-0.184544,-0.186528,-0.171936,-0.088969,-0.124026,-0.138031,-0.140328:-0.222979,-0.168031,-0.194507,-0.26525,-0.243298,-0.260044,-0.19564,-0.17077,-0.153862,-0.175771,-0.151816,-0.166896,-0.183314,-0.179241,-0.164872,-0.173446,-0.17884:-0.013935,-0.069095,-0.034407,-0.032747,-0.041851,0.017207,0.040033,0.051157,0.068302,0.123795,0.100544,0.120144,0.1802,0.161472,0.19872,0.186977,0.181861:7
1.183498,1.125884,1.228159,1.362947,1.327239,1.303473,1.193592,1.173759,1.262086,1.138932,1.016415,1.002846,0.991315,0.984302:-0.057054,-0.075572,-0.045327,-0.105669,0.008159,0.061678,0.007236,-0.076823,-0.107102,-0.116417,-0.150885,-0.161145,-0.211662,-0.267201:-0.08568,-0.106466,-0.24728,-0.235899,-0.360363,-0.419736,-0.326149,-0.252782,-0.385652,-0.347155,-0.327467,-0.301386,-0.226759,-0.195942:-0.392438,-0.414814,-0.331945,-0.299552,-0.344126,-0.356361,-0.357578,-0.38015,-0.261639,-0.268741,-0.223203,-0.212167,-0.168593,-0.128987:0.017563,0.085597,0.118037,0.044095,0.120031,0.226337,0.260698,0.301318,0.25599,0.310962,0.351918,0.43878,0.477782,0.473977:-0.450217,-0.450401,-0.442142,-0.333086,-0.281193,-0.280468,-0.225869,-0.157553,-0.079795,-0.070606,-0.029582,-0.001859,0.033093,0.092844:-0.120485,-0.100894,-0.065199,-0.0726,-0.058301,-0.056252,-0.054035,-0.05686,-0.075781,-0.107354,-0.11601,-0.131466,-0.136195,-0.164937:0.001754,-0.030667,-0.064805,-0.102632,-0.140168,-0.147412,-0.196265,-0.260989,-0.292342,-0.276367,-0.31937,-0.34303,-0.373948,-0.39813:0.234762,0.221894,0.232892,0.246258,0.253235,0.189741,0.147624,0.14813,0.156403,0.14833,0.122343,0.072894,0.060786,0.100887:0.017001,0.010705,0.005554,-0.054875,-0.114102,-0.112799,-0.135581,-0.173707,-0.260766,-0.279092,-0.278586,-0.257907,-0.256922,-0.276545:-0.200041,-0.241244,-0.253451,-0.223096,-0.202768,-0.220786,-0.229989,-0.240726,-0.173547,-0.159549,-0.147104,-0.12615,-0.129906,-0.126065:-1.79E-4,4.58E-4,-0.032615,-0.032552,-0.049534,-0.057526,-0.004907,0.065232,0.023451,0.047801,0.079536,0.115682,0.157551,0.160859:7
1.108526,1.093488,1.070433,1.125299,1.002566,0.8871,0.848414,0.88681,1.081315,1.095303,1.047716,1.00663,0.880999,0.93502:0.20733,0.124629,0.142668,0.081193,0.099462,0.258772,0.286842,0.268051,0.077142,0.004629,0.00219,-0.076317,-0.093216,-0.161159:0.069011,0.059685,0.040546,-0.020029,0.009276,-0.070026,-0.256618,-0.357663,-0.357404,-0.35574,-0.403992,-0.380497,-0.320292,-0.297368:-0.550783,-0.547318,-0.522867,-0.452912,-0.548991,-0.509357,-0.453822,-0.36939,-0.330956,-0.264038,-0.258492,-0.125423,9.7E-4,0.032312:0.066487,0.073256,0.073061,0.027025,0.088565,0.131754,0.183369,0.196698,0.240958,0.265287,0.34617,0.322994,0.30737,0.369319:-0.321717,-0.314467,-0.327084,-0.211492,-0.094387,-0.061289,0.044283,0.064339,0.130138,0.216972,0.280416,0.279548,0.224663,0.142008:-0.235579,-0.149069,-0.093532,-0.100367,-0.103712,-0.107228,-0.136921,-0.081476,-0.084624,-0.173424,-0.154609,-0.174918,-0.13932,-0.111344:-0.069561,-0.057421,-0.03265,-0.114208,-0.145437,-0.187249,-0.244139,-0.275215,-0.347289,-0.399461,-0.460329,-0.436746,-0.456486,-0.445013:0.371652,0.332224,0.287273,0.34846,0.282817,0.28409,0.246569,0.228211,0.222993,0.227458,0.189222,0.133418,0.086199,0.082757:0.037239,-0.030325,-0.083709,-0.184508,-0.21009,-0.248988,-0.246284,-0.262497,-0.272231,-0.27903,-0.323564,-0.320293,-0.263074,-0.247446:-0.134384,-0.174957,-0.178037,-0.169164,-0.148787,-0.057143,0.013448,0.016616,0.014809,0.04746,0.122503,0.101552,0.07432,0.056302:0.099605,0.141287,0.14309,0.132919,0.167673,0.127535,0.065389,0.03653,0.046623,0.018841,0.03992,0.009049,0.002348,-0.008657:7
1.155331,1.091056,1.071155,1.10864,1.04316,0.965559,0.944129,0.850136,0.79103,0.794426,0.824606,0.756592,0.708499,0.538269,0.494856,0.609769,0.341665,0.176264:0.173344,0.131367,0.134988,0.209838,0.223947,0.14766,0.129056,0.166634,0.267029,0.25674,0.077539,-0.040646,-0.039787,-0.032727,-0.12626,-0.178244,-0.106975,-0.157214:0.061243,0.045224,0.015895,-0.087871,-0.156705,-0.095109,-0.09625,-0.263079,-0.333222,-0.2745,-0.203572,-0.176551,-0.148294,0.003727,0.076447,0.118844,0.199579,0.207642:-0.597401,-0.623343,-0.661343,-0.681314,-0.636438,-0.552669,-0.559938,-0.401595,-0.277435,-0.188005,-0.08658,0.05265,0.096877,0.07687,0.098763,0.174275,0.212472,0.234381:-0.01211,-0.021591,0.084376,0.2155,0.309312,0.359044,0.436717,0.428909,0.461552,0.464989,0.434482,0.385364,0.555051,0.610795,0.643121,0.631433,0.6122,0.619726:-0.294244,-0.167412,-0.114149,-0.081306,-0.082851,-0.054068,0.030038,0.007183,-0.002203,0.101787,0.13979,0.097028,0.03726,0.011294,0.011567,0.005875,-0.026706,-0.03913:-0.043577,-0.001009,7.62E-4,-0.016804,-0.049077,-0.091278,-0.071162,-0.03225,-0.035555,-0.090415,-0.129568,-0.097734,-0.127384,-0.146411,-0.106521,-0.04803,-0.030453,-0.033889:-0.02243,-0.077438,-0.078747,-0.076815,-0.084643,-0.163413,-0.205449,-0.219123,-0.222127,-0.3362,-0.365567,-0.355945,-0.402931,-0.355545,-0.376547,-0.426082,-0.370683,-0.321925:0.278174,0.235569,0.164375,0.069241,0.063702,0.09795,7.43E-4,-0.002376,0.004956,0.050328,0.059102,0.049887,0.071905,0.066988,0.083874,0.095144,0.055461,0.072668:0.06519,0.024508,-0.008188,-0.031149,-0.071414,-0.083117,-0.130226,-0.204709,-0.236826,-0.26149,-0.297389,-0.281221,-0.178803,-0.169049,-0.144949,-0.11351,-0.123792,-0.134282:-0.252903,-0.273085,-0.277662,-0.217559,-0.17423,-0.217352,-0.18341,-0.07783,-0.009456,0.097793,0.125518,0.078369,-0.01029,-0.019006,-0.009855,-0.027387,-0.005029,-0.003921:0.117708,0.138323,0.148123,0.102007,0.06121,0.149115,0.159862,0.09798,0.033268,0.002298,0.02839,0.034836,0.040001,0.068179,0.097414,0.120258,0.10198,0.075523:7
0.732247,0.865934,1.049399,0.960002,0.842121,0.863575,0.856538,0.73113,0.718481,0.753305,0.752538,0.619864,0.502384,0.501877,0.461038,0.316336,0.114097:0.276072,0.162034,0.121095,0.135038,0.041689,0.014045,0.111177,0.326706,0.323105,0.318571,0.190656,0.078999,-0.072002,-0.189825,-0.146572,-0.24579,-0.269393:0.053669,0.053873,-0.077056,-0.177885,-0.074154,-0.019188,-0.094654,-0.242973,-0.28109,-0.224167,-0.216562,-0.165986,-0.087919,0.063814,0.026025,0.071611,0.137969:-0.464589,-0.582767,-0.557083,-0.538948,-0.580079,-0.622597,-0.572706,-0.502175,-0.479944,-0.346751,-0.157499,-0.15959,-0.08263,-0.114845,-0.026734,0.097203,0.16691:0.276488,0.331915,0.323221,0.426034,0.483995,0.485763,0.410608,0.410412,0.428652,0.39295,0.459369,0.548867,0.581183,0.686259,0.733693,0.638661,0.593071:-0.374238,-0.28195,-0.289304,-0.235177,-0.119997,-0.043027,-0.010303,0.065306,0.125913,0.049339,-0.031955,0.105886,0.15673,0.08915,0.005245,-0.007257,-0.040353:-0.251761,-0.164692,-0.097402,-0.152203,-0.222325,-0.221738,-0.173909,-0.1901,-0.152204,-0.124268,-0.104718,-0.12797,-0.192088,-0.195499,-0.186564,-0.196719,-0.169688:0.003655,0.058127,0.043672,0.00378,0.002819,0.074946,0.106604,-0.046827,-0.170743,-0.196921,-0.240652,-0.294546,-0.296606,-0.300628,-0.292799,-0.227938,-0.255395:0.168791,0.166044,0.215076,0.159199,0.06517,0.024799,-0.010361,0.064336,0.057847,0.062642,0.113874,0.123988,0.100295,0.051787,0.033907,0.017649,0.060007:0.027575,-0.013995,-0.035396,-0.12383,-0.125305,-0.131245,-0.156691,-0.220133,-0.235572,-0.25065,-0.232269,-0.246858,-0.231915,-0.144826,-0.134221,-0.155344,-0.193379:-0.07858,-0.203816,-0.193431,-0.065262,-0.074848,-0.127277,-0.055793,0.069504,0.159968,0.162824,0.101101,0.07388,0.045884,0.032952,0.084604,0.091442,0.070867:0.073431,0.098383,0.005164,-0.02135,0.056078,0.026748,0.017027,0.008047,0.049766,0.039313,0.041815,0.061726,0.087406,0.103472,0.04513,0.021378,0.049111:7
1.584443,1.485649,1.244245,1.218462,1.256932,1.323269,1.31029,1.391544,1.269804,1.244641,1.367439,1.086478,0.804641,0.928218,0.94741,0.824516,0.750882,0.606272,0.668863,0.70305:-0.071195,-0.005289,0.203685,0.250587,0.195565,0.092221,0.035203,0.035005,0.11893,-8.5E-5,-0.061215,0.004871,0.06196,-0.02549,0.004727,0.075805,0.092802,0.171732,0.126406,0.037389:0.188304,0.178911,0.047482,0.018106,0.003693,0.106862,0.088331,0.131949,0.182148,0.023588,-0.065244,-0.090266,-0.073655,-0.11227,-0.108798,-0.078302,-0.075935,-0.065787,-0.016071,0.101009:-0.573001,-0.679359,-0.739677,-0.666762,-0.570559,-0.745172,-0.743101,-0.765491,-0.757912,-0.54162,-0.521582,-0.44412,-0.376346,-0.307128,-0.236206,-0.202387,-0.158514,-0.111036,-0.053439,-0.058042:0.032065,0.184535,0.288531,0.311522,0.128529,0.189702,0.371487,0.336349,0.244222,0.40031,0.546403,0.614279,0.719195,0.79366,0.826593,0.803324,0.816684,0.914657,0.820705,0.72939:-0.376243,-0.373757,-0.449021,-0.367332,-0.181321,-0.103157,-0.170122,-0.07643,0.080274,0.061074,1.14E-4,-0.01437,-0.042949,-0.023338,-0.045123,0.008224,-0.006366,-0.08137,-0.035983,0.073848:-0.191701,-0.201366,-0.117396,-0.143144,-0.01969,-0.024931,-0.100883,-0.033474,-0.012199,-0.109368,-0.120312,-0.061759,-0.098358,-0.155424,-0.151883,-0.151416,-0.164261,-0.176788,-0.164903,-0.200747:0.144188,0.182236,0.252845,0.163242,-0.014663,0.009364,0.075945,0.031032,-0.084603,-0.141149,-0.151882,-0.200192,-0.19541,-0.258068,-0.301528,-0.34841,-0.351231,-0.309909,-0.33009,-0.3365:0.102292,0.060292,0.031004,0.072339,0.11292,-0.01752,-0.093404,-0.188785,-0.164164,-0.069075,-0.049143,-0.129983,-0.140418,-0.073991,-0.060743,-0.066306,-0.078091,-0.102508,-0.01968,0.05901:0.122832,0.052892,0.010974,0.012351,-0.034848,-0.008097,-0.031289,-0.09601,-0.194216,-0.194417,-0.197676,-0.151998,-0.144235,-0.133032,-0.123224,-0.105124,-0.098179,-0.074765,-0.127952,-0.172317:-0.15166,-0.178975,-0.180806,-0.187294,-0.210503,-0.239873,-0.25242,-0.222464,-0.186159,-0.191742,-0.183857,-0.13853,-0.103564,-0.109394,-0.137261,-0.122428,-0.081293,-0.058812,-0.042632,-0.023898:-0.042707,-0.025589,-0.057122,-0.061478,0.03027,0.029096,0.002891,0.063759,0.138766,0.108199,0.103925,0.135258,0.111936,0.071903,0.065938,0.053106,0.029999,-0.003827,0.002367,0.022561:7
1.341664,1.159146,1.076549,1.163617,1.303323,1.143645,0.953052,0.800966,0.670529,0.660605,0.721509,0.689681,0.61539,0.515179,0.395042,0.482199,0.484794:-0.408164,-0.337269,-0.242857,-0.16456,-0.203582,-0.028311,0.18959,0.157335,0.036282,-0.031675,-0.107613,-0.139617,-0.201875,-0.197067,-0.209951,-0.306316,-0.375572:0.091335,0.062815,0.05799,-0.076301,-0.219587,-0.268872,-0.365446,-0.360073,-0.298165,-0.3008,-0.322521,-0.27392,-0.219835,-0.164733,-0.097475,-0.015224,0.041402:-0.633391,-0.647862,-0.659481,-0.678916,-0.595493,-0.573462,-0.632976,-0.560867,-0.426032,-0.346863,-0.255773,-0.197981,-0.062202,0.051686,0.084098,0.112643,0.196776:0.047449,0.125264,0.156152,0.219776,0.258836,0.371687,0.546276,0.556741,0.518151,0.556996,0.643327,0.630226,0.637392,0.660559,0.651842,0.62733,0.614807:-0.393513,-0.377953,-0.295124,-0.170454,-0.173188,-0.209706,-0.218052,-0.139629,-0.050177,-0.029425,-0.102084,-0.026838,-0.027562,-0.069044,-0.106204,-0.094818,-0.119186:-0.192164,-0.184995,-0.152812,-0.094244,-0.082303,-0.053292,-0.042136,-0.057754,-0.123551,-0.112442,-0.076379,-0.102532,-0.155774,-0.178571,-0.151986,-0.165786,-0.179229:0.079029,0.052984,-0.006992,-0.108293,-0.155586,-0.172132,-0.143636,-0.185894,-0.250927,-0.335454,-0.353827,-0.385836,-0.395525,-0.402344,-0.367897,-0.319012,-0.307717:0.09831,0.101924,0.083206,0.024609,0.074836,0.029711,-0.102621,-0.140698,-0.067065,-0.01941,-0.048463,-0.044539,0.018378,0.040788,-0.003302,3.07E-4,0.07101:0.203685,0.134217,0.109521,0.071028,-0.041244,-0.095185,-0.04562,-0.093692,-0.190792,-0.198699,-0.15767,-0.167941,-0.1633,-0.149943,-0.12528,-0.148835,-0.231418:-0.272595,-0.309395,-0.309303,-0.261149,-0.259557,-0.242429,-0.201488,-0.137131,-0.092345,-0.11689,-0.110544,-0.049463,-0.054574,-0.048496,-0.056259,-0.055229,-0.012254:-0.071785,0.018588,0.068397,0.092428,0.094816,0.110673,0.063786,0.081931,0.122921,0.134566,0.114405,0.076542,0.030736,0.004755,-0.005329,-0.034377,-0.013542:7
0.611013,0.498677,0.48632,0.651394,0.817246,0.819351,0.726188,0.591097,0.460642,0.391705,0.4271,0.311887,0.406243,0.379886:0.242642,0.382906,0.374072,0.262842,0.139979,0.01808,-0.004634,0.145019,0.117362,0.053792,0.083282,0.100729,-0.011781,-0.152811:0.245672,0.314554,0.179969,0.053171,0.198687,0.215875,0.063393,-0.037613,0.011055,0.030701,-0.04783,-0.089443,-0.013829,0.194666:-0.712497,-0.801392,-0.698626,-0.536709,-0.571091,-0.420788,-0.325481,-0.262585,-0.107846,0.001817,0.111515,0.194531,0.270562,0.219938:0.14049,0.190488,0.286582,0.356007,0.409579,0.470766,0.630484,0.706375,0.614312,0.603386,0.712741,0.761025,0.621203,0.67909:-0.209374,-0.221838,-0.125012,-0.129091,-0.151302,-0.149794,-0.185331,-0.118054,-0.088232,-0.093961,-0.17931,-0.211767,-0.138675,-0.152571:0.025357,-0.023429,-0.006998,-0.029789,-0.118515,-0.160523,-0.162606,-0.173014,-0.135886,-0.137831,-0.158776,-0.189487,-0.224256,-0.23393:-0.008077,0.070648,-0.026827,-0.038581,-0.005898,-0.047464,-0.093351,-0.182887,-0.208467,-0.184904,-0.205334,-0.214464,-0.210536,-0.190883:-0.061056,-0.091741,-0.120768,-0.030332,-0.052886,-0.048608,-0.080222,-0.071238,-0.072582,-0.07493,-0.071201,-0.052174,0.024685,0.025732:-0.078215,-0.077183,-0.159881,-0.244302,-0.139173,-0.152721,-0.119979,-0.122747,-0.215822,-0.268212,-0.166114,-0.148873,-0.269669,-0.220825:-0.093695,-0.051502,-0.008528,-0.018879,-0.032792,-0.062796,-0.071049,-0.043425,0.065778,0.125887,0.035094,0.021673,0.093652,0.030109:0.157771,0.111416,0.18115,0.186955,0.14172,0.148736,0.118882,0.037494,0.005178,-0.024569,-0.031773,-0.071026,-0.064331,0.008351:7
0.669821,0.558288,0.543753,0.62361,0.795834,0.762383,0.767433,0.763026,0.507443,0.52961,0.56735,0.450941,0.207973:0.373211,0.360597,0.318252,0.221435,0.203533,0.186662,0.222984,0.122162,0.300273,0.21517,0.019229,-0.016961,0.024518:0.201887,0.123467,0.084055,0.051264,-0.085057,-0.091816,-0.209408,-0.264601,-0.380636,-0.337121,-0.210785,-0.183034,-0.100419:-0.632979,-0.601367,-0.595738,-0.675935,-0.664438,-0.594852,-0.549507,-0.40001,-0.2582,-0.2401,-0.19833,-0.032058,0.044024:0.201706,0.301676,0.397616,0.279389,0.402365,0.429139,0.586924,0.59506,0.596052,0.626105,0.633204,0.565667,0.571268:-0.481564,-0.473009,-0.490191,-0.365121,-0.344906,-0.295707,-0.269517,-0.121219,-0.010497,0.074347,0.06986,0.054332,-0.012866:-0.143507,-0.170262,-0.118854,-0.06009,-0.061258,-0.055616,-0.117276,-0.186912,-0.14414,-0.174019,-0.159886,-0.071587,-4.52E-4:0.083946,0.006278,0.001631,0.02634,0.047719,0.02494,0.024795,-0.059162,-0.237462,-0.27551,-0.271129,-0.340036,-0.310015:0.104576,0.026935,-0.052919,-0.012903,-0.035524,-0.012971,-0.103143,-0.110616,-0.00938,6.7E-5,-0.033063,-0.029747,-0.066687:0.040204,0.089643,0.076065,-0.009938,-0.026242,-0.105769,-0.092921,-0.116736,-0.258294,-0.273699,-0.219349,-0.174971,-0.20434:-0.016425,-0.025052,-0.044914,-0.140645,-0.211589,-0.234009,-0.232348,-0.170205,-0.001069,0.05849,0.015952,0.004485,0.072326:0.149893,0.098411,0.062089,0.077687,0.059617,0.071986,-0.018762,-0.02671,-0.021718,-0.03378,-0.002108,0.009671,-0.013407:7
0.739254,0.837722,0.780095,0.650684,0.683151,0.7767,0.847622,0.933413,0.870062,0.772206,0.805274,0.759876,0.753382,0.680514,0.681216,0.70306:0.427805,0.494934,0.424425,0.348307,0.351756,0.330503,0.313181,0.351406,0.317593,0.222364,0.082933,0.185077,0.136994,-0.025516,-0.035226,-0.104243:0.139299,-0.001976,-0.031369,-0.05535,-0.106468,-0.040358,-0.103924,-0.208119,-0.199939,-0.147838,-0.232907,-0.26555,-0.118474,0.049524,0.009898,0.012789:-0.604953,-0.59941,-0.502411,-0.51273,-0.621224,-0.643581,-0.529906,-0.428318,-0.415059,-0.358242,-0.161592,-0.190277,-0.190466,-0.147358,-0.088035,-0.065275:0.197733,0.302165,0.30311,0.446115,0.494496,0.461743,0.453375,0.450053,0.484547,0.441724,0.420955,0.605715,0.578955,0.596022,0.613193,0.643573:-0.385941,-0.515772,-0.512961,-0.423181,-0.361672,-0.296339,-0.143592,-0.07629,-0.056373,-0.004116,0.001879,0.050688,0.093962,-0.017949,0.003284,-1.99E-4:-0.097237,-0.193391,-0.165169,-0.207848,-0.110884,-0.095823,-0.157694,-0.16301,-0.113748,-0.099552,-0.123495,-0.260891,-0.229612,-0.18968,-0.173193,-0.158564:0.081334,0.133413,0.039265,0.015319,0.055299,0.018864,-0.046203,-0.030028,-0.131148,-0.260945,-0.268583,-0.257315,-0.238083,-0.189825,-0.240444,-0.259373:0.140839,0.207372,0.213431,0.194648,0.072307,0.011513,0.002668,-0.04739,-0.046816,-0.03591,-0.03595,-0.031777,-0.090711,-0.117762,-0.065214,-0.05075:-0.077421,-0.022496,-0.041086,-0.003589,-0.034291,-0.058106,-0.126831,-0.242392,-0.265408,-0.225402,-0.201154,-0.257879,-0.244023,-0.168594,-0.172019,-0.158092:-0.039974,-0.018704,-0.04959,-0.042193,-0.067628,-0.05068,0.024236,0.048153,-0.020924,-0.032756,-0.059659,0.088225,0.073596,-0.014792,-0.025552,-0.016352:0.11704,1.5E-4,0.072301,0.079131,0.091977,0.125557,0.084809,0.006387,0.039972,0.089339,0.035272,-0.073802,-0.01262,0.018786,0.027258,0.032263:7
0.848785,0.963744,0.957128,0.797903,0.823464,0.794068,0.926426,0.941474,0.83177,0.753307,0.806286,0.820799,0.754373,0.710145,0.794084,0.864686:0.205572,0.085052,0.033815,0.215155,0.239862,0.166459,0.031425,0.156987,0.259813,0.227116,0.027254,0.012155,-0.068065,-0.099001,-0.065172,-0.118711:0.07646,0.160384,0.086569,-0.076608,0.030432,0.027943,0.049082,0.047428,0.004724,0.032467,0.107025,0.099315,0.149614,0.200666,0.196001,0.222887:-0.51031,-0.557828,-0.503364,-0.430908,-0.446529,-0.485126,-0.505619,-0.611521,-0.663552,-0.519814,-0.289705,-0.202599,-0.036082,-0.020961,-0.102806,-0.063488:0.218513,0.20645,0.231087,0.333002,0.351458,0.349039,0.457369,0.520727,0.516762,0.453567,0.362517,0.343609,0.257417,0.326968,0.412148,0.273324:-0.435866,-0.39266,-0.255309,-0.25935,-0.302825,-0.267231,-0.255518,-0.194112,-0.084177,-0.073957,-0.04477,-0.031794,-0.1108,-0.146506,-0.139395,-0.062194:-0.115834,-0.129363,-0.128727,-0.104718,-0.169248,-0.108312,-0.148552,-0.136752,-0.154437,-0.152227,-0.138393,-0.16248,-0.197009,-0.212964,-0.1773,-0.092621:-0.041344,0.010589,-0.080045,-0.15729,-0.148339,-0.098947,-0.013535,0.039547,0.030847,-0.091439,-0.224471,-0.192685,-0.132339,-0.098712,-0.098073,-0.161098:0.186925,0.154023,0.19927,0.162562,0.171561,0.074773,-0.012849,-0.058736,-0.08046,-0.019238,0.029115,0.008326,0.056955,-0.01087,-0.073901,-0.054309:-0.00784,-0.007579,-0.008112,0.003102,-0.096626,-0.121809,-0.046459,-0.050731,-0.06032,-0.056473,-0.090708,-0.125229,-0.148643,-0.269401,-0.325441,-0.315216:-0.131788,-0.180796,-0.215842,-0.107799,-0.020671,-0.019971,-0.108216,-0.11804,-0.075543,-0.060002,-0.045211,-0.023049,-0.048743,0.098325,0.104405,-0.011318:0.169751,0.180783,0.188123,0.138591,0.131418,0.152459,0.137738,0.096251,0.05766,0.069079,0.120245,0.073404,-0.008256,0.017142,0.082431,0.115375:7
1.03191,1.129177,1.131343,1.225026,1.179093,1.080086,0.925978,0.767894,0.728147,0.840122,0.835751,0.872922,0.861314,0.757176,0.752039,0.585994,0.579922,0.680067,0.622154,0.507416,0.50493:0.105477,0.028412,0.068887,0.131898,0.0208,-0.069836,-0.010104,0.073873,0.003238,-0.021563,-0.00968,-0.129078,-0.220603,-0.179744,-0.23962,-0.159084,-0.198156,-0.381594,-0.342068,-0.265062,-0.340713:-0.157011,-0.219553,-0.24945,-0.298974,-0.262175,-0.214073,-0.223895,-0.279785,-0.313901,-0.30211,-0.347494,-0.274743,-0.060656,-0.042652,-0.055165,-0.08382,-0.044649,0.027482,0.052018,0.062298,0.132769:-0.525904,-0.530602,-0.53847,-0.645947,-0.615834,-0.646833,-0.672137,-0.596102,-0.547929,-0.485733,-0.377228,-0.34439,-0.405173,-0.353612,-0.33872,-0.240947,-0.161434,-0.057951,-0.012345,-0.004396,0.047923:0.146131,0.176509,0.131867,0.16762,0.113339,0.225574,0.346211,0.389039,0.427599,0.450623,0.439608,0.465445,0.500898,0.556838,0.634565,0.661763,0.663401,0.576304,0.537599,0.567969,0.518881:-0.251233,-0.251314,-0.210442,-0.151045,-0.064197,-0.057284,-0.057071,-0.061551,-0.083706,-0.022602,0.062383,0.046723,0.030859,0.038071,0.06227,0.019621,-0.036052,-0.034141,0.002516,0.015331,0.0405:-0.286812,-0.247565,-0.186896,-0.139298,-0.172996,-0.170674,-0.158065,-0.204508,-0.161288,-0.17122,-0.205123,-0.200888,-0.173995,-0.188814,-0.221127,-0.169215,-0.151161,-0.136782,-0.15726,-0.171892,-0.192713:0.159402,0.07288,-0.023893,-0.056647,-0.059338,-0.115338,-0.115683,-0.053257,-0.098319,-0.167426,-0.196039,-0.165066,-0.169132,-0.211253,-0.183126,-0.236676,-0.225349,-0.189828,-0.161902,-0.145956,-0.119141:0.113566,0.124284,0.229512,0.193446,0.18253,0.15636,0.090223,0.037752,0.041132,0.048565,-0.001558,-0.057937,-0.079936,-0.03336,-0.065537,-0.033844,-0.029896,-0.002394,0.009193,-0.006652,-0.022957:-0.075903,-0.034936,-0.158705,-0.217897,-0.197209,-0.146716,-0.12964,-0.168617,-0.199015,-0.211022,-0.230713,-0.238311,-0.243051,-0.264873,-0.241774,-0.226616,-0.258708,-0.282916,-0.3245,-0.328795,-0.276981:-0.058347,-0.098801,-0.083294,-0.026021,-0.050262,-0.104823,-0.133899,-0.113627,-0.104006,-0.082135,-0.044207,-0.064416,-0.094004,-0.071104,-0.032482,-0.056982,-0.021732,-0.046194,-0.013082,0.020557,0.022398:-0.096457,-0.077968,-0.027852,-0.017013,0.005295,0.069083,0.086777,0.01114,0.006919,0.027221,-0.009901,-0.019719,0.051141,0.05767,0.026736,0.02552,0.022579,0.059084,0.034323,-7.51E-4,-0.035275:7
1.527284,1.291535,1.105674,1.209071,0.962444,0.913337,0.85401,0.645921,0.832197,0.754636,0.651481,0.621037,0.532723,0.57131,0.597236,0.609964:-0.022337,-0.061521,-0.167392,-0.193291,-0.004729,0.028934,0.088991,0.174028,-0.02782,-0.018721,0.039194,0.045336,0.005574,-0.147378,-0.279484,-0.302997:0.192909,0.370463,0.429643,0.331227,0.114065,0.074624,0.112985,0.128833,0.044443,0.065379,0.201698,0.307674,0.374023,0.384168,0.475414,0.562492:-0.691885,-0.774924,-0.721132,-0.696964,-0.538762,-0.422385,-0.453497,-0.45951,-0.41145,-0.315774,-0.259551,-0.18761,-0.139629,-0.236468,-0.154947,-0.038575:0.206201,0.143248,0.165984,0.252612,0.300135,0.317809,0.345473,0.413324,0.489811,0.426735,0.369123,0.339753,0.35726,0.411617,0.448669,0.397671:-0.342448,-0.250516,-0.182541,-0.097203,-0.114028,-0.120174,-0.083134,-0.092009,-0.014718,-0.006417,-0.056612,-0.074978,-0.086023,0.086563,0.082355,-0.001487:-0.225677,-0.194857,-0.252948,-0.256284,-0.165851,-0.140899,-0.156584,-0.185309,-0.21622,-0.157428,-0.137312,-0.183117,-0.261709,-0.208396,-0.217246,-0.204088:0.150228,0.155071,0.130512,0.10644,-0.071457,-0.193463,-0.160387,-0.129827,-0.203439,-0.291114,-0.274983,-0.198411,-0.15993,-0.238395,-0.20315,-0.178213:0.014203,-0.044035,-0.061237,-0.049509,-8.26E-4,0.021828,-0.025431,-0.01171,0.037188,0.100337,0.104505,0.052204,0.068966,-0.015365,-0.078343,-0.04955:0.040164,-0.004359,-0.02892,-0.030854,-0.05041,-0.048368,-0.101365,-0.15515,-0.152492,-0.181534,-0.217424,-0.279244,-0.238233,-0.190843,-0.206918,-0.216824:-0.181021,-0.166763,-0.164224,-0.19008,-0.230582,-0.211128,-0.158551,-0.149205,-0.164191,-0.197416,-0.157593,-0.013637,-0.003472,-0.041129,-0.058638,-0.070748:0.012366,0.057927,0.069923,0.070623,0.180462,0.218459,0.210626,0.220936,0.213018,0.245013,0.217672,0.13054,0.036888,0.116929,0.115402,0.076698:7
0.881413,0.768754,0.760169,0.858894,1.017164,1.320504,1.268167,0.82583,0.592853,0.495407,0.502603,0.489825,0.49494,0.538233,0.300925:0.45117,0.49108,0.267737,0.174705,0.186569,0.103182,0.159701,0.448585,0.655478,0.649752,0.496246,0.293013,0.222078,0.029246,-0.1001:0.200156,0.155369,0.256038,0.295465,0.122352,-0.007738,-0.025753,-0.032594,-0.061111,-0.132737,-0.064158,0.00174,0.087292,0.262193,0.276734:-0.527539,-0.485348,-0.473346,-0.435358,-0.4274,-0.482894,-0.420634,-0.349344,-0.431345,-0.382764,-0.33672,-0.246514,-0.131422,0.014142,0.129933:0.162291,0.172727,0.158467,0.222873,0.295846,0.344264,0.279868,0.218422,0.229603,0.267241,0.340911,0.472052,0.462174,0.397539,0.438705:-0.402591,-0.417661,-0.309585,-0.310591,-0.2421,-0.095123,-0.048131,0.002049,0.012535,0.017858,0.098851,0.06822,0.059446,0.004068,-0.042484:-0.118709,-0.232674,-0.223746,-0.248941,-0.266237,-0.239923,-0.228937,-0.12356,0.014007,0.010903,-0.043708,-0.034213,-0.013243,-0.059114,-0.075965:-0.037615,-0.040656,-0.073566,-0.093897,-0.050343,-0.007527,-0.049657,-0.182071,-0.23728,-0.262958,-0.296133,-0.319569,-0.31765,-0.240033,-0.239625:0.155925,0.132481,0.101014,0.130423,0.152795,0.177454,0.182223,0.143482,-0.006248,0.020708,-0.014969,-0.022303,-0.010698,0.003177,0.030351:0.037005,0.035907,0.020676,-0.025991,-0.117442,-0.191423,-0.212001,-0.215191,-0.206963,-0.263369,-0.249155,-0.254382,-0.312238,-0.320505,-0.30819:-0.042484,-0.024348,-0.072864,-0.098569,-0.094418,-0.143294,-0.096583,-0.116789,-0.084862,-0.004461,-0.036369,-0.059604,-0.021273,-0.017103,0.019006:0.114257,0.072987,0.125321,0.126096,0.057459,-0.018972,-0.015823,0.054406,0.111142,0.030042,0.079192,0.097189,0.055786,0.032003,0.020185:7
0.805931,1.064681,1.151099,1.166292,1.087438,0.95576,0.827638,0.857845,0.974926,1.046373,0.977839,0.881828,0.825772,0.733967,0.636477,0.511076,0.511552,0.649294,0.509944,0.276141,0.330627:-0.053974,0.099287,0.151786,0.079348,0.148945,0.257561,0.269329,0.134868,-0.008788,0.071009,0.181713,0.125644,-0.091494,-0.164252,-0.163469,-0.205443,-0.240378,-0.224905,-0.192214,-0.172801,-0.175538:0.181849,0.007886,-0.001108,0.028553,-0.026443,-0.012573,-0.060703,-0.167935,-0.207302,-0.209198,-0.237582,-0.278172,-0.12348,-0.01999,0.028045,0.074975,0.08822,0.114264,0.155437,0.217113,0.143017:-0.586769,-0.651327,-0.659864,-0.656617,-0.576753,-0.542059,-0.560876,-0.46066,-0.315009,-0.367205,-0.462243,-0.357981,-0.271837,-0.248011,-0.184304,-0.189988,-0.172155,-0.072235,-0.056966,-0.030966,0.001764:0.157908,0.210221,0.187433,0.265122,0.22096,0.119026,0.214138,0.288845,0.316273,0.463153,0.526345,0.547559,0.480526,0.49819,0.514345,0.612156,0.671279,0.572216,0.612764,0.600289,0.683232:-0.342205,-0.359774,-0.321114,-0.327219,-0.313011,-0.159665,-0.076154,-0.05153,-0.126415,-0.159619,-0.075377,-0.0993,-0.001073,-0.039976,-0.013682,-0.018241,-0.032854,-0.006582,-0.081311,-0.10931,-0.148135:-0.223809,-0.188296,-0.17658,-0.190468,-0.105024,-0.084518,-0.112114,-0.144593,-0.137087,-0.102542,-0.064676,-0.032468,-0.063243,-0.121856,-0.200394,-0.223158,-0.190346,-0.099733,-0.112896,-0.093742,-0.102114:0.131116,0.195704,0.20622,0.154326,0.098252,-0.009036,-0.043911,-0.05721,-0.103339,-0.134409,-0.204223,-0.17445,-0.165435,-0.145641,-0.119522,-0.102581,-0.125579,-0.255146,-0.12179,-0.125135,-0.125578:0.128146,0.160323,0.153905,0.083325,0.063576,0.094455,0.018562,0.041997,0.067876,-0.026105,-0.05459,-0.093379,-0.101524,-0.048143,-0.058464,-0.088833,-0.078402,0.003302,-0.12092,-0.103288,-0.104893:-0.013584,-0.025147,-0.066326,0.026117,-0.061556,-0.213567,-0.212799,-0.217377,-0.223695,-0.126928,-0.134946,-0.152361,-0.165618,-0.207264,-0.194012,-0.165686,-0.180299,-0.248821,-0.201539,-0.193339,-0.190434:-0.112524,-0.092936,-0.065717,-0.138238,-0.122958,-0.043522,-0.03395,-0.060812,-0.069234,-0.084321,-0.00145,0.025032,-0.004348,-0.003068,-0.004976,-0.024466,-0.037561,-0.027872,-0.065159,-0.084577,-0.079396:0.051481,0.006048,-0.009774,0.006853,0.06668,0.09269,0.100537,0.080197,0.086299,0.101324,0.112483,0.09392,0.100161,0.12349,0.100067,0.081137,0.105804,0.183206,0.121225,0.13001,0.105902:7
0.825419,1.013873,1.151325,1.02934,0.95135,1.005752,0.915342,0.965179,0.986118,0.879133,0.83884,0.900578,0.807204,0.711023,0.72851,0.774848:0.098227,0.045421,0.049608,0.186548,0.148686,0.156425,0.240521,0.297707,0.254061,0.267216,0.255984,0.151465,0.142545,0.195888,0.165691,0.115517:0.241111,0.001047,-0.155594,-0.159311,-0.063279,-0.110917,-0.153822,-0.183652,-0.09271,-0.172346,-0.291257,-0.345734,-0.309981,-0.29884,-0.201176,-0.150695:-0.684334,-0.649593,-0.467107,-0.547542,-0.596961,-0.582637,-0.660356,-0.661602,-0.709796,-0.706562,-0.55511,-0.371785,-0.324539,-0.311852,-0.319439,-0.230185:0.216039,0.189235,0.045436,0.196274,0.27066,0.340152,0.409422,0.406546,0.383293,0.478901,0.595885,0.577281,0.56614,0.625398,0.624486,0.573121:-0.529571,-0.441145,-0.355549,-0.381646,-0.421612,-0.423917,-0.349475,-0.287188,-0.274094,-0.235295,-0.226388,-0.215028,-0.121881,-0.066533,-0.066844,-0.045278:-0.375611,-0.272909,-0.169361,-0.173806,-0.164328,-0.166848,-0.148679,-0.055839,-0.018033,-0.049285,-0.067052,-0.082908,-0.130472,-0.148953,-0.129992,-0.159028:0.157263,0.082737,-0.086392,-0.004796,0.028467,0.008838,0.009847,-0.049375,-0.028946,-0.088558,-0.175482,-0.19507,-0.226543,-0.273514,-0.245591,-0.228559:0.111189,0.220588,0.393086,0.271469,0.223048,0.161764,0.067867,-0.014472,-0.064106,-0.091163,-0.103268,-0.067403,-0.058735,-0.073885,-0.135309,-0.156107:0.015333,-0.031103,-0.099646,-0.070562,-0.071028,-0.058293,-0.069627,-0.098551,-0.151656,-0.129053,-0.120734,-0.173848,-0.181756,-0.144652,-0.148875,-0.1654:-0.083981,-0.110823,-0.134994,-0.127905,-0.178017,-0.171224,-0.129305,-0.104672,-0.087979,-0.048779,-0.017463,-0.0665,-0.059803,-0.050328,-0.037349,-0.016857:0.065666,0.04714,0.063338,0.010703,0.076931,0.07843,0.049665,0.096487,0.143748,0.10852,0.09436,0.114276,0.060524,0.015764,0.005522,-0.019734:7
0.744129,0.682321,0.622161,0.70966,0.635944,0.777978,0.967617,0.608924,0.510261,0.696421,0.825433,0.691233,0.66155,0.722381,0.682882,0.73216,0.649207,0.56232,0.472247,0.423379,0.360557:0.371581,0.543322,0.622968,0.461996,0.412222,0.349567,0.15214,0.333565,0.360017,0.28005,0.208226,0.17103,0.083943,0.106269,-0.068501,-0.177315,-0.16672,-0.204794,0.01248,-0.169596,-0.208088:0.098182,-0.005163,0.014138,-0.00992,-0.066744,-0.093261,-0.00554,-0.047259,-0.120724,-0.223722,-0.263908,-0.24611,-0.221709,-0.267906,-0.082386,4.2E-4,-0.120127,-0.010917,-0.135824,0.025825,0.089963:-0.345279,-0.407383,-0.404915,-0.391582,-0.338447,-0.324041,-0.342791,-0.37892,-0.431139,-0.445089,-0.360491,-0.322306,-0.247792,-0.185213,-0.117895,-0.107317,0.014718,-0.018139,-0.003845,0.078204,0.141251:0.252658,0.404685,0.333905,0.193512,0.147544,0.13441,0.10309,0.142528,0.22272,0.301542,0.408202,0.545386,0.549455,0.52289,0.481058,0.560714,0.536532,0.591994,0.663958,0.602315,0.619736:-0.524228,-0.591022,-0.560379,-0.456123,-0.405282,-0.325141,-0.249228,-0.256033,-0.24354,-0.169888,-0.089883,-0.144055,-0.033832,0.05531,0.05441,0.032927,0.005675,-0.026702,-0.046789,-0.061911,-0.084616:-0.165931,-0.114319,-0.129902,-0.064146,-0.002192,-0.008706,0.020556,0.107204,0.176341,0.125364,-0.019879,-0.07934,-0.153152,-0.162419,-0.190574,-0.261063,-0.230544,-0.209473,-0.161959,-0.216906,-0.273698:0.105236,0.15006,0.098165,0.046923,0.004807,-0.066656,-0.080863,-0.086407,-0.085694,-0.08815,-0.172054,-0.188779,-0.274721,-0.31536,-0.331474,-0.313392,-0.322419,-0.307706,-0.302525,-0.299943,-0.286937:0.138046,0.115629,0.140245,0.163641,0.24227,0.288363,0.241891,0.119143,0.002144,-0.036404,0.013721,0.007473,0.016348,0.024218,0.055382,0.01737,0.004896,-0.020093,-0.052037,0.026742,0.038362:-0.076392,-0.038334,-0.056409,-0.098765,-0.17133,-0.183997,-0.220704,-0.240291,-0.249883,-0.229755,-0.182915,-0.169664,-0.172545,-0.255353,-0.258643,-0.182801,-0.199469,-0.166258,-0.179237,-0.220321,-0.171322:-0.092433,-0.161018,-0.142374,-0.134052,-0.152031,-0.168912,-0.201024,-0.149295,-0.108923,-0.136762,-0.183632,-0.151671,-0.086901,0.005843,-0.092983,-0.161893,-0.117216,-0.145766,-0.096611,-0.107731,-0.111272:0.056932,0.001496,0.011053,0.049861,0.057765,0.070752,0.140741,0.148181,0.129667,0.105423,0.092823,0.065287,0.071207,0.031572,0.120018,0.119257,0.063694,0.087939,0.063031,0.081315,0.037527:7
0.971006,0.824222,0.78828,0.932521,0.87827,0.778088,0.638463,0.619372,0.549933,0.567063,0.519055,0.409029,0.567895,0.493576,0.387892,0.322942,0.331493,0.449324,0.593429,0.57612,0.655066,0.5347,0.410652,0.520526,0.68016:0.327842,0.459861,0.391447,0.31784,0.283142,0.432104,0.535166,0.483392,0.475097,0.308846,0.254524,0.49726,0.400038,0.293536,0.307672,0.22955,0.140731,0.176009,0.062861,0.09153,0.092657,0.048406,-0.036499,-0.120535,-0.171197:0.085746,-0.006651,4.4E-4,0.033449,0.041341,-0.084069,-0.16466,-0.13535,-0.052529,-0.085396,-0.114242,-0.068597,-0.172422,-0.123163,-0.224312,-0.231525,-0.168731,-0.200767,-0.280328,-0.334109,-0.316654,-0.140552,0.096131,0.057441,0.00781:-0.467631,-0.525113,-0.536825,-0.555013,-0.545012,-0.546461,-0.552445,-0.61384,-0.6001,-0.393291,-0.398818,-0.549863,-0.41257,-0.309744,-0.192842,-0.102956,-0.119867,-0.086609,-0.027369,0.072278,0.145192,0.054117,-0.058743,0.069195,0.241451:0.338009,0.37683,0.295699,0.207669,0.24281,0.314956,0.387689,0.440421,0.413657,0.430228,0.501767,0.510823,0.604356,0.587609,0.549551,0.535831,0.581981,0.54662,0.603885,0.574011,0.550472,0.667061,0.672466,0.667542,0.604714:-0.584494,-0.654468,-0.523098,-0.331818,-0.375315,-0.435841,-0.444158,-0.437746,-0.371935,-0.273497,-0.262899,-0.202542,-0.172946,-0.165857,-0.096566,-0.082186,-0.069691,-0.05537,-0.124755,-0.120074,-0.114824,-0.148834,-0.073871,-0.095765,-0.128146:-0.272783,-0.191482,-0.197346,-0.24323,-0.222256,-0.180989,-0.126285,-0.008563,0.024305,-0.083081,-0.092687,0.037129,-0.115978,-0.24135,-0.207394,-0.186044,-0.218716,-0.151644,-0.112361,-0.097633,-0.139339,-0.130016,-0.163185,-0.201964,-0.158901:0.097773,0.08275,0.020233,-0.001114,0.009486,-0.007677,0.025662,0.074489,0.027696,-0.150897,-0.10751,-0.061667,-0.079375,-0.128011,-0.184755,-0.196252,-0.189659,-0.227902,-0.240823,-0.226605,-0.193436,-0.223144,-0.264982,-0.202796,-0.270441:0.132941,0.18513,0.228264,0.220811,0.245739,0.257229,0.150638,-0.012945,-0.08777,-0.009674,-0.046237,-0.214932,-0.132671,0.029624,0.036424,0.010551,0.005278,-0.023246,-0.065786,-0.044365,-0.034334,-0.102559,-0.112056,-0.112601,-0.013014:-0.046364,0.022288,-0.010539,0.028897,-0.007974,-0.080215,-0.084638,-0.08639,-0.100527,-0.093077,-0.155327,-0.185683,-0.155118,-0.127667,-0.19587,-0.218511,-0.21479,-0.204604,-0.186366,-0.275829,-0.300862,-0.167162,-0.122572,-0.17369,-0.245599:-0.098442,-0.167667,-0.155122,-0.183192,-0.215752,-0.108811,-0.098165,-0.195544,-0.154685,-0.068408,-0.032825,0.012329,-0.049482,-0.097532,-0.054369,-0.012759,-5.99E-4,-0.002584,-0.013137,0.057111,0.07267,-0.047407,-0.089204,-0.066045,-0.055587:0.026675,0.0169,0.032982,0.017242,0.050747,-0.004573,-0.040921,0.032562,0.086808,0.111587,0.097988,0.133406,0.089177,0.074798,0.085386,0.095068,0.130326,0.12314,0.0719,0.022009,0.012269,0.101823,0.160816,0.09858,0.075361:7
1.22103,1.166931,1.182675,1.406686,1.622383,1.605052,1.400783,1.177159,0.918848,0.898344:-0.386734,-0.386501,-0.41685,-0.595674,-0.902197,-0.961441,-0.882064,-0.82382,-0.777211,-0.82663:0.051931,8.56E-4,0.108364,0.134545,0.332683,0.466962,0.40819,0.451688,0.508708,0.594297:-0.107878,-0.119578,-0.051643,0.055267,-0.075907,-0.159815,-0.034274,0.058271,0.199788,0.264906:-0.453581,-0.421214,-0.352152,-0.227779,-0.093294,0.017909,0.127891,0.204126,0.240552,0.264506:-0.150253,-0.060394,-0.018547,-0.016975,-0.017807,-0.052794,-0.053035,-0.059732,-0.073902,-0.11803:0.078324,0.056277,-0.066417,-0.11748,-0.162303,-0.202158,-0.23921,-0.25735,-0.250063,-0.243938:-0.080665,-0.048764,-0.106547,-0.116477,-0.144504,-0.155547,-0.168345,-0.156773,-0.129048,-0.086835:0.059018,0.028998,-0.03491,-0.174804,-0.229708,-0.283838,-0.271236,-0.251359,-0.193702,-0.167229:-0.230949,-0.292853,-0.217413,-0.195769,-0.231121,-0.191212,-0.184067,-0.153235,-0.121587,-0.100564:0.009603,-0.008878,0.01497,0.07711,0.101459,0.096109,0.122218,0.107982,0.052898,-0.008886:0.271908,0.239756,0.208875,0.188832,0.205816,0.193174,0.114415,0.020125,-0.099933,-0.193681:8
0.957823,0.825737,0.804408,0.675289,0.520751,0.415933,0.380653,0.433581,0.467143,0.368525,0.259295,0.185704:0.039191,-0.05759,-0.095267,0.083895,0.136089,0.063161,-0.145818,-0.221387,-0.218887,-0.215105,-0.26288,-0.29589:-0.137262,-0.045551,0.018855,-0.089003,-0.190781,-0.11093,0.07338,0.200779,0.244769,0.355817,0.480965,0.544175:-0.640504,-0.561996,-0.520561,-0.337518,-0.254728,-0.115986,0.075603,0.194212,0.363798,0.475243,0.496715,0.580284:0.172754,0.200557,0.232619,0.281783,0.322688,0.283926,0.227761,0.192451,0.199437,0.193696,0.232354,0.17974:-0.457781,-0.428027,-0.452299,-0.500238,-0.560468,-0.430557,-0.318022,-0.314608,-0.377608,-0.316866,-0.258511,-0.238644:-0.073934,-0.138384,-0.101062,8.5E-4,0.095277,0.091609,0.057601,0.006303,0.001051,-0.011091,-0.04059,0.032539:0.128432,0.121374,0.106335,-0.058617,-0.191621,-0.316951,-0.415088,-0.385014,-0.332727,-0.28034,-0.231517,-0.281627:-0.2188,-0.268184,-0.328365,-0.329144,-0.338033,-0.273348,-0.142086,-0.087681,-0.045916,0.015517,0.062617,0.081622:-0.199092,-0.177974,-0.156873,-0.183974,-0.151067,-0.149106,-0.14123,-0.19001,-0.193797,-0.214296,-0.214006,-0.177186:0.036538,0.076478,0.119129,0.210615,0.098335,0.080914,0.090779,0.11065,0.049509,0.033329,0.008482,-0.058078:0.143387,0.164633,0.221703,0.222177,0.205403,0.215326,0.179246,0.085592,-0.013583,-0.098455,-0.169151,-0.220385:8
0.94411,0.925836,0.994394,1.010333,0.975627,0.859763,0.867088,0.87154,0.751004,0.621921,0.506712:-0.606263,-0.657538,-0.504503,-0.470597,-0.591641,-0.591351,-0.647282,-0.724814,-0.677148,-0.654447,-0.713967:-0.209708,-0.121922,-0.169538,-0.201013,-0.011518,0.038824,0.053707,0.224296,0.373045,0.401256,0.445528:-0.305362,-0.278068,-0.228489,-0.178735,-0.142734,-0.033742,0.051859,0.134464,0.198427,0.297128,0.37869:-0.133664,-0.069915,-0.06873,0.004235,0.044447,0.090371,0.159078,0.247499,0.301514,0.367828,0.446406:-0.412844,-0.335541,-0.212733,-0.129663,-0.032156,-1.9E-4,-0.01247,-0.064979,-0.064168,-0.124535,-0.260857:0.168311,0.12859,0.062026,-0.015588,-0.178507,-0.245701,-0.265087,-0.254521,-0.314526,-0.273421,-0.18553:-0.139108,-0.141457,-0.136924,-0.157725,-0.100863,-0.121737,-0.110992,-0.057574,-0.040629,-0.001651,0.086674:0.017973,0.038435,0.132743,0.028466,-0.157465,-0.196459,-0.211665,-0.254645,-0.178562,-0.099782,-0.115355:-0.248132,-0.231051,-0.387593,-0.43857,-0.363067,-0.336966,-0.27409,-0.131012,-0.105424,-0.114364,-0.079922:-0.145523,-0.096115,-0.035636,0.032526,0.131058,0.154604,0.130891,0.144416,0.135719,0.064689,-0.021231:0.368691,0.396943,0.374272,0.299579,0.287669,0.261718,0.195969,0.054296,-0.073248,-0.132619,-0.174595:8
1.310519,1.307479,1.175979,1.062671,0.871541,0.765731,0.698367,0.771491,0.892266,0.675558,0.5387:-0.800838,-0.810836,-0.775539,-0.739196,-0.751825,-0.739023,-0.633046,-0.686543,-0.740861,-0.665293,-0.643197:0.110048,0.232627,0.329546,0.324149,0.32621,0.351921,0.379674,0.44315,0.520477,0.623249,0.721132:-0.538408,-0.598136,-0.57754,-0.43086,-0.409755,-0.355677,-0.284547,-0.131671,0.048787,0.080515,0.140229:-0.252307,-0.128205,-0.007876,0.066236,0.217322,0.30234,0.341935,0.315958,0.328512,0.411227,0.42194:-0.200216,-0.19567,-0.171347,-0.143732,-0.111241,-0.103501,-0.120182,-0.114511,-0.126809,-0.159088,-0.194695:-0.16315,-0.172764,-0.194107,-0.161147,-0.168879,-0.175938,-0.183373,-0.209647,-0.194781,-0.230148,-0.244306:0.14254,0.136113,0.084402,0.001415,-0.061916,-0.127455,-0.166722,-0.197106,-0.194449,-0.092724,-0.069059:-0.088075,-0.187357,-0.236377,-0.264603,-0.323657,-0.36013,-0.35259,-0.297102,-0.250433,-0.189559,-0.158136:-0.303512,-0.263946,-0.24491,-0.239675,-0.234101,-0.177164,-0.134187,-0.086735,-0.048429,-0.086321,-0.092678:0.038703,0.093059,0.096096,0.086937,0.089543,0.097534,0.123211,0.08868,0.032362,-0.011316,-0.081151:0.22299,0.227097,0.227011,0.214657,0.206375,0.152944,0.086448,0.018477,-0.012117,-0.096653,-0.143544:8
0.6843,0.905124,0.757404,0.757739,0.628139,0.519565,0.471369,0.393005,0.28251,0.173776:-0.305583,-0.416755,-0.54429,-0.643876,-0.707054,-0.832278,-0.888375,-0.894913,-0.917149,-0.894688:0.280544,0.253954,0.224748,0.218435,0.261511,0.364404,0.40918,0.492045,0.587547,0.678134:-0.783094,-0.706134,-0.590576,-0.484845,-0.343174,-0.214068,-0.103955,0.013399,0.071713,0.145952:0.02532,0.076365,0.188801,0.221741,0.242878,0.302616,0.336066,0.38946,0.456225,0.495695:-0.121765,-0.170267,-0.210568,-0.168132,-0.163365,-0.241017,-0.256903,-0.285382,-0.308863,-0.342035:-0.195826,-0.172857,-0.154226,-0.119242,-0.131351,-0.201656,-0.226126,-0.217934,-0.2022,-0.2237:0.20027,0.11213,0.045337,-0.03035,-0.08526,-0.074094,-0.081239,-0.07256,-0.039282,0.008862:-0.2191,-0.302672,-0.345924,-0.385283,-0.358196,-0.336749,-0.301002,-0.234642,-0.222365,-0.19384:-0.256642,-0.207683,-0.167633,-0.168998,-0.186831,-0.167568,-0.141532,-0.101556,-0.081542,-0.099852:0.0846,0.116143,0.128145,0.146806,0.101544,0.051411,0.011404,-0.057959,-0.116962,-0.144348:0.100262,0.087004,0.111982,0.158387,0.162845,0.07103,0.017351,-0.033544,-0.089067,-0.118932:8
1.051467,1.073546,1.161483,1.143006,1.005753,0.963146,0.879294,0.838214,0.867246,0.724086,0.697036:-0.597433,-0.405861,-0.389674,-0.460096,-0.540884,-0.508952,-0.329465,-0.446599,-0.558217,-0.618468,-0.721832:0.216315,0.050359,-0.138037,-0.144501,0.038692,0.004533,-0.163642,0.01438,0.117175,0.180352,0.285526:-0.734126,-0.606488,-0.402865,-0.260464,-0.299337,-0.224122,-0.087273,-0.056886,0.021942,0.073595,0.127608:0.025783,-0.088155,-0.127998,3.95E-4,0.112419,0.237432,0.328804,0.263783,0.209093,0.251698,0.291942:-0.356154,-0.320772,-0.154489,-0.155603,-0.11554,-0.071491,-0.109189,-0.104674,-0.115262,-0.180763,-0.247079:-0.120465,-0.111032,-0.231328,-0.210894,-0.186914,-0.221183,-0.227482,-0.195026,-0.240534,-0.237469,-0.240082:0.24268,0.163324,0.060785,4.57E-4,-0.042206,-0.081282,-0.162958,-0.165227,-0.147236,-0.16324,-0.131048:-0.134407,-0.119516,-0.177359,-0.243298,-0.23703,-0.239625,-0.215645,-0.317929,-0.316044,-0.286701,-0.251242:-0.220914,-0.290188,-0.29307,-0.21707,-0.183449,-0.20945,-0.229057,-0.174387,-0.155344,-0.138664,-0.111948:-0.129993,0.048548,0.200079,0.143966,0.111802,0.144047,0.149541,0.171539,0.134535,0.07358,0.021002:0.281802,0.233926,0.244375,0.203105,0.161853,0.184706,0.13516,0.082731,0.025172,-0.011775,-0.043569:8
1.143498,0.956438,0.810474,0.679655,0.620919,0.64382,0.710898,0.523113,0.357405,0.250403,0.151086:-0.361135,-0.449703,-0.556531,-0.54337,-0.513612,-0.649141,-0.843535,-0.836537,-0.811672,-0.835168,-0.887106:-0.124295,-0.066863,0.037109,0.099924,0.162603,0.256837,0.327381,0.347169,0.392386,0.446528,0.565033:-0.379185,-0.369631,-0.351662,-0.275699,-0.139226,0.010608,0.06215,0.1183,0.209217,0.3038,0.348468:-0.034705,-0.015832,0.026802,0.092178,0.151067,0.223177,0.353101,0.395918,0.423516,0.434233,0.425298:-0.240781,-0.178259,-0.124618,-0.12512,-0.099443,-0.065887,-0.148691,-0.239742,-0.261764,-0.229936,-0.198934:-0.151081,-0.207536,-0.271364,-0.303078,-0.351943,-0.399014,-0.432142,-0.431712,-0.418275,-0.356658,-0.362463:-0.126025,-0.109356,-0.085145,-0.105664,-0.109882,-0.09518,-0.078662,-0.07388,-0.060478,-0.023269,0.011731:0.064511,-0.039747,-0.151135,-0.204251,-0.215421,-0.210224,-0.227663,-0.22556,-0.182902,-0.14514,-0.174961:-0.441348,-0.424537,-0.400991,-0.385394,-0.355263,-0.324434,-0.251784,-0.187515,-0.160402,-0.158884,-0.148456:-0.082317,-0.006512,0.041365,0.084189,0.100194,0.038724,0.007591,-0.010054,-0.036375,-0.051122,-0.063539:0.254554,0.22047,0.198071,0.200807,0.16477,0.080614,-0.025869,-0.096852,-0.128174,-0.158827,-0.229093:8
0.755699,0.718076,0.614394,0.740888,0.750737,0.565007,0.460131,0.48809,0.516586,0.366446,0.238413,0.173876,0.068065,-0.031494:-0.559079,-0.655358,-0.670948,-0.653089,-0.658187,-0.526449,-0.512414,-0.537756,-0.612839,-0.567471,-0.596092,-0.55255,-0.502582,-0.484015:0.16955,0.127017,0.118485,0.174636,0.224433,0.258404,0.217164,0.229881,0.414294,0.462406,0.576034,0.584184,0.601156,0.611584:-0.825005,-0.641442,-0.620512,-0.551423,-0.443936,-0.291962,-0.009067,0.029717,0.069029,0.157624,0.263879,0.330298,0.348979,0.364265:0.246524,0.232268,0.267074,0.246383,0.247895,0.254711,0.290064,0.379069,0.369398,0.356202,0.312478,0.323387,0.328784,0.361137:-0.304123,-0.161614,-0.148901,-0.168153,-0.131443,-0.163612,-0.249744,-0.274716,-0.292276,-0.328012,-0.318299,-0.31801,-0.343414,-0.36072:-0.180011,-0.100683,-0.134285,-0.175854,-0.188989,-0.096002,-0.06941,-0.159647,-0.211264,-0.19744,-0.19654,-0.181146,-0.08791,-0.066718:0.217173,0.03145,-0.069574,-0.098773,-0.129242,-0.201287,-0.244419,-0.166979,-0.14826,-0.162072,-0.143283,-0.101916,-0.152307,-0.130285:-0.281124,-0.238941,-0.286097,-0.315175,-0.386638,-0.410764,-0.286141,-0.207103,-0.209229,-0.133356,-0.109289,-0.094266,-0.021131,-0.002037:-0.229754,-0.188541,-0.183593,-0.176116,-0.121696,-0.042904,0.011034,-0.063185,-0.095271,-0.135952,-0.114988,-0.108684,-0.100719,-0.107968:-0.051638,-0.062763,-0.032138,0.045027,0.157825,0.20599,0.138056,0.086144,0.060406,0.026157,-0.004642,0.014858,-0.021884,-0.030948:0.214746,0.19043,0.173535,0.175069,0.08065,0.03614,0.034291,-0.014737,-0.037324,-0.073377,-0.123362,-0.143765,-0.12643,-0.167455:8
1.359637,1.224753,1.285437,1.234115,1.106736,0.957232,0.923152,0.768028,0.762301,0.769326,0.763194,0.684023,0.578826:-0.748816,-0.721911,-0.727109,-0.768247,-0.622845,-0.641546,-0.652011,-0.606448,-0.668319,-0.709437,-0.83996,-0.79146,-0.687318:0.373181,0.357858,0.257631,0.261199,0.307475,0.419506,0.459273,0.517124,0.585452,0.6836,0.632105,0.576098,0.682788:-0.663813,-0.629668,-0.479689,-0.412436,-0.354615,-0.289881,-0.213146,-0.098301,-0.06277,-0.035297,0.116712,0.210792,0.155513:0.072764,0.119951,0.146104,0.188933,0.257665,0.296571,0.315379,0.336491,0.360137,0.404906,0.407621,0.437182,0.503755:-0.141561,-0.177045,-0.09838,-0.047846,-0.099324,-0.064077,-0.119537,-0.200107,-0.246704,-0.254653,-0.2472,-0.282861,-0.297794:-0.316739,-0.279748,-0.266619,-0.32186,-0.218145,-0.211898,-0.239038,-0.335614,-0.408071,-0.462621,-0.464696,-0.378954,-0.356905:0.169656,0.160542,0.021538,-0.073823,-0.114467,-0.130445,-0.109686,-0.076589,-0.038145,-0.025326,-0.027109,-0.032314,0.017419:-0.133886,-0.140747,-0.142459,-0.182143,-0.247122,-0.316441,-0.298775,-0.222962,-0.212687,-0.185458,-0.126678,-0.091,-0.110349:-0.325635,-0.301637,-0.259661,-0.262959,-0.236333,-0.234355,-0.223991,-0.223076,-0.220664,-0.191134,-0.159095,-0.111056,-0.09204:-0.074887,-0.081082,-0.024252,-0.005804,0.014738,0.030355,0.013694,0.017514,0.026003,-0.009209,-0.027585,-0.060218,-0.070118:0.23313,0.298165,0.242069,0.192182,0.243036,0.182004,0.107216,0.00333,-0.041223,-0.061779,-0.10031,-0.106984,-0.150112:8
1.173963,0.940284,0.831096,0.766192,0.604614,0.749818,0.681548,0.628417,0.567468,0.571931,0.569099,0.54794:-0.408162,-0.393299,-0.390683,-0.559918,-0.544338,-0.769852,-0.779771,-0.801462,-0.82317,-0.825401,-0.828995,-0.872038:0.159312,0.202148,0.234235,0.247267,0.319665,0.377201,0.355483,0.436716,0.51242,0.602061,0.65846,0.707025:-0.638053,-0.613984,-0.449796,-0.405498,-0.326568,-0.139117,-0.015767,-0.042008,-0.005669,0.061986,0.133072,0.150175:0.178137,0.228702,0.206179,0.251463,0.300715,0.318879,0.326076,0.407043,0.445817,0.472504,0.496078,0.513844:-0.257237,-0.239316,-0.168813,-0.107217,-0.156797,-0.164549,-0.197306,-0.278703,-0.318979,-0.334983,-0.316235,-0.306331:-0.184422,-0.182166,-0.13802,-0.137543,-0.145072,-0.237715,-0.250758,-0.285476,-0.326563,-0.348715,-0.323824,-0.293179:0.102059,0.058887,-0.0798,-0.108464,-0.144531,-0.128088,-0.166929,-0.141021,-0.113543,-0.075636,-0.025985,0.005773:-0.23796,-0.27755,-0.295061,-0.364399,-0.38754,-0.353552,-0.305134,-0.282813,-0.255154,-0.228417,-0.209077,-0.202389:-0.215006,-0.230652,-0.225651,-0.237616,-0.216029,-0.213997,-0.198412,-0.160521,-0.145526,-0.125298,-0.099319,-0.087517:-0.096734,-0.083643,-0.019614,0.00872,0.049582,0.030339,-0.004527,-0.059482,-0.078744,-0.073466,-0.071207,-0.108747:0.132491,0.141819,0.140975,0.109066,0.085574,0.039059,0.006442,-0.006493,-0.029775,-0.063673,-0.121067,-0.148609:8
0.83836,0.779614,0.74944,0.614317,0.527625,0.572429,0.59608,0.657756,0.515299,0.367839,0.289518,0.223385:-0.519948,-0.47827,-0.432292,-0.408882,-0.473621,-0.571047,-0.611687,-0.673543,-0.663717,-0.721682,-0.759229,-0.765162:0.109676,0.088344,0.062813,0.048874,0.069683,0.101383,0.138649,0.219016,0.250789,0.334919,0.428653,0.49582:-0.788908,-0.725837,-0.648424,-0.585442,-0.50488,-0.398619,-0.315774,-0.235795,-0.128209,-0.080093,-0.005686,0.118716:0.125401,0.168121,0.205406,0.24484,0.269787,0.24938,0.274426,0.295613,0.321643,0.397462,0.442224,0.518916:-0.35951,-0.340344,-0.298186,-0.249986,-0.213064,-0.174385,-0.174765,-0.187894,-0.229497,-0.288499,-0.315772,-0.3564:-0.162216,-0.153051,-0.13232,-0.089081,-0.053918,-0.043028,-0.068982,-0.149522,-0.184878,-0.231877,-0.246071,-0.240534:0.173534,0.101091,0.034478,0.012086,-0.019668,-0.078205,-0.11735,-0.127498,-0.140879,-0.111373,-0.082331,-0.036412:-0.142435,-0.15998,-0.191166,-0.260678,-0.334535,-0.360105,-0.357969,-0.352533,-0.33525,-0.311339,-0.258227,-0.180192:-0.225593,-0.243392,-0.273283,-0.297634,-0.297275,-0.281147,-0.246214,-0.222677,-0.228179,-0.198292,-0.154319,-0.137042:-0.081261,-0.071759,-0.068149,-0.044821,-0.008987,0.018924,0.026545,0.023623,0.052704,0.017938,-0.017902,-0.08313:0.158876,0.177907,0.204902,0.173005,0.126904,0.113268,0.079752,0.061572,0.043242,0.009126,-0.048402,-0.084198:8
1.139211,1.060657,1.033287,0.983985,0.849163,0.944488,1.043656,0.956553,0.901485,0.78851,0.767565,0.733537,0.579059:0.356364,0.430648,0.362527,0.33094,0.171633,0.021664,-0.212393,-0.281065,-0.415705,-0.60135,-0.816581,-0.885331,-0.991608:0.092316,0.008493,-0.030835,-0.007958,0.073277,0.051468,0.072192,0.137948,0.308434,0.481088,0.557932,0.501693,0.702094:-0.516919,-0.579739,-0.572407,-0.483859,-0.399767,-0.349153,-0.22276,-0.156537,-0.066285,0.025668,-0.136638,-0.188108,-0.042285:-0.235833,-0.127727,-0.003635,0.066724,0.084085,0.117581,0.094954,0.132387,0.151592,0.173752,0.368701,0.522814,0.482419:-0.328994,-0.265688,-0.268297,-0.21958,-0.124802,-0.106549,-0.064099,-0.110873,-0.101713,-0.071272,-0.042187,-0.049046,-0.126546:-0.009813,-0.079927,-0.097963,-0.058472,-0.100973,-0.141978,-0.175716,-0.206023,-0.262429,-0.311956,-0.384157,-0.361096,-0.362869:-0.079391,-0.082134,-0.029847,-0.078098,-0.11067,-0.142687,-0.162224,-0.099596,-0.092854,-0.098422,-0.050457,0.01769,0.047902:0.120604,0.026803,-0.129372,-0.138728,-0.131161,-0.184815,-0.250314,-0.385823,-0.366924,-0.312086,-0.24409,-0.20659,-0.218158:-0.437715,-0.407746,-0.376138,-0.435264,-0.454632,-0.434877,-0.357259,-0.295902,-0.297495,-0.246627,-0.165381,-0.124126,-0.109989:0.171009,0.191313,0.17375,0.15158,0.128842,0.134325,0.078723,0.14435,0.153493,0.108032,0.05091,-0.038708,-0.057837:0.078345,0.014168,0.009599,0.052931,0.103876,0.12661,0.138461,0.060186,0.039408,-0.005922,-0.109355,-0.190071,-0.25867:8
0.731289,0.696916,0.749777,0.856853,0.897523,0.897825,0.892042,0.82467,0.817099,0.732346,0.629824,0.615741,0.639662,0.598004,0.495029,0.47199,0.412875:-0.572257,-0.514721,-0.358569,-0.294041,-0.251652,-0.342092,-0.396352,-0.403611,-0.428049,-0.434059,-0.444454,-0.5711,-0.622501,-0.635346,-0.617864,-0.653191,-0.634395:0.150765,0.081604,0.044437,0.013494,-0.074132,-0.025127,-0.018422,0.028577,0.095414,0.210715,0.333964,0.485206,0.55437,0.607594,0.673057,0.772927,0.821652:-0.515971,-0.457581,-0.449278,-0.400036,-0.293513,-0.303638,-0.225253,-0.232938,-0.216335,-0.191347,-0.160752,-0.080917,-0.007604,0.010996,0.04289,0.069796,0.109654:0.053482,0.065396,0.220635,0.319315,0.348883,0.371306,0.326017,0.341683,0.384456,0.401173,0.449925,0.463526,0.487465,0.52456,0.528719,0.504372,0.499667:-0.338667,-0.357328,-0.351048,-0.316764,-0.294873,-0.242122,-0.177583,-0.150388,-0.167779,-0.181649,-0.231656,-0.23182,-0.234431,-0.268127,-0.312149,-0.324977,-0.37796:-0.084456,-0.031311,-0.053337,-0.111158,-0.124236,-0.13268,-0.153494,-0.20739,-0.287851,-0.290902,-0.282428,-0.294377,-0.275986,-0.259769,-0.245772,-0.279104,-0.287694:0.061001,-0.020788,0.031036,0.034164,-0.013061,-0.03618,-0.107101,-0.146572,-0.138907,-0.182998,-0.149612,-0.079017,-0.034865,0.025827,0.059881,0.10235,0.12916:-0.070112,-0.086395,-0.179494,-0.215325,-0.165093,-0.23296,-0.246545,-0.248476,-0.273288,-0.292464,-0.317962,-0.31152,-0.301107,-0.308377,-0.292156,-0.256968,-0.227526:-0.345436,-0.358789,-0.367884,-0.375762,-0.394284,-0.354293,-0.325815,-0.291524,-0.221194,-0.143151,-0.109957,-0.084333,-0.075302,-0.075634,-0.074622,-0.104408,-0.129974:-0.09339,-0.10192,-0.065618,-0.010818,0.01658,0.007371,-0.00583,-0.001201,0.018668,0.035847,0.060932,0.068936,0.063246,0.037303,-0.017594,-0.068289,-0.119459:0.26826,0.308721,0.24445,0.209213,0.20347,0.198454,0.156459,0.103485,0.034523,-9.65E-4,-0.022161,-0.067245,-0.096606,-0.147653,-0.19038,-0.213409,-0.207876:8
1.570966,1.570117,1.378889,1.350047,1.109416,1.035279,0.89181,0.782763,0.698778,0.617989,0.57124,0.472113,0.354194:-1.079778,-0.964288,-0.940761,-1.010065,-0.90567,-0.884568,-0.848385,-0.932468,-0.997001,-0.948909,-0.942999,-0.94949,-0.884847:0.271302,0.262499,0.304695,0.293878,0.27641,0.348895,0.433286,0.5512,0.634753,0.700665,0.820005,0.871638,0.868858:-0.54164,-0.584545,-0.589259,-0.541528,-0.445812,-0.299111,-0.195762,-0.128167,-0.037161,0.020722,0.107108,0.129351,0.158877:-0.22231,-0.035579,0.069143,0.17175,0.353415,0.385881,0.393538,0.421105,0.440815,0.472678,0.437477,0.420914,0.440041:-0.125521,-0.094203,-0.020143,0.010807,-0.04752,-0.126939,-0.168435,-0.16115,-0.12315,-0.176556,-0.213115,-0.220783,-0.26776:-0.262718,-0.292398,-0.273199,-0.274542,-0.326161,-0.308745,-0.333979,-0.373742,-0.332704,-0.320455,-0.331723,-0.311521,-0.28911:0.137792,0.127796,0.093524,0.055582,-0.010974,-0.079049,-0.117768,-0.083963,-0.029142,0.034917,0.050336,0.060582,0.064374:-0.015246,-0.089684,-0.164357,-0.242338,-0.287829,-0.321586,-0.294214,-0.260437,-0.236178,-0.226288,-0.20923,-0.217893,-0.216401:-0.307061,-0.275155,-0.300657,-0.317157,-0.26997,-0.174871,-0.09629,-0.076494,-0.071208,-0.087375,-0.101131,-0.100881,-0.098945:-0.014626,0.005583,-0.019446,-0.010988,-0.001225,-0.025724,-0.020786,0.001875,0.00238,-0.023423,-0.062878,-0.084499,-0.103983:0.257684,0.241868,0.194533,0.160429,0.131152,0.102494,-0.0092,-0.093929,-0.165606,-0.215682,-0.238248,-0.260295,-0.251912:8
1.082299,1.001317,0.982187,0.898122,0.883653,0.685597,0.553021,0.579305,0.625714,0.566612,0.552902:-0.46497,-0.355179,-0.420907,-0.413321,-0.377991,-0.235651,-0.236209,-0.279506,-0.383737,-0.409428,-0.404262:0.333844,0.241533,0.230391,0.124464,0.053748,-0.027184,0.054635,0.164691,0.271028,0.307526,0.316869:-0.754193,-0.670337,-0.560229,-0.420637,-0.30906,-0.148755,-0.061413,0.004058,0.133401,0.279753,0.371556:0.223608,0.381726,0.426113,0.513926,0.575792,0.587937,0.554137,0.54747,0.540137,0.544773,0.535025:-0.22037,-0.244841,-0.219972,-0.208668,-0.2409,-0.289567,-0.301501,-0.281272,-0.317803,-0.391935,-0.406346:-0.282972,-0.273275,-0.299498,-0.302668,-0.307077,-0.247687,-0.206799,-0.222132,-0.225818,-0.196848,-0.185391:0.233631,0.191889,0.124525,0.032318,-0.041452,-0.131532,-0.158136,-0.139516,-0.090473,-0.070297,-0.076587:-0.21615,-0.203787,-0.182352,-0.16936,-0.169544,-0.17841,-0.211915,-0.218198,-0.165621,-0.073763,-0.02822:-0.235052,-0.20746,-0.221575,-0.239824,-0.217078,-0.198509,-0.197833,-0.185204,-0.15055,-0.148874,-0.154011:0.042914,-0.021955,-0.010735,0.008504,0.012342,0.063258,0.107483,0.089377,-0.004611,-0.064085,-0.072121:0.172213,0.159401,0.177889,0.172723,0.14435,0.084021,0.025366,-0.003331,-0.012147,-0.044694,-0.093014:8
1.147237,1.150597,1.023581,0.953873,0.946195,0.945841,0.866964,0.837476,0.715125,0.701914,0.710932,0.556048:-0.466756,-0.42962,-0.470103,-0.428752,-0.378641,-0.391045,-0.257189,-0.26513,-0.340977,-0.444967,-0.544718,-0.541371:0.228154,0.148831,0.167617,0.194719,0.129529,0.064047,0.003414,0.106431,0.268611,0.352283,0.474846,0.602145:-0.631108,-0.543205,-0.499057,-0.468975,-0.238884,-0.145372,-0.078187,-0.015632,0.072786,0.258117,0.361669,0.346594:0.105484,0.187308,0.192097,0.273436,0.391247,0.394833,0.339624,0.367992,0.398086,0.415888,0.448968,0.440978:-0.286672,-0.257102,-0.141946,-0.133343,-0.256445,-0.210091,-0.190056,-0.185808,-0.26029,-0.314305,-0.337488,-0.279967:-0.28248,-0.267473,-0.19984,-0.225054,-0.319296,-0.124434,-0.016241,-0.090931,-0.151803,-0.172697,-0.145201,-0.182897:0.198355,0.134289,0.048451,0.042395,-0.018231,-0.177387,-0.255484,-0.191613,-0.133141,-0.086661,-0.08233,-0.061115:-0.024896,-0.059314,-0.146316,-0.183598,-0.110496,-0.184891,-0.218978,-0.260001,-0.213605,-0.111787,-0.070589,-0.055862:-0.259521,-0.288505,-0.287913,-0.305087,-0.22265,-0.162204,-0.212198,-0.212288,-0.163571,-0.115641,-0.083677,-0.130522:-0.13669,-0.093349,-0.034024,-0.024336,-0.027761,-0.059062,0.00774,0.029026,0.027671,-0.018999,-0.081565,-0.074628:0.181441,0.204715,0.247729,0.201806,0.10938,0.167901,0.148896,0.086647,-0.007884,-0.083979,-0.105159,-0.144444:8
0.998584,0.79986,0.918644,1.045721,1.125583,0.975747,0.869855,0.904396,0.771896,0.722664,0.707922:-0.430736,-0.29742,-0.238177,-0.252218,-0.380895,-0.370994,-0.359781,-0.535918,-0.667855,-0.835989,-0.983322:0.416202,0.375345,0.235283,0.070138,0.10107,0.084838,0.042887,0.187256,0.337232,0.512826,0.682785:-0.682922,-0.634866,-0.546473,-0.371043,-0.339521,-0.206906,0.013582,0.082717,0.065136,0.075278,0.055707:0.044813,0.116907,0.189836,0.141855,0.152875,0.163154,0.17862,0.240351,0.357092,0.401328,0.416276:-0.273279,-0.280551,-0.274866,-0.235841,-0.206982,-0.237585,-0.274262,-0.230591,-0.193025,-0.202141,-0.206298:-0.195586,-0.167219,-0.136502,-0.113295,-0.130422,-0.097844,-0.093008,-0.176226,-0.268047,-0.31638,-0.375486:0.252508,0.212211,0.086421,-0.017516,-0.074575,-0.15978,-0.224556,-0.211975,-0.119862,-0.052621,-0.009295:-0.164599,-0.228002,-0.277636,-0.304144,-0.328351,-0.339189,-0.318961,-0.266285,-0.272133,-0.28377,-0.261395:-0.294596,-0.308825,-0.304534,-0.353811,-0.357931,-0.331673,-0.265068,-0.204977,-0.196049,-0.183679,-0.16809:-0.181954,-0.140753,-0.093206,-0.036613,-0.016017,0.039067,0.085795,0.073521,0.045467,3.75E-4,-0.037527:0.100134,0.093818,0.102347,0.126764,0.171316,0.19103,0.152745,0.096926,0.01736,-0.057271,-0.125908:8
1.067269,1.134995,1.121943,1.040627,0.918541,0.853446,0.75477,0.672879,0.665778,0.60242,0.517202,0.485398:-0.920583,-1.053572,-1.054896,-0.984812,-0.926876,-0.906304,-0.908723,-0.943442,-0.966743,-1.002231,-1.06784,-1.093819:0.351984,0.394587,0.381998,0.366111,0.358169,0.352955,0.327659,0.329968,0.41476,0.52329,0.626373,0.68137:-0.637834,-0.711136,-0.692562,-0.626104,-0.551876,-0.512457,-0.475822,-0.411589,-0.302446,-0.150297,-0.078705,-0.028605:-0.20893,-0.099764,0.014031,0.162338,0.299213,0.405553,0.44563,0.460694,0.4726,0.514915,0.563825,0.572758:-0.16543,-0.108902,-0.094464,-0.120979,-0.110192,-0.079002,-0.064004,-0.072542,-0.087886,-0.080339,-0.117714,-0.163469:-0.231278,-0.304286,-0.337032,-0.336841,-0.350941,-0.384698,-0.382682,-0.379171,-0.388722,-0.359431,-0.375274,-0.394352:0.219083,0.238281,0.216591,0.169147,0.121268,0.063304,-0.002338,-0.043567,-0.056746,-0.03075,0.020964,0.058508:-0.014948,-0.08121,-0.135671,-0.220146,-0.302851,-0.356594,-0.379809,-0.38196,-0.353434,-0.313725,-0.292477,-0.281882:-0.322587,-0.370995,-0.390786,-0.359691,-0.347515,-0.336755,-0.298247,-0.245765,-0.182817,-0.13366,-0.127744,-0.131895:-0.085598,-0.058173,-0.066775,-0.085615,-0.060862,-0.02297,-0.010119,0.007146,0.032931,0.033884,-0.004553,-0.039409:0.137003,0.113443,0.116352,0.126553,0.101219,0.089427,0.06764,0.014987,-0.037407,-0.100407,-0.154389,-0.194989:8
1.206917,1.189404,1.073976,0.965972,0.891006,0.869964,0.77497,0.669865,0.63163,0.593158,0.643923:-0.706625,-0.755022,-0.7339,-0.635874,-0.620493,-0.722607,-0.774083,-0.826298,-0.873815,-0.92381,-1.017802:0.259367,0.214296,0.193202,0.220555,0.322803,0.386988,0.401456,0.445345,0.474912,0.55716,0.630921:-0.860768,-0.860775,-0.839175,-0.75381,-0.603175,-0.574426,-0.508899,-0.415036,-0.303054,-0.14184,-0.055323:0.086119,0.121143,0.202476,0.255245,0.265922,0.327436,0.356063,0.394609,0.421778,0.463374,0.474475:-0.298489,-0.281018,-0.278441,-0.229424,-0.190127,-0.151747,-0.172113,-0.205238,-0.227369,-0.241888,-0.24304:-0.327037,-0.32138,-0.345981,-0.369426,-0.380371,-0.35689,-0.308851,-0.338247,-0.355637,-0.341467,-0.371961:0.311512,0.289585,0.279257,0.192641,0.090311,0.021725,-0.019689,-0.038884,-0.038151,-0.014045,0.006409:-0.12509,-0.194773,-0.229401,-0.243395,-0.257038,-0.380333,-0.471958,-0.465376,-0.418463,-0.354759,-0.296385:-0.27987,-0.288137,-0.286,-0.275639,-0.264649,-0.221846,-0.207876,-0.188932,-0.162983,-0.112473,-0.091764:-0.083648,-0.071191,-0.061563,-0.038793,-9.92E-4,0.051043,0.105902,0.110381,0.094979,0.036833,-0.032711:0.149438,0.135879,0.108103,0.105603,0.088246,0.03041,0.046402,0.058331,0.027891,-0.0843,-0.176739:8
1.331146,1.100881,0.889634,0.79766,0.843009,0.721306,0.628667,0.583588,0.552386,0.489873,0.436669,0.408898:-0.419982,-0.330602,-0.363506,-0.401669,-0.482206,-0.524049,-0.516224,-0.462711,-0.576733,-0.639665,-0.655366,-0.652347:0.223127,0.201638,0.255204,0.21454,0.160329,0.156888,0.217094,0.276162,0.297929,0.353678,0.433121,0.490102:-0.720083,-0.683154,-0.599926,-0.524417,-0.470296,-0.371103,-0.309042,-0.189363,-0.05631,0.019204,0.102461,0.173763:0.141776,0.201999,0.160799,0.191274,0.178392,0.204157,0.244836,0.268296,0.383053,0.451936,0.4734,0.457854:-0.32552,-0.306452,-0.279192,-0.229223,-0.165885,-0.162372,-0.162773,-0.174957,-0.236294,-0.295195,-0.365242,-0.402623:-0.20936,-0.15128,-0.117226,-0.058449,-0.012076,-0.031991,-0.081614,-0.143479,-0.192471,-0.186876,-0.210278,-0.214963:0.195875,0.139649,0.066625,-0.026065,-0.092365,-0.139702,-0.170322,-0.169025,-0.141683,-0.085678,-0.029514,-0.021647:-0.181111,-0.212894,-0.257367,-0.326908,-0.384641,-0.382529,-0.380599,-0.362354,-0.264161,-0.221747,-0.205469,-0.15676:-0.200276,-0.204435,-0.183064,-0.204357,-0.227707,-0.231875,-0.198927,-0.164935,-0.147204,-0.146804,-0.127563,-0.145943:-0.040685,-0.070031,-0.053532,0.021861,0.023055,0.047212,0.092349,0.127324,0.052789,-0.009909,-0.0702,-0.118812:0.20913,0.175369,0.121656,0.119551,0.140556,0.125121,0.077655,0.011324,-0.003451,-0.050989,-0.128527,-0.149072:8
1.248173,1.466829,1.403549,1.249037,1.039045,0.899315,0.81099,0.786957,0.795173,0.768108,0.844725,0.853628,0.797802,0.753881:-0.69701,-0.700459,-0.396707,-0.31599,-0.255334,-0.156226,-0.022062,-0.128239,-0.311734,-0.391182,-0.511364,-0.67592,-0.790873,-0.860199:0.322292,0.367824,0.201585,0.190332,0.167786,-0.023507,-0.107419,0.063079,0.103141,0.222314,0.371015,0.46767,0.526261,0.614135:-0.753571,-0.844755,-0.734324,-0.731726,-0.658222,-0.523197,-0.384923,-0.24741,-0.180627,-0.134586,-0.117448,-0.02016,0.082298,0.153663:-0.137727,-0.047325,0.061992,0.138371,0.17454,0.249811,0.265446,0.170324,0.201664,0.296056,0.38033,0.43859,0.456869,0.477645:-0.239649,-0.227105,-0.341843,-0.360691,-0.304858,-0.309924,-0.31006,-0.261223,-0.213398,-0.215055,-0.234984,-0.284386,-0.29756,-0.308972:-0.305121,-0.32836,-0.144861,-0.09542,-0.070287,-0.07137,-0.026145,-0.002387,-0.05682,-0.114586,-0.188449,-0.308464,-0.357646,-0.399993:0.305463,0.356383,0.272962,0.244188,0.155882,0.034689,-0.038556,-0.131811,-0.154904,-0.13883,-0.095381,-0.056182,-0.033066,0.012301:0.020291,-0.056097,-0.113612,-0.172321,-0.195301,-0.148932,-0.153504,-0.237741,-0.270424,-0.290513,-0.267781,-0.164403,-0.143488,-0.149343:-0.241641,-0.292837,-0.285343,-0.299609,-0.335161,-0.391675,-0.422113,-0.348276,-0.308014,-0.252199,-0.173061,-0.142063,-0.144295,-0.146749:0.033822,0.016213,-0.068412,-0.076533,-0.041349,-0.011254,0.034301,0.12012,0.117812,0.116181,0.029693,-0.088582,-0.12274,-0.115035:0.107847,0.112593,0.211555,0.225249,0.205174,0.189506,0.145536,0.144478,0.157259,0.103403,0.022952,-0.051508,-0.105974,-0.153216:8
1.420611,1.426666,1.416077,1.193812,0.956015,0.890553,0.878019,0.749709,0.614266,0.608934,0.674203,0.681177,0.659817,0.346618,0.18271:0.167688,0.069895,-0.139356,-0.123627,-0.123529,-0.250994,-0.38227,-0.503028,-0.587091,-0.629675,-0.716394,-0.866221,-0.942996,-0.798969,-0.680221:-5.82E-4,-0.062117,0.157941,0.173015,0.115593,0.171942,0.279902,0.379863,0.44902,0.505399,0.622766,0.726843,0.723196,0.629173,0.562569:-0.72033,-0.696574,-0.796556,-0.761438,-0.61463,-0.499402,-0.547217,-0.548651,-0.493414,-0.438946,-0.332959,-0.203974,-0.026287,0.107522,0.136874:-0.185705,-0.110748,-0.044153,0.016361,0.111981,0.152367,0.262721,0.327222,0.384707,0.483409,0.52519,0.550524,0.498836,0.470153,0.522132:-0.39621,-0.391236,-0.337773,-0.260806,-0.253715,-0.169854,-0.121085,-0.055698,-0.031681,-0.056098,-0.067129,-0.064996,-0.096698,-0.110826,-0.150192:-0.072731,-0.066403,-0.102015,-0.122504,-0.107371,-0.133417,-0.21905,-0.365519,-0.469098,-0.511271,-0.522209,-0.575168,-0.547615,-0.515242,-0.533609:0.252311,0.222235,0.208339,0.164068,0.119212,0.079461,0.078395,0.069337,0.024566,-0.006741,-0.0023,0.028782,0.009509,-0.028868,-0.027658:-0.213729,-0.213295,-0.228512,-0.236896,-0.263598,-0.308493,-0.331057,-0.316691,-0.314125,-0.336031,-0.34154,-0.285299,-0.23968,-0.195157,-0.156067:-0.177768,-0.169688,-0.196392,-0.243563,-0.290059,-0.324044,-0.342904,-0.340317,-0.286952,-0.206977,-0.166424,-0.195295,-0.210493,-0.195878,-0.180238:0.007677,-0.037584,-0.035773,0.00318,0.012542,0.022578,0.019069,0.043797,0.095144,0.145535,0.177496,0.144638,0.092348,0.035811,-0.005616:-0.047459,-0.004917,0.040363,0.044199,0.077412,0.108315,0.116579,0.081128,0.046658,0.002712,-0.065672,-0.121599,-0.161143,-0.204263,-0.240171:8
1.313472,1.596337,1.58915,1.624268,1.39129,1.285277,1.162305,1.092819,1.035338,1.103056,1.018462,0.920161,0.812199,0.642017:-0.872475,-0.866834,-0.635986,-0.675241,-0.576789,-0.566084,-0.607757,-0.713421,-0.8027,-0.918359,-0.938513,-0.924621,-0.934833,-0.93306:0.230029,0.217652,-0.031194,0.003849,0.042363,0.185033,0.22739,0.27299,0.324759,0.310829,0.397042,0.588802,0.708652,0.80175:-0.653993,-0.697785,-0.620186,-0.711855,-0.667242,-0.619458,-0.499758,-0.456862,-0.3723,-0.140595,0.013094,0.073534,0.167938,0.209857:-0.173269,-0.136112,-0.075003,0.04976,0.21996,0.386866,0.450314,0.446881,0.420864,0.415438,0.453612,0.463288,0.444202,0.444371:-0.21181,-0.191367,-0.259251,-0.279343,-0.26856,-0.258224,-0.247593,-0.167663,-0.130362,-0.173381,-0.207279,-0.247682,-0.278039,-0.288551:-0.296081,-0.327139,-0.256117,-0.284794,-0.328426,-0.376156,-0.366999,-0.367489,-0.347666,-0.301041,-0.263653,-0.327822,-0.315385,-0.301275:0.235216,0.247006,0.211988,0.212428,0.145969,0.098763,0.02069,-0.048254,-0.09685,-0.10193,-0.057403,-0.022027,-0.030972,-0.007383:0.063464,0.016263,-0.06075,-0.164345,-0.212055,-0.30249,-0.345533,-0.391062,-0.420851,-0.390695,-0.331811,-0.278982,-0.266778,-0.260656:-0.321165,-0.361585,-0.363175,-0.31653,-0.291629,-0.274279,-0.244732,-0.204972,-0.156863,-0.089993,-0.062201,-0.055269,-0.040549,-0.045224:-0.089361,-0.071232,-0.046413,-0.040859,-0.026032,-0.001699,3.48E-4,0.016034,0.041717,0.018415,-0.036153,-0.074491,-0.10014,-0.113294:0.160213,0.165695,0.167094,0.151772,0.151128,0.179554,0.160922,0.11346,0.059774,-0.018824,-0.11206,-0.198542,-0.215977,-0.213124:8
1.092842,1.175279,1.160254,1.156081,1.213581,1.196127,1.071398,1.097148,0.96887,0.801894,0.704634,0.540727,0.558462,0.681433,0.601357:-0.427965,-0.487774,-0.420823,-0.355835,-0.242896,-0.146292,-0.114793,-0.042286,-0.0981,-0.144622,-0.19323,-0.201372,-0.309415,-0.533579,-0.557872:0.260469,0.181245,0.050767,-0.038934,-0.129137,-0.052279,0.093059,0.026546,0.032277,0.043593,0.104605,0.390625,0.486941,0.571443,0.632178:-0.836243,-0.765305,-0.591131,-0.483111,-0.400045,-0.379013,-0.377726,-0.396601,-0.267852,-0.084164,0.104873,0.108143,0.221032,0.382453,0.452786:-0.063773,-0.057148,-0.100489,-0.034917,0.061158,0.148185,0.254023,0.387769,0.424839,0.488395,0.501802,0.522542,0.495375,0.373178,0.350744:-0.447234,-0.405555,-0.342258,-0.311604,-0.306198,-0.298938,-0.275275,-0.344681,-0.318488,-0.318371,-0.345511,-0.395773,-0.466003,-0.406441,-0.421786:-0.2365,-0.181355,-0.158605,-0.142013,-0.12926,-0.077927,-0.094274,-0.165569,-0.174533,-0.182297,-0.140869,-0.131341,-0.188247,-0.124133,-0.061593:0.39119,0.366994,0.293647,0.206897,0.120139,0.058643,0.016697,-0.053906,-0.184069,-0.229876,-0.216506,-0.153755,-0.085839,-0.136274,-0.084234:-0.013118,-0.056831,-0.067857,-0.126592,-0.182028,-0.251956,-0.352011,-0.353182,-0.298682,-0.252678,-0.256066,-0.302242,-0.176611,-0.098808,-0.112389:-0.174079,-0.197084,-0.296172,-0.349638,-0.362538,-0.339671,-0.277409,-0.207423,-0.131468,-0.099445,-0.089779,-0.053798,-0.069069,-0.058014,-0.024186:0.012772,0.004607,0.045441,0.018694,-0.020098,-0.038594,0.022436,0.046531,0.048315,0.060744,0.025728,-0.003063,-0.135533,-0.21189,-0.229572:0.117244,0.103001,0.11409,0.128703,0.158225,0.193124,0.16868,0.142942,0.102066,0.004166,-0.064172,-0.144074,-0.160347,-0.128506,-0.144406:8
1.572753,1.308104,1.150267,1.041879,1.001973,0.955386,0.811391,0.658285,0.543372,0.468169,0.467281,0.519712,0.490041:-1.024043,-0.98207,-0.916947,-0.84613,-0.827563,-0.795019,-0.750099,-0.798622,-0.85767,-0.848658,-0.832503,-0.893742,-1.041941:0.350852,0.347637,0.316077,0.239827,0.184314,0.16065,0.165652,0.178842,0.206657,0.254389,0.323666,0.480943,0.644842:-0.81696,-0.847491,-0.860108,-0.853925,-0.823122,-0.754539,-0.645217,-0.550216,-0.472208,-0.380026,-0.260792,-0.087808,0.017756:-0.272146,-0.163398,-0.080945,0.006939,0.076189,0.148107,0.205118,0.301973,0.383345,0.443372,0.465901,0.453752,0.464535:-0.226878,-0.24642,-0.267082,-0.288858,-0.280947,-0.286619,-0.279804,-0.248368,-0.21656,-0.192366,-0.178681,-0.183448,-0.198889:-0.253176,-0.256869,-0.245547,-0.213344,-0.227869,-0.256452,-0.250132,-0.259289,-0.305276,-0.390751,-0.4309,-0.403131,-0.404018:0.270749,0.289691,0.284532,0.248316,0.198994,0.148791,0.092827,0.035626,-0.037413,-0.108182,-0.123633,-0.085418,-0.01867:-0.036812,-0.091464,-0.152166,-0.211016,-0.222257,-0.223452,-0.238014,-0.273243,-0.30153,-0.309668,-0.308073,-0.271439,-0.252035:-0.253655,-0.266877,-0.27775,-0.283633,-0.283575,-0.289342,-0.308979,-0.321934,-0.292991,-0.231069,-0.192159,-0.147652,-0.151609:-0.073824,-0.069228,-0.056403,-0.052935,-0.060398,-0.07017,-0.058741,-0.048083,-0.031332,0.020211,0.043491,0.015481,-0.03697:0.15602,0.182572,0.200274,0.237651,0.266434,0.305268,0.31706,0.258435,0.17786,0.121131,0.07062,-0.020129,-0.131488:8
0.896464,0.886027,0.852053,0.741866,0.691811,0.649027,0.566023,0.461108,0.375022,0.366952:-0.625753,-0.638243,-0.625301,-0.620632,-0.687683,-0.776062,-0.827676,-0.868127,-0.924132,-0.972844:0.124187,0.162321,0.223559,0.250824,0.277027,0.314058,0.333907,0.408371,0.521445,0.620628:-0.732843,-0.705181,-0.636266,-0.533742,-0.491653,-0.438573,-0.333717,-0.191436,-0.062815,0.020328:0.155286,0.189444,0.27242,0.34267,0.348836,0.352876,0.374865,0.406825,0.473783,0.492045:-0.330206,-0.262134,-0.208008,-0.171999,-0.125422,-0.12256,-0.164152,-0.186397,-0.186336,-0.215911:-0.239375,-0.252354,-0.283571,-0.286421,-0.262955,-0.257363,-0.262584,-0.275779,-0.302678,-0.334186:0.231096,0.177687,0.109969,0.042539,-0.016346,-0.036722,-0.027534,-0.006374,0.035153,0.069007:-0.218198,-0.284119,-0.33043,-0.383754,-0.456138,-0.501388,-0.501296,-0.448347,-0.368275,-0.315489:-0.234208,-0.242483,-0.244267,-0.24509,-0.233645,-0.235212,-0.237115,-0.203352,-0.186045,-0.184216:-0.089643,-0.052906,-0.04297,-0.017637,0.043436,0.099906,0.124764,0.114873,0.050306,-0.010922:0.054514,0.039829,0.039118,0.031895,0.01873,0.027998,0.028396,-0.039874,-0.128091,-0.189362:8
0.621613,0.672744,0.887841,0.984596,1.057234,0.888178,0.748876,0.601453,0.380742,0.33122,0.362249,0.356485,0.263119:-0.314232,-0.330035,-0.414394,-0.428884,-0.486247,-0.490761,-0.524415,-0.517064,-0.548468,-0.674855,-0.715476,-0.769794,-0.743973:-0.014256,-0.014005,0.003306,0.001339,0.037577,0.091969,0.117555,0.137461,0.327729,0.440424,0.502949,0.650092,0.748144:-0.634924,-0.623272,-0.583262,-0.547717,-0.472718,-0.387226,-0.331032,-0.259122,-0.118595,0.017258,0.12639,0.16231,0.22037:0.124365,0.123623,0.154473,0.20856,0.257288,0.359129,0.391219,0.387721,0.372983,0.399994,0.417839,0.440233,0.427044:-0.476804,-0.409023,-0.31777,-0.278472,-0.242171,-0.23522,-0.199994,-0.17151,-0.236383,-0.260667,-0.251516,-0.27985,-0.323254:-0.136831,-0.146785,-0.192391,-0.19485,-0.188074,-0.194669,-0.220543,-0.206498,-0.197468,-0.209359,-0.207715,-0.243399,-0.245723:0.231997,0.210498,0.185339,0.138913,0.069875,-0.021458,-0.097425,-0.15268,-0.162171,-0.124923,-0.090177,-0.028389,-0.02043:-0.126848,-0.141471,-0.173352,-0.222293,-0.228966,-0.271275,-0.321085,-0.337894,-0.305223,-0.25849,-0.219671,-0.195102,-0.175814:-0.246013,-0.266502,-0.290663,-0.308022,-0.298461,-0.24832,-0.206206,-0.199339,-0.138446,-0.114156,-0.119064,-0.121227,-0.113563:-0.086166,-0.077812,-0.057705,-0.037807,-0.054922,-0.071236,-0.019888,0.015842,0.015069,-0.016169,-0.050013,-0.08697,-0.128714:0.121088,0.115703,0.109552,0.125868,0.158432,0.16878,0.123716,0.089941,0.024896,-0.012827,-0.073155,-0.140156,-0.175161:8
1.056923,0.963632,0.810664,0.948552,0.925259,0.836366,0.715161,0.594008,0.594494,0.622414,0.596161,0.610461,0.552163,0.39205,0.360493:-0.324731,-0.198338,-0.100198,-0.213687,-0.221983,-0.221736,-0.1568,-0.241952,-0.449346,-0.594506,-0.672549,-0.750233,-0.845234,-0.82173,-0.842858:-0.026389,-0.091664,-0.163138,-0.253543,-0.244742,-0.130133,-0.113615,-0.026327,0.048261,0.196111,0.368823,0.604682,0.768794,0.753863,0.82737:-0.664696,-0.573394,-0.522235,-0.450157,-0.391328,-0.318507,-0.225256,-0.205251,-0.121511,-0.018818,0.105325,0.204088,0.234224,0.22598,0.272488:-0.056561,-0.054803,0.005021,0.03751,0.115033,0.279858,0.320959,0.341285,0.390884,0.411242,0.456821,0.455047,0.46724,0.541715,0.498879:-0.459595,-0.46501,-0.450611,-0.40854,-0.333397,-0.302317,-0.239278,-0.218503,-0.256856,-0.265158,-0.304149,-0.332391,-0.373092,-0.410793,-0.400894:-0.056958,-0.021387,-0.01755,-0.052286,-0.147924,-0.212619,-0.16503,-0.104204,-0.148138,-0.216843,-0.261524,-0.267318,-0.296484,-0.292775,-0.246759:0.201925,0.157313,0.099595,0.024089,0.00413,-0.038281,-0.121015,-0.171908,-0.189352,-0.15769,-0.075326,-0.008171,0.069195,0.102896,0.118633:-0.005091,0.010573,-0.01234,-0.043996,-0.109641,-0.17242,-0.183023,-0.260492,-0.284878,-0.266153,-0.195614,-0.171698,-0.173456,-0.175578,-0.184098:-0.374732,-0.396825,-0.400896,-0.412666,-0.394407,-0.361896,-0.396146,-0.349414,-0.26129,-0.191093,-0.139982,-0.121253,-0.140685,-0.129044,-0.107692:-0.096747,-0.075171,-0.049584,-0.068601,0.004755,0.039401,0.058157,0.042607,0.013828,-0.007027,-0.057204,-0.121006,-0.158477,-0.174688,-0.17868:0.178628,0.16515,0.124671,0.16699,0.156241,0.157741,0.143885,0.106053,0.081771,0.04462,-0.054517,-0.128997,-0.148299,-0.158078,-0.159316:8
0.664592,0.862243,1.003736,1.197363,1.078083,0.896754,0.893166,0.916455,0.938074,1.091207,1.103533,0.974674,0.763481:0.024125,0.067616,0.09095,-0.119225,-0.258014,-0.299081,-0.380764,-0.458409,-0.586569,-0.818071,-0.927218,-1.054062,-1.07346:-0.036509,-0.103588,-0.169781,-0.13102,-0.083907,-0.079165,0.085113,0.151668,0.2672,0.43592,0.508457,0.672694,0.835096:-0.49255,-0.467376,-0.372479,-0.322839,-0.336819,-0.301231,-0.306012,-0.254536,-0.12795,0.003342,0.144084,0.194584,0.195432:-0.101055,-0.067433,-0.020165,-0.011201,0.119523,0.257268,0.281393,0.32928,0.35159,0.374537,0.384694,0.367492,0.349898:-0.418917,-0.434537,-0.456719,-0.401181,-0.338294,-0.284478,-0.191311,-0.187676,-0.169492,-0.150075,-0.173769,-0.173263,-0.184505:0.05465,0.083611,0.068444,0.112018,0.072311,0.018051,-0.102308,-0.13961,-0.165727,-0.206683,-0.187641,-0.249217,-0.29565:0.123965,0.102656,0.076549,0.067378,0.028483,-0.020676,-0.026186,-0.13881,-0.201224,-0.136278,-0.074721,0.011245,0.079346:-0.012459,-0.144922,-0.268835,-0.330844,-0.367777,-0.353654,-0.374861,-0.348595,-0.368257,-0.381615,-0.316734,-0.230117,-0.188248:-0.369247,-0.359618,-0.308155,-0.294121,-0.313926,-0.3677,-0.32297,-0.243063,-0.118027,-0.041635,-0.038121,-0.085975,-0.117059:0.09514,0.121776,0.089002,-0.001107,-0.014915,0.002415,0.051333,0.034392,0.013123,0.018898,-0.014217,-0.062475,-0.083569:0.154726,0.116626,0.149893,0.194877,0.191844,0.182788,0.112751,0.099703,0.039331,-0.071995,-0.127311,-0.189074,-0.253682:8
1.8427,1.665117,1.637576,1.468994,1.506208,1.495648,1.239966,1.072702,0.958967,0.837157,0.758408,0.701777,0.730996,0.72303,0.744231,0.666382:-0.491212,-0.639363,-0.76816,-0.795332,-0.845264,-0.828315,-0.780585,-0.72479,-0.730518,-0.724233,-0.70055,-0.740518,-0.851789,-0.926437,-0.932883,-0.899327:0.072607,0.111965,0.145719,0.201562,0.285302,0.245878,0.25361,0.276018,0.253243,0.225252,0.206685,0.301885,0.469178,0.555365,0.640332,0.741342:-0.382506,-0.429052,-0.522489,-0.592917,-0.766905,-0.703722,-0.676987,-0.576241,-0.383876,-0.276085,-0.249221,-0.124048,0.066471,0.199721,0.303237,0.346866:-0.443987,-0.438797,-0.447816,-0.355238,-0.189103,-0.117195,-6.14E-4,0.101688,0.249419,0.385226,0.453285,0.489982,0.504682,0.48036,0.433593,0.40495:-0.462093,-0.379959,-0.237204,-0.20226,-0.203238,-0.212175,-0.250845,-0.264613,-0.239547,-0.227385,-0.230313,-0.225375,-0.211842,-0.240264,-0.289086,-0.325846:0.098149,0.069773,-0.032409,-0.103656,-0.192827,-0.176897,-0.183474,-0.195298,-0.195921,-0.245536,-0.299826,-0.36235,-0.375466,-0.340673,-0.295163,-0.236546:0.016829,0.017151,0.070575,0.107146,0.202996,0.185148,0.147834,0.068293,-0.07243,-0.136946,-0.142559,-0.150259,-0.092609,-0.042369,-0.016372,0.021904:-0.005723,-0.022545,-0.031954,-0.026785,-0.086906,-0.14332,-0.208152,-0.23981,-0.281601,-0.312112,-0.299469,-0.227082,-0.15243,-0.133461,-0.147951,-0.136484:-0.166346,-0.206519,-0.292942,-0.338558,-0.332135,-0.354377,-0.337947,-0.316583,-0.27721,-0.270146,-0.266804,-0.185286,-0.124193,-0.137816,-0.116307,-0.093402:-0.179371,-0.162133,-0.089079,-0.088784,-0.116334,-0.116093,-0.104185,-0.07536,-0.079054,-0.060129,-0.024306,-0.044138,-0.090444,-0.135227,-0.153047,-0.176694:0.178382,0.222485,0.23182,0.252655,0.237192,0.252599,0.272336,0.284308,0.269412,0.238221,0.190154,0.090914,-0.035407,-0.113518,-0.158042,-0.163193:8
1.23909,1.155726,1.193816,1.235383,1.272744,1.375948,1.313458,1.266745,1.313255,1.289764,1.283138,1.279035,1.182812,1.188639,1.209065,1.202312,1.19291:-0.182066,-0.168982,-0.147474,-0.20852,-0.287131,-0.380495,-0.343047,-0.396697,-0.520735,-0.549856,-0.573484,-0.604105,-0.657689,-0.729332,-0.739069,-0.735433,-0.580729:0.406748,0.385749,0.299624,0.240927,0.314084,0.354738,0.247342,0.152268,0.188857,0.235441,0.245375,0.267678,0.270371,0.273931,0.252106,0.17338,0.131233:-0.491015,-0.480784,-0.492643,-0.527622,-0.607262,-0.627268,-0.523869,-0.41357,-0.399826,-0.387945,-0.291004,-0.265741,-0.198188,-0.122825,-0.078742,-0.025087,-0.05707:-0.248879,-0.226822,-0.212937,-0.15246,-0.09659,-0.087936,0.006131,0.033087,0.067098,0.115774,0.166943,0.216363,0.32197,0.404758,0.509981,0.588965,0.664546:-0.517593,-0.470891,-0.436452,-0.403887,-0.400376,-0.394132,-0.394448,-0.389329,-0.374269,-0.305451,-0.208196,-0.192553,-0.133927,-0.072556,-0.093134,-0.108923,-0.098104:0.107838,0.10203,0.152361,0.130109,0.09044,0.090389,0.083061,0.113294,0.102493,-0.018626,-0.153417,-0.171788,-0.187846,-0.23618,-0.302658,-0.317242,-0.332869:0.292798,0.308255,0.341325,0.343025,0.338497,0.331945,0.264612,0.185218,0.129602,0.123936,0.182187,0.193807,0.153045,0.130829,0.103272,0.095647,0.067194:-0.26034,-0.261857,-0.270462,-0.312271,-0.336851,-0.348058,-0.345292,-0.350953,-0.336935,-0.330685,-0.352288,-0.31935,-0.296199,-0.268943,-0.240633,-0.259383,-0.220257:0.06187,0.024854,-0.019666,-0.080971,-0.118085,-0.120292,-0.101931,-0.100835,-0.15236,-0.229556,-0.277648,-0.270961,-0.225876,-0.207344,-0.171342,-0.143452,-0.118489:0.01614,0.026492,0.012289,0.021126,0.016037,-0.017333,-0.052857,-0.083651,-0.109432,-0.025298,0.11594,0.114849,0.136593,0.132575,0.100594,0.09392,0.077617:-0.052763,-0.040641,-0.052959,-0.058242,-0.019486,0.01392,0.069825,0.106782,0.207979,0.244989,0.187286,0.171902,0.156272,0.112322,0.063225,0.01564,-0.03116:9
1.434264,1.30714,1.226302,1.221413,1.202362,1.174848,1.128922,1.085401,1.069528,0.942701,0.832742,0.6373:-0.449358,-0.437402,-0.433637,-0.44658,-0.450799,-0.525512,-0.551824,-0.602674,-0.677129,-0.67761,-0.69249,-0.630387:0.185516,0.140693,0.099982,0.093714,0.086504,0.172043,0.201894,0.233859,0.313279,0.340862,0.420171,0.434498:-0.589983,-0.577045,-0.546638,-0.520155,-0.45627,-0.461644,-0.42164,-0.331505,-0.280007,-0.272077,-0.213138,-0.05536:0.169897,0.268807,0.304848,0.355458,0.414479,0.515411,0.567916,0.605478,0.634828,0.698095,0.675277,0.656899:-0.237559,-0.199828,-0.200594,-0.22898,-0.26665,-0.268721,-0.261888,-0.212763,-0.130807,-0.143589,-0.163446,-0.212316:-0.245872,-0.240522,-0.228606,-0.231865,-0.233691,-0.298427,-0.317933,-0.336366,-0.385025,-0.350201,-0.335985,-0.351551:0.2738,0.246934,0.224133,0.190846,0.149307,0.132805,0.102329,0.050364,0.057897,0.086395,0.068306,0.030056:-0.097623,-0.154197,-0.180115,-0.207579,-0.252798,-0.319616,-0.341351,-0.336139,-0.321662,-0.345564,-0.368669,-0.345599:-0.275511,-0.289446,-0.293701,-0.279112,-0.233696,-0.212373,-0.203219,-0.187918,-0.200591,-0.172576,-0.157679,-0.155009:-0.13884,-0.13673,-0.1425,-0.138213,-0.111007,-0.053317,-0.03861,-0.016421,0.029017,0.014511,0.032074,0.03193:0.040508,0.0518,0.063277,0.093146,0.109842,0.123025,0.127978,0.108834,0.038902,-0.012495,-0.056958,-0.104449:9
1.351919,1.211996,1.23899,1.203733,1.124518,1.091187,1.115005,1.196323,1.157351,1.122444,1.142476,1.050068,1.014646,0.94088,0.905885,0.847245,0.793586,0.750286:-0.145138,-0.073908,-0.136182,-0.165131,-0.142754,-0.171044,-0.221256,-0.292288,-0.303731,-0.371393,-0.411805,-0.333097,-0.392912,-0.506223,-0.531691,-0.49366,-0.522125,-0.540083:0.425393,0.336923,0.326814,0.27507,0.207592,0.165382,0.156043,0.184335,0.214403,0.212885,0.211586,0.143191,0.179272,0.245315,0.304278,0.337473,0.392067,0.427239:-0.564916,-0.4712,-0.520204,-0.564045,-0.476599,-0.423746,-0.425007,-0.462164,-0.453198,-0.370796,-0.350335,-0.309172,-0.327752,-0.290442,-0.231707,-0.225561,-0.166754,-0.100187:0.056491,0.045078,0.087727,0.172973,0.23635,0.290849,0.366776,0.478451,0.592281,0.668566,0.702668,0.791983,0.885629,0.857909,0.776899,0.799262,0.798954,0.804399:-0.459256,-0.467376,-0.440835,-0.401502,-0.339934,-0.237037,-0.198066,-0.191279,-0.177869,-0.148143,-0.094374,-0.069869,-0.034754,0.010813,0.013891,-0.017611,-0.109186,-0.136493:0.07661,0.117709,0.109357,0.1091,0.085282,0.041872,0.011149,-0.036831,-0.124515,-0.192167,-0.227548,-0.221871,-0.279324,-0.329665,-0.28182,-0.267123,-0.221798,-0.231038:0.390227,0.364896,0.358628,0.361379,0.324061,0.294505,0.293,0.279872,0.212861,0.174586,0.141352,0.046992,0.040283,0.043829,-0.003672,-0.012968,0.050852,0.084399:-0.2005,-0.160598,-0.120861,-0.124149,-0.111368,-0.137394,-0.201589,-0.26173,-0.260873,-0.257561,-0.253539,-0.220122,-0.239328,-0.254982,-0.259268,-0.26226,-0.284106,-0.259707:-0.121468,-0.117916,-0.182471,-0.257651,-0.297707,-0.345051,-0.334623,-0.297104,-0.245821,-0.246474,-0.24478,-0.190369,-0.122707,-0.109084,-0.081408,-0.07048,-0.093482,-0.106721:-0.10986,-0.161278,-0.195188,-0.176978,-0.123059,-0.108307,-0.132503,-0.153908,-0.13772,-0.132394,-0.098087,-0.112156,-0.108188,-0.073994,-0.044581,-0.025359,0.001083,0.012062:0.083229,0.077842,0.109788,0.120744,0.096714,0.096566,0.086738,0.094542,0.094274,0.103967,0.087075,0.05915,-0.008795,-0.07143,-0.068996,-0.054551,-0.014831,-0.013168:9
0.953358,1.093853,1.154309,1.194096,1.268006,1.162535,1.118132,1.028928,1.140953,1.117714,1.014621,0.913928,0.865614,0.835219,0.814215,0.79325:-0.446245,-0.518024,-0.513065,-0.529371,-0.566039,-0.521039,-0.545942,-0.568644,-0.697197,-0.736318,-0.719243,-0.738495,-0.743942,-0.726484,-0.729954,-0.874413:0.459929,0.450865,0.332981,0.311255,0.333958,0.304094,0.319657,0.300276,0.364467,0.415191,0.415169,0.412372,0.428772,0.426909,0.471977,0.563084:-0.569333,-0.68329,-0.726098,-0.680967,-0.687776,-0.661845,-0.619896,-0.504479,-0.488598,-0.474426,-0.453909,-0.3592,-0.284077,-0.247142,-0.193769,-0.184301:-0.220519,-0.168546,-0.028595,0.030609,0.087053,0.178174,0.235226,0.274185,0.335965,0.408422,0.500152,0.543383,0.565324,0.598044,0.600424,0.58367:-0.211154,-0.243156,-0.23231,-0.270002,-0.275692,-0.248037,-0.217142,-0.21277,-0.161506,-0.101673,-0.127252,-0.164632,-0.1798,-0.159719,-0.12357,-0.060751:-0.108664,-0.109433,-0.12481,-0.106803,-0.116632,-0.125364,-0.147662,-0.167075,-0.259385,-0.306103,-0.297366,-0.273388,-0.26109,-0.274068,-0.3478,-0.434994:0.294335,0.288666,0.235845,0.228671,0.189448,0.178305,0.171912,0.122434,0.128164,0.130673,0.126654,0.095449,0.049797,-1.37E-4,-0.010445,0.038825:-0.080618,-0.119684,-0.1617,-0.208733,-0.25031,-0.294803,-0.289395,-0.259282,-0.260554,-0.279881,-0.317185,-0.30977,-0.278142,-0.256793,-0.221795,-0.241738:-0.189687,-0.219711,-0.203466,-0.220622,-0.209999,-0.180046,-0.170713,-0.161837,-0.166416,-0.167424,-0.145413,-0.124158,-0.125243,-0.139673,-0.165513,-0.189462:-0.033341,-0.026292,-0.075747,-0.056044,-0.049247,0.002854,0.023772,0.063083,0.129122,0.145237,0.126612,0.083864,0.036509,0.024752,0.052037,0.096147:0.116798,0.139545,0.153869,0.216091,0.290512,0.276219,0.295393,0.323573,0.298565,0.245687,0.216312,0.190041,0.179515,0.167078,0.100308,0.006151:9
0.932481,1.121348,1.098107,1.137305,1.171495,1.195075,1.041436,1.058463,1.040578,0.912406,0.81449,0.856626,0.87395,0.74919,0.761477,0.701181,0.602545:-0.256086,-0.444346,-0.575411,-0.562502,-0.594754,-0.599895,-0.496256,-0.516823,-0.525397,-0.453528,-0.436392,-0.537993,-0.615679,-0.572618,-0.607153,-0.667726,-0.662427:0.481226,0.43328,0.208423,0.149318,0.216925,0.342887,0.392122,0.381711,0.368493,0.364357,0.433956,0.57939,0.654481,0.670008,0.768879,0.838964,0.785469:-0.655272,-0.571379,-0.614029,-0.634079,-0.527039,-0.463751,-0.349454,-0.332044,-0.298174,-0.25982,-0.22631,-0.194862,-0.18892,-0.139972,-0.102554,-0.072641,-0.013567:0.423638,0.51774,0.526642,0.587989,0.624216,0.649562,0.722853,0.789828,0.806916,0.764058,0.750841,0.71823,0.743611,0.774495,0.767606,0.726654,0.722495:-0.106282,-0.173175,-0.15889,-0.161274,-0.09452,-0.087006,-0.149428,-0.094009,-0.0469,-0.013578,0.001636,-0.044848,-0.092943,-0.113274,-0.117202,-0.108832,-0.105212:-0.228327,-0.316754,-0.327089,-0.338976,-0.316095,-0.305662,-0.306437,-0.372533,-0.387651,-0.338035,-0.368304,-0.383288,-0.428411,-0.421374,-0.428625,-0.407138,-0.364174:0.308493,0.276021,0.176306,0.171505,0.181929,0.211161,0.137619,0.042589,-0.030509,-0.073254,-0.022863,0.0547,0.115288,0.112243,0.13595,0.158788,0.148279:-0.243267,-0.293804,-0.335909,-0.345995,-0.249931,-0.265431,-0.271087,-0.220913,-0.168718,-0.177785,-0.225126,-0.28773,-0.314484,-0.301508,-0.283611,-0.256683,-0.224196:-0.228452,-0.227987,-0.184431,-0.15895,-0.155297,-0.169726,-0.127297,-0.10704,-0.109187,-0.141697,-0.170334,-0.176227,-0.145717,-0.11316,-0.099542,-0.092597,-0.070455:0.050462,0.098665,0.107066,0.07514,0.061187,0.075047,0.039286,0.010624,-0.009409,0.027448,0.043045,0.073853,0.101013,0.093894,0.103362,0.125103,0.115998:0.16027,0.20751,0.13723,0.111364,0.123121,0.108096,0.107559,0.118699,0.111265,0.087341,0.026232,-0.014719,-0.082053,-0.108889,-0.119152,-0.124462,-0.132671:9
1.360049,1.193549,1.121924,1.214353,1.287918,1.247012,1.170507,1.182487,1.21956,1.145795,1.077508,1.028302,0.916385,0.865313,0.858949,0.771695,0.735955,0.76111,0.757553:-0.333796,-0.291652,-0.261265,-0.303135,-0.381129,-0.376963,-0.398494,-0.561464,-0.759047,-0.574552,-0.493672,-0.480219,-0.439182,-0.45038,-0.513423,-0.510691,-0.466345,-0.503261,-0.513971:0.34591,0.223498,0.174386,0.18237,0.163981,0.159828,0.147599,0.078303,0.091391,0.163831,0.188671,0.195896,0.164803,0.179114,0.206401,0.270448,0.283471,0.296265,0.321265:-0.513179,-0.533996,-0.51525,-0.409631,-0.366735,-0.304912,-0.259578,-0.093102,-0.004279,-0.167225,-0.162907,-0.115962,-0.074732,-0.033632,0.057111,0.091734,0.133033,0.171441,0.182105:-0.168803,-0.135504,-0.088227,-0.015393,-0.01977,0.063112,0.15027,0.212636,0.370155,0.475671,0.545485,0.584217,0.596416,0.607391,0.623417,0.672823,0.6981,0.706844,0.712926:-0.531354,-0.518319,-0.519687,-0.516464,-0.502597,-0.463688,-0.365209,-0.292587,-0.201793,-0.206038,-0.202806,-0.20223,-0.201425,-0.224099,-0.264604,-0.333382,-0.361768,-0.363188,-0.351705:0.215695,0.294626,0.300052,0.221975,0.212388,0.250776,0.239478,0.238169,0.216602,0.130467,0.025038,-0.013051,3.37E-4,-0.009708,-0.033292,-0.094562,-0.125154,-0.137479,-0.147433:0.254447,0.191632,0.187204,0.173711,0.165994,0.104971,0.062196,0.00318,0.02757,0.053987,0.057905,-0.012826,-0.085853,-0.113564,-0.131567,-0.092993,-0.07721,-0.092691,-0.092575:-0.215306,-0.232802,-0.272487,-0.238979,-0.226447,-0.248165,-0.244858,-0.210938,-0.290578,-0.379281,-0.3745,-0.32895,-0.325513,-0.313442,-0.287761,-0.261896,-0.261257,-0.243814,-0.237379:0.029565,-0.023611,-0.048,-0.07108,-0.12647,-0.11801,-0.151814,-0.187169,-0.161612,-0.152799,-0.14521,-0.099526,-0.033703,-0.005751,-0.0023,-0.013428,-0.019014,-0.004579,0.001342:-0.118957,-0.11641,-0.112537,-0.120333,-0.11663,-0.109137,-0.12549,-0.158626,-0.127462,-0.077965,-0.073344,-0.116929,-0.129851,-0.123109,-0.129458,-0.145141,-0.121809,-0.116201,-0.10889:0.111127,0.196275,0.209043,0.233766,0.257849,0.305657,0.307111,0.288952,0.254236,0.267921,0.218098,0.189688,0.130826,0.08926,0.08172,0.073359,0.05379,0.042803,0.032542:9
1.116844,1.075146,1.015672,0.973413,1.139214,1.213444,1.231574,1.263185,1.28849,1.332386,1.17991,0.65237,0.779671,1.142616,1.176629,1.254612,1.128939,1.136731,1.095923,1.028777:-0.46359,-0.460754,-0.337767,-0.128555,-0.16771,-0.401749,-0.487669,-0.561436,-0.597491,-0.666906,-0.66363,-0.555295,-0.620103,-0.608001,-0.55929,-0.639301,-0.675271,-0.692273,-0.567022,-0.501572:0.390486,0.445836,0.397159,0.214329,0.084424,0.097726,0.278439,0.328668,0.317076,0.40072,0.494088,0.635945,0.638467,0.377129,0.287984,0.397972,0.401065,0.439761,0.374393,0.288582:-0.705219,-0.706261,-0.647885,-0.552113,-0.49075,-0.497334,-0.548891,-0.534637,-0.479158,-0.47035,-0.491491,-0.425307,-0.410531,-0.21874,-0.09409,-0.138194,-0.071655,-0.046121,0.022291,0.135606:-0.202995,-0.129683,-0.060681,-0.044219,0.126352,0.304582,0.248866,0.238168,0.279086,0.34725,0.453872,0.577627,0.579952,0.478792,0.457182,0.518108,0.512291,0.53302,0.546195,0.524853:-0.219175,-0.170271,-0.117331,-0.058942,-0.105499,-0.191283,-0.160286,-0.056349,0.016353,0.007919,-0.0295,-0.005509,0.014658,2.67E-4,0.016906,0.005337,0.023758,0.020992,-0.023589,-0.058533:-0.036525,-0.093547,-0.092962,-0.083748,-0.089903,-0.120235,-0.170073,-0.207182,-0.284453,-0.360092,-0.413017,-0.456892,-0.481666,-0.40277,-0.39634,-0.419117,-0.385259,-0.371924,-0.362544,-0.381209:0.241032,0.194996,0.173354,0.145247,0.107659,0.137945,0.168518,0.156778,0.104485,0.122157,0.160251,0.191189,0.165734,0.014801,0.004138,0.034966,0.007715,0.00253,0.007687,0.03434:-0.049976,-0.058301,-0.053706,-0.018968,-0.073158,-0.185626,-0.208796,-0.161444,-0.143739,-0.193729,-0.243664,-0.265854,-0.231596,-0.167534,-0.178684,-0.184697,-0.193769,-0.22588,-0.262147,-0.256727:-0.22074,-0.226628,-0.227717,-0.20882,-0.193773,-0.251259,-0.293708,-0.29969,-0.285646,-0.26081,-0.249029,-0.258238,-0.229429,-0.221555,-0.217705,-0.244537,-0.222887,-0.193413,-0.171202,-0.177156:-0.011838,-0.021938,0.019164,0.084765,0.085227,0.016233,0.077945,0.063539,0.082895,0.136049,0.158464,0.166081,0.173749,0.130418,0.143629,0.146165,0.157236,0.163723,0.158935,0.128371:0.213277,0.277151,0.287229,0.238286,0.216843,0.242972,0.309092,0.271408,0.204624,0.143023,0.123628,0.100276,0.081551,0.106966,0.039569,0.037456,0.015094,-0.019058,-0.069349,-0.100418:9
0.92234,1.302186,1.157811,1.189573,1.441499,1.536322,1.594585,1.385877,1.288213,1.380437,1.279017,1.074424,0.97037,0.902232,0.893902,0.814886,0.758722,0.721473,0.678587:-0.485152,-0.582834,-0.727007,-0.655036,-0.442846,-0.425718,-0.482232,-0.371525,-0.377205,-0.513823,-0.531905,-0.486903,-0.505375,-0.561518,-0.534961,-0.458718,-0.44195,-0.493274,-0.469397:0.597222,0.282478,0.188757,0.297869,0.252963,0.261294,0.216134,0.16791,0.178534,0.184436,0.205622,0.178647,0.20836,0.220599,0.237067,0.26598,0.36096,0.425455,0.410154:-0.681081,-0.694594,-0.812439,-0.809162,-0.552541,-0.54469,-0.421099,-0.462227,-0.472781,-0.433493,-0.397606,-0.264054,-0.17297,-0.159758,-0.099498,-0.030693,-0.039992,0.026281,0.042657:0.233261,0.110932,0.068261,0.06373,0.140269,0.142804,0.166136,0.361087,0.485072,0.477394,0.586806,0.618446,0.648733,0.718316,0.70191,0.675064,0.713184,0.694573,0.729432:-0.147616,-0.213049,-0.325229,-0.308949,-0.258908,-0.290806,-0.255352,-0.250972,-0.229323,-0.143198,-0.098556,-0.150433,-0.173814,-0.175891,-0.20486,-0.216897,-0.228331,-0.199734,-0.190065:0.009404,-0.008049,-0.098463,-0.107403,-0.052233,-0.095524,-0.096908,-0.065372,-0.102518,-0.088615,-0.152192,-0.135212,-0.107963,-0.06314,-0.058189,-0.094621,-0.194772,-0.266302,-0.235894:0.52233,0.439702,0.372325,0.384147,0.316629,0.226026,0.245479,0.229394,0.207488,0.190712,0.142098,0.105338,0.067825,0.07265,0.048893,0.03137,0.085479,0.124142,0.10271:-0.278655,-0.245666,-0.353127,-0.37918,-0.315803,-0.321911,-0.322967,-0.344131,-0.353053,-0.342323,-0.324513,-0.34233,-0.340189,-0.327876,-0.344777,-0.342824,-0.307527,-0.262656,-0.292728:-0.188337,-0.215614,-0.224515,-0.26871,-0.201672,-0.172449,-0.198053,-0.151922,-0.089983,-0.058105,-0.036057,-0.032269,-0.030101,-0.015751,-0.004622,-0.0287,-0.046411,-0.086931,-0.081286:0.12287,0.033103,0.077136,0.078706,0.02881,0.01377,0.059342,0.026469,0.069648,0.090467,0.074801,0.108687,0.071269,-0.005603,0.029013,0.06754,0.111927,0.105926,0.097212:0.012677,0.030257,0.078771,0.1047,0.108892,0.179885,0.171945,0.198994,0.182437,0.152152,0.129538,0.107962,0.099043,0.129884,0.113978,0.065649,-0.018735,-0.058287,-0.045699:9
1.178797,1.352982,1.651055,1.423576,1.288027,1.210456,1.168144,0.961522,1.030345,0.999842,1.05012,1.054068,0.961292,0.981207,0.960457,0.96946,0.925437,0.926847:-0.83148,-0.793818,-0.740347,-0.607697,-0.565575,-0.524537,-0.49056,-0.437986,-0.551296,-0.596334,-0.641699,-0.636665,-0.588769,-0.686009,-0.737683,-0.798192,-0.824371,-0.843604:0.224028,0.102803,0.066389,0.175411,0.331089,0.297647,0.283475,0.112869,0.133252,0.119236,0.079826,0.123521,0.155717,0.236512,0.34073,0.405109,0.442936,0.501933:-0.450231,-0.39798,-0.471734,-0.574374,-0.608892,-0.586157,-0.602354,-0.420803,-0.368153,-0.296368,-0.155451,-0.09125,-0.058022,-0.082444,-0.084088,-0.141517,-0.10899,-0.113852:-0.198879,0.007429,-0.004257,0.037767,0.148409,0.232597,0.353026,0.437753,0.514251,0.562492,0.565344,0.567654,0.562396,0.564203,0.572813,0.627944,0.631384,0.649109:-0.370094,-0.33157,-0.365653,-0.295523,-0.268327,-0.281031,-0.27982,-0.286171,-0.268143,-0.219139,-0.218226,-0.207176,-0.143286,-0.051261,-0.063027,-0.075425,-0.087459,-0.098802:0.133085,0.200597,0.06083,-0.063769,-0.137883,-0.151049,-0.166456,-0.151498,-0.179247,-0.141511,-0.097878,-0.144281,-0.248817,-0.312282,-0.307141,-0.33965,-0.358145,-0.381253:0.29219,0.270454,0.248955,0.243337,0.26515,0.269674,0.230988,0.123411,0.095986,0.06133,-0.009154,-0.062051,-0.067003,-0.006217,0.048242,0.080208,0.074734,0.08782:-0.218161,-0.275667,-0.323339,-0.305447,-0.314505,-0.32834,-0.377381,-0.313501,-0.312595,-0.345725,-0.340994,-0.267484,-0.198829,-0.248555,-0.290989,-0.285187,-0.270562,-0.268138:-0.132742,-0.134966,-0.134002,-0.205913,-0.224229,-0.221776,-0.177107,-0.08959,-0.060859,-0.073576,-0.037993,-0.053007,-0.122551,-0.14986,-0.147518,-0.12585,-0.117813,-0.128246:-0.036303,-0.09924,-0.030939,0.025871,0.069953,0.073168,0.094199,0.047887,0.025745,2.67E-4,-0.023161,-0.033984,0.032578,0.099678,0.122461,0.091138,0.069451,0.054247:0.085905,0.12081,0.120278,0.132516,0.166666,0.18565,0.186965,0.147014,0.152415,0.16259,0.14605,0.14003,0.077303,-0.005963,-0.043225,-0.082547,-0.106733,-0.110341:9
1.300204,1.380797,1.327612,1.142247,1.126103,1.246184,1.197696,1.107817,1.109982,1.108196,1.05606:-0.182885,-0.199065,-0.266916,-0.315016,-0.328529,-0.464771,-0.412463,-0.404278,-0.435846,-0.486171,-0.53025:-0.157908,-0.096308,-0.004169,0.054592,0.121342,0.113782,0.075204,0.238323,0.33428,0.422159,0.454581:-0.437236,-0.377266,-0.322372,-0.294789,-0.231798,-0.182803,-0.070969,-0.104882,-0.097292,-0.045404,-0.040688:0.175893,0.227093,0.337666,0.392048,0.451821,0.499953,0.472042,0.604067,0.674291,0.629637,0.631103:-0.031722,-0.035009,-0.081852,-0.065754,-0.098847,-0.149609,-0.096493,-0.177833,-0.275183,-0.263811,-0.241662:-0.091669,-0.122114,-0.203239,-0.221198,-0.205536,-0.152748,-0.208114,-0.24344,-0.291312,-0.277515,-0.232737:0.210465,0.196019,0.126205,0.125159,0.124331,0.138725,0.110386,0.061465,0.079572,0.102154,0.123975:-0.154168,-0.182817,-0.164801,-0.173702,-0.186437,-0.260667,-0.279353,-0.340242,-0.305562,-0.308552,-0.305716:-0.176714,-0.179352,-0.188857,-0.249386,-0.248588,-0.167429,-0.222425,-0.173194,-0.099118,-0.080051,-0.028306:-0.012035,0.038617,0.11456,0.135684,0.0931,0.034613,0.093996,0.071644,0.032733,0.073321,0.065743:0.028065,0.067273,0.111766,0.114224,0.110119,0.069756,0.056045,0.068232,0.042718,1.72E-4,-0.042512:9
1.223883,1.283677,1.250701,1.198905,1.358207,1.32472,1.131971,1.000248,1.082847,1.158676,1.142504:-0.009453,-0.153325,-0.178172,-0.161898,-0.320064,-0.376524,-0.339814,-0.260297,-0.477288,-0.682392,-0.766468:0.208324,0.343966,0.397305,0.299538,0.33337,0.324966,0.278418,0.307625,0.312736,0.287635,0.238181:-0.613524,-0.704759,-0.760744,-0.621687,-0.580651,-0.507292,-0.475434,-0.624695,-0.579934,-0.305141,-0.134786:-0.255591,-0.199868,-0.155447,-0.168366,-0.164989,-0.115562,-0.035541,0.170655,0.2266,0.215313,0.2548:-0.308534,-0.340737,-0.322199,-0.303105,-0.247798,-0.208215,-0.186304,-0.223197,-0.185527,-0.233966,-0.220982:-0.023035,-0.018683,-0.025587,0.016391,-0.013825,-0.062306,-0.098327,-0.162822,-0.303752,-0.293302,-0.217351:0.340744,0.345364,0.322076,0.315434,0.28887,0.234495,0.170102,0.123034,0.014484,-0.013335,0.030438:-0.123554,-0.184665,-0.221868,-0.22783,-0.278871,-0.333022,-0.351067,-0.378502,-0.342479,-0.32351,-0.350192:-0.122592,-0.096903,-0.111083,-0.193614,-0.228208,-0.235851,-0.264441,-0.223651,-0.128049,-0.100222,-0.093483:0.125455,0.111356,0.107869,0.142773,0.150155,0.167482,0.158826,0.142786,0.168868,0.204967,0.223296:-0.011096,-0.002061,0.024247,0.077138,0.07383,0.066806,0.115226,0.158485,0.139583,0.152827,0.147749:9
0.943159,0.975342,0.905522,1.062315,1.189163,1.23735,1.347424,1.349897,1.317679,1.303817,1.253263,1.213793,1.134342,1.185405,1.119127,1.088438,1.129362:0.164446,0.171045,0.183672,0.125336,0.04155,-0.059774,-0.300622,-0.278775,-0.302648,-0.413221,-0.437027,-0.482929,-0.550409,-0.644743,-0.651891,-0.653191,-0.71924:-0.042333,-0.102942,-0.187352,-0.185379,-0.207602,-0.358093,-0.395117,-0.236356,-0.067781,0.013114,-0.017615,-0.027125,0.037554,0.115704,0.209859,0.304155,0.429313:-0.375563,-0.320709,-0.253376,-0.296777,-0.28121,-0.236511,-0.188675,-0.229917,-0.247891,-0.22642,-0.1361,-0.006944,0.128745,0.159844,0.192748,0.156122,0.126867:-0.442051,-0.416315,-0.374448,-0.352153,-0.365215,-0.240825,-0.117887,-0.003593,0.155362,0.283273,0.310278,0.354926,0.42085,0.485171,0.513116,0.608358,0.612919:-0.303902,-0.299008,-0.264387,-0.250735,-0.270972,-0.261975,-0.247235,-0.261463,-0.24973,-0.232867,-0.139623,-0.108798,-0.104343,-0.087463,-0.057619,-0.11769,-0.125055:0.09991,0.107369,0.057244,0.037753,0.06281,0.066239,0.023343,-0.005795,-0.06888,-0.090161,-0.174867,-0.209365,-0.221714,-0.259725,-0.281972,-0.289105,-0.290003:0.156612,0.132643,0.105731,0.115838,0.066359,0.046265,0.038245,0.122251,0.153421,0.140468,0.100655,0.038451,0.035477,0.045772,-0.00121,0.002535,-0.007936:0.151195,0.098308,0.072452,0.059574,0.046992,-0.029817,-0.146962,-0.263298,-0.368397,-0.403841,-0.383704,-0.348507,-0.377087,-0.377388,-0.308792,-0.313465,-0.344466:-0.326582,-0.378278,-0.438488,-0.443281,-0.424901,-0.377255,-0.314601,-0.289546,-0.209875,-0.181338,-0.193094,-0.161288,-0.125468,-0.110515,-0.120067,-0.070742,-0.014446:0.096813,0.138879,0.160775,0.101233,0.044058,0.014574,0.024562,0.035275,0.074166,0.079612,0.144414,0.141833,0.116421,0.143175,0.131171,0.083545,0.074454:-0.014301,0.008112,0.035219,0.068271,0.100667,0.122339,0.220949,0.22345,0.190288,0.196093,0.150749,0.118463,0.068253,-0.02217,-0.049591,-0.113131,-0.183168:9
1.332328,1.329309,1.515304,1.663047,1.685345,1.748417,1.561099,1.634359,1.481201,1.747003,1.686534,1.632855,1.443639,1.172815,1.415888:-1.050097,-0.997482,-1.092778,-1.190203,-1.237647,-1.291924,-1.22175,-1.34548,-1.226199,-1.40599,-1.438798,-1.466623,-1.4479,-1.292435,-1.500278:0.549785,0.325953,0.202756,0.218664,0.230542,0.198168,0.135995,0.185376,0.071236,0.156307,0.244818,0.208753,0.24889,0.206878,0.329861:-0.342061,-0.195717,-0.208863,-0.254386,-0.273929,-0.23969,-0.222679,-0.214493,-0.124254,-0.158193,-0.151413,-0.017872,0.105728,0.171315,0.157405:-0.484968,-0.420278,-0.331256,-0.294691,-0.263508,-0.159464,-0.068659,-0.04972,0.034165,0.040292,0.001218,0.161844,0.293471,0.362267,0.327745:-0.381418,-0.354974,-0.451486,-0.435415,-0.370236,-0.354699,-0.335785,-0.331515,-0.344189,-0.245569,-0.111623,-0.201331,-0.272401,-0.247485,-0.212451:-0.109677,-0.097111,-0.177155,-0.131439,-0.071461,-0.05464,-0.049667,-0.05798,-0.103907,-0.102061,-0.034211,-0.070087,-0.108627,-0.084531,-0.025568:0.351425,0.405371,0.3932,0.389145,0.371956,0.387145,0.337863,0.301195,0.263462,0.157079,0.057941,0.038924,0.009458,-0.031717,-0.02785:-0.109187,-0.127993,-0.120583,-0.18997,-0.241335,-0.300876,-0.325957,-0.375897,-0.354131,-0.382113,-0.381913,-0.442528,-0.467304,-0.465876,-0.522905:-0.176345,-0.318733,-0.311043,-0.316284,-0.327311,-0.35232,-0.31584,-0.295177,-0.303561,-0.250345,-0.219327,-0.15104,-0.066474,-0.068783,-0.02259:0.200925,0.123482,0.13384,0.129561,0.10178,0.095567,0.070242,0.078419,0.096469,0.108294,0.088909,0.084024,0.085615,0.103292,0.058461:0.004956,0.04341,0.064588,0.049832,0.026328,0.03705,0.067625,0.06999,0.155223,0.150635,0.143069,0.058811,0.003994,0.006269,-0.080103:9
1.364243,1.389271,1.393887,1.409455,1.394051,1.270776,1.18588,1.123678,1.042282,0.99592,1.046211,1.025261:-0.520069,-0.564711,-0.528977,-0.635256,-0.605013,-0.569862,-0.575742,-0.564076,-0.537105,-0.504505,-0.585837,-0.667605:0.199806,0.147958,0.127883,0.129638,-0.014421,-0.010838,-0.012937,-0.059465,-0.074124,-0.008789,0.060993,-0.033926:-0.536857,-0.588051,-0.489166,-0.377416,-0.400972,-0.396727,-0.311641,-0.250611,-0.213979,-0.184709,-0.123399,-9.7E-5:-0.138645,0.014295,0.085687,0.055659,0.186477,0.267738,0.296575,0.317889,0.352959,0.413226,0.470472,0.53498:-0.447451,-0.481044,-0.523593,-0.498995,-0.481353,-0.446751,-0.427234,-0.431748,-0.426159,-0.433197,-0.389791,-0.382865:-0.075632,-0.120485,-0.102568,-0.040127,-0.040721,-0.051986,-0.037218,-0.034923,-0.032083,-0.078339,-0.134188,-0.217068:0.176785,0.20003,0.214502,0.208913,0.123658,0.058128,0.032275,0.002031,-0.035647,-0.076596,-0.152255,-0.146265:-0.058769,-0.118694,-0.188357,-0.208439,-0.285102,-0.317534,-0.331798,-0.325214,-0.328887,-0.302395,-0.289367,-0.290388:-0.132256,-0.156013,-0.116075,-0.081036,-0.112433,-0.140164,-0.135244,-0.124984,-0.114527,-0.086559,-0.028066,0.008427:-0.253324,-0.269086,-0.238915,-0.204135,-0.193153,-0.180332,-0.190055,-0.176114,-0.138305,-0.113157,-0.087698,-0.054944:0.126954,0.187283,0.18763,0.156731,0.237377,0.312932,0.296883,0.283123,0.29693,0.282259,0.242413,0.140444:9
1.273194,1.313036,1.049557,0.833233,0.917678,1.072311,1.132787,1.037041,0.887646,0.897139,0.99056,1.11724,0.907775,0.849441,0.802779:0.019244,-0.114949,0.051206,-0.144754,-0.357236,-0.521645,-0.66748,-0.713064,-0.645642,-0.651444,-0.767196,-0.977255,-0.898284,-0.766378,-0.74127:-0.36281,-0.38216,-0.297088,-0.241934,-0.138433,-0.025129,0.074214,0.083219,-0.004816,-0.017015,0.121521,0.258536,0.242474,0.230647,0.335187:-0.058983,0.005904,-0.080344,-0.15746,-0.192072,-0.138999,-0.120136,-0.047013,0.107963,0.189358,0.19739,0.18741,0.280235,0.378199,0.352699:-0.427427,-0.403771,-0.259308,-0.019185,0.026335,0.107426,0.20295,0.289595,0.324756,0.395755,0.467276,0.531612,0.491378,0.378219,0.474859:-0.403192,-0.41774,-0.2811,-0.205873,-0.21086,-0.240782,-0.185826,-0.1389,-0.100454,-0.137602,-0.191602,-0.232307,-0.183172,-0.106574,-0.200882:0.122758,0.071353,0.0322,-0.06626,-0.174753,-0.212719,-0.218775,-0.197875,-0.184854,-0.179175,-0.178694,-0.242212,-0.202313,-0.148178,-0.157552:0.010503,-0.017703,0.057521,0.076722,0.122644,0.121045,0.085683,0.037621,-0.004477,-0.044986,-0.067745,-0.00321,0.019758,-0.182625,-0.267475:0.103788,0.011245,-0.047815,-0.155901,-0.268475,-0.303468,-0.310339,-0.318105,-0.320077,-0.331089,-0.352132,-0.300747,-0.231395,-0.173458,-0.112763:-0.437024,-0.355393,-0.42829,-0.384199,-0.315405,-0.235034,-0.196189,-0.166502,-0.148243,-0.104444,-0.028245,-0.021783,-0.042814,-0.081219,-0.046893:0.017278,0.057509,0.08169,0.069538,0.041688,0.054438,0.067725,0.054808,0.01719,-0.00759,0.028855,7.5E-5,0.007503,-0.061611,-0.169976:0.043198,0.112447,0.131263,0.137505,0.165907,0.152839,0.146065,0.118665,0.081352,0.052625,0.006943,-0.050669,-0.05213,-0.039248,-0.029654:9
1.370764,1.481337,1.538156,1.453891,1.468141,1.40161,1.231348,1.274425,1.296387,1.251047,1.223703,0.983092,0.850433,0.686003:-0.437526,-0.523677,-0.412191,-0.312838,-0.323636,-0.31461,-0.255885,-0.33121,-0.383754,-0.406402,-0.477927,-0.332744,-0.294479,-0.351796:0.44215,0.367409,0.268218,0.12433,0.107684,0.095384,0.046596,0.03634,0.010491,0.050231,0.169588,0.072842,0.032153,0.165926:-0.782441,-0.782326,-0.71564,-0.574383,-0.559,-0.494617,-0.353049,-0.272067,-0.17996,-0.078063,-0.070194,0.065956,0.240225,0.140062:-0.004708,0.134004,0.244854,0.294822,0.463421,0.53263,0.523675,0.576242,0.642806,0.660976,0.701887,0.691069,0.610279,0.635658:-0.277188,-0.228606,-0.224742,-0.21425,-0.21834,-0.180167,-0.15021,-0.149203,-0.218785,-0.24526,-0.211065,-0.213176,-0.271892,-0.270417:-0.280738,-0.274081,-0.239041,-0.226879,-0.24775,-0.195407,-0.117831,-0.192204,-0.214404,-0.222511,-0.267591,-0.182771,-0.14383,-0.202226:0.409038,0.375637,0.335449,0.216578,0.13349,0.05883,-0.004043,0.003171,-0.012577,-0.036759,-0.023832,-0.070968,-0.060445,-0.013927:-0.014378,-0.081746,-0.12434,-0.130894,-0.155449,-0.158909,-0.144482,-0.14198,-0.208187,-0.249042,-0.220429,-0.206823,-0.182791,-0.205702:-0.230881,-0.223778,-0.230961,-0.202461,-0.121843,-0.109485,-0.190863,-0.189642,-0.108117,-0.072885,-0.029646,-0.031974,-0.065427,-0.129162:-0.015744,-0.064656,-0.075658,-0.024274,-0.065598,-0.10955,-0.093565,-0.072794,-0.084869,-0.08022,-0.046312,-0.013489,-0.009716,0.049983:0.104866,0.104888,0.125381,0.143334,0.192931,0.231457,0.24419,0.173815,0.132577,0.11266,0.05886,0.038331,-8.3E-5,-0.058616:9
1.374932,1.329109,1.487053,1.552205,1.4551,1.409612,1.325487,1.227418,1.247751,1.195401,1.085625,1.053487,0.947609,0.944708:-0.41603,-0.422088,-0.464435,-0.49687,-0.575683,-0.634165,-0.569677,-0.566301,-0.654176,-0.662701,-0.649206,-0.668148,-0.661736,-0.737844:-0.060932,0.024539,0.161298,0.261216,0.202991,0.23369,0.235144,0.243157,0.318839,0.347671,0.36181,0.40681,0.420027,0.546794:-0.615616,-0.58648,-0.500446,-0.53067,-0.465586,-0.49517,-0.474655,-0.440884,-0.383511,-0.292442,-0.169993,-0.1433,-0.095965,-0.04701:0.185753,0.188739,0.14302,0.18331,0.235229,0.378657,0.489244,0.594187,0.617754,0.640063,0.691341,0.725355,0.713051,0.710046:-0.344596,-0.358885,-0.30699,-0.155463,-0.097787,-0.100966,-0.056985,-0.016371,-0.020484,-0.044439,-0.103882,-0.086609,-0.049924,-0.050199:-0.03454,-0.007857,0.042852,-0.107522,-0.186703,-0.203609,-0.228526,-0.272591,-0.315263,-0.33901,-0.373029,-0.372984,-0.299442,-0.339961:0.332761,0.351759,0.286415,0.274601,0.289169,0.269931,0.192496,0.194295,0.184978,0.149046,0.088004,0.075712,0.108061,0.125435:-0.218783,-0.25679,-0.225359,-0.150031,-0.122138,-0.179298,-0.187349,-0.169727,-0.218805,-0.198587,-0.170871,-0.204476,-0.223331,-0.190598:-0.158533,-0.169767,-0.10362,-0.241635,-0.295325,-0.233545,-0.192944,-0.205601,-0.169247,-0.15029,-0.073099,-0.048135,-0.089447,-0.060732:-0.09224,-0.082994,-0.093547,0.038227,0.117696,0.099072,0.07106,0.06322,0.104855,0.088206,0.063596,0.069524,0.087478,0.071075:0.047567,0.095157,0.152449,0.250034,0.250222,0.22231,0.199579,0.151946,0.101528,0.085374,0.03688,0.00641,0.002495,-0.059979:9
1.013476,0.900833,0.952955,0.920409,0.862538,0.856119,0.833004,0.797127,0.743725,0.728274,0.704058:-0.420717,-0.365025,-0.412977,-0.409271,-0.408778,-0.458072,-0.515731,-0.424758,-0.355046,-0.38502,-0.422188:0.097832,0.054897,0.058724,0.034912,-0.010572,-0.027519,-0.027726,-0.014615,0.02004,0.066734,0.081821:-0.543552,-0.569979,-0.5405,-0.44584,-0.32506,-0.148745,-0.074366,-0.230534,-0.249043,-0.186768,-0.077105:-0.154299,-0.083379,-0.016999,0.058063,0.077187,0.089037,0.23342,0.30218,0.359096,0.427584,0.478399:-0.382958,-0.329342,-0.391733,-0.382963,-0.385202,-0.441263,-0.472733,-0.44132,-0.426839,-0.417694,-0.423381:0.129152,0.07835,0.169677,0.203626,0.171204,0.080175,0.083924,0.032384,-0.014225,-0.041979,-0.051121:0.222407,0.17417,0.103223,0.062553,0.019954,-0.050835,-0.059755,-0.058173,-0.076987,-0.058914,-0.052332:-0.313657,-0.340051,-0.347971,-0.333206,-0.315342,-0.282542,-0.327752,-0.355668,-0.367855,-0.346063,-0.272795:-0.015547,-0.01705,-0.045446,-0.107832,-0.137951,-0.097473,-0.05305,-0.052449,-0.043049,-0.04582,-0.009787:0.045679,0.055012,0.02801,-0.018486,-0.032837,0.026728,0.010679,0.021645,0.030068,0.033456,0.012747:0.116859,0.128804,0.226491,0.300355,0.308056,0.284502,0.285947,0.278737,0.278522,0.26893,0.202262:9
1.384458,1.363907,1.273663,1.223967,1.187252,1.097613,1.105589,1.11143,1.093771,1.034154,1.087572,1.076086,0.972686:-0.288688,-0.370315,-0.254023,-0.390831,-0.436727,-0.379851,-0.417263,-0.499675,-0.476263,-0.473672,-0.559546,-0.63553,-0.579313:-0.15046,-0.099809,-0.216994,-0.036164,0.040741,0.052859,0.069784,0.060588,0.027924,-0.012606,0.070623,0.196965,0.206329:-0.418112,-0.514172,-0.552048,-0.609804,-0.548032,-0.464317,-0.4081,-0.276506,-0.173987,-0.030177,0.001919,0.02052,-0.017869:0.143884,0.213904,0.337827,0.453402,0.541496,0.592085,0.672362,0.673587,0.738537,0.694968,0.673393,0.675958,0.731179:-0.403292,-0.397052,-0.386845,-0.3561,-0.321994,-0.31133,-0.2959,-0.258114,-0.247884,-0.236034,-0.217523,-0.204514,-0.244688:-0.136719,-0.142737,-0.109084,-0.135125,-0.18963,-0.145503,-0.118164,-0.124391,-0.123166,-0.080654,-0.112712,-0.166214,-0.178733:0.298819,0.292939,0.231317,0.26174,0.227285,0.176896,0.160922,0.08352,0.045355,-0.01656,-0.075371,-0.059112,-0.049949:-0.253343,-0.279944,-0.261256,-0.273981,-0.307973,-0.358599,-0.383463,-0.38978,-0.335366,-0.34272,-0.375983,-0.345414,-0.348094:-0.148312,-0.206584,-0.210223,-0.18517,-0.142984,-0.132075,-0.111372,-0.099242,-0.059621,-0.023341,-7.63E-4,-0.006005,-0.014524:-0.104624,-0.107778,-0.167599,-0.192712,-0.093374,-0.039302,-0.037098,-0.049363,-0.099297,-0.102056,-0.094993,-0.073191,-0.083502:0.080742,0.097002,0.109889,0.099719,0.084554,0.124415,0.151391,0.13841,0.120437,0.098652,0.04536,0.002848,0.011431:9
1.279939,1.263286,1.258261,1.057713,1.066298,1.060474,0.979835,0.922757,0.975869,1.0541,0.914597,0.807583,0.791443,0.520159:-0.265687,-0.290735,-0.210424,-0.15397,-0.243941,-0.322731,-0.321426,-0.335304,-0.384415,-0.511871,-0.406544,-0.310655,-0.370613,-0.288572:-0.143899,-0.092783,-0.157142,-0.251618,-0.244679,-0.098801,-0.070421,-0.039688,0.101048,0.207425,0.117872,0.129969,0.212709,0.225746:-0.415381,-0.344714,-0.342152,-0.252386,-0.216195,-0.136492,0.004186,0.03376,0.053527,0.059756,0.05352,0.085402,0.127773,0.27947:-0.01298,0.02619,0.145375,0.125063,0.170623,0.303445,0.427659,0.445371,0.429889,0.4934,0.622817,0.62246,0.566777,0.542134:-0.489265,-0.444389,-0.406483,-0.419135,-0.403298,-0.3387,-0.386585,-0.328543,-0.254808,-0.21218,-0.21836,-0.223965,-0.191776,-0.223583:0.101716,0.16493,0.199801,0.275175,0.269346,0.142304,0.039276,0.03371,0.045138,-0.029378,-0.104001,-0.021101,0.095761,0.119451:0.424428,0.294896,0.18455,0.171403,0.114735,-0.002627,-0.049456,-0.119606,-0.183937,-0.217926,-0.217688,-0.210708,-0.197538,-0.13424:-0.14853,-0.136064,-0.056858,-0.116255,-0.163614,-0.156702,-0.145762,-0.179058,-0.22577,-0.230368,-0.191742,-0.196107,-0.230467,-0.142676:-0.098986,-0.096251,-0.137606,-0.16854,-0.157533,-0.065803,-0.077266,-0.100788,-0.098246,-0.01183,0.043513,0.039294,0.090659,0.010791:-0.108063,-0.106074,-0.164347,-0.132991,-0.102467,-0.075403,-0.082161,-0.087966,-0.046146,-0.040807,-0.090929,-0.053761,-0.027748,-0.012691:0.107595,0.192456,0.27048,0.283916,0.298091,0.260296,0.300497,0.316544,0.296945,0.256698,0.187884,0.169645,0.132793,0.102708:9
1.247029,1.198277,1.270483,1.263622,1.286305,1.313413,1.338287,1.335883,1.31008,1.16297,0.994924,0.878005:-0.229836,-0.149982,-0.217089,-0.255568,-0.303421,-0.310561,-0.333229,-0.358303,-0.331922,-0.168264,-0.092267,-0.14445:0.126165,0.115173,0.134068,0.195228,0.285245,0.226863,0.137419,0.115997,0.185202,0.181358,0.288186,0.321915:-0.535483,-0.530972,-0.478057,-0.462691,-0.47204,-0.375465,-0.120662,0.037777,-0.003343,0.022105,0.086968,0.314286:0.037365,0.189938,0.252143,0.367943,0.435734,0.509372,0.494506,0.554664,0.684876,0.792962,0.826168,0.747193:-0.361238,-0.411955,-0.351305,-0.26198,-0.236273,-0.202496,-0.193631,-0.197088,-0.169521,-0.206327,-0.236629,-0.259471:-0.030285,-0.023274,-0.045695,-0.090083,-0.031809,-0.102582,-0.136608,-0.140759,-0.170457,-0.205305,-0.243973,-0.156398:0.365013,0.338213,0.311252,0.228502,0.174611,0.102843,0.004293,-0.100675,-0.120809,-0.157404,-0.184108,-0.21913:-0.132939,-0.193294,-0.222976,-0.261384,-0.335368,-0.339496,-0.318978,-0.271731,-0.236225,-0.197274,-0.15727,-0.112465:-0.173249,-0.155113,-0.176852,-0.137866,-0.146162,-0.132259,-0.108355,-0.057303,-0.024979,-0.030964,-0.024983,0.012231:0.052279,0.043705,0.047691,0.054415,0.023393,0.016121,0.065699,0.058873,0.00824,-0.055505,-0.077923,-0.131344:0.138112,0.187506,0.198695,0.175914,0.236504,0.183163,0.149551,0.149924,0.117539,0.034713,-0.056434,-0.075058:9
0.979691,0.94019,0.949603,0.977918,0.974999,0.995147,1.086768,1.215473,1.104906,1.018355,0.987041,1.001091,0.899405,0.845859,1.01256,0.974204,0.87328:-0.17857,-0.271859,-0.371617,-0.517384,-0.402371,-0.33722,-0.371698,-0.527161,-0.542491,-0.542582,-0.589626,-0.645207,-0.437241,-0.377309,-0.525389,-0.497267,-0.406539:-0.056433,0.029131,-0.045105,-0.074389,0.02069,-0.022947,0.018104,0.194608,0.201236,0.224874,0.319023,0.426806,0.215128,0.143297,0.283875,0.34488,0.324438:-0.270237,-0.39447,-0.393299,-0.301865,-0.250374,-0.158138,-0.158159,-0.20604,-0.154775,-0.068051,0.016598,0.06585,0.187686,0.268069,0.310697,0.342763,0.376856:0.049015,0.103224,0.115107,0.251511,0.331845,0.340447,0.418277,0.577772,0.613798,0.599753,0.57944,0.586477,0.541331,0.485681,0.494154,0.554766,0.574683:-0.056673,-0.037706,-0.048926,-0.07868,-0.037002,-0.029344,-0.048727,-0.009251,0.012158,0.004212,-0.033155,-0.058818,-0.08311,-0.085403,-0.057216,-0.081451,-0.075027:-0.204309,-0.174147,-0.151674,-0.153422,-0.217401,-0.289269,-0.336705,-0.341948,-0.323907,-0.312302,-0.293822,-0.29554,-0.256715,-0.291883,-0.401884,-0.418375,-0.426052:0.16016,0.261201,0.225029,0.159796,0.123216,0.059526,0.033856,0.053644,0.027336,0.004713,-0.005117,-0.008655,-0.080011,-0.121937,-0.047173,0.008141,0.057123:0.016548,-0.056662,-0.136738,-0.244974,-0.201379,-0.126341,-0.171625,-0.239223,-0.239944,-0.251843,-0.281463,-0.296475,-0.276405,-0.17811,-0.1992,-0.243202,-0.257264:-0.361856,-0.325792,-0.321021,-0.30108,-0.327719,-0.336898,-0.300238,-0.251534,-0.218273,-0.176937,-0.141034,-0.143247,-0.160263,-0.212101,-0.214095,-0.199131,-0.167469:9.77E-4,-0.028355,0.013924,0.075455,0.069995,0.061896,0.058699,0.06083,0.054533,0.041009,0.017178,0.010466,0.027004,0.006491,0.026308,0.053807,0.061028:0.214794,0.139571,0.106545,0.136571,0.164071,0.171747,0.130263,0.065843,0.026197,-0.023671,-0.068514,-0.082849,-0.067293,-0.080255,-0.122998,-0.151088,-0.172392:9
1.382714,1.300551,1.178787,1.080538,1.294748,1.303951,1.157538,1.052951,1.087975,1.024537,1.053434:-0.184104,-0.230109,-0.293902,-0.307945,-0.325878,-0.342404,-0.306588,-0.3034,-0.344754,-0.371285,-0.510386:0.066019,0.069042,0.167221,0.363825,0.38937,0.343997,0.370782,0.470172,0.494345,0.607765,0.527426:-0.432141,-0.353132,-0.372033,-0.482533,-0.600737,-0.505035,-0.432017,-0.383046,-0.321341,-0.329166,-0.166743:-0.015288,0.099003,0.324548,0.529762,0.606433,0.630039,0.662029,0.705027,0.770131,0.739238,0.700645:-0.049019,-0.074583,-0.094859,-0.020668,0.071992,-0.017266,-0.026642,-0.031169,-0.070946,-0.061797,-0.124435:-0.12333,-0.168097,-0.216831,-0.254001,-0.29314,-0.283033,-0.299693,-0.346698,-0.359172,-0.389195,-0.404231:0.202696,0.188971,0.142522,0.113159,0.039263,0.070559,0.047062,0.047967,0.084963,0.107539,0.056119:0.041879,-0.006286,-0.106143,-0.247756,-0.264982,-0.29765,-0.288999,-0.27768,-0.290193,-0.320941,-0.259202:-0.277021,-0.302891,-0.285579,-0.192772,-0.136489,-0.166595,-0.169054,-0.145193,-0.15113,-0.182363,-0.194442:-0.05809,-0.010003,0.063443,0.077184,0.00952,0.014295,0.017013,0.022738,0.036968,0.060339,0.065873:0.101588,0.135814,0.204032,0.183177,0.139165,0.113742,0.077614,0.027974,0.023827,-0.025115,-0.023554:9
1.288338,1.230953,1.082587,1.03696,1.012197,0.940073,0.964089,0.844872,0.706424,0.633263:-0.25265,-0.117745,-0.093684,-0.013341,-0.040281,-0.159915,-0.339885,-0.369742,-0.323877,-0.278863:-0.590743,-0.586151,-0.526442,-0.47798,-0.462739,-0.332646,-0.161654,-0.094327,-0.091274,-0.159124:0.101772,0.040187,-0.029708,-0.131131,-0.115735,-0.134493,-0.158011,-0.111775,-0.062233,0.060694:-0.349453,-0.215783,-0.176822,-0.136655,-0.070742,0.078626,0.198884,0.310913,0.448329,0.465551:-0.372806,-0.353293,-0.266622,-0.229323,-0.227017,-0.208311,-0.142768,-0.144554,-0.16438,-0.121177:0.119984,0.116585,0.038202,-0.00779,-0.027251,-0.128391,-0.232739,-0.218545,-0.204983,-0.211985:0.001626,-0.020689,-0.044988,0.00769,-0.021898,0.028926,0.130715,0.104453,0.05514,0.008206:0.11,0.09532,0.082536,0.090735,0.07723,-0.043484,-0.178666,-0.213613,-0.234575,-0.25065:-0.303875,-0.368386,-0.386103,-0.413667,-0.40145,-0.312459,-0.22142,-0.202321,-0.189248,-0.189911:0.092052,0.060685,0.102772,0.120819,0.140688,0.115534,0.088974,0.100551,0.11914,0.139337:0.085868,0.115955,0.156208,0.148659,0.143156,0.178783,0.150438,0.156083,0.125729,0.070851:9
1.185678,0.898436,0.879494,1.088694,1.431561,1.477946,1.422555,1.339677,1.420387,1.422898,1.318091,1.229703,1.209465,1.114968:-0.430011,-0.697285,-0.718393,-0.687197,-0.692352,-0.70211,-0.737113,-0.717997,-0.903993,-1.021389,-0.996297,-0.960982,-0.959196,-0.936948:-0.004158,-0.085812,-0.130111,-0.06147,0.084865,0.114458,0.238933,0.273288,0.349435,0.411575,0.482917,0.502087,0.509631,0.549994:-0.11357,-0.116799,-0.141822,-0.141391,-0.153978,-0.054919,-0.071289,-0.021024,0.011124,0.054326,0.091247,0.167637,0.251227,0.27143:-0.09054,0.064146,0.133391,0.153304,0.393005,0.487133,0.496708,0.505106,0.542922,0.534296,0.563907,0.566619,0.550188,0.537684:-0.170363,-0.125427,-0.066754,-0.03869,-0.108489,-0.102203,-0.066102,-0.068621,-0.068079,-0.057592,-0.09246,-0.139241,-0.160495,-0.145062:-0.189518,-0.21694,-0.22872,-0.261632,-0.280185,-0.347174,-0.319704,-0.294182,-0.305438,-0.293188,-0.323024,-0.307909,-0.296036,-0.324811:0.080787,0.125255,0.128544,0.146521,0.155659,0.097582,0.01518,0.004183,0.044144,0.049224,0.043234,0.018825,-0.018256,-0.025569:-0.055098,-0.209198,-0.317472,-0.311802,-0.301916,-0.299589,-0.335014,-0.366578,-0.344149,-0.328939,-0.331339,-0.366043,-0.354598,-0.322676:-0.274092,-0.276081,-0.264956,-0.283179,-0.252336,-0.183629,-0.119123,-0.118091,-0.119799,-0.099596,-0.09866,-0.087274,-0.077417,-0.090796:-0.026063,-0.018825,0.05939,0.114872,0.11058,0.101453,0.117766,0.143306,0.124973,0.076721,0.042877,0.046344,0.027824,0.026324:0.20374,0.135443,0.142561,0.164681,0.115108,0.012166,-0.018019,-0.023058,-0.05823,-0.135949,-0.156873,-0.165192,-0.170827,-0.191249:9
1.350661,1.408054,1.330171,1.142174,1.165411,1.091788,1.186173,1.361751,1.330389,1.121027,1.126642,1.087443,0.955908,0.937612,0.940369:-0.612996,-0.536705,-0.507567,-0.518056,-0.520145,-0.357302,-0.379602,-0.46458,-0.466567,-0.478862,-0.613221,-0.684222,-0.687217,-0.678013,-0.652831:0.386161,0.328176,0.305683,0.244571,0.290643,0.210262,0.140094,-0.076423,0.051813,0.197048,0.297539,0.408565,0.480113,0.50391,0.457452:-0.726014,-0.650928,-0.568231,-0.478659,-0.550152,-0.555956,-0.586484,-0.609229,-0.558084,-0.398373,-0.382326,-0.318129,-0.291887,-0.279274,-0.259364:-0.038534,0.036188,0.061396,0.09848,0.23661,0.298528,0.309925,0.282805,0.379709,0.505684,0.547767,0.550558,0.584639,0.599142,0.624977:-0.21252,-0.214995,-0.204743,-0.184106,-0.189055,-0.226552,-0.181783,-0.12322,-0.142765,-0.181788,-0.151397,-0.144839,-0.159645,-0.167765,-0.236877:-0.278075,-0.241779,-0.192451,-0.202149,-0.208083,-0.155917,-0.156926,-0.12371,-0.141949,-0.193226,-0.292467,-0.387887,-0.421721,-0.441493,-0.454757:0.342428,0.303564,0.260484,0.241851,0.254376,0.230276,0.149314,0.034514,0.064882,0.101971,0.114885,0.097948,0.047524,0.025588,0.017603:-0.0233,-0.055956,-0.091252,-0.130764,-0.203314,-0.229637,-0.225248,-0.249832,-0.317793,-0.32052,-0.29897,-0.292929,-0.317192,-0.320885,-0.278405:-0.312139,-0.310379,-0.271107,-0.229552,-0.224206,-0.228206,-0.184391,-0.097371,-0.106248,-0.142538,-0.197087,-0.199901,-0.154424,-0.145628,-0.101095:-0.033179,-0.032488,-6.8E-4,0.079583,0.065169,0.014535,-0.036797,-0.016699,-0.030969,-0.023585,0.021204,0.086188,0.102966,0.103565,0.06807:0.145436,0.18452,0.199539,0.16115,0.179053,0.213018,0.177922,0.11664,0.116581,0.120296,0.10377,0.057031,0.038548,0.027787,-0.002035:9
0.868252,0.988576,1.147993,1.202193,1.207963,1.193889,1.18465,1.173024,1.038514,1.078472,1.066043,1.025651,0.991121,1.032208,0.979391,0.908693,0.969614:-0.165602,0.069249,0.320588,0.274842,0.117777,0.017777,-0.122087,-0.217193,-0.176533,-0.287431,-0.317187,-0.267196,-0.287936,-0.337794,-0.344448,-0.391745,-0.511914:-0.472931,-0.468026,-0.524308,-0.569779,-0.513947,-0.499175,-0.397832,-0.305467,-0.336229,-0.259354,-0.217706,-0.27125,-0.267103,-0.190865,-0.151946,-0.126283,-0.031632:0.153917,-1.85E-4,-0.108709,-0.006122,0.017374,0.097665,0.10387,0.058963,0.091431,0.070775,0.126844,0.230195,0.325235,0.285609,0.28417,0.338476,0.394731:-0.072916,-0.128241,-0.085347,-0.075496,-0.072143,-0.104869,-0.063778,0.027079,0.143122,0.251895,0.238997,0.19493,0.218221,0.2783,0.3182,0.345585,0.336728:-0.234803,-0.3236,-0.405778,-0.386146,-0.3223,-0.23541,-0.133016,-0.090303,-0.060936,-0.093293,-0.040583,0.048401,-0.004327,0.021681,0.016919,0.007736,0.001406:0.20996,0.110453,0.057775,0.065169,0.094162,0.093469,0.058432,0.044973,0.045366,0.018995,-0.089466,-0.184249,-0.199678,-0.261401,-0.231242,-0.182354,-0.147155:0.165318,0.141253,0.11845,0.041434,0.020558,0.006678,-0.056924,-0.141463,-0.177068,-0.212,-0.242156,-0.277711,-0.279335,-0.257606,-0.261861,-0.264327,-0.282373:0.168707,0.134289,0.167415,0.189002,0.11689,0.057858,0.019958,0.006642,0.030139,-0.02961,-0.055249,-0.026581,-0.031168,-0.057278,-0.034898,0.004947,0.010744:-0.292245,-0.335946,-0.308266,-0.33552,-0.390401,-0.421992,-0.411663,-0.406759,-0.427519,-0.356599,-0.328597,-0.331661,-0.314765,-0.273191,-0.287297,-0.27966,-0.223239:-0.048096,-0.026513,-0.075508,-0.085666,-0.079559,-0.005301,0.01605,-0.020713,-0.008525,-0.0259,-0.009216,0.001153,-0.008608,0.00375,0.038986,0.050166,0.011835:-0.088355,-0.027366,0.00497,0.023233,0.062565,0.088676,0.136329,0.164882,0.1355,0.172594,0.151852,0.098222,0.074662,0.078055,0.079998,0.060869,0.041177:9
1.407858,1.223804,1.034481,1.031508,1.258624,1.379946,1.365356,1.427606,1.505263,1.478791,1.472062,1.457966:-0.310496,-0.337076,-0.296715,-0.150205,-0.346233,-0.543782,-0.557916,-0.579152,-0.700795,-0.807033,-0.753588,-0.686668:0.139769,0.086374,0.05072,-0.050779,-0.074147,0.053059,0.077592,0.044124,0.085891,0.185042,0.146493,0.074314:-0.419397,-0.333321,-0.320866,-0.339165,-0.26192,-0.264493,-0.280663,-0.253461,-0.17444,-0.158791,-0.068695,0.113276:-0.374991,-0.227634,-0.172465,-0.214591,-0.122151,-0.068116,-7.44E-4,0.103793,0.23725,0.30568,0.298222,0.19529:-0.283117,-0.31661,-0.317801,-0.230876,-0.226924,-0.130865,-0.073012,-0.083969,-0.107523,-0.159871,-0.166289,-0.11082:-0.111215,-0.187636,-0.257575,-0.121816,-0.111039,-0.158665,-0.169709,-0.169998,-0.194286,-0.221862,-0.239574,-0.264812:0.341622,0.302814,0.234887,0.228014,0.260214,0.267047,0.249405,0.236212,0.16528,0.133668,0.081344,-0.005118:-0.017056,-0.09421,-0.106787,-0.130111,-0.162834,-0.208424,-0.247739,-0.30094,-0.353725,-0.381029,-0.393132,-0.341557:-0.139756,-0.142101,-0.165991,-0.254429,-0.210295,-0.218144,-0.241368,-0.260764,-0.20494,-0.187782,-0.196042,-0.200298:0.160754,0.189687,0.235903,0.232009,0.153887,0.194063,0.208249,0.22894,0.240572,0.186418,0.176191,0.180921:0.080159,0.120461,0.147237,0.176231,0.200711,0.150231,0.124869,0.12918,0.116141,0.090955,0.101864,0.130216:9
1.172216,0.886567,1.114773,1.254748,1.3155,1.444622,1.45115,1.451324,1.320915,1.295548,1.333588,1.324834,1.293336,1.223718:0.137979,0.002587,-0.071157,-0.054541,-0.095587,-0.156007,-0.097723,-0.072117,-0.116024,-0.240705,-0.336968,-0.336692,-0.33644,-0.326818:-0.170947,-0.082727,-0.060395,-0.1876,-0.204271,-0.180085,-0.249716,-0.213653,-0.196267,-0.067059,0.030185,0.060618,0.134648,0.192024:-0.371477,-0.319855,-0.333598,-0.28292,-0.257474,-0.21264,-0.123979,-0.172722,-0.112216,-0.12764,-0.129151,-0.034256,0.023617,0.089982:0.01008,0.021656,0.022005,0.004191,0.00773,-0.029218,0.00449,0.137427,0.271119,0.430259,0.499724,0.441256,0.467529,0.544756:-0.432253,-0.360849,-0.338011,-0.267194,-0.192199,-0.078794,0.034193,0.054071,0.033913,0.051127,0.131581,0.168798,0.110041,-0.003609:-0.115549,-0.092013,-0.08351,-0.091355,-0.084732,-0.093959,-0.190799,-0.275567,-0.316994,-0.349127,-0.387142,-0.440586,-0.475315,-0.454612:0.194258,0.186839,0.179612,0.107232,0.037979,-0.084701,-0.147229,-0.165143,-0.215242,-0.189353,-0.144674,-0.123923,-0.160231,-0.143666:0.075585,0.034324,0.049813,0.074778,0.062905,0.097905,0.109148,0.022141,-0.009972,-0.088937,-0.163379,-0.227229,-0.193539,-0.207381:-0.192855,-0.213924,-0.216987,-0.294286,-0.360378,-0.411212,-0.44064,-0.445938,-0.421098,-0.354285,-0.31326,-0.28847,-0.279124,-0.244012:-0.154419,-0.211937,-0.217056,-0.176462,-0.147005,-0.151499,-0.139813,-0.058128,-0.01367,-0.025057,0.002683,0.065863,0.079796,0.047631:0.019993,0.065662,0.076721,0.072632,0.10038,0.149352,0.133032,0.137858,0.118646,0.094077,0.017867,-0.044028,-0.05805,-0.085085:9
1.240598,1.227252,1.228334,1.074871,1.141889,1.162979,1.224771,1.030606,0.966744:-0.352572,-0.313229,-0.328534,-0.543987,-0.485815,-0.34098,-0.371558,-0.30928,-0.323093:0.202753,0.18586,0.355018,0.347815,0.288329,0.290894,0.335834,0.311761,0.305467:-0.819913,-0.916691,-0.754335,-0.652068,-0.687604,-0.553881,-0.547974,-0.466693,-0.419457:-0.0385,-0.024352,0.075544,0.28481,0.301889,0.324858,0.38487,0.453942,0.514195:-0.385671,-0.39582,-0.305401,-0.164443,-0.203278,-0.250906,-0.203234,-0.260364,-0.31106:-0.021062,-0.028499,0.023347,0.056965,0.057573,0.008865,-0.058058,0.004476,-0.033985:0.434753,0.442761,0.425791,0.423496,0.382032,0.249452,0.26369,0.22759,0.154038:-0.200198,-0.175446,-0.197482,-0.167755,-0.245315,-0.35053,-0.368357,-0.413259,-0.389686:-0.184956,-0.165696,-0.184463,-0.188309,-0.1879,-0.169895,-0.213397,-0.169547,-0.089183:0.050853,0.032784,0.024559,-0.076021,-0.034779,0.101546,0.117961,0.168689,0.16625:0.061848,0.076978,0.125767,0.134912,0.170756,0.227674,0.226729,0.214409,0.173642:9
